<?php
class ModelCatalogProduct extends Model {

				################################################
				################ COMPLEMENTO BLING #############
				################################################

				public function getAllProduct() {
					$query = $this->db->query("
						SELECT
							pd.product_id,
							pd.name,
							pd.description,
							p.model,
							p.sku,
							p.quantity,
							p.price,
							p.weight,
							p.length,
							p.width,
							p.height,
							p.date_added,
							pa.text AS attribute
						FROM
							". DB_PREFIX ."product p LEFT JOIN
							". DB_PREFIX ."product_description pd ON pd.product_id = p.product_id LEFT JOIN
							". DB_PREFIX ."product_attribute pa ON pa.product_id = p.product_id
						WHERE
							pd.language_id = 2 AND
							(pa.language_id = 2 OR pa.language_id IS NULL)
						GROUP BY
							p.product_id
					");

					return $query->rows;
				}

				//Products by filters
				public function getAllProductFilters($filters) {
					$filters = urldecode($filters);
					$filter = explode('|', $filters);

					$startDate = $filter[0];
					$finishDate = isset($filter[1]) ? $filter[1] : '';

					if ($startDate == date('Y-m-d')) {
						$d = date('d') + 1;
						$y = date('Y');
						$m = date('m');
						$finishDate = $y."-".$m ."-".$d;
					}

					$query = $this->db->query("
						SELECT
							pd.product_id,
							pd.name,
							pd.description,
							p.model,
							p.sku,
							p.quantity,
							p.price,
							p.weight,
							p.length,
							p.width,
							p.height,
							p.date_added,
							pa.text AS attribute
						FROM
							". DB_PREFIX ."product p LEFT JOIN
							". DB_PREFIX ."product_description pd ON pd.product_id = p.product_id LEFT JOIN
							". DB_PREFIX ."product_attribute pa ON pa.product_id = p.product_id
						WHERE
							(p.date_added BETWEEN '".$startDate."' AND '".$finishDate."') AND
							p.status = '1' AND
							pd.language_id = 2 AND
							(pa.language_id = 2 OR pa.language_id IS NULL)
						GROUP BY
							p.product_id
					");

					return $query->rows;
				}

				//Products by filters
				public function getCountProduct() {
					$query = $this->db->query("SELECT COUNT(product_id) as NrProducts FROM ". DB_PREFIX ."product");

					return $query->rows;
				}

				//Insert products
				public function insert_oc_products($parameter) {
					if (strlen($parameter->descricaoComplementar) > 64) {
						$parameter->descricaoComplementar = substr($parameter->descricaoComplementar, 0, 64);
					}

					$idProd = (int)$parameter->id;

					if ($idProd == 0) {
						$sql = $this->db->query("
							INSERT INTO ". DB_PREFIX ."product (model, sku, upc, ean, jan, isbn, mpn, location, quantity, stock_status_id, image, manufacturer_id, shipping, price, points, tax_class_id, date_available, weight, weight_class_id, length, width, height, length_class_id, subtract, minimum, sort_order, status, viewed, date_added, date_modified )
							VALUES ('".strip_tags($parameter->descricaoComplementar)."', '".strip_tags($parameter->codigo)."','','','','','','','".$parameter->estoqueAtual."','1','','0','0','".$parameter->preco."','0', '9','".date('Y-m-d')."', '".$parameter->peso."',	'1','".$parameter->profundidadeProduto."','".$parameter->larguraProduto."','".$parameter->alturaProduto."','1','0','1','0','1','0', NOW(), NOW())
						");

						$query = $this->db->query("SELECT model, sku, quantity, MAX(product_id) as maximo FROM `". DB_PREFIX ."product`");

						return $query->rows;
					} else {
						$sql = $this->db->query("UPDATE ". DB_PREFIX ."product SET	model = '".strip_tags($parameter->descricaoComplementar)."', sku = '".strip_tags($parameter->codigo)."', quantity = '".$parameter->estoqueAtual."', price = '".$parameter->preco."', weight = '".$parameter->peso."', length = '".$parameter->profundidadeProduto."', width = '".$parameter->larguraProduto."', height = '".$parameter->alturaProduto."', date_modified = NOW()  WHERE product_id = '" . $idProd ."'");

						return array('id' => $idPrd, 'returnUp' => $sql);
					}
				}

				public function update_oc_description($parameter, $id) {
					$sql = $this->db->query("UPDATE ". DB_PREFIX ."product_description SET `name` =  '".strip_tags($parameter->nome)."', `description` = '".htmlentities($parameter->descricaoComplementar)."' WHERE `product_id` = '".$id."'");

					return $sql;
				}

				public function insert_oc_description($parameter, $id) {
					$sql = $this->db->query("
						INSERT INTO ". DB_PREFIX ."product_description (`product_id`, `language_id`, `name`, `description`, `tag`, `meta_title`, `meta_description`, `meta_keyword`)
						VALUES('".$id."','". (int)$this->config->get('config_language_id')."','".strip_tags($parameter->nome)."','".htmlentities($parameter->descricaoComplementar)."','','','','')
					");

					$query = $this->db->query("SELECT MAX(product_id) as idMax FROM ". DB_PREFIX ."product_description");

					return $query->rows;
				}

				public function delete_oc_products($id) {
					$del = $this->db->query("DELETE FROM `". DB_PREFIX ."product` WHERE product_id = '".$id."'");

					return true;
				}

				//Get products variations
				public function getVariation($parameters) {
					$query = $this->db->query("
						SELECT
							pd.name as variationName,
							od.name as nomeTipoVariacao,
							ovd.name as tipoVariacao,
							pov.quantity as quantidadeVariacao,
							pov.price as precoVaricao,
							pov.price_prefix as prefixPrecoVaricao,
							pov.weight as   pesoVaricao,
							pov.weight_prefix as prefixPesoVaricao,
							pov.product_option_value_id as idVariation
						FROM
							". DB_PREFIX ."option_description od LEFT JOIN
							". DB_PREFIX ."option_value_description ovd ON (od.option_id = ovd.option_id) LEFT JOIN
							". DB_PREFIX ."product_option_value pov ON (ovd.option_value_id = pov.option_value_id) LEFT JOIN
							". DB_PREFIX ."product_description pd ON (pov.product_id = pd.product_id)
						WHERE
							pd.product_id = '".$parameters['product_id']."' AND
							od.language_id = 2 AND
							(ovd.language_id = 2 OR ovd.language_id IS NULL) AND
							pd.language_id = 2
					");

					return $query->rows;
				}

				public function update_stock_product($id, $qtd) {
					$up = $this->db->query("UPDATE `". DB_PREFIX ."product` SET `quantity`= '" . $qtd . "' WHERE  `product_id` = '" . $id . "'");

					if ($up) {
						return true;
					} else {
						return false;
					}
				}

				public function update_stock_variation($id, $qtd) {
					$up = $this->db->query("UPDATE `". DB_PREFIX ."product_option_value` SET `quantity`= '" . $qtd . "' WHERE  `product_option_value_id` = '" . $id . "' ");

					if ($up) {
						return true;
					} else {
						return false;
					}
				}
			
	public function updateViewed($product_id) {
		$this->db->query("UPDATE " . DB_PREFIX . "product SET viewed = (viewed + 1) WHERE product_id = '" . (int)$product_id . "'");
	}

	public function getProduct($product_id) {
		$query = $this->db->query("SELECT DISTINCT *, pd.name AS name, p.image, m.name AS manufacturer, (SELECT price FROM " . DB_PREFIX . "product_discount pd2 WHERE pd2.product_id = p.product_id AND pd2.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND pd2.quantity = '1' AND ((pd2.date_start = '0000-00-00' OR pd2.date_start < NOW()) AND (pd2.date_end = '0000-00-00' OR pd2.date_end > NOW())) ORDER BY pd2.priority ASC, pd2.price ASC LIMIT 1) AS discount, (SELECT price FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = p.product_id AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1) AS special, (SELECT points FROM " . DB_PREFIX . "product_reward pr WHERE pr.product_id = p.product_id AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "') AS reward, (SELECT ss.name FROM " . DB_PREFIX . "stock_status ss WHERE ss.stock_status_id = p.stock_status_id AND ss.language_id = '" . (int)$this->config->get('config_language_id') . "') AS stock_status, (SELECT wcd.unit FROM " . DB_PREFIX . "weight_class_description wcd WHERE p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS weight_class, (SELECT lcd.unit FROM " . DB_PREFIX . "length_class_description lcd WHERE p.length_class_id = lcd.length_class_id AND lcd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS length_class, (SELECT AVG(rating) AS total FROM " . DB_PREFIX . "review r1 WHERE r1.product_id = p.product_id AND r1.status = '1' GROUP BY r1.product_id) AS rating, (SELECT COUNT(*) AS total FROM " . DB_PREFIX . "review r2 WHERE r2.product_id = p.product_id AND r2.status = '1' GROUP BY r2.product_id) AS reviews, p.sort_order FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN " . DB_PREFIX . "manufacturer m ON (p.manufacturer_id = m.manufacturer_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'");

		if ($query->num_rows) {

				$product_download_query = $this->db->query("SELECT COUNT(product_id) AS total FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int)$query->row['product_id'] . "'");
				$has_downloads = $product_download_query->row['total'];

				$product_recurring_query = $this->db->query("SELECT COUNT(product_id) AS total FROM " . DB_PREFIX . "product_recurring WHERE product_id = '" . (int)$query->row['product_id'] . "'");
				$has_recurring = $product_recurring_query->row['total'];

				$product_option_query = $this->db->query("SELECT COUNT(product_id) AS total FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int)$query->row['product_id'] . "' AND required = 1");
				$has_options = $product_option_query->row['total'];

				$product_option_query = $this->db->query("SELECT MAX(price) AS price FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$query->row['product_id'] . "' AND price_prefix = '+'");
				$options_price_plus = (float)$product_option_query->row['price'];

				$product_option_query = $this->db->query("SELECT MAX(price) AS price FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int)$query->row['product_id'] . "' AND price_prefix = '-'");
				$options_price_minus = (float)$product_option_query->row['price'];
			

				$in_stock_status = '';

				if (isset($query->row['in_stock_status_id']) && $query->row['in_stock_status_id'] > 0) {
					$stock_status_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "stock_status WHERE stock_status_id = '" . (int)$query->row['in_stock_status_id'] . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
					if ($stock_status_query->rows) {
						$in_stock_status = $stock_status_query->row['name'];
					}
				}
			
			return array(

				'in_stock_status' => $in_stock_status,
			

				'has_downloads'       => $has_downloads,
				'has_recurring'       => $has_recurring,
				'has_options'         => $has_options,
				'options_price_plus'  => $options_price_plus,
				'options_price_minus' => $options_price_minus,
			

				'raw_info' => $query->row,
			
				'product_id'       => $query->row['product_id'],
				'name'             => $query->row['name'],
				'description'      => $query->row['description'],
				'meta_title'       => $query->row['meta_title'],
				'meta_description' => $query->row['meta_description'],
				'meta_keyword'     => $query->row['meta_keyword'],
				'tag'              => $query->row['tag'],
				'model'            => $query->row['model'],
				'sku'              => $query->row['sku'],
				'upc'              => $query->row['upc'],
				'ean'              => $query->row['ean'],
				'jan'              => $query->row['jan'],
				'isbn'             => $query->row['isbn'],
				'mpn'              => $query->row['mpn'],
				'location'         => $query->row['location'],
				'quantity'         => $query->row['quantity'],
				'stock_status'     => $query->row['stock_status'],
				'image'            => $query->row['image'],
				'manufacturer_id'  => $query->row['manufacturer_id'],
				'manufacturer'     => $query->row['manufacturer'],
				'price'            => ($query->row['discount'] ? $query->row['discount'] : $query->row['price']),
				'special'          => $query->row['special'],
				'reward'           => $query->row['reward'],
				'points'           => $query->row['points'],
				'tax_class_id'     => $query->row['tax_class_id'],
				'date_available'   => $query->row['date_available'],
				'weight'           => $query->row['weight'],
				'weight_class_id'  => $query->row['weight_class_id'],
				'length'           => $query->row['length'],
				'width'            => $query->row['width'],
				'height'           => $query->row['height'],
				'length_class_id'  => $query->row['length_class_id'],
				'subtract'         => $query->row['subtract'],
				'rating'           => round($query->row['rating']),
				'reviews'          => $query->row['reviews'] ? $query->row['reviews'] : 0,
				'minimum'          => $query->row['minimum'],
				'sort_order'       => $query->row['sort_order'],
				'status'           => $query->row['status'],
				'date_added'       => $query->row['date_added'],
				'date_modified'    => $query->row['date_modified'],
				'viewed'           => $query->row['viewed']
			);
		} else {
			return false;
		}
	}

	public function getProducts($data = array()) {
		$sql = "SELECT p.product_id, (SELECT AVG(rating) AS total FROM " . DB_PREFIX . "review r1 WHERE r1.product_id = p.product_id AND r1.status = '1' GROUP BY r1.product_id) AS rating, (SELECT price FROM " . DB_PREFIX . "product_discount pd2 WHERE pd2.product_id = p.product_id AND pd2.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND pd2.quantity = '1' AND ((pd2.date_start = '0000-00-00' OR pd2.date_start < NOW()) AND (pd2.date_end = '0000-00-00' OR pd2.date_end > NOW())) ORDER BY pd2.priority ASC, pd2.price ASC LIMIT 1) AS discount, (SELECT price FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = p.product_id AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1) AS special";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (cp.category_id = p2c.category_id)";
			} else {
				$sql .= " FROM " . DB_PREFIX . "product_to_category p2c";
			}

			if (!empty($data['filter_filter'])) {
				$sql .= " LEFT JOIN " . DB_PREFIX . "product_filter pf ON (p2c.product_id = pf.product_id) LEFT JOIN " . DB_PREFIX . "product p ON (pf.product_id = p.product_id)";
			} else {
				$sql .= " LEFT JOIN " . DB_PREFIX . "product p ON (p2c.product_id = p.product_id)";
			}
		} else {
			$sql .= " FROM " . DB_PREFIX . "product p";
		}

		$sql .= " LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " AND cp.path_id = '" . (int)$data['filter_category_id'] . "'";
			} else {
				$sql .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
			}

			if (!empty($data['filter_filter'])) {
				$implode = array();

				$filters = explode(',', $data['filter_filter']);

				foreach ($filters as $filter_id) {
					$implode[] = (int)$filter_id;
				}

				$sql .= " AND pf.filter_id IN (" . implode(',', $implode) . ")";

				if (count($implode) > 1) {
					$filter_sql = "SELECT * FROM " . DB_PREFIX . "filter WHERE filter_id IN (" . implode(',', $implode) . ")";
					$filter_query = $this->db->query($filter_sql);

					$filter_groups = array();

					foreach ($filter_query->rows as $filter_result) {
						$filter_id = $filter_result['filter_id'];
						$filter_group_id = $filter_result['filter_group_id'];

						if (!isset($filter_groups[$filter_group_id])) {
							$filter_groups[$filter_group_id] = array();
						}

						$filter_groups[$filter_group_id][] = $filter_id;
					}

					$total_groups = count($filter_groups);

					$sql .= " AND p.product_id IN ( SELECT pf2.product_id FROM " . DB_PREFIX . "product_filter pf2 WHERE pf2.filter_id IN (" . implode(',', $implode) . ") GROUP BY pf2.product_id HAVING COUNT(pf2.product_id) = {$total_groups} ) ";
				}
			
			}
		}

		if (!empty($data['filter_name']) || !empty($data['filter_tag'])) {
			$sql .= " AND (";

			if (!empty($data['filter_name'])) {
				$implode = array();

				$words = explode(' ', trim(preg_replace('/\s+/', ' ', $data['filter_name'])));

				foreach ($words as $word) {
					$implode[] = "pd.name LIKE '%" . $this->db->escape($word) . "%'";
				}

				if ($implode) {
					$sql .= " " . implode(" AND ", $implode) . "";
				}

				if (!empty($data['filter_description'])) {
					$sql .= " OR pd.description LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
				}
			}

			if (!empty($data['filter_name']) && !empty($data['filter_tag'])) {
				$sql .= " OR ";
			}

			if (!empty($data['filter_tag'])) {
				$sql .= "pd.tag LIKE '%" . $this->db->escape($data['filter_tag']) . "%'";
			}

			if (!empty($data['filter_name'])) {
				$sql .= " OR LCASE(p.model) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.sku) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.upc) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.ean) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.jan) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.isbn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.mpn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";

				$sql .= " OR p.manufacturer_id IN (SELECT manufacturer_id FROM `" . DB_PREFIX . "manufacturer` WHERE LCASE(name) LIKE '%" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%') ";
			
			}

			$sql .= ")";
		}


				if (isset($data['filter_has_stock']) && $data['filter_has_stock'] == true) {
					$sql .= " AND (p.quantity > 0 OR p.subtract = 0) ";
				}
			
		if (!empty($data['filter_manufacturer_id'])) {
			$sql .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'";
		}

		$sql .= " GROUP BY p.product_id";

		$sort_data = array(
			'pd.name',
			'p.model',
			'p.quantity',
			'p.price',
			'rating',
			'p.sort_order',
			'p.date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			if ($data['sort'] == 'pd.name' || $data['sort'] == 'p.model') {
				$sql .= " ORDER BY LCASE(" . $data['sort'] . ")";
			} elseif ($data['sort'] == 'p.price') {
				$sql .= " ORDER BY (CASE WHEN special IS NOT NULL THEN special WHEN discount IS NOT NULL THEN discount ELSE p.price END)";
			} else {
				$sql .= " ORDER BY " . $data['sort'];
			}
		} else {
			$sql .= " ORDER BY p.sort_order";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC, LCASE(pd.name) DESC";
		} else {
			$sql .= " ASC, LCASE(pd.name) ASC";
		}


				if (isset($data['order_has_stock']) && $data['order_has_stock'] == true) {
					$sql = str_replace(' ORDER BY ', ' ORDER BY (p.quantity > 0 OR p.subtract = 0) DESC, ', $sql);
				}
			
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$product_data = array();

		$query = $this->db->query($sql);

		foreach ($query->rows as $result) {
			$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
		}

		return $product_data;
	}

	public function getProductSpecials($data = array()) {

				$where = '';
				if ($this->config->get('config_stock_show_products') == '0'){
					$where = ' AND (p.quantity > 0 OR p.subtract = 0) ';
				}
			
		$sql = "SELECT DISTINCT ps.product_id, (SELECT AVG(rating) FROM " . DB_PREFIX . "review r1 WHERE r1.product_id = ps.product_id AND r1.status = '1' GROUP BY r1.product_id) AS rating FROM " . DB_PREFIX . "product_special ps LEFT JOIN " . DB_PREFIX . "product p ON (ps.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) {$where} GROUP BY ps.product_id";

		$sort_data = array(
			'pd.name',
			'p.model',
			'ps.price',
			'rating',
			'p.sort_order'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			if ($data['sort'] == 'pd.name' || $data['sort'] == 'p.model') {
				$sql .= " ORDER BY LCASE(" . $data['sort'] . ")";
			} else {
				$sql .= " ORDER BY " . $data['sort'];
			}
		} else {
			$sql .= " ORDER BY p.sort_order";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC, LCASE(pd.name) DESC";
		} else {
			$sql .= " ASC, LCASE(pd.name) ASC";
		}


				if ($this->config->get('config_stock_show_products') == '2'){
					$sql = str_replace(' ORDER BY ', ' ORDER BY (p.quantity > 0 OR p.subtract = 0) DESC, ', $sql);
				}
			
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$product_data = array();

		$query = $this->db->query($sql);

		foreach ($query->rows as $result) {
			$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
		}

		return $product_data;
	}

	public function getLatestProducts($limit) {
		$product_data = $this->cache->get('product.latest.' . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $this->config->get('config_customer_group_id') . '.' . (int)$limit);

		if (!$product_data) {
			$query = $this->db->query("SELECT p.product_id FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' ORDER BY p.date_added DESC LIMIT " . (int)$limit);

			foreach ($query->rows as $result) {
				$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
			}

			$this->cache->set('product.latest.' . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $this->config->get('config_customer_group_id') . '.' . (int)$limit, $product_data);
		}

		return $product_data;
	}

	public function getPopularProducts($limit) {
		$product_data = array();

		$query = $this->db->query("SELECT p.product_id FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' ORDER BY p.viewed DESC, p.date_added DESC LIMIT " . (int)$limit);

		foreach ($query->rows as $result) {
			$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
		}

		return $product_data;
	}

	public function getBestSellerProducts($limit) {
		$product_data = $this->cache->get('product.bestseller.' . (int)$this->config->get('config_stock_show_products') . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $this->config->get('config_customer_group_id') . '.' . (int)$limit);

		if (!$product_data) {
			$product_data = array();


				$where = '';
				if ($this->config->get('config_stock_show_products') == '0'){
					$where = ' AND (p.quantity > 0 OR p.subtract = 0) ';
				}
				$orderby = '';
				if ($this->config->get('config_stock_show_products') == '2'){
					$orderby = ' (p.quantity > 0 OR p.subtract = 0) DESC, ';
				}
			
			$query = $this->db->query("SELECT op.product_id, SUM(op.quantity) AS total FROM " . DB_PREFIX . "order_product op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) LEFT JOIN `" . DB_PREFIX . "product` p ON (op.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE o.order_status_id > '0' {$where} AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' GROUP BY op.product_id ORDER BY {$orderby} total DESC LIMIT " . (int)$limit);

			foreach ($query->rows as $result) {
				$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
			}

			$this->cache->set('product.bestseller.' . (int)$this->config->get('config_stock_show_products') . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $this->config->get('config_customer_group_id') . '.' . (int)$limit, $product_data);
		}

		return $product_data;
	}


				public function getProductStockStatusNames($product_id) {
					$data = array(
						'stock_status' => '',
						'in_stock_status' => ''
					);

					$stock_status_query = $this->db->query("SELECT
						(SELECT ss1.name FROM " . DB_PREFIX . "stock_status ss1 WHERE ss1.stock_status_id = p.stock_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' LIMIT 1) AS stock_status,
						(SELECT ss2.name FROM " . DB_PREFIX . "stock_status ss2 WHERE ss2.stock_status_id = p.in_stock_status_id AND language_id = '" . (int)$this->config->get('config_language_id') . "' LIMIT 1) AS in_stock_status
					FROM " . DB_PREFIX . "product p WHERE product_id = '" . (int)$product_id . "'");

					if ($stock_status_query->rows) {
						$data['stock_status'] = ($stock_status_query->row['stock_status'] != '') ? $stock_status_query->row['stock_status'] : '';
						$data['in_stock_status'] = ($stock_status_query->row['in_stock_status'] != '') ? $stock_status_query->row['in_stock_status'] : '';
					}

					return $data;
				}
			

				public function getRandomProducts($limit) {
					$cache_time = 10; // em minutos

					$limit = (int)$limit;

					$cache_name = date('H') . ceil(date('i') / $cache_time);
					$cache_name = 'product.random.' . $cache_name . (int)$this->config->get('config_stock_show_products') . (int)$this->config->get('config_language_id') . '.' . (int)$this->config->get('config_store_id') . '.' . $this->config->get('config_customer_group_id') . '.' . $limit;

					$product_data = $this->cache->get($cache_name);

					if (!$product_data) {
						$product_data = array();

						$where = '';
						if ($this->config->get('config_stock_show_products') == '0'){
							$where = ' AND (p.quantity > 0 OR p.subtract = 0) ';
						}
						$orderby = '';
						if ($this->config->get('config_stock_show_products') == '2'){
							$orderby = ' (p.quantity > 0 OR p.subtract = 0) DESC, ';
						}

						$query = $this->db->query("SELECT p.product_id FROM " . DB_PREFIX . "product p LEFT JOIN  " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' {$where} ORDER BY {$orderby} RAND() LIMIT " . $limit);

						foreach ($query->rows as $result) {
							$product_data[$result['product_id']] = $this->getProduct($result['product_id']);
						}

						$this->cache->set($cache_name, $product_data);
					}

					return $product_data;
				}
			
	public function getProductAttributes($product_id) {
		$product_attribute_group_data = array();

		$product_attribute_group_query = $this->db->query("SELECT ag.attribute_group_id, agd.name FROM " . DB_PREFIX . "product_attribute pa LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id) LEFT JOIN " . DB_PREFIX . "attribute_group ag ON (a.attribute_group_id = ag.attribute_group_id) LEFT JOIN " . DB_PREFIX . "attribute_group_description agd ON (ag.attribute_group_id = agd.attribute_group_id) WHERE pa.product_id = '" . (int)$product_id . "' AND agd.language_id = '" . (int)$this->config->get('config_language_id') . "' GROUP BY ag.attribute_group_id ORDER BY ag.sort_order, agd.name");

		foreach ($product_attribute_group_query->rows as $product_attribute_group) {
			$product_attribute_data = array();

			$product_attribute_query = $this->db->query("SELECT a.attribute_id, ad.name, pa.text FROM " . DB_PREFIX . "product_attribute pa LEFT JOIN " . DB_PREFIX . "attribute a ON (pa.attribute_id = a.attribute_id) LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (a.attribute_id = ad.attribute_id) WHERE pa.product_id = '" . (int)$product_id . "' AND a.attribute_group_id = '" . (int)$product_attribute_group['attribute_group_id'] . "' AND ad.language_id = '" . (int)$this->config->get('config_language_id') . "' AND pa.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY a.sort_order, ad.name");

			foreach ($product_attribute_query->rows as $product_attribute) {
				$product_attribute_data[] = array(
					'attribute_id' => $product_attribute['attribute_id'],
					'name'         => $product_attribute['name'],
					'text'         => $product_attribute['text']
				);
			}

			$product_attribute_group_data[] = array(
				'attribute_group_id' => $product_attribute_group['attribute_group_id'],
				'name'               => $product_attribute_group['name'],
				'attribute'          => $product_attribute_data
			);
		}

		return $product_attribute_group_data;
	}

	public function getProductOptions($product_id) {
		$product_option_data = array();

		$product_option_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.product_id = '" . (int)$product_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY o.sort_order, od.name");

		foreach ($product_option_query->rows as $product_option) {
			$product_option_value_data = array();

			$product_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_id = '" . (int)$product_id . "' AND pov.product_option_id = '" . (int)$product_option['product_option_id'] . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY ov.sort_order, ovd.name");

			foreach ($product_option_value_query->rows as $product_option_value) {
				$product_option_value_data[] = array(

				'raw_info' => $product_option_value,
			
					'product_option_value_id' => $product_option_value['product_option_value_id'],
					'option_value_id'         => $product_option_value['option_value_id'],
					'name'                    => $product_option_value['name'],
					'image'                   => $product_option_value['image'],
					'quantity'                => $product_option_value['quantity'],
					'subtract'                => $product_option_value['subtract'],
					'price'                   => $product_option_value['price'],
					'price_prefix'            => $product_option_value['price_prefix'],
					'weight'                  => $product_option_value['weight'],
					'weight_prefix'           => $product_option_value['weight_prefix']
				);
			}

			$product_option_data[] = array(

				'raw_info' => $product_option,
			
				'product_option_id'    => $product_option['product_option_id'],
				'product_option_value' => $product_option_value_data,
				'option_id'            => $product_option['option_id'],
				'name'                 => $product_option['name'],
				'type'                 => $product_option['type'],
				'value'                => $product_option['value'],
				'required'             => $product_option['required']
			);
		}

		return $product_option_data;
	}

	public function getProductDiscounts($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND quantity > 1 AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY quantity ASC, priority ASC, price ASC");

		return $query->rows;
	}

	public function getProductImages($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "' ORDER BY sort_order ASC");

		return $query->rows;
	}

	public function getProductRelated($product_id) {
		$product_data = array();


				$where = '';
				if ($this->config->get('config_stock_show_products') == '0'){
					$where = ' AND (p.quantity > 0 OR p.subtract = 0) ';
				}
				$orderby = '';
				if ($this->config->get('config_stock_show_products') == '2'){
					$orderby = ' ORDER BY (p.quantity > 0 OR p.subtract = 0) DESC ';
				}
			
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_related pr LEFT JOIN " . DB_PREFIX . "product p ON (pr.related_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE pr.product_id = '" . (int)$product_id . "' AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' {$where} {$orderby}");

		foreach ($query->rows as $result) {
			$product_data[$result['related_id']] = $this->getProduct($result['related_id']);
		}

		return $product_data;
	}

	public function getProductLayoutId($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int)$product_id . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");

		if ($query->num_rows) {
			return $query->row['layout_id'];
		} else {
			return 0;
		}
	}

	public function getCategories($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");

		return $query->rows;
	}

	public function getTotalProducts($data = array()) {
		$sql = "SELECT COUNT(DISTINCT p.product_id) AS total";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " FROM " . DB_PREFIX . "category_path cp LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (cp.category_id = p2c.category_id)";
			} else {
				$sql .= " FROM " . DB_PREFIX . "product_to_category p2c";
			}

			if (!empty($data['filter_filter'])) {
				$sql .= " LEFT JOIN " . DB_PREFIX . "product_filter pf ON (p2c.product_id = pf.product_id) LEFT JOIN " . DB_PREFIX . "product p ON (pf.product_id = p.product_id)";
			} else {
				$sql .= " LEFT JOIN " . DB_PREFIX . "product p ON (p2c.product_id = p.product_id)";
			}
		} else {
			$sql .= " FROM " . DB_PREFIX . "product p";
		}

		$sql .= " LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";

		if (!empty($data['filter_category_id'])) {
			if (!empty($data['filter_sub_category'])) {
				$sql .= " AND cp.path_id = '" . (int)$data['filter_category_id'] . "'";
			} else {
				$sql .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
			}

			if (!empty($data['filter_filter'])) {
				$implode = array();

				$filters = explode(',', $data['filter_filter']);

				foreach ($filters as $filter_id) {
					$implode[] = (int)$filter_id;
				}

				$sql .= " AND pf.filter_id IN (" . implode(',', $implode) . ")";

				if (count($implode) > 1) {
					$filter_sql = "SELECT * FROM " . DB_PREFIX . "filter WHERE filter_id IN (" . implode(',', $implode) . ")";
					$filter_query = $this->db->query($filter_sql);

					$filter_groups = array();

					foreach ($filter_query->rows as $filter_result) {
						$filter_id = $filter_result['filter_id'];
						$filter_group_id = $filter_result['filter_group_id'];

						if (!isset($filter_groups[$filter_group_id])) {
							$filter_groups[$filter_group_id] = array();
						}

						$filter_groups[$filter_group_id][] = $filter_id;
					}

					$total_groups = count($filter_groups);

					$sql .= " AND p.product_id IN ( SELECT pf2.product_id FROM " . DB_PREFIX . "product_filter pf2 WHERE pf2.filter_id IN (" . implode(',', $implode) . ") GROUP BY pf2.product_id HAVING COUNT(pf2.product_id) = {$total_groups} ) ";
				}
			
			}
		}

		if (!empty($data['filter_name']) || !empty($data['filter_tag'])) {
			$sql .= " AND (";

			if (!empty($data['filter_name'])) {
				$implode = array();

				$words = explode(' ', trim(preg_replace('/\s+/', ' ', $data['filter_name'])));

				foreach ($words as $word) {
					$implode[] = "pd.name LIKE '%" . $this->db->escape($word) . "%'";
				}

				if ($implode) {
					$sql .= " " . implode(" AND ", $implode) . "";
				}

				if (!empty($data['filter_description'])) {
					$sql .= " OR pd.description LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
				}
			}

			if (!empty($data['filter_name']) && !empty($data['filter_tag'])) {
				$sql .= " OR ";
			}

			if (!empty($data['filter_tag'])) {
				$sql .= "pd.tag LIKE '%" . $this->db->escape(utf8_strtolower($data['filter_tag'])) . "%'";
			}

			if (!empty($data['filter_name'])) {
				$sql .= " OR LCASE(p.model) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.sku) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.upc) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.ean) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.jan) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.isbn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				$sql .= " OR LCASE(p.mpn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";

				$sql .= " OR p.manufacturer_id IN (SELECT manufacturer_id FROM `" . DB_PREFIX . "manufacturer` WHERE LCASE(name) LIKE '%" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%') ";
			
			}

			$sql .= ")";
		}


				if (isset($data['filter_has_stock']) && $data['filter_has_stock'] == true) {
					$sql .= " AND (p.quantity > 0 OR p.subtract = 0) ";
				}
			
		if (!empty($data['filter_manufacturer_id'])) {
			$sql .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer_id'] . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getProfiles($product_id) {
		return $this->db->query("SELECT `pd`.* FROM `" . DB_PREFIX . "product_recurring` `pp` JOIN `" . DB_PREFIX . "recurring_description` `pd` ON `pd`.`language_id` = " . (int)$this->config->get('config_language_id') . " AND `pd`.`recurring_id` = `pp`.`recurring_id` JOIN `" . DB_PREFIX . "recurring` `p` ON `p`.`recurring_id` = `pd`.`recurring_id` WHERE `product_id` = " . (int)$product_id . " AND `status` = 1 AND `customer_group_id` = " . (int)$this->config->get('config_customer_group_id') . " ORDER BY `sort_order` ASC")->rows;
	}

	public function getProfile($product_id, $recurring_id) {
		return $this->db->query("SELECT * FROM `" . DB_PREFIX . "recurring` `p` JOIN `" . DB_PREFIX . "product_recurring` `pp` ON `pp`.`recurring_id` = `p`.`recurring_id` AND `pp`.`product_id` = " . (int)$product_id . " WHERE `pp`.`recurring_id` = " . (int)$recurring_id . " AND `status` = 1 AND `pp`.`customer_group_id` = " . (int)$this->config->get('config_customer_group_id'))->row;
	}

	public function getTotalProductSpecials() {

				$where = '';
				if ($this->config->get('config_stock_show_products') == '0'){
					$where = ' AND (p.quantity > 0 OR p.subtract = 0) ';
				}
			
		$query = $this->db->query("SELECT COUNT(DISTINCT ps.product_id) AS total FROM " . DB_PREFIX . "product_special ps LEFT JOIN " . DB_PREFIX . "product p ON (ps.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND ps.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) {$where}");

		if (isset($query->row['total'])) {
			return $query->row['total'];
		} else {
			return 0;
		}
	}
}
