<?php
class ControllerProductProduct extends Controller {
	private $error = array();

	public function index() {

				$language_id = $this->config->get('config_language_id');
				$data['language_id'] = $language_id;

				$config_stock_text_out = $this->config->has('config_stock_text_out') ? $this->config->get('config_stock_text_out') : array();
				$config_stock_text_out = isset($config_stock_text_out[$language_id]) ? trim($config_stock_text_out[$language_id]) : '';
				$data['config_stock_text_out'] = $config_stock_text_out;
			

				$this->load->model('module/exibir_parcelamento');
				$_parc_config = $this->model_module_exibir_parcelamento->getParcelamentoConfig();
			

				$this->load->model('module/exibir_descontos');
				$_desc_config = $this->model_module_exibir_descontos->getDescontosConfig();
			
		$this->load->language('product/product');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$this->load->model('catalog/category');

		if (isset($this->request->get['path'])) {
			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path)
					);
				}
			}

			// Set the last category breadcrumb
			$category_info = $this->model_catalog_category->getCategory($category_id);

			if ($category_info) {
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}

				if (isset($this->request->get['limit'])) {
					$url .= '&limit=' . $this->request->get['limit'];
				}

				$data['breadcrumbs'][] = array(
					'text' => $category_info['name'],
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url)
				);
			}
		}

		$this->load->model('catalog/manufacturer');

		if (isset($this->request->get['manufacturer_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_brand'),
				'href' => $this->url->link('product/manufacturer')
			);

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);

			if ($manufacturer_info) {
				$data['breadcrumbs'][] = array(
					'text' => $manufacturer_info['name'],
					'href' => $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $this->request->get['manufacturer_id'] . $url)
				);
			}
		}

		if (isset($this->request->get['search']) || isset($this->request->get['tag'])) {
			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_search'),
				'href' => $this->url->link('product/search', $url)
			);
		}

		if (isset($this->request->get['product_id'])) {
			$product_id = (int)$this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		$this->load->model('catalog/product');

		$product_info = $this->model_catalog_product->getProduct($product_id);

		if ($product_info) {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $product_info['name'],
				'href' => $this->url->link('product/product', $url . '&product_id=' . $this->request->get['product_id'])
			);

			$this->document->setTitle($product_info['meta_title']);
			$this->document->setDescription($product_info['meta_description']);
			$this->document->setKeywords($product_info['meta_keyword']);
			$this->document->addLink($this->url->link('product/product', 'product_id=' . $this->request->get['product_id']), 'canonical');
			$this->document->addScript('catalog/view/javascript/jquery/magnific/jquery.magnific-popup.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/magnific/magnific-popup.css');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
			$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
			$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');

			$data['heading_title'] = $product_info['name'];

			$data['text_select'] = $this->language->get('text_select');
			$data['text_manufacturer'] = $this->language->get('text_manufacturer');
			$data['text_model'] = $this->language->get('text_model');
			$data['text_reward'] = $this->language->get('text_reward');
			$data['text_points'] = $this->language->get('text_points');
			$data['text_stock'] = $this->language->get('text_stock');
			$data['text_discount'] = $this->language->get('text_discount');
			$data['text_tax'] = $this->language->get('text_tax');
			$data['text_option'] = $this->language->get('text_option');
			$data['text_minimum'] = sprintf($this->language->get('text_minimum'), $product_info['minimum']);
			$data['text_write'] = $this->language->get('text_write');
			$data['text_login'] = sprintf($this->language->get('text_login'), $this->url->link('account/login', '', 'SSL'), $this->url->link('account/register', '', 'SSL'));
			$data['text_note'] = $this->language->get('text_note');
			$data['text_tags'] = $this->language->get('text_tags');
			$data['text_related'] = $this->language->get('text_related');
			$data['text_loading'] = $this->language->get('text_loading');


				$this->load->language('checkout/checkout');

				$data['entry_country']         = $this->language->get('entry_country');
				$data['entry_postcode']        = $this->language->get('entry_postcode');
				$data['entry_zone']            = $this->language->get('entry_zone');
				$data['text_none']             = $this->language->get('text_none');
				$data['text_shipping_rate']    = $this->language->get('text_shipping_rate');
				$data['text_shipping_methods'] = $this->language->get('text_shipping_methods');
				$data['button_get_shipping']   = $this->language->get('button_get_shipping');
				$data['button_cancel']         = $this->language->get('button_cancel');
				$data['button_close']          = $this->language->get('button_close');

				$data['config_product_page_shipping'] = $this->config->has('config_product_page_shipping') ? $this->config->get('config_product_page_shipping') : 1;
				$data['config_campo_pais'] = $this->config->get('config_campo_pais');

				if (isset($this->session->data['shipping_address']['country_id'])) {
					$data['country_id'] = $this->session->data['shipping_address']['country_id'];
				} else {
					$data['country_id'] = $this->config->get('config_country_id');
				}

				if (isset($this->session->data['shipping_address']['postcode'])) {
					$data['postcode'] = $this->session->data['shipping_address']['postcode'];
				} else {
					$data['postcode'] = '';
				}

				if (isset($this->session->data['shipping_address']['zone_id'])) {
					$data['zone_id'] = $this->session->data['shipping_address']['zone_id'];
				} else {
					$data['zone_id'] = '';
				}

				$this->load->model('localisation/country');
				$data['countries'] = $this->model_localisation_country->getCountries();

				$raw_info = isset($product_info['raw_info']) ? $product_info['raw_info'] : array();

				$data['product_shipping'] = isset($raw_info) && isset($raw_info['shipping']) && $raw_info['shipping'] == '1';
			
			$data['entry_qty'] = $this->language->get('entry_qty');
			$data['entry_name'] = $this->language->get('entry_name');
			$data['entry_review'] = $this->language->get('entry_review');
			$data['entry_rating'] = $this->language->get('entry_rating');
			$data['entry_good'] = $this->language->get('entry_good');
			$data['entry_bad'] = $this->language->get('entry_bad');

			$data['button_cart'] = $this->language->get('button_cart');
			$data['button_wishlist'] = $this->language->get('button_wishlist');
			$data['button_compare'] = $this->language->get('button_compare');
			$data['button_upload'] = $this->language->get('button_upload');
			$data['button_continue'] = $this->language->get('button_continue');

			$this->load->model('catalog/review');

			$data['tab_description'] = $this->language->get('tab_description');
			$data['tab_attribute'] = $this->language->get('tab_attribute');
			$data['tab_review'] = sprintf($this->language->get('tab_review'), $product_info['reviews']);

			$data['product_id'] = (int)$this->request->get['product_id'];
			$data['manufacturer'] = $product_info['manufacturer'];
			$data['manufacturers'] = $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $product_info['manufacturer_id']);
			$data['model'] = $product_info['model'];
			$data['reward'] = $product_info['reward'];
			$data['points'] = $product_info['points'];

			if ($product_info['quantity'] <= 0) {
				$data['stock'] = $product_info['stock_status'];
			} elseif ($this->config->get('config_stock_display')) {
				$data['stock'] = $product_info['quantity'];
			} else {
				
				if ($product_info['in_stock_status'] != '') {
					$data['stock'] = $product_info['in_stock_status'];
				} else {
					$data['stock'] = $this->language->get('text_instock');
				}
			
			}

			$this->load->model('tool/image');

			if ($product_info['image']) {
				$data['popup'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height'));
			} else {
				$data['popup'] = '';
			}

			if ($product_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height'));
			} else {
				$data['thumb'] = '';
			}

			$data['images'] = array();

			$results = $this->model_catalog_product->getProductImages($this->request->get['product_id']);

			foreach ($results as $result) {
				$data['images'][] = array(
					'popup' => $this->model_tool_image->resize($result['image'], $this->config->get('config_image_popup_width'), $this->config->get('config_image_popup_height')),
					'thumb' => $this->model_tool_image->resize($result['image'], $this->config->get('config_image_additional_width'), $this->config->get('config_image_additional_height'))
				);
			}

			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$data['price'] = false;
			}

			if ((float)$product_info['special']) {
				$data['special'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$data['special'] = false;
			}

			if ($this->config->get('config_tax')) {
				$data['tax'] = $this->currency->format((float)$product_info['special'] ? $product_info['special'] : $product_info['price']);
			} else {
				$data['tax'] = false;
			}


				$data['descontos_cfg'] = $_desc_config;
			

				$data['parcelamentos_cfg'] = $_parc_config;
			
			$discounts = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);

			$data['discounts'] = array();

			foreach ($discounts as $discount) {
				$data['discounts'][] = array(
					'quantity' => $discount['quantity'],
					'price'    => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], $this->config->get('config_tax')))
				);
			}

			$data['options'] = array();

			foreach ($this->model_catalog_product->getProductOptions($this->request->get['product_id']) as $option) {
				$product_option_value_data = array();

				foreach ($option['product_option_value'] as $option_value) {
					if (!$option_value['subtract'] || $option['raw_info']['combination'] || ($option_value['quantity'] > 0)) {
						if ((($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) && (float)$option_value['price']) {
							$price = $this->currency->format($this->tax->calculate($option_value['price'], $product_info['tax_class_id'], $this->config->get('config_tax') ? 'P' : false));
						} else {
							$price = false;
						}

						$product_option_value_data[] = array(

				'raw_info' => $option_value['raw_info'],
			
							'product_option_value_id' => $option_value['product_option_value_id'],
							'option_value_id'         => $option_value['option_value_id'],
							'name'                    => $option_value['name'],
							'image'                   => $this->model_tool_image->resize($option_value['image'], 150, 150),
							'price'                   => $price,
							'price_prefix'            => $option_value['price_prefix']
						);
					}
				}

				$data['options'][] = array(

				'raw_info' => $option['raw_info'],
			
					'product_option_id'    => $option['product_option_id'],
					'product_option_value' => $product_option_value_data,
					'option_id'            => $option['option_id'],
					'name'                 => $option['name'],
					'type'                 => $option['type'],
					'value'                => $option['value'],
					'required'             => $option['required']
				);
			}

			if ($product_info['minimum']) {
				$data['minimum'] = $product_info['minimum'];
			} else {
				$data['minimum'] = 1;
			}

			$data['review_status'] = $this->config->get('config_review_status');

			if ($this->config->get('config_review_guest') || $this->customer->isLogged()) {
				$data['review_guest'] = true;
			} else {
				$data['review_guest'] = false;
			}

			if ($this->customer->isLogged()) {
				$data['customer_name'] = $this->customer->getFirstName() . '&nbsp;' . $this->customer->getLastName();
			} else {
				$data['customer_name'] = '';
			}

			$data['reviews'] = sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']);
			$data['rating'] = (int)$product_info['rating'];
			$data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');
			$data['attribute_groups'] = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);

			$data['products'] = array();

			$results = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('config_image_related_width'), $this->config->get('config_image_related_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('config_image_related_width'), $this->config->get('config_image_related_height'));
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}


				$_descontos = array();

				if ($price || $special) {
					$_desc_price = $special ? $special : $price;
					$_descontos = $this->model_module_exibir_descontos->exibirDescontosListagem($_desc_config, $_desc_price);
				}
			

				$_parcelamentos = array();

				if ($price || $special) {
					$_parc_price = $special ? $special : $price;
					$_parcelamentos = $this->model_module_exibir_parcelamento->exibirParcelamentoListagem($_parc_config, $_parc_price);
				}
			

				$result = array_merge($result, $result['raw_info']);
				unset($result['raw_info']);

				$result['has_stock'] = ($this->config->get('config_stock_checkout') == '1') || ($result['quantity'] > 0) || ($result['subtract'] == '0');
			
				$data['products'][] = array(

				'raw_info' => $result,
				'has_stock' => $result['has_stock'],
			

				'parcelamentos' => $_parcelamentos,
			

				'descontos' => $_descontos,
			
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
				);
			}

			$data['tags'] = array();

			if ($product_info['tag']) {
				$tags = explode(',', $product_info['tag']);

				foreach ($tags as $tag) {
					$data['tags'][] = array(
						'tag'  => trim($tag),
						'href' => $this->url->link('product/search', 'tag=' . trim($tag))
					);
				}
			}

			$data['text_payment_recurring'] = $this->language->get('text_payment_recurring');
			$data['recurrings'] = $this->model_catalog_product->getProfiles($this->request->get['product_id']);

			$this->model_catalog_product->updateViewed($this->request->get['product_id']);

			if ($this->config->get('config_google_captcha_status')) {
				$this->document->addScript('https://www.google.com/recaptcha/api.js');

				$data['site_key'] = $this->config->get('config_google_captcha_public');
			} else {
				$data['site_key'] = '';
			}


				$price = $product_info['price'];
				if ((float)$product_info['special']) {
					$price = $product_info['special'];
				}

				$this->document->setMetaOg('og:type', 'product');
				$this->document->setMetaOg('og:description', $product_info['meta_description']);

				$this->document->setMetaTw('twitter:card', 'product');
				$this->document->setMetaTw('twitter:description', $product_info['meta_description']);
				$this->document->setMetaTw('twitter:label1', 'Preço');
				$this->document->setMetaTw('twitter:data1', $this->currency->format($this->tax->calculate($price, $product_info['tax_class_id'], $this->config->get('config_tax'))));
				$this->document->setMetaTw('twitter:label2', 'Disponibilidade');
				$this->document->setMetaTw('twitter:data2', $this->language->get('text_instock'));

				$this->load->model('tool/image');

				$imgfb_big_w = 1200;
				$imgfb_big_h = 630;

				$imgfb_small_w = 600;
				$imgfb_small_h = 315;

				$image_w = $this->config->get('config_image_popup_width');
				$image_h = $this->config->get('config_image_popup_height');

				$thumb_w = $this->config->get('config_image_thumb_width');
				$thumb_h = $this->config->get('config_image_thumb_height');

				$total_images = 0;

				if ($product_info['image']) {
					$ogimage = $this->model_tool_image->resize($product_info['image'], $imgfb_big_w, $imgfb_big_h);
					$this->document->setMetaOg('og:image', $ogimage);

					$ogimage = $this->model_tool_image->resize($product_info['image'], $imgfb_small_w, $imgfb_small_h);
					$this->document->setMetaOg('og:image', $ogimage);

					$ogimage = $this->model_tool_image->resize($product_info['image'], $image_w, $image_h);
					$this->document->setMetaOg('og:image', $ogimage);

					$ogimage = $this->model_tool_image->resize($product_info['image'], $thumb_w, $thumb_h);
					$this->document->setMetaOg('og:image', $ogimage);

					$this->document->setMetaTw('twitter:image', $ogimage);
					$this->document->setMetaTw('twitter:image:width', $image_w);
					$this->document->setMetaTw('twitter:image:height', $image_h);

					$total_images++;
				}

				if ($total_images == 0) {
					$other_images = $this->model_catalog_product->getProductImages($product_id);

					foreach ($other_images as $other_image) {
						if ($total_images > 0) {
							break;
						}

						$ogimage = $this->model_tool_image->resize($other_image['image'], $imgfb_big_w, $imgfb_big_h);
						$this->document->setMetaOg('og:image', $ogimage);

						$ogimage = $this->model_tool_image->resize($other_image['image'], $imgfb_small_w, $imgfb_small_h);
						$this->document->setMetaOg('og:image', $ogimage);

						$ogimage = $this->model_tool_image->resize($other_image['image'], $image_w, $image_h);
						$this->document->setMetaOg('og:image', $ogimage);

						$ogimage = $this->model_tool_image->resize($other_image['image'], $thumb_w, $thumb_h);

						$total_images++;
					}
				}
			

				$data['text_combination_loading']      = $this->language->get('text_combination_loading');
				$data['text_combination_in_stock']     = $this->language->get('text_combination_in_stock');
				$data['text_combination_out_of_stock'] = $this->language->get('text_combination_out_of_stock');
				$data['text_combination_not_avail']    = $this->language->get('text_combination_not_avail');
				$data['text_combination_id_missing']   = $this->language->get('text_combination_id_missing');

				$raw_info = isset($product_info['raw_info']) ? $product_info['raw_info'] : array();
				$data['raw_info'] = $raw_info;

				$data['has_combination'] = false;
				foreach ($data['options'] as $option) {
					if ($option['raw_info']['combination']) {
						$data['has_combination'] = true;
						break;
					}
				}
			

				$data['has_stock'] = ($this->config->get('config_stock_checkout') == '1') || ($product_info['quantity'] > 0) || ($product_info['subtract'] == '0');
			
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/product.tpl')) {
				$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/product/product.tpl', $data));
			} else {
				$this->response->setOutput($this->load->view('default/template/product/product.tpl', $data));
			}
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['manufacturer_id'])) {
				$url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
			}

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . $this->request->get['search'];
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . $this->request->get['tag'];
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/product', $url . '&product_id=' . $product_id)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['heading_title'] = $this->language->get('text_error');

			$data['text_error'] = $this->language->get('text_error');

			$data['button_continue'] = $this->language->get('button_continue');

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/error/not_found.tpl', $data));
			} else {
				$this->response->setOutput($this->load->view('default/template/error/not_found.tpl', $data));
			}
		}
	}

	public function review() {
		$this->load->language('product/product');

		$this->load->model('catalog/review');

		$data['text_no_reviews'] = $this->language->get('text_no_reviews');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$data['reviews'] = array();

		$review_total = $this->model_catalog_review->getTotalReviewsByProductId($this->request->get['product_id']);

		$results = $this->model_catalog_review->getReviewsByProductId($this->request->get['product_id'], ($page - 1) * 5, 5);

		foreach ($results as $result) {
			$data['reviews'][] = array(
				'author'     => $result['author'],
				'text'       => nl2br($result['text']),
				'rating'     => (int)$result['rating'],
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}

		$pagination = new Pagination();
		$pagination->total = $review_total;
		$pagination->page = $page;
		$pagination->limit = 5;
		$pagination->url = $this->url->link('product/product/review', 'product_id=' . $this->request->get['product_id'] . '&page={page}');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($review_total) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($review_total - 5)) ? $review_total : ((($page - 1) * 5) + 5), $review_total, ceil($review_total / 5));

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/review.tpl')) {
			$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/product/review.tpl', $data));
		} else {
			$this->response->setOutput($this->load->view('default/template/product/review.tpl', $data));
		}
	}

	public function write() {
		$this->load->language('product/product');

		$json = array();

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 25)) {
				$json['error'] = $this->language->get('error_name');
			}

			if ((utf8_strlen($this->request->post['text']) < 25) || (utf8_strlen($this->request->post['text']) > 1000)) {
				$json['error'] = $this->language->get('error_text');
			}

			if (empty($this->request->post['rating']) || $this->request->post['rating'] < 0 || $this->request->post['rating'] > 5) {
				$json['error'] = $this->language->get('error_rating');
			}

			if ($this->config->get('config_google_captcha_status') && empty($json['error'])) {
				if (isset($this->request->post['g-recaptcha-response'])) {
					$recaptcha = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($this->config->get('config_google_captcha_secret')) . '&response=' . $this->request->post['g-recaptcha-response'] . '&remoteip=' . $this->request->server['REMOTE_ADDR']);

					$recaptcha = json_decode($recaptcha, true);

					if (!$recaptcha['success']) {
						$json['error'] = $this->language->get('error_captcha');
					}
				} else {
					$json['error'] = $this->language->get('error_captcha');
				}
			}

			if (!isset($json['error'])) {
				$this->load->model('catalog/review');

				$this->model_catalog_review->addReview($this->request->get['product_id'], $this->request->post);

				$json['success'] = $this->language->get('text_success');
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}


				public function productOptionStatus() {
					$this->language->load('product/product');

					$json = array();

					$product_id  = isset($this->request->post['product_id']) ? $this->request->post['product_id'] : 0;
					$combination = isset($this->request->post['combination']) ? $this->request->post['combination'] : '';

					if ($this->config->get('config_stock_checkout') == '1') {
						$productOptionStatusName = $this->_getProductOptionStatusName($product_id);
						$json['success'] = $productOptionStatusName['in_stock_status'];

					} else {
						if ($product_id == 0 || $combination == '') {
							$json['error'] = $this->language->get('text_combination_id_missing');

						} else {
							$product_id  = (int)$product_id;
							$combination = $this->db->escape($combination);

							$sql = "SELECT * FROM `" . DB_PREFIX . "product_option_combination` WHERE `product_id` = '{$product_id}' AND `combination` = '{$combination}' LIMIT 1";
							$option_query = $this->db->query($sql);

							if ($option_query->num_rows) {
								$combination = $option_query->row;

								if ($combination['active'] != 1) {
									$json['error'] = $this->language->get('text_combination_not_avail');

								} else {
									if ($combination['quantity'] > 0 || $combination['subtract'] == 0) {
										$productOptionStatusName = $this->_getProductOptionStatusName($product_id);
										$json['success'] = $productOptionStatusName['in_stock_status'];
									} else {
										$productOptionStatusName = $this->_getProductOptionStatusName($product_id);
										$json['error'] = $productOptionStatusName['stock_status'];
									}
								}

							} else {
								$json['error'] = $this->language->get('text_combination_id_missing');
							}
						}
					}

					$this->response->addHeader('Content-Type: application/json');
					$this->response->setOutput(json_encode($json));
				}

				private function _getProductOptionStatusName($product_id) {
					$this->language->load('product/product');

					$stock_names = array(
						'stock_status' => $this->language->get('text_combination_out_of_stock'),
						'in_stock_status' => $this->language->get('text_combination_in_stock')
					);

					$product_id = intval($product_id);

					if ($product_id > 0) {
						$this->load->model('catalog/product');

						if (method_exists($this->model_catalog_product, 'getProductStockStatusNames') && is_callable(array($this->model_catalog_product, 'getProductStockStatusNames'))) {
							$status = $this->model_catalog_product->getProductStockStatusNames($product_id);

							if ($status['stock_status'] != '') {
								$stock_names['stock_status'] = $status['stock_status'];
							}

							if ($status['in_stock_status'] != '') {
								$stock_names['in_stock_status'] = $status['in_stock_status'];
							}
						}
					}

					return $stock_names;
				}
			

				public function quoteShipping() {
					$this->load->language('checkout/cart');

					$json = array();

					if (isset($this->request->post['product_id'])) {
						$product_id = (int)$this->request->post['product_id'];
					} else {
						$product_id = 0;
					}

					$this->load->model('catalog/product');

					$product_info = $this->model_catalog_product->getProduct($product_id);

					if ($product_info) {
						if (isset($this->request->post['quantity']) && ((int)$this->request->post['quantity'] >= $product_info['minimum'])) {
							$quantity = (int)$this->request->post['quantity'];
						} else {
							$quantity = $product_info['minimum'] ? $product_info['minimum'] : 1;
						}

						if (isset($this->request->post['option'])) {
							$option = array_filter($this->request->post['option']);
						} else {
							$option = array();
						}

						$product_options = $this->model_catalog_product->getProductOptions($this->request->post['product_id']);

						foreach ($product_options as $product_option) {
							if ($product_option['required'] && empty($option[$product_option['product_option_id']])) {
								$json['error']['option'][$product_option['product_option_id']] = sprintf($this->language->get('error_required'), $product_option['name']);
							}
						}

						if (isset($this->request->post['recurring_id'])) {
							$recurring_id = $this->request->post['recurring_id'];
						} else {
							$recurring_id = 0;
						}

						$recurrings = $this->model_catalog_product->getProfiles($product_info['product_id']);

						if ($recurrings) {
							$recurring_ids = array();

							foreach ($recurrings as $recurring) {
								$recurring_ids[] = $recurring['recurring_id'];
							}

							if (!in_array($recurring_id, $recurring_ids)) {
								$json['error']['recurring'] = $this->language->get('error_recurring_required');
							}
						}

						if (!$json) {
							// guarda carrinho atual
							$this->session->data['cacheCart'] = $this->cart->getProducts();

							// limpa o carrinho
							$this->cart->clear();

							// adiciona o produto atual no carrinho
							$this->cart->add($product_id, $quantity, $option, $recurring_id);

							// chama o cálculo do frete
							$json = $this->quoteShipping2();

							// limpa novamente o carrinho
							$this->cart->clear();

							// retorna os produtos anteriores ao carrinho
							foreach ($this->session->data['cacheCart'] as $product_cart) {
								$tmp_options = array();
								foreach ($product_cart['option'] as $po) {
									$po_id = $po['product_option_id'];
									$po_type = $po['type'];

									if ($po_type == 'select' || $po_type == 'radio' || $po_type == 'image') {
										$tmp_options[$po_id] = $po['product_option_value_id'];
									} elseif ($po_type == 'checkbox') {
										$tmp_options[$po_id] = isset($tmp_options[$po_id]) && is_array($tmp_options[$po_id]) ? $tmp_options[$po_id] : array();
										$tmp_options[$po_id][] = $po['product_option_value_id'];
									} elseif ($po_type == 'text' || $po_type == 'textarea' || $po_type == 'file' || $po_type == 'date' || $po_type == 'datetime' || $po_type == 'time') {
										$tmp_options[$po_id] = $po['value'];
									}
								}
								$this->cart->add($product_cart['product_id'], $product_cart['quantity'], $tmp_options, $product_cart['recurring']);
							}

							unset($this->session->data['cacheCart']);
						}

					} else {
						$json['error'] = $this->language->get('error_product');
					}

					$this->response->addHeader('Content-Type: application/json');
					$this->response->setOutput(json_encode($json));
				}

				public function quoteShipping2() {
					$this->load->language('checkout/shipping');

					$json = array();

					if (!$this->cart->hasProducts()) {
						$json['error']['warning'] = $this->language->get('error_product');
					}

					if (!$this->cart->hasShipping()) {
						$json['error']['warning'] = sprintf($this->language->get('error_no_shipping'), $this->url->link('information/contact'));
					}

					if ($this->request->post['country_id'] == '') {
						$json['error']['country'] = $this->language->get('error_country');
					}

					if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
						$json['error']['zone'] = $this->language->get('error_zone');
					}

					$this->load->model('localisation/country');

					$country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

					if ($country_info && $country_info['postcode_required'] && (utf8_strlen(trim($this->request->post['postcode'])) < 2 || utf8_strlen(trim($this->request->post['postcode'])) > 10)) {
						$json['error']['postcode'] = $this->language->get('error_postcode');
					}

					if (!$json) {
						$this->tax->setShippingAddress($this->request->post['country_id'], $this->request->post['zone_id']);

						if ($country_info) {
							$country = $country_info['name'];
							$iso_code_2 = $country_info['iso_code_2'];
							$iso_code_3 = $country_info['iso_code_3'];
							$address_format = $country_info['address_format'];
						} else {
							$country = '';
							$iso_code_2 = '';
							$iso_code_3 = '';
							$address_format = '';
						}

						$this->load->model('localisation/zone');

						$zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);

						if ($zone_info) {
							$zone = $zone_info['name'];
							$zone_code = $zone_info['code'];
						} else {
							$zone = '';
							$zone_code = '';
						}

						$this->session->data['shipping_address'] = array(
							'firstname'      => '',
							'lastname'       => '',
							'company'        => '',
							'address_1'      => '',
							'address_2'      => '',
							'postcode'       => $this->request->post['postcode'],
							'city'           => '',
							'zone_id'        => $this->request->post['zone_id'],
							'zone'           => $zone,
							'zone_code'      => $zone_code,
							'country_id'     => $this->request->post['country_id'],
							'country'        => $country,
							'iso_code_2'     => $iso_code_2,
							'iso_code_3'     => $iso_code_3,
							'address_format' => $address_format
						);

						$quote_data = array();

						$this->load->model('extension/extension');

						$results = $this->model_extension_extension->getExtensions('shipping');

						foreach ($results as $result) {
							if ($this->config->get($result['code'] . '_status')) {
								$this->load->model('shipping/' . $result['code']);

								$quote = $this->{'model_shipping_' . $result['code']}->getQuote($this->session->data['shipping_address']);

								if ($quote) {
									$quote_data[$result['code']] = array(
										'title'      => $quote['title'],
										'quote'      => $quote['quote'],
										'sort_order' => $quote['sort_order'],
										'error'      => $quote['error']
									);
								}
							}
						}

						$sort_order = array();

						foreach ($quote_data as $key => $value) {
							$sort_order[$key] = $value['sort_order'];
						}

						array_multisort($sort_order, SORT_ASC, $quote_data);

						$this->session->data['shipping_methods'] = $quote_data;

						if ($this->session->data['shipping_methods']) {
							$json['shipping_method'] = $this->session->data['shipping_methods'];
						} else {
							$json['error']['warning'] = sprintf($this->language->get('error_no_shipping'), $this->url->link('information/contact'));
						}
					}

					return $json;
				}
			
	public function getRecurringDescription() {
		$this->language->load('product/product');
		$this->load->model('catalog/product');

		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		} else {
			$product_id = 0;
		}

		if (isset($this->request->post['recurring_id'])) {
			$recurring_id = $this->request->post['recurring_id'];
		} else {
			$recurring_id = 0;
		}

		if (isset($this->request->post['quantity'])) {
			$quantity = $this->request->post['quantity'];
		} else {
			$quantity = 1;
		}

		$product_info = $this->model_catalog_product->getProduct($product_id);
		$recurring_info = $this->model_catalog_product->getProfile($product_id, $recurring_id);

		$json = array();

		if ($product_info && $recurring_info) {
			if (!$json) {
				$frequencies = array(
					'day'        => $this->language->get('text_day'),
					'week'       => $this->language->get('text_week'),
					'semi_month' => $this->language->get('text_semi_month'),
					'month'      => $this->language->get('text_month'),
					'year'       => $this->language->get('text_year'),
				);

				if ($recurring_info['trial_status'] == 1) {
					$price = $this->currency->format($this->tax->calculate($recurring_info['trial_price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')));
					$trial_text = sprintf($this->language->get('text_trial_description'), $price, $recurring_info['trial_cycle'], $frequencies[$recurring_info['trial_frequency']], $recurring_info['trial_duration']) . ' ';
				} else {
					$trial_text = '';
				}

				$price = $this->currency->format($this->tax->calculate($recurring_info['price'] * $quantity, $product_info['tax_class_id'], $this->config->get('config_tax')));

				if ($recurring_info['duration']) {
					$text = $trial_text . sprintf($this->language->get('text_payment_description'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				} else {
					$text = $trial_text . sprintf($this->language->get('text_payment_cancel'), $price, $recurring_info['cycle'], $frequencies[$recurring_info['frequency']], $recurring_info['duration']);
				}

				$json['success'] = $text;
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
