<?php
class ControllerModuleRandom extends Controller {
	public function index($setting) {

				$language_id = $this->config->get('config_language_id');
				$data['language_id'] = $language_id;

				$config_stock_text_out = $this->config->has('config_stock_text_out') ? $this->config->get('config_stock_text_out') : array();
				$config_stock_text_out = isset($config_stock_text_out[$language_id]) ? trim($config_stock_text_out[$language_id]) : '';
				$data['config_stock_text_out'] = $config_stock_text_out;
			

				$this->load->model('module/exibir_parcelamento');
				$_parc_config = $this->model_module_exibir_parcelamento->getParcelamentoConfig();
			

				$this->load->model('module/exibir_descontos');
				$_desc_config = $this->model_module_exibir_descontos->getDescontosConfig();
			
		$this->load->language('module/random');

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_tax'] = $this->language->get('text_tax');

		$data['button_cart'] = $this->language->get('button_cart');
		$data['button_wishlist'] = $this->language->get('button_wishlist');
		$data['button_compare'] = $this->language->get('button_compare');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$data['setting'] = $setting;

		$language_id = $this->config->get('config_language_id');
		$data['heading_title'] = trim(isset($setting['title'][$language_id]) ? $setting['title'][$language_id] : $data['heading_title']);

		$data['products'] = array();

		$results = $this->model_catalog_product->getRandomProducts($setting['limit']);

		if ($results) {
			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']);
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = $result['rating'];
				} else {
					$rating = false;
				}


				$_descontos = array();

				if ($price || $special) {
					$_desc_price = $special ? $special : $price;
					$_descontos = $this->model_module_exibir_descontos->exibirDescontosListagem($_desc_config, $_desc_price);
				}
			

				$_parcelamentos = array();

				if ($price || $special) {
					$_parc_price = $special ? $special : $price;
					$_parcelamentos = $this->model_module_exibir_parcelamento->exibirParcelamentoListagem($_parc_config, $_parc_price);
				}
			

				$result = array_merge($result, $result['raw_info']);
				unset($result['raw_info']);

				$result['has_stock'] = ($this->config->get('config_stock_checkout') == '1') || ($result['quantity'] > 0) || ($result['subtract'] == '0');
			
				$data['products'][] = array(

				'raw_info' => $result,
				'has_stock' => $result['has_stock'],
			

				'parcelamentos' => $_parcelamentos,
			

				'descontos' => $_descontos,
			
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id']),
				);
			}

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/random.tpl')) {
				return $this->load->view($this->config->get('config_template') . '/template/module/random.tpl', $data);
			} else {
				return $this->load->view('default/template/module/random.tpl', $data);
			}
		}
	}
}