<?php
class ControllerModuleFeatured extends Controller {
	public function index($setting) {

				$language_id = $this->config->get('config_language_id');
				$data['language_id'] = $language_id;

				$config_stock_text_out = $this->config->has('config_stock_text_out') ? $this->config->get('config_stock_text_out') : array();
				$config_stock_text_out = isset($config_stock_text_out[$language_id]) ? trim($config_stock_text_out[$language_id]) : '';
				$data['config_stock_text_out'] = $config_stock_text_out;
			

				$this->load->model('module/exibir_parcelamento');
				$_parc_config = $this->model_module_exibir_parcelamento->getParcelamentoConfig();
			

				$this->load->model('module/exibir_descontos');
				$_desc_config = $this->model_module_exibir_descontos->getDescontosConfig();
			
		$this->load->language('module/featured');

		$data['heading_title'] = $this->language->get('heading_title');

				$data['setting'] = $setting;

				$language_id = $this->config->get('config_language_id');
				$data['heading_title'] = trim(isset($setting['title'][$language_id]) ? $setting['title'][$language_id] : $data['heading_title']);
			

		$data['text_tax'] = $this->language->get('text_tax');

		$data['button_cart'] = $this->language->get('button_cart');
		$data['button_wishlist'] = $this->language->get('button_wishlist');
		$data['button_compare'] = $this->language->get('button_compare');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$data['products'] = array();

		if (!$setting['limit']) {
			$setting['limit'] = 4;
		}

		if (!empty($setting['product'])) {
			$products = array_slice($setting['product'], 0, (int)$setting['limit']);

				$products = $setting['product'];
				$total = 0;

				$featured_products_in_stock = array();
				$featured_products_out_stock = array();
			

			foreach ($products as $product_id) {
				$product_info = $this->model_catalog_product->getProduct($product_id);

					if (!$product_info) {
						continue;
					}

					if ($total >= (int)$setting['limit']) {
						break;
					}

					if ($this->config->get('config_stock_checkout') == '0' && $product_info['quantity'] <= 0 && $product_info['subtract'] == '1'){
						if ($this->config->get('config_stock_show_products') == '0'){
							// não exibir produtos sem estoque
							continue;
						}
						if ($this->config->get('config_stock_show_products') == '2'){
							// exibir produtos sem estoque por último nas listagens
							$featured_products_out_stock[] = $product_info;
							$total++;
							continue;
						}
					}

					// produto em estoque, exibe normalmente
					$featured_products_in_stock[] = $product_info;
					$total++;

				} // foreach

				$products = array_merge($featured_products_in_stock, $featured_products_out_stock);

				foreach($products as $product_info){
					$result = $product_info;
			

				if ($product_info) {
					if ($product_info['image']) {
						$image = $this->model_tool_image->resize($product_info['image'], $setting['width'], $setting['height']);
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
					}

					if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
						$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
					} else {
						$price = false;
					}

					if ((float)$product_info['special']) {
						$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
					} else {
						$special = false;
					}

					if ($this->config->get('config_tax')) {
						$tax = $this->currency->format((float)$product_info['special'] ? $product_info['special'] : $product_info['price']);
					} else {
						$tax = false;
					}

					if ($this->config->get('config_review_status')) {
						$rating = $product_info['rating'];
					} else {
						$rating = false;
					}


				$_descontos = array();

				if ($price || $special) {
					$_desc_price = $special ? $special : $price;
					$_descontos = $this->model_module_exibir_descontos->exibirDescontosListagem($_desc_config, $_desc_price);
				}
			

				$_parcelamentos = array();

				if ($price || $special) {
					$_parc_price = $special ? $special : $price;
					$_parcelamentos = $this->model_module_exibir_parcelamento->exibirParcelamentoListagem($_parc_config, $_parc_price);
				}
			

				$result = array_merge($result, $result['raw_info']);
				unset($result['raw_info']);

				$result['has_stock'] = ($this->config->get('config_stock_checkout') == '1') || ($result['quantity'] > 0) || ($result['subtract'] == '0');
			
					$data['products'][] = array(

				'raw_info' => $result,
				'has_stock' => $result['has_stock'],
			

				'parcelamentos' => $_parcelamentos,
			

				'descontos' => $_descontos,
			
						'product_id'  => $product_info['product_id'],
						'thumb'       => $image,
						'name'        => $product_info['name'],
						'description' => utf8_substr(strip_tags(html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..',
						'price'       => $price,
						'special'     => $special,
						'tax'         => $tax,
						'rating'      => $rating,
						'href'        => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
					);
				}
			}
		}

		if ($data['products']) {
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/featured.tpl')) {
				return $this->load->view($this->config->get('config_template') . '/template/module/featured.tpl', $data);
			} else {
				return $this->load->view('default/template/module/featured.tpl', $data);
			}
		}
	}
}