<?php
class ControllerCommonSeoUrl extends Controller {

				private $url_list = array (
					'account/account'             => 'minha-conta',
					'account/address'             => 'minha-conta/enderecos',
					'account/address/add'         => 'minha-conta/novo-endereco',
					'account/address/edit'        => 'minha-conta/editar-endereco',
					'account/download'            => 'minha-conta/downloads',
					'account/edit'                => 'minha-conta/meus-dados',
					'account/forgotten'           => 'minha-conta/esqueci-minha-senha',
					'account/login'               => 'minha-conta/login',
					'account/logout'              => 'minha-conta/sair',
					'account/newsletter'          => 'minha-conta/newsletter',
					'account/order'               => 'minha-conta/historico-de-pedidos',
					'account/order/info'          => 'minha-conta/detalhes-do-pedido',
					'account/password'            => 'minha-conta/alterar-senha',
					'account/recurring'           => 'minha-conta/assinaturas',
					'account/register'            => 'cadastre-se',
					'account/return'              => 'minha-conta/devolucoes',
					'account/return/add'          => 'solicitar-devolucao',
					'account/reward'              => 'minha-conta/pontos-de-fidelidade',
					'account/transaction'         => 'minha-conta/creditos',
					'account/voucher'             => 'vale-presentes',
					'account/wishlist'            => 'lista-de-desejos',
					'affiliate/account'           => 'afiliados',
					'affiliate/edit'              => 'afiliados/alterar-informacoes',
					'affiliate/forgotten'         => 'afiliados/esqueci-minha-senha',
					'affiliate/login'             => 'afiliados/login',
					'affiliate/logout'            => 'afiliados/sair',
					'affiliate/password'          => 'afiliados/alterar-senha',
					'affiliate/payment'           => 'afiliados/info-para-comissoes',
					'affiliate/register'          => 'afiliados/cadastro',
					'affiliate/tracking'          => 'afiliados/gerador-de-links',
					'affiliate/transaction'       => 'afiliados/comissoes',
					'checkout/cart'               => 'carrinho-de-compras',
					'checkout/checkout'           => 'finalizar-pedido',
					'checkout/success'            => 'pedido-finalizado',
					'common/home'                 => '',
					'information/contact'         => 'contato',
					'information/contact/success' => 'contato/mensagem-enviada',
					'information/sitemap'         => 'mapa-do-site',
					'product/compare'             => 'comparacao-de-produtos',
					'product/manufacturer'        => 'fabricantes',
					'product/search'              => 'busca',
					'product/special'             => 'ofertas-especiais',
				);
			
	public function index() {
		// Add rewrite to url class
		if ($this->config->get('config_seo_url')) {
			$this->url->addRewrite($this);
		}

		// Decode URL
		if (isset($this->request->get['_route_'])) {
			$parts = explode('/', $this->request->get['_route_']);

			// remove any empty arrays from trailing
			if (utf8_strlen(end($parts)) == 0) {
				array_pop($parts);
			}

			foreach ($parts as $part) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE keyword = '" . $this->db->escape($part) . "'");

				if ($query->num_rows) {
					$url = explode('=', $query->row['query']);

					if ($url[0] == 'product_id') {
						$this->request->get['product_id'] = $url[1];
					}

					if ($url[0] == 'category_id') {
						if (!isset($this->request->get['path'])) {
							$this->request->get['path'] = $url[1];
						} else {
							$this->request->get['path'] .= '_' . $url[1];
						}
					}

					if ($url[0] == 'manufacturer_id') {
						$this->request->get['manufacturer_id'] = $url[1];
					}

					if ($url[0] == 'information_id') {
						$this->request->get['information_id'] = $url[1];
					}

					if ($query->row['query'] && $url[0] != 'information_id' && $url[0] != 'manufacturer_id' && $url[0] != 'category_id' && $url[0] != 'product_id') {
						$this->request->get['route'] = $query->row['query'];
					}
				} else {
					$this->request->get['route'] = 'error/not_found';

					break;
				}
			}

				if ( $_s = $this->setURL($this->request->get['_route_']) ) {
					$this->request->get['route'] = $_s;
				}
			

			if (!isset($this->request->get['route'])) {
				if (isset($this->request->get['product_id'])) {
					$this->request->get['route'] = 'product/product';
				} elseif (isset($this->request->get['path'])) {
					$this->request->get['route'] = 'product/category';
				} elseif (isset($this->request->get['manufacturer_id'])) {
					$this->request->get['route'] = 'product/manufacturer/info';
				} elseif (isset($this->request->get['information_id'])) {
					$this->request->get['route'] = 'information/information';
				}
			}

			if (isset($this->request->get['route'])) {
				return new Action($this->request->get['route']);
			}
		}
	}

	public function rewrite($link) {
		$url_info = parse_url(str_replace('&amp;', '&', $link));

		$url = '';

		$data = array();

		parse_str($url_info['query'], $data);

		foreach ($data as $key => $value) {
			if (isset($data['route'])) {
				if (($data['route'] == 'product/product' && $key == 'product_id') || (($data['route'] == 'product/manufacturer/info' || $data['route'] == 'product/product') && $key == 'manufacturer_id') || ($data['route'] == 'information/information' && $key == 'information_id')) {
					$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = '" . $this->db->escape($key . '=' . (int)$value) . "'");

					if ($query->num_rows && $query->row['keyword']) {
						$url .= '/' . $query->row['keyword'];

						unset($data[$key]);
					}
				} elseif ($key == 'path') {
					$categories = explode('_', $value);

					foreach ($categories as $category) {
						$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE `query` = 'category_id=" . (int)$category . "'");

						if ($query->num_rows && $query->row['keyword']) {
							$url .= '/' . $query->row['keyword'];
						} else {
							$url = '';

							break;
						}
					}

					unset($data[$key]);
				}

				if( $_u = $this->getURL($data['route']) ){
					$url .= $_u;
					unset($data[$key]);
				}
			
			}
		}

		if ($url) {
			unset($data['route']);

			$query = '';

			if ($data) {
				foreach ($data as $key => $value) {
					$query .= '&' . rawurlencode((string)$key) . '=' . rawurlencode((string)$value);
				}

				if ($query) {
					$query = '?' . str_replace('&', '&amp;', trim($query, '&'));
				}
			}

			return $url_info['scheme'] . '://' . $url_info['host'] . (isset($url_info['port']) ? ':' . $url_info['port'] : '') . str_replace('/index.php', '', $url_info['path']) . $url . $query;
		} else {
			return $link;
		}
	}

				public function getURL($route) {
						if( count($this->url_list) > 0) {
							 foreach ($this->url_list as $key => $value) {
								if($route == $key) {
									return '/'.$value;
								}
							 }
						}
						return false;
				}
				public function setURL($_route) {
						if( count($this->url_list) > 0 ){
							 foreach ($this->url_list as $key => $value) {
								if($_route == $value) {
									return $key;
								}
							 }
						}
						return false;
				}
			
}
