<?php
class ControllerCheckoutGuest extends Controller {
	public function index() {
		$this->load->language('checkout/checkout');

		$data['text_select'] = $this->language->get('text_select');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_your_details'] = $this->language->get('text_your_details');
		$data['text_your_account'] = $this->language->get('text_your_account');
		$data['text_your_address'] = $this->language->get('text_your_address');
		$data['text_loading'] = $this->language->get('text_loading');

		$data['entry_firstname'] = $this->language->get('entry_firstname');
		$data['entry_lastname'] = $this->language->get('entry_lastname');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_telephone'] = $this->language->get('entry_telephone');
		$data['entry_fax'] = $this->language->get('entry_fax');
		$data['entry_company'] = $this->language->get('entry_company');
		$data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$data['entry_address_1'] = $this->language->get('entry_address_1');
		$data['entry_address_2'] = $this->language->get('entry_address_2');
		$data['entry_postcode'] = $this->language->get('entry_postcode');
		$data['entry_city'] = $this->language->get('entry_city');
		$data['entry_country'] = $this->language->get('entry_country');
		$data['entry_zone'] = $this->language->get('entry_zone');
		$data['entry_shipping'] = $this->language->get('entry_shipping');

		$data['button_continue'] = $this->language->get('button_continue');
		$data['button_upload'] = $this->language->get('button_upload');

		$data['customer_groups'] = array();

		if (is_array($this->config->get('config_customer_group_display'))) {
			$this->load->model('account/customer_group');

			$customer_groups = $this->model_account_customer_group->getCustomerGroups();

			foreach ($customer_groups as $customer_group) {
				if (in_array($customer_group['customer_group_id'], $this->config->get('config_customer_group_display'))) {
					$data['customer_groups'][] = $customer_group;
				}
			}
		}

		if (isset($this->session->data['guest']['customer_group_id'])) {
			$data['customer_group_id'] = $this->session->data['guest']['customer_group_id'];
		} else {
			$data['customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		if (isset($this->session->data['guest']['firstname'])) {
			$data['firstname'] = $this->session->data['guest']['firstname'];
		} else {
			$data['firstname'] = '';
		}

		if (isset($this->session->data['guest']['lastname'])) {
			$data['lastname'] = $this->session->data['guest']['lastname'];
		} else {
			$data['lastname'] = '';
		}

		if (isset($this->session->data['guest']['email'])) {
			$data['email'] = $this->session->data['guest']['email'];
		} else {
			$data['email'] = '';
		}

		if (isset($this->session->data['guest']['telephone'])) {
			$data['telephone'] = $this->session->data['guest']['telephone'];
		} else {
			$data['telephone'] = '';
		}

		if (isset($this->session->data['guest']['fax'])) {
			$data['fax'] = $this->session->data['guest']['fax'];
		} else {
			$data['fax'] = '';
		}

		if (isset($this->session->data['payment_address']['company'])) {
			$data['company'] = $this->session->data['payment_address']['company'];
		} else {
			$data['company'] = '';
		}

		if (isset($this->session->data['payment_address']['address_1'])) {
			$data['address_1'] = $this->session->data['payment_address']['address_1'];
		} else {
			$data['address_1'] = '';
		}

		if (isset($this->session->data['payment_address']['address_2'])) {
			$data['address_2'] = $this->session->data['payment_address']['address_2'];
		} else {
			$data['address_2'] = '';
		}

		if (isset($this->session->data['payment_address']['postcode'])) {
			$data['postcode'] = $this->session->data['payment_address']['postcode'];
		} elseif (isset($this->session->data['shipping_address']['postcode'])) {
			$data['postcode'] = $this->session->data['shipping_address']['postcode'];
		} else {
			$data['postcode'] = '';
		}

		if (isset($this->session->data['payment_address']['city'])) {
			$data['city'] = $this->session->data['payment_address']['city'];
		} else {
			$data['city'] = '';
		}

		if (isset($this->session->data['payment_address']['country_id'])) {
			$data['country_id'] = $this->session->data['payment_address']['country_id'];
		} elseif (isset($this->session->data['shipping_address']['country_id'])) {
			$data['country_id'] = $this->session->data['shipping_address']['country_id'];
		} else {
			$data['country_id'] = $this->config->get('config_country_id');
		}

		if (isset($this->session->data['payment_address']['zone_id'])) {
			$data['zone_id'] = $this->session->data['payment_address']['zone_id'];
		} elseif (isset($this->session->data['shipping_address']['zone_id'])) {
			$data['zone_id'] = $this->session->data['shipping_address']['zone_id'];
		} else {
			$data['zone_id'] = '';
		}

		$this->load->model('localisation/country');

		$data['countries'] = $this->model_localisation_country->getCountries();

		// Custom Fields
		$this->load->model('account/custom_field');

		$data['custom_fields'] = $this->model_account_custom_field->getCustomFields();

		if (isset($this->session->data['guest']['custom_field'])) {
			if (isset($this->session->data['guest']['custom_field'])) {
				$guest_custom_field = $this->session->data['guest']['custom_field'];
			} else {
				$guest_custom_field = array();
			}
			
			if (isset($this->session->data['payment_address']['custom_field'])) {
				$address_custom_field = $this->session->data['payment_address']['custom_field'];
			} else {
				$address_custom_field = array();
			}
						
			$data['guest_custom_field'] = $guest_custom_field + $address_custom_field;
		} else {
			$data['guest_custom_field'] = array();
		}

		$data['shipping_required'] = $this->cart->hasShipping();

				$data['entry_celular']       = $this->language->get('entry_celular');
				$data['entry_tipo']          = $this->language->get('entry_tipo');
				$data['entry_tipo_fisica']   = $this->language->get('entry_tipo_fisica');
				$data['entry_tipo_juridica'] = $this->language->get('entry_tipo_juridica');
				$data['entry_cpf']           = $this->language->get('entry_cpf');
				$data['entry_rg']            = $this->language->get('entry_rg');
				$data['entry_razao']         = $this->language->get('entry_razao');
				$data['entry_cnpj']          = $this->language->get('entry_cnpj');
				$data['entry_ie']            = $this->language->get('entry_ie');
				$data['entry_im']            = $this->language->get('entry_im');
				$data['entry_nascimento']    = $this->language->get('entry_nascimento');
				$data['entry_sexo']          = $this->language->get('entry_sexo');
				$data['entry_sexo_m']        = $this->language->get('entry_sexo_m');
				$data['entry_sexo_f']        = $this->language->get('entry_sexo_f');
				$data['entry_numero']        = $this->language->get('entry_numero');
				$data['entry_complemento']   = $this->language->get('entry_complemento');

				$data['config_campo_pais']       = $this->config->get('config_campo_pais');
				$data['config_campo_celular']    = $this->config->get('config_campo_celular');
				$data['config_campo_sexo']       = $this->config->get('config_campo_sexo');
				$data['config_campo_nascimento'] = $this->config->get('config_campo_nascimento');
				$data['config_campo_idade']      = $this->config->get('config_campo_idade');
				$data['config_campo_pessoa']     = $this->config->get('config_campo_pessoa');
				$data['config_campo_rg']         = $this->config->get('config_campo_rg');
				$data['config_campo_ie']         = $this->config->get('config_campo_ie');
				$data['config_campo_im']         = $this->config->get('config_campo_im');
			

		if (isset($this->session->data['guest']['shipping_address'])) {
			$data['shipping_address'] = $this->session->data['guest']['shipping_address'];
		} else {
			$data['shipping_address'] = true;
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/checkout/guest.tpl')) {
			$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/checkout/guest.tpl', $data));
		} else {
			$this->response->setOutput($this->load->view('default/template/checkout/guest.tpl', $data));
		}
	}

	public function save() {
		$this->load->language('checkout/checkout');

		$json = array();

		// Validate if customer is logged in.
		if ($this->customer->isLogged()) {
			$json['redirect'] = $this->url->link('checkout/checkout', '', 'SSL');
		}

		// Validate cart has products and has stock.
		if ((!$this->cart->hasProducts() && empty($this->session->data['vouchers'])) || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
			$json['redirect'] = $this->url->link('checkout/cart');
		}

		// Check if guest checkout is available.
		if (!$this->config->get('config_checkout_guest') || $this->config->get('config_customer_price') || $this->cart->hasDownload()) {
			$json['redirect'] = $this->url->link('checkout/checkout', '', 'SSL');
		}

		if (!$json) {
			if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
				$json['error']['firstname'] = $this->language->get('error_firstname');
			}

			if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
				$json['error']['lastname'] = $this->language->get('error_lastname');
			}

			if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $this->request->post['email'])) {
				$json['error']['email'] = $this->language->get('error_email');
			}

			if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
				$json['error']['telephone'] = $this->language->get('error_telephone');
			}

			if ((utf8_strlen(trim($this->request->post['address_1'])) < 3) || (utf8_strlen(trim($this->request->post['address_1'])) > 128)) {
				$json['error']['address_1'] = $this->language->get('error_address_1');
			}

			if ((utf8_strlen(trim($this->request->post['city'])) < 2) || (utf8_strlen(trim($this->request->post['city'])) > 128)) {
				$json['error']['city'] = $this->language->get('error_city');
			}

			$this->load->model('localisation/country');

			$country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

			if ($country_info && $country_info['postcode_required'] && (utf8_strlen(trim($this->request->post['postcode'])) < 2 || utf8_strlen(trim($this->request->post['postcode'])) > 10)) {
				$json['error']['postcode'] = $this->language->get('error_postcode');
			}

			if ($this->request->post['country_id'] == '') {
				$json['error']['country'] = $this->language->get('error_country');
			}

			if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
				$json['error']['zone'] = $this->language->get('error_zone');
			}

			// Customer Group
			if (isset($this->request->post['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($this->request->post['customer_group_id'], $this->config->get('config_customer_group_display'))) {
				$customer_group_id = $this->request->post['customer_group_id'];
			} else {
				$customer_group_id = $this->config->get('config_customer_group_id');
			}

			// Custom field validation
			$this->load->model('account/custom_field');

			$custom_fields = $this->model_account_custom_field->getCustomFields($customer_group_id);


				$config_campo_celular    = $this->config->get('config_campo_celular');
				$config_campo_sexo       = $this->config->get('config_campo_sexo');
				$config_campo_nascimento = $this->config->get('config_campo_nascimento');
				$config_campo_idade      = $this->config->get('config_campo_idade');
				$config_campo_pessoa     = $this->config->get('config_campo_pessoa');
				$config_campo_rg         = $this->config->get('config_campo_rg');
				$config_campo_ie         = $this->config->get('config_campo_ie');
				$config_campo_im         = $this->config->get('config_campo_im');

				if ($config_campo_celular > 0) {
					if ($config_campo_celular == 1 || ($config_campo_celular == 2 && $this->request->post['custom_field']['account']['celular'] != '')) {
						if ((utf8_strlen($this->request->post['custom_field']['account']['celular']) < 3) || (utf8_strlen($this->request->post['custom_field']['account']['celular']) > 32)) {
							$json['error']['celular'] = $this->language->get('error_celular');
						}
					}
				}

				if ($config_campo_sexo > 0) {
					if ($config_campo_sexo == 1 || ($config_campo_sexo == 2 && isset($this->request->post['custom_field']['account']['sexo']))) {
						if (!isset($this->request->post['custom_field']['account']['sexo']) || ($this->request->post['custom_field']['account']['sexo'] != 'f' && $this->request->post['custom_field']['account']['sexo'] != 'm')) {
							$json['error']['sexo'] = $this->language->get('error_sexo');
						}
					}
				}

				if ($config_campo_nascimento > 0) {
					if ($config_campo_nascimento == 1 || ($config_campo_nascimento == 2 && $this->request->post['custom_field']['account']['nascimento'] != '')) {
						if (!preg_match('/([12][0-9]{3}-(0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|([12][0-9]{3}-(0[469]|11)-(0[1-9]|[12][0-9]|30))|([12][0-9]([02468][1235679]|[13579][01345789])-02-(0[1-9]|1[0-9]|2[0-8]))|([12][0-9]([02468][048]|[13579][26])-02-(0[1-9]|[12][0-9]))/', $this->request->post['custom_field']['account']['nascimento'])) {
							$json['error']['nascimento'] = $this->language->get('error_nascimento');
						} else {
							if (is_numeric($config_campo_idade) && $config_campo_idade > 0) {
								$date1 = new DateTime(date('Y-m-d'));
								$date2 = new DateTime($this->request->post['custom_field']['account']['nascimento']);
								$interval = $date1->diff($date2);
								$age = $interval->y;
								if ($age < $config_campo_idade) {
									$json['error']['nascimento'] = sprintf($this->language->get('error_idade'), $config_campo_idade);
								}
							}
						}
					}
				}

				$country_name = '';

				if ($country_info) {
					$country_name = mb_strtolower(trim($country_info['name']), 'UTF-8');
				} else {
					$json['error']['country'] = $this->language->get('error_country');
				}

				if ($country_name == 'brasil' || $country_name == 'brazil') {
					if (!preg_match('/^\([0-9]{2}\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['telephone'])) {
						$json['error']['telephone'] = 'Telefone inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
					} else {
						if (!preg_match('/^\((11|12|13|14|15|16|17|18|19|21|22|24|27|28|31|32|33|34|35|37|38|41|42|43|44|45|46|47|48|49|51|53|54|55|61|62|63|64|65|66|67|68|69|71|73|74|75|77|79|81|82|83|84|85|86|87|88|89|91|92|93|94|95|96|97|98|99)\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['telephone'])) {
							$json['error']['telephone'] = 'DDD inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
						}
					}

					if ($config_campo_celular > 0) {
						if ($config_campo_celular == 1 || ($config_campo_celular == 2 && $this->request->post['custom_field']['account']['celular'] != '')) {
							if (!preg_match('/^\([0-9]{2}\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['custom_field']['account']['celular'])) {
								$json['error']['celular'] = 'Celular inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
							} else {
								if (!preg_match('/^\((11|12|13|14|15|16|17|18|19|21|22|24|27|28|31|32|33|34|35|37|38|41|42|43|44|45|46|47|48|49|51|53|54|55|61|62|63|64|65|66|67|68|69|71|73|74|75|77|79|81|82|83|84|85|86|87|88|89|91|92|93|94|95|96|97|98|99)\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['telephone'])) {
									$json['error']['celular'] = 'DDD inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
								}
							}
						}
					}

					if ($this->request->post['fax'] != '') {
						if (!preg_match('/^\([0-9]{2}\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['fax'])) {
							$json['error']['fax'] = 'Fax inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
						} else {
							if (!preg_match('/^\((11|12|13|14|15|16|17|18|19|21|22|24|27|28|31|32|33|34|35|37|38|41|42|43|44|45|46|47|48|49|51|53|54|55|61|62|63|64|65|66|67|68|69|71|73|74|75|77|79|81|82|83|84|85|86|87|88|89|91|92|93|94|95|96|97|98|99)\) [0-9]{4,5}-[0-9]{4}$/', $this->request->post['fax'])) {
								$json['error']['fax'] = 'DDD inválido! Informe corretamente o DDD e o número no formato: (99) 99999-9999';
							}
						}
					}

					if (!isset($this->request->post['custom_field']['account']['tipo']) || ($this->request->post['custom_field']['account']['tipo'] != 'f' && $this->request->post['custom_field']['account']['tipo'] != 'j')) {
						$json['error']['tipo'] = 'Selecione o tipo de pessoa.';
					} else {
						$this->load->model('account/customer');

						if ($this->request->post['custom_field']['account']['tipo'] == 'f') {
							if (!$this->model_account_customer->validaCPF($this->request->post['custom_field']['account']['cpf'])) {
								$json['error']['cpf'] = 'CPF inválido! Informe um CPF válido no formato: 999.999.999-99';
							}

							if ($config_campo_rg > 0) {
								if ($config_campo_rg == 1 || ($config_campo_rg == 2 && $this->request->post['custom_field']['account']['rg'] != '')) {
									if ((utf8_strlen($this->request->post['custom_field']['account']['rg']) < 3) || (utf8_strlen($this->request->post['custom_field']['account']['rg']) > 32)) {
										$json['error']['rg'] = 'O RG deve ter entre 3 e 32 caracteres!';
									}
								}
							}
						}
						if ($this->request->post['custom_field']['account']['tipo'] == 'j') {
							if (!$this->model_account_customer->validaCNPJ($this->request->post['custom_field']['account']['cnpj'])) {
								$json['error']['cnpj'] = 'CNPJ inválido! Informe um CNPJ válido no formato: 99.999.999/9999-99';
							}

							if ((utf8_strlen($this->request->post['custom_field']['account']['razao']) < 3) || (utf8_strlen($this->request->post['custom_field']['account']['razao']) > 32)) {
								$json['error']['razao'] = 'A razão social deve ter entre 3 e 32 caracteres!';
							}

							if ($config_campo_ie > 0) {
								if ($config_campo_ie == 1 || ($config_campo_ie == 2 && $this->request->post['custom_field']['account']['ie'] != '')) {
									if ((utf8_strlen($this->request->post['custom_field']['account']['ie']) < 3) || (utf8_strlen($this->request->post['custom_field']['account']['ie']) > 32)) {
										$json['error']['ie'] = 'A Inscrição Estadual deve ter entre 3 e 32 caracteres!';
									}
								}
							}

							if ($config_campo_im > 0) {
								if ($config_campo_im == 1 || ($config_campo_im == 2 && $this->request->post['custom_field']['account']['im'] != '')) {
									if ((utf8_strlen($this->request->post['custom_field']['account']['im']) < 3) || (utf8_strlen($this->request->post['custom_field']['account']['im']) > 32)) {
										$json['error']['im'] = 'A Inscrição Municipal deve ter entre 3 e 32 caracteres!';
									}
								}
							}
						}
					}

					if ((utf8_strlen($this->request->post['custom_field']['address']['numero']) < 1) || (utf8_strlen($this->request->post['custom_field']['address']['numero']) > 10)) {
						$json['error']['numero'] = 'O número do endereço deve ter entre 1 e 10 caracteres!';
					}
				}
			
			foreach ($custom_fields as $custom_field) {
				if ($custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['location']][$custom_field['custom_field_id']])) {
					$json['error']['custom_field' . $custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
				}
			}
		}

		if (!$json) {
			$this->session->data['account'] = 'guest';

			$this->session->data['guest']['customer_group_id'] = $customer_group_id;
			$this->session->data['guest']['firstname'] = $this->request->post['firstname'];
			$this->session->data['guest']['lastname'] = $this->request->post['lastname'];
			$this->session->data['guest']['email'] = $this->request->post['email'];
			$this->session->data['guest']['telephone'] = $this->request->post['telephone'];
			$this->session->data['guest']['fax'] = $this->request->post['fax'];

			if (isset($this->request->post['custom_field']['account'])) {
				$this->session->data['guest']['custom_field'] = $this->request->post['custom_field']['account'];
			} else {
				$this->session->data['guest']['custom_field'] = array();
			}

			$this->session->data['payment_address']['firstname'] = $this->request->post['firstname'];
			$this->session->data['payment_address']['lastname'] = $this->request->post['lastname'];
			$this->session->data['payment_address']['company'] = $this->request->post['company'];
			$this->session->data['payment_address']['address_1'] = $this->request->post['address_1'];
			$this->session->data['payment_address']['address_2'] = $this->request->post['address_2'];
			$this->session->data['payment_address']['postcode'] = $this->request->post['postcode'];
			$this->session->data['payment_address']['city'] = $this->request->post['city'];
			$this->session->data['payment_address']['country_id'] = $this->request->post['country_id'];
			$this->session->data['payment_address']['zone_id'] = $this->request->post['zone_id'];

			$this->load->model('localisation/country');

			$country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

			if ($country_info) {
				$this->session->data['payment_address']['country'] = $country_info['name'];
				$this->session->data['payment_address']['iso_code_2'] = $country_info['iso_code_2'];
				$this->session->data['payment_address']['iso_code_3'] = $country_info['iso_code_3'];
				$this->session->data['payment_address']['address_format'] = $country_info['address_format'];
			} else {
				$this->session->data['payment_address']['country'] = '';
				$this->session->data['payment_address']['iso_code_2'] = '';
				$this->session->data['payment_address']['iso_code_3'] = '';
				$this->session->data['payment_address']['address_format'] = '';
			}

			if (isset($this->request->post['custom_field']['address'])) {
				$this->session->data['payment_address']['custom_field'] = $this->request->post['custom_field']['address'];
			} else {
				$this->session->data['payment_address']['custom_field'] = array();
			}

			$this->load->model('localisation/zone');

			$zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);

			if ($zone_info) {
				$this->session->data['payment_address']['zone'] = $zone_info['name'];
				$this->session->data['payment_address']['zone_code'] = $zone_info['code'];
			} else {
				$this->session->data['payment_address']['zone'] = '';
				$this->session->data['payment_address']['zone_code'] = '';
			}

			if (!empty($this->request->post['shipping_address'])) {
				$this->session->data['guest']['shipping_address'] = $this->request->post['shipping_address'];
			} else {
				$this->session->data['guest']['shipping_address'] = false;
			}

			// Default Payment Address
			if ($this->session->data['guest']['shipping_address']) {
				$this->session->data['shipping_address']['firstname'] = $this->request->post['firstname'];
				$this->session->data['shipping_address']['lastname'] = $this->request->post['lastname'];
				$this->session->data['shipping_address']['company'] = $this->request->post['company'];
				$this->session->data['shipping_address']['address_1'] = $this->request->post['address_1'];
				$this->session->data['shipping_address']['address_2'] = $this->request->post['address_2'];
				$this->session->data['shipping_address']['postcode'] = $this->request->post['postcode'];
				$this->session->data['shipping_address']['city'] = $this->request->post['city'];
				$this->session->data['shipping_address']['country_id'] = $this->request->post['country_id'];
				$this->session->data['shipping_address']['zone_id'] = $this->request->post['zone_id'];

				if ($country_info) {
					$this->session->data['shipping_address']['country'] = $country_info['name'];
					$this->session->data['shipping_address']['iso_code_2'] = $country_info['iso_code_2'];
					$this->session->data['shipping_address']['iso_code_3'] = $country_info['iso_code_3'];
					$this->session->data['shipping_address']['address_format'] = $country_info['address_format'];
				} else {
					$this->session->data['shipping_address']['country'] = '';
					$this->session->data['shipping_address']['iso_code_2'] = '';
					$this->session->data['shipping_address']['iso_code_3'] = '';
					$this->session->data['shipping_address']['address_format'] = '';
				}

				if ($zone_info) {
					$this->session->data['shipping_address']['zone'] = $zone_info['name'];
					$this->session->data['shipping_address']['zone_code'] = $zone_info['code'];
				} else {
					$this->session->data['shipping_address']['zone'] = '';
					$this->session->data['shipping_address']['zone_code'] = '';
				}

				if (isset($this->request->post['custom_field']['address'])) {
					$this->session->data['shipping_address']['custom_field'] = $this->request->post['custom_field']['address'];
				} else {
					$this->session->data['shipping_address']['custom_field'] = array();
				}
			}

			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}