<?php
class ModelCatalogUrlAlias extends Model {

				private $url_list = array (
					'account/account'             => 'minha-conta',
					'account/address'             => 'minha-conta/enderecos',
					'account/address/add'         => 'minha-conta/novo-endereco',
					'account/address/edit'        => 'minha-conta/editar-endereco',
					'account/download'            => 'minha-conta/downloads',
					'account/edit'                => 'minha-conta/meus-dados',
					'account/forgotten'           => 'minha-conta/esqueci-minha-senha',
					'account/login'               => 'minha-conta/login',
					'account/logout'              => 'minha-conta/sair',
					'account/newsletter'          => 'minha-conta/newsletter',
					'account/order'               => 'minha-conta/historico-de-pedidos',
					'account/order/info'          => 'minha-conta/detalhes-do-pedido',
					'account/password'            => 'minha-conta/alterar-senha',
					'account/recurring'           => 'minha-conta/assinaturas',
					'account/register'            => 'cadastre-se',
					'account/return'              => 'minha-conta/devolucoes',
					'account/return/add'          => 'solicitar-devolucao',
					'account/reward'              => 'minha-conta/pontos-de-fidelidade',
					'account/transaction'         => 'minha-conta/creditos',
					'account/voucher'             => 'vale-presentes',
					'account/wishlist'            => 'lista-de-desejos',
					'affiliate/account'           => 'afiliados',
					'affiliate/edit'              => 'afiliados/alterar-informacoes',
					'affiliate/forgotten'         => 'afiliados/esqueci-minha-senha',
					'affiliate/login'             => 'afiliados/login',
					'affiliate/logout'            => 'afiliados/sair',
					'affiliate/password'          => 'afiliados/alterar-senha',
					'affiliate/payment'           => 'afiliados/info-para-comissoes',
					'affiliate/register'          => 'afiliados/cadastro',
					'affiliate/tracking'          => 'afiliados/gerador-de-links',
					'affiliate/transaction'       => 'afiliados/comissoes',
					'checkout/cart'               => 'carrinho-de-compras',
					'checkout/checkout'           => 'finalizar-pedido',
					'checkout/success'            => 'pedido-finalizado',
					'common/home'                 => '',
					'information/contact'         => 'contato',
					'information/contact/success' => 'contato/mensagem-enviada',
					'information/sitemap'         => 'mapa-do-site',
					'product/compare'             => 'comparacao-de-produtos',
					'product/manufacturer'        => 'fabricantes',
					'product/search'              => 'busca',
					'product/special'             => 'ofertas-especiais',
				);
			
	public function getUrlAlias($keyword) {

				$tmp = array_search($keyword, $this->url_list);

				if ($tmp !== false) {
					return array(
						'url_alias_id' => 0,
						'query'        => "route={$tmp}",
						'keyword'      => $keyword
					);
				}
			
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "url_alias WHERE keyword = '" . $this->db->escape($keyword) . "'");

		return $query->row;
	}
}