<?php
class ControllerModuleSlideshow extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/slideshow');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/module');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (!isset($this->request->get['module_id'])) {
				$this->model_extension_module->addModule('slideshow', $this->request->post);
			} else {
				$this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_banner'] = $this->language->get('entry_banner');
		$data['entry_width'] = $this->language->get('entry_width');
		$data['entry_height'] = $this->language->get('entry_height');
		$data['entry_status'] = $this->language->get('entry_status');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['width'])) {
			$data['error_width'] = $this->error['width'];
		} else {
			$data['error_width'] = '';
		}

		if (isset($this->error['height'])) {
			$data['error_height'] = $this->error['height'];
		} else {
			$data['error_height'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/slideshow', 'token=' . $this->session->data['token'], 'SSL')
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/slideshow', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL')
			);
		}

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('module/slideshow', 'token=' . $this->session->data['token'], 'SSL');
		} else {
			$data['action'] = $this->url->link('module/slideshow', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL');
		}

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['banner_id'])) {
			$data['banner_id'] = $this->request->post['banner_id'];
		} elseif (!empty($module_info)) {
			$data['banner_id'] = $module_info['banner_id'];
		} else {
			$data['banner_id'] = '';
		}

		$this->load->model('design/banner');

		$data['banners'] = $this->model_design_banner->getBanners();

		if (isset($this->request->post['width'])) {
			$data['width'] = $this->request->post['width'];
		} elseif (!empty($module_info)) {
			$data['width'] = $module_info['width'];
		} else {
			$data['width'] = '';
		}

		if (isset($this->request->post['height'])) {
			$data['height'] = $this->request->post['height'];
		} elseif (!empty($module_info)) {
			$data['height'] = $module_info['height'];
		} else {
			$data['height'] = '';
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = '';
		}


				$data['entry_screen']   = $this->language->get('entry_screen');
				$data['entry_columns']  = $this->language->get('entry_columns');
				$data['entry_cssclass'] = $this->language->get('entry_cssclass');
				$data['entry_timeout']  = $this->language->get('entry_timeout');

				$data['text_screen_all'] = $this->language->get('text_screen_all');
				$data['text_screen_lg']  = $this->language->get('text_screen_lg');
				$data['text_screen_md']  = $this->language->get('text_screen_md');
				$data['text_screen_sm']  = $this->language->get('text_screen_sm');
				$data['text_screen_except_lg'] = $this->language->get('text_screen_except_lg');
				$data['text_screen_except_md'] = $this->language->get('text_screen_except_md');
				$data['text_screen_except_sm'] = $this->language->get('text_screen_except_sm');
				$data['text_columns_nd'] = $this->language->get('text_columns_nd');

				$data['help_name']     = $this->language->get('help_name');
				$data['help_banner']   = $this->language->get('help_banner');
				$data['help_screen']   = $this->language->get('help_screen');
				$data['help_columns']  = $this->language->get('help_columns');
				$data['help_cssclass'] = $this->language->get('help_cssclass');
				$data['help_width']    = $this->language->get('help_width');
				$data['help_height']   = $this->language->get('help_height');
				$data['help_timeout']  = $this->language->get('help_timeout');

				if (isset($this->error['columns'])) {
					$data['error_columns'] = $this->error['columns'];
				} else {
					$data['error_columns'] = '';
				}

				if (isset($this->error['timeout'])) {
					$data['error_timeout'] = $this->error['timeout'];
				} else {
					$data['error_timeout'] = '';
				}

				if (isset($this->request->post['screen'])) {
					$data['screen'] = $this->request->post['screen'];
				} elseif (isset($module_info['screen']) && !empty($module_info['screen'])) {
					$data['screen'] = $module_info['screen'];
				} else {
					$data['screen'] = '';
				}

				if (isset($this->request->post['columns'])) {
					$data['columns'] = $this->request->post['columns'];
				} elseif (isset($module_info['columns']) && !empty($module_info['columns'])) {
					$data['columns'] = $module_info['columns'];
				} else {
					$data['columns'] = 0;
				}

				if (isset($this->request->post['cssclass'])) {
					$data['cssclass'] = $this->request->post['cssclass'];
				} elseif (isset($module_info['cssclass']) && !empty($module_info['cssclass'])) {
					$data['cssclass'] = $module_info['cssclass'];
				} else {
					$data['cssclass'] = '';
				}

				if (isset($this->request->post['timeout'])) {
					$data['timeout'] = $this->request->post['timeout'];
				} elseif (isset($module_info['timeout']) && !empty($module_info['timeout'])) {
					$data['timeout'] = $module_info['timeout'];
				} else {
					$data['timeout'] = 4;
				}
			
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('module/slideshow_hdw.tpl', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/slideshow')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->request->post['width']) {
			$this->error['width'] = $this->language->get('error_width');
		}

		if (!$this->request->post['height']) {
			$this->error['height'] = $this->language->get('error_height');
		}


				if (!is_numeric($this->request->post['timeout']) || $this->request->post['timeout'] < 0 || $this->request->post['timeout'] > 60) {
					$this->error['timeout'] = $this->language->get('error_timeout');
				}
			
		return !$this->error;
	}
}
