<?php

class Pedido
{
	private $logger;

	public $dadosEcNumero;
	public $dadosEcChave;

	public $dadosPortadorNumero;
	public $dadosPortadorVal;
	public $dadosPortadorInd;
	public $dadosPortadorCodSeg;
	public $dadosPortadorNome;
	public $dadosPortadorToken = "";

	public $dadosPedidoNumero;
	public $dadosPedidoValor;
	public $dadosPedidoMoeda = "986";
	public $dadosPedidoData;
	public $dadosPedidoDescricao;
	public $dadosPedidoIdioma = "PT";
	public $dadosPedidoSoftDesc = "";
	public $dadosPedidoTaxaEmb = "";

	public $formaPagamentoBandeira;
	public $formaPagamentoProduto;
	public $formaPagamentoParcelas;

	public $urlRetorno;
	public $autorizar;
	public $capturar;

	public $campoLivre = "";
	public $bin = "";
	public $gerarToken = false;

	public $tid;
	public $status;
	public $urlAutenticacao;

	const ENCODING = "UTF-8"; //"ISO-8859-1";

	function __construct()
	{
		// cria um logger
		$this->logger = new Logger();
	}

	// Geradores de XML
	private function XMLHeader()
	{
		return '<?xml version="1.0" encoding="' . self::ENCODING . '" ?>';
	}

	private function XMLDadosEc()
	{
		$msg = '<dados-ec>' . "\n		" .
					'<numero>'. $this->dadosEcNumero .'</numero>' . "\n		" .
					'<chave>'. $this->dadosEcChave .'</chave>' . "\n	" .
				'</dados-ec>';

		return $msg;
	}

	private function XMLDadosPortador()
	{
		$msg = '<dados-portador>' . "\n		" .
					'<numero>'. $this->dadosPortadorNumero .'</numero>' . "\n		" .
					'<validade>'. $this->dadosPortadorVal .'</validade>' . "\n		" .
					'<indicador>'. $this->dadosPortadorInd .'</indicador>' . "\n		" .
					'<codigo-seguranca>'. $this->dadosPortadorCodSeg .'</codigo-seguranca>' . "\n	";

		// Verifica se Nome do Portador foi informado
		if($this->dadosPortadorNome != null && $this->dadosPortadorNome != "")
		{
			$msg .= '	<nome-portador><![CDATA['. $this->dadosPortadorNome .']]></nome-portador>' . "\n	";
		}

		$msg .= '</dados-portador>';

		return $msg;
	}

	private function XMLDadosCartao()
	{
		$msg = '<dados-cartao>' . "\n		" .
					'<numero>'. $this->dadosPortadorNumero .'</numero>' . "\n		" .
					'<validade>'. $this->dadosPortadorVal .'</validade>' . "\n		" .
					'<indicador>'. $this->dadosPortadorInd .'</indicador>' . "\n		" .
					'<codigo-seguranca>'. $this->dadosPortadorCodSeg .'</codigo-seguranca>' . "\n	";

		// Verifica se Nome do Portador foi informado
		if($this->dadosPortadorNome != null && $this->dadosPortadorNome != "")
		{
			$msg .= '	<nome-portador><![CDATA['. $this->dadosPortadorNome .']]></nome-portador>' . "\n	";
		}

		$msg .= '</dados-cartao>';

		return $msg;
	}

	private function XMLDadosPedido()
	{
		$this->dadosPedidoData = date("Y-m-d") . "T" . date("H:i:s");
		$msg = '<dados-pedido>' . "\n		" .
					'<numero>'. $this->dadosPedidoNumero .'</numero>' . "\n		" .
					'<valor>'. $this->dadosPedidoValor .'</valor>' . "\n		" .
					'<moeda>'. $this->dadosPedidoMoeda .'</moeda>' . "\n		" .
					'<data-hora>'. $this->dadosPedidoData .'</data-hora>' . "\n		";

		if($this->dadosPedidoDescricao != null && $this->dadosPedidoDescricao != "")
		{
			$msg .= '<descricao><![CDATA['. $this->dadosPedidoDescricao .']]></descricao>' . "\n		";
		}
		
		$msg .= '<idioma>'. $this->dadosPedidoIdioma .'</idioma>' . "\n	" .
			'</dados-pedido>';

		return $msg;
	}

	private function XMLFormaPagamento()
	{
		$msg = '<forma-pagamento>' . "\n		" .
					'<bandeira>'. $this->formaPagamentoBandeira .'</bandeira>' . "\n		" .
					'<produto>'. $this->formaPagamentoProduto .'</produto>' . "\n		" .
					'<parcelas>'. $this->formaPagamentoParcelas .'</parcelas>' . "\n	" .
				'</forma-pagamento>';

		return $msg;
	}

	private function XMLUrlRetorno()
	{
		$msg = '<url-retorno>' . urlencode($this->urlRetorno) . '</url-retorno>';

		return $msg;
	}

	private function XMLAutorizar()
	{
		$msg = '<autorizar>' . $this->autorizar . '</autorizar>';

		return $msg;
	}

	private function XMLCapturar()
	{
		$msg = '<capturar>' . ($this->capturar ? 'true' : 'false') . '</capturar>';

		return $msg;
	}

	// Requisicoes
	public function RequisicaoTransacao($incluirPortador)
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-transacao id="' . md5(date("YmdHisu")) . '" versao="' . CIELO_VERSAO . '">' . "\n	"
				. $this->XMLDadosEc() . "\n	";
		if($incluirPortador == true)
		{
			$msg .=	$this->XMLDadosPortador() . "\n	";
		}
		
		$msg .=	  $this->XMLDadosPedido() . "\n	"
				. $this->XMLFormaPagamento() . "\n	"
				. $this->XMLUrlRetorno() . "\n	"
				. $this->XMLAutorizar() . "\n	"
				. $this->XMLCapturar() . "\n";

		$msg .= '</requisicao-transacao>';

		$objResposta = $this->Enviar($msg, "Transacao");
		return $objResposta;
	}

	public function RequisicaoTid()
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-tid id="' . md5(date("YmdHisu")) . '" versao ="' . CIELO_VERSAO . '">' . "\n	"
				. $this->XMLDadosEc() . "\n	"
				. $this->XMLFormaPagamento() . "\n" .
			'</requisicao-tid>';

		$objResposta = $this->Enviar($msg, "Requisicao Tid");
		return $objResposta;
	}

	public function RequisicaoAutorizacaoPortador()
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-autorizacao-portador id="' . md5(date("YmdHisu")) . '" versao ="' . CIELO_VERSAO . '">' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. $this->XMLDadosEc() . "\n	"
				. $this->XMLDadosCartao() . "\n	"
				. $this->XMLDadosPedido() . "\n	"
				. $this->XMLFormaPagamento() . "\n	"
				. '<capturar-automaticamente>' . $this->capturar . '</capturar-automaticamente>' . "\n" .
			'</requisicao-autorizacao-portador>';

		$objResposta = $this->Enviar($msg, "Autorizacao Portador");
		return $objResposta;
	}

	public function RequisicaoAutorizacaoTid()
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-autorizacao-tid id="' . md5(date("YmdHisu")) . '" versao="' . CIELO_VERSAO . '">' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. $this->XMLDadosEc() . "\n" .
			'</requisicao-autorizacao-tid>';

		$objResposta = $this->Enviar($msg, "Autorizacao Tid");
		return $objResposta;
	}

	public function RequisicaoCaptura($PercentualCaptura, $anexo)
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-captura id="' . md5(date("YmdHisu")) . '" versao="' . CIELO_VERSAO . '">' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. $this->XMLDadosEc() . "\n	"
				. '<valor>' . $PercentualCaptura . '</valor>' . "\n";
					
		if($anexo != null && $anexo != "")
		{
			$msg .=	'	<anexo>' . $anexo . '</anexo>' . "\n";
		}
		
		$msg .= '</requisicao-captura>';

		$objResposta = $this->Enviar($msg, "Captura");
		return $objResposta;
	}

	public function RequisicaoCancelamento()
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-cancelamento id="' . md5(date("YmdHisu")) . '" versao="' . CIELO_VERSAO . '">' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. $this->XMLDadosEc() . "\n" .
			'</requisicao-cancelamento>';

		$objResposta = $this->Enviar($msg, "Cancelamento");
		return $objResposta;
	}

	public function RequisicaoConsulta()
	{
		$msg = $this->XMLHeader() . "\n" .
			'<requisicao-consulta id="' . md5(date("YmdHisu")) . '" versao="' . CIELO_VERSAO . '">' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. $this->XMLDadosEc() . "\n" .
			'</requisicao-consulta>';

		$objResposta = $this->Enviar($msg, "Consulta");
		return $objResposta;
	}

	// Transforma em/le string
	public function ToString()
	{
		$msg = $this->XMLHeader() .
			'<objeto-pedido>' . "\n	"
				. '<tid>' . $this->tid . '</tid>' . "\n	"
				. '<status>' . $this->status . '</status>' . "\n	"
				. $this->XMLDadosEc() . "\n	"
				. $this->XMLDadosPedido() . "\n	"
				. $this->XMLFormaPagamento() .
			'</objeto-pedido>';

		return $msg;
	}

	public function FromString($Str)
	{
		$XML = simplexml_load_string($Str);

		$this->tid = $XML->tid;
		$this->status = $XML->status;
		$this->dadosEcChave = $XML->{"dados-ec"}->chave;
		$this->dadosEcNumero = $XML->{"dados-ec"}->numero;
		$this->dadosPedidoNumero = $XML->{"dados-pedido"}->numero;
		$this->dadosPedidoValor = $XML->{"dados-pedido"}->valor;
		$this->dadosPedidoData = $XML->{"dados-pedido"}->{"data-hora"};
		$this->formaPagamentoBandeira = $XML->{"forma-pagamento"}->bandeira;
		$this->formaPagamentoProduto = $XML->{"forma-pagamento"}->produto;
		$this->formaPagamentoParcelas = $XML->{"forma-pagamento"}->parcelas;
	}
	
	public function FromArray($Arr)
	{
		$this->tid = $Arr['tid'];
		$this->status = $Arr['status'];
		$this->dadosEcChave = $Arr['dados-ec']['chave'];
		$this->dadosEcNumero = $Arr['dados-ec']['numero'];
		$this->dadosPedidoNumero = $Arr['dados-pedido']['numero'];
		$this->dadosPedidoValor = $Arr['dados-pedido']['valor'];
		$this->dadosPedidoData = $Arr['dados-pedido']['data-hora'];
		$this->formaPagamentoBandeira = $Arr['forma-pagamento']['bandeira'];
		$this->formaPagamentoProduto = $Arr['forma-pagamento']['produto'];
		$this->formaPagamentoParcelas = $Arr['forma-pagamento']['parcelas'];
	}

	// Envia Requisicao
	public function Enviar($vmPost, $transacao)
	{
		$this->logger->logWrite("ENVIO", $vmPost, $transacao);
		$vmResposta = cieloHTTPRequest(CIELO_URL, "mensagem=" . $vmPost);
		$this->logger->logWrite("RESPOSTA", $vmResposta, $transacao);

		$valido = cieloVerificaErro($vmPost, $vmResposta);
		
		if($valido){
			$vmResposta = simplexml_load_string($vmResposta);
			$vmResposta = objectToArray($vmResposta);
		}else{
			$vmResposta = FALSE;
		}

		return $vmResposta;
	}

	// Traduz cogigo do Status
	public function getStatus()
	{
		return cieloGetStatus($this->status);
	}

}
