<?php

define('CIELO_XML_LOG_FOLDER', DIR_LOGS . "cielo/");
define('CIELO_XML_LOG_FILE', CIELO_XML_LOG_FOLDER . "xml-".strtolower(date('Y-F')).".txt");

class Logger
{
	private $fp = null;

	public function logOpen()
	{
		if( !file_exists(CIELO_XML_LOG_FOLDER) ){
			mkdir(CIELO_XML_LOG_FOLDER);
		}
		
		$this->fp = fopen(CIELO_XML_LOG_FILE, 'a');
	}

	public function logWrite($tipo, $strMessage, $transacao)
	{
		if(!$this->fp)
			$this->logOpen();

		$path = $_SERVER["REQUEST_URI"];
		$data = date("Y-m-d H:i:s:u (T)");

		$log = "***********************************************" . "\n\n";
		$log .= $tipo . ": " . $data . "\n";
		$log .= "ARQUIVO: " . $path . "\n";
		$log .= "OPERAÇÃO: " . $transacao . "\n";
		$log .= $strMessage . "\n\n";

		fwrite($this->fp, utf8_decode($log));
	}
}
