<?php

// define as configuracoes com a variavel $GLOBAL, pois o PHP nao aceita arrays como constantes, utilizando a funcao "define"

// define as bandeiras disponiveis
$GLOBALS['CIELO_BANDEIRAS_DISPONIVEIS'] = array(
	'visa',
	'visae',
	'mastercard',
	'maestro',
	'amex',
	'diners',
	'aura',
	'elo',
	'discover',
	'jcb'
);

// define as bandeiras apenas para debito
$GLOBALS['CIELO_BANDEIRAS_DEBITO'] = array(
	'visae' => 'visa',
	'maestro' => 'mastercard'
);

// define o numero minimo e maximo de parcelas permitidas
$GLOBALS['CIELO_MINIMO_PARCELAS'] = 1;
$GLOBALS['CIELO_MAXIMO_PARCELAS'] = 24;

// define o valor minimo que as parcelas devem alcancar para habilitar o parcelamento
$GLOBALS['CIELO_PARCELA_MINIMA'] = 1.00;

// define os tipos de autorizacao disponiveis
// 0 – nao autorizar (somente autenticar)
// 1 – autorizar somente se autenticada
// 2 – autorizar autenticada e nao autenticada
// 3 – autorizar sem passar por autenticacao (somente para credito) – tambem conhecida como "autorizacao direta"
// 4 – transacao recorrente
$GLOBALS['CIELO_TIPOS_AUTORIZACAO'] = array(0,1,2,3,4);



// define os valores padroes para o formulario admin
$GLOBALS['CIELO_VALORES_PADROES'] = array(
	'total' => '0.01',
	'status_pendente' => 1,
	'status_aprovada' => 17,
	'status_nao_aprovada' => 7,
	'valor_minimo' => '0.01',
	'desconto' => '0.00',
	'parcela_minima' => '1.00',
	'tipo_autorizacao' => 3,
	'tipo_autorizacao_debito' => 1,
	'taxa_juros' => '2.99'
);



// URL do webservice
$GLOBALS['CIELO_URL_TESTES'] = 'https://qasecommerce.cielo.com.br/servicos/ecommwsec.do';
$GLOBALS['CIELO_URL_PRODUCAO'] = 'https://ecommerce.cielo.com.br/servicos/ecommwsec.do';


