<?php

define('CIELO_VERSAO', '1.3.0');



if($this->config->get('cielo_ambiente') == '0'){
	define('CIELO_URL', $GLOBALS['CIELO_URL_TESTES']);
}else{
	define('CIELO_URL', $GLOBALS['CIELO_URL_PRODUCAO']);
}



// Envia requisicao
function cieloHTTPRequest($paEndereco, $paPost){

	$sessao_curl = curl_init();
	curl_setopt($sessao_curl, CURLOPT_URL, $paEndereco);
	// curl_setopt($sessao_curl, CURLOPT_DNS_CACHE_TIMEOUT, 0);
	// curl_setopt($sessao_curl, CURLOPT_FRESH_CONNECT, true);
	// curl_setopt($sessao_curl, CURLOPT_FORBID_REUSE, true);

	curl_setopt($sessao_curl, CURLOPT_FAILONERROR, true);

	// curl_setopt($sessao_curl, CURLOPT_SSLVERSION, 3);
	curl_setopt($sessao_curl, CURLOPT_SSLVERSION, 1);

	$arrayCiphers = array(
		'DHE-RSA-AES256-SHA',
		'DHE-DSS-AES256-SHA',
		'AES256-SHA:KRB5-DES-CBC3-MD5',
		'KRB5-DES-CBC3-SHA',
		'EDH-RSA-DES-CBC3-SHA',
		'EDH-DSS-DES-CBC3-SHA',
		'DES-CBC3-SHA:DES-CBC3-MD5',
		'DHE-RSA-AES128-SHA',
		'DHE-DSS-AES128-SHA',
		'AES128-SHA:RC2-CBC-MD5',
		'KRB5-RC4-MD5:KRB5-RC4-SHA',
		'RC4-SHA:RC4-MD5:RC4-MD5',
		'KRB5-DES-CBC-MD5',
		'KRB5-DES-CBC-SHA',
		'EDH-RSA-DES-CBC-SHA',
		'EDH-DSS-DES-CBC-SHA:DES-CBC-SHA',
		'DES-CBC-MD5:EXP-KRB5-RC2-CBC-MD5',
		'EXP-KRB5-DES-CBC-MD5',
		'EXP-KRB5-RC2-CBC-SHA',
		'EXP-KRB5-DES-CBC-SHA',
		'EXP-EDH-RSA-DES-CBC-SHA',
		'EXP-EDH-DSS-DES-CBC-SHA',
		'EXP-DES-CBC-SHA',
		'EXP-RC2-CBC-MD5',
		'EXP-RC2-CBC-MD5',
		'EXP-KRB5-RC4-MD5',
		'EXP-KRB5-RC4-SHA',
		'EXP-RC4-MD5:EXP-RC4-MD5'
	);
	curl_setopt($sessao_curl, CURLOPT_SSL_CIPHER_LIST, implode(':', $arrayCiphers));

	curl_setopt($sessao_curl, CURLOPT_POST, true);
	curl_setopt($sessao_curl, CURLOPT_POSTFIELDS, $paPost );

	//  CURLOPT_SSL_VERIFYPEER
	//  verifica a validade do certificado
	// curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYPEER, false);

	//  CURLOPPT_SSL_VERIFYHOST
	//  verifica se a identidade do servidor bate com aquela informada no certificado
	curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYHOST, 2);

	//  CURLOPT_SSL_CAINFO
	//  informa a localizacao do certificado para verificacao com o peer
	curl_setopt($sessao_curl, CURLOPT_CAINFO, DIR_SYSTEM . 'library/Cielo/ssl/cert.crt');

	//  CURLOPT_CONNECTTIMEOUT
	//  o tempo em segundos de espera para obter uma conexao
	curl_setopt($sessao_curl, CURLOPT_CONNECTTIMEOUT, 10);

	//  CURLOPT_TIMEOUT
	//  o tempo maximo em segundos de espera para a execucao da requisicao (curl_exec)
	curl_setopt($sessao_curl, CURLOPT_TIMEOUT, 40);

	//  CURLOPT_RETURNTRANSFER
	//  TRUE para curl_exec retornar uma string de resultado em caso de sucesso, ao
	//  inves de imprimir o resultado na tela. Retorna FALSE se ha problemas na requisicao
	curl_setopt($sessao_curl, CURLOPT_RETURNTRANSFER, true);

	// LOG para debug
	// curl_setopt($sessao_curl, CURLOPT_VERBOSE, 1);
	// curl_setopt($sessao_curl, CURLOPT_STDERR, fopen(DIR_SYSTEM . 'library/Cielo/ssl/curl_debug.txt', "w+"));

	$resultado = curl_exec($sessao_curl);

	$error = '';
	if($resultado === FALSE){ $error = curl_error($sessao_curl); }

	curl_close($sessao_curl);

	if($error != ''){ return $error; }
	if(trim($resultado) == ''){ return 'vazio'; }

	return $resultado;
}



// Verifica na Resposta XML a ocorrencia de erros
// Parametros: XML de envio, XML de Resposta
function cieloVerificaErro($vmPost, $vmResposta){

	try
	{

		$objResposta = simplexml_load_string($vmResposta, NULL, LIBXML_NOERROR);
		if($objResposta == NULL OR $objResposta === FALSE){
			if (stripos($vmResposta, "SSL") !== FALSE) {
				throw new Exception("CERTIFICADO INVÁLIDO - Problema com o certificado SSL", "099");
			} else {
				throw new Exception("HTTP READ TIMEOUT - O limite de tempo da transação foi estourado", "099");
			}
		}

	}
	catch (Exception $ex)
	{
		$error_msg = 'ERRO CIELO'."\n";
		$error_msg .= '------------------------------'."\n";
		$error_msg .= 'Código do erro: '. $ex->getCode() ."\n";
		$error_msg .= 'Mensagem: '. $ex->getMessage() ."\n\n";
		$error_msg .= 'XML de envio:'."\n". $vmPost ."\n\n";
		$error_msg .= 'Resposta:'."\n". $vmResposta ."\n";
		$error_msg .= '------------------------------'."\n";

		// Dispara o erro
		trigger_error($error_msg, E_USER_ERROR);
		return FALSE;
	}

	if($objResposta->getName() == "erro"){
		$erro_cod = (string) $objResposta->codigo;
		$erro_msg = (string) $objResposta->mensagem;

		$error_msg = 'ERRO CIELO'."\n";
		$error_msg .= '------------------------------'."\n";
		$error_msg .= 'Código do erro: '. $erro_cod ."\n";
		$error_msg .= 'Mensagem: '. $erro_msg ."\n\n";
		$error_msg .= 'XML de envio:'."\n". $vmPost ."\n\n";
		$error_msg .= 'XML de resposta:'."\n". $vmResposta ."\n";
		$error_msg .= '------------------------------'."\n";

		// Dispara o erro
		trigger_error($error_msg, E_USER_ERROR);
		return FALSE;
	}

	return TRUE;
}



function cieloGetStatus($status){
	$retorno = '';

	switch($status){
		case "0": $retorno = "Criada"; break;
		case "1": $retorno = "Em andamento"; break;
		case "2": $retorno = "Autenticada"; break;
		case "3": $retorno = "Não autenticada"; break;
		case "4": $retorno = "Autorizada"; break; // captura pendente
		case "5": $retorno = "Não autorizada"; break;
		case "6": $retorno = "Capturada"; break; // finalizada
		case "8": $retorno = "Não capturada"; break;
		case "9": $retorno = "Cancelada"; break;
		case "10": $retorno = "Em autenticação"; break;
		case "12": $retorno = "Em cancelamento"; break;
		default: $retorno = "n/a"; break;
	}

	return $retorno;
}



function cieloCreditToDebit($cartao){
	$bandeiras = array_flip($GLOBALS['CIELO_BANDEIRAS_DEBITO']);
	if( array_key_exists($cartao, $bandeiras) ){
		$cartao = $bandeiras[$cartao];
	}
	return $cartao;
}

function cieloDebitToCredit($cartao){
	$bandeiras = $GLOBALS['CIELO_BANDEIRAS_DEBITO'];
	if( array_key_exists($cartao, $bandeiras) ){
		$cartao = $bandeiras[$cartao];
	}
	return $cartao;
}

function cieloCheckIsDebit($cartao){
	if( array_key_exists($cartao, $GLOBALS['CIELO_BANDEIRAS_DEBITO']) ){
		return TRUE;
	}
	return FALSE;
}



// Transforma objetos em array
function objectToArray($object){
	if( !is_object($object) && !is_array($object) ){
		return $object;
	}
	if( is_object($object) ){
		$object = get_object_vars($object);
	}
	return array_map( 'objectToArray', $object );
}


