<?php

$habilita_parcelamentos = isset($parcelamentos_cfg) && isset($parcelamentos_cfg['parcelamentos']) && count($parcelamentos_cfg['parcelamentos']) > 0;
$habilita_descontos = isset($descontos_cfg) && isset($descontos_cfg['descontos']) && count($descontos_cfg['descontos']) > 0;

$habilita_calculo_frete = isset($config_product_page_shipping) && isset($product_shipping) && $config_product_page_shipping != '0' && $product_shipping;

function print_product_option_price($price_prefix, $price) {
	global $registry;

	if (!$price) {
		return 0;
	}

	$decimal_place = $registry->get('currency')->getDecimalPlace();
	$divisor = intval('1' . str_repeat('0', $decimal_place));

	$price = intval(preg_replace('/[^0-9]/', '', $price));
	$price = number_format($price / $divisor, $decimal_place, '.', '');

	return "{$price_prefix}{$price}";
}

?>
<?php echo $header; ?>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<div class="oc-product oc-content col-xs-12">
					<div class="oc-content-inner">
						<div class="row">

							<?php if ($column_left && $column_right) { ?>
							<?php $class = 'col-sm-6'; ?>
							<?php } elseif ($column_left || $column_right) { ?>
							<?php $class = 'col-sm-6'; ?>
							<?php } else { ?>
							<?php $class = 'col-sm-4'; ?>
							<?php } ?>

							<div class="product-details-1 col-xs-12 <?php echo $class; ?> pull-right">
								<h1><?php echo $heading_title; ?></h1>

								<ul class="product-info list-unstyled">
									<?php if ($manufacturer) { ?>
										<li class="prod-manufacturer"><strong><?php echo $text_manufacturer; ?></strong> <a href="<?php echo $manufacturers; ?>"><?php echo $manufacturer; ?></a></li>
									<?php } ?>

									<li class="prod-model"><strong><?php echo $text_model; ?></strong> <?php echo $model; ?></li>

									<?php if ($reward) { ?>
										<li class="prod-reward"><strong><?php echo $text_reward; ?></strong> <?php echo $reward; ?></li>
									<?php } ?>

									<?php if (!$has_combination) { ?>
										<li class="prod-stock-status"><strong><?php echo $text_stock; ?></strong> <?php echo $stock; ?></li>
									<?php } ?>
								</ul>

								<?php if ($price) { ?>
									<ul class="product-prices list-unstyled">
										<li class="price-box preco">
											<?php if (!$special) { ?>
												<span class="price-new"><?php echo $price; ?></span>
											<?php } else { ?>
												<span class="price-old"><?php echo $price; ?></span>
												<span class="price-new"><?php echo $special; ?></span>
											<?php } ?>
										</li>

										<?php /*if (isset($parcelamentos) && $parcelamentos) { ?>
											<?php foreach ($parcelamentos as $parcelamento) { ?>
												<li class="price-box parcelamento">
													<span class="parcelas-resumo"><?php echo $parcelamento['descricao_titulo']; ?></span>
													<span class="parcelas-ver"><?php echo $parcelamento['texto_link']; ?></span>

													<div class="parcelas-wrapper">
														<div class="parcelas-table">
															<span class="parcelas-titulo"><?php echo $parcelamento['titulo_tabela']; ?></span>

															<div class="parcelas-list">
																<ul>
																	<?php
																	foreach ($parcelamento['parcelas'] as $p => $parcela) {
																		?><li><?php echo $parcela; ?></li><?php
																	}
																	?>
																</ul>
															</div>

															<?php
															if ($parcelamento['texto_juros'] != '' || $parcelamento['texto_parcela_minima'] != '' || $parcelamento['texto_observacoes'] != '') {
																?><small><?php

																if ($parcelamento['texto_juros'] != '') {
																	?> <span class="parcelas-juros"><?php echo $parcelamento['texto_juros']; ?></span> <?php
																}

																if ($parcelamento['texto_parcela_minima'] != '') {
																	?> <span class="parcelas-minima"><?php echo $parcelamento['texto_parcela_minima']; ?></span> <?php
																}

																if ($parcelamento['texto_observacoes'] != '') {
																	?> <span class="parcelas-obs"><?php echo $parcelamento['texto_observacoes']; ?></span> <?php
																}

																?></small><?php
															}
															?>
														</div> <!-- .parcelas-table -->
													</div> <!-- .parcelas-wrapper -->
												</li>
											<?php } ?>
										<?php } ?>

										<?php if (isset($descontos) && $descontos) { ?>
											<?php foreach ($descontos as $desconto) { ?>
												<li class="price-box descontos">
													<span><?php echo $desconto['descricao']; ?></span>
													<?php if ($desconto['validade'] != '') { ?>
														<small class="desconto-obs"><?php echo $desconto['validade']; ?></small>
													<?php } ?>
												</li>
											<?php } ?>
										<?php }*/ ?>

										<?php if ($discounts) { ?>
											<li class="price-box discounts">
												<small>Desconto para compra em maiores quantidades:</small>
												<?php foreach ($discounts as $discount) { ?>
													<div>
														<span class="discount-qtd"><?php echo $discount['quantity']; ?></span>
														<span class="discount-txt"><?php echo $text_discount; ?></span>
														<span class="discount-price"><?php echo $discount['price']; ?></span>
													</div>
												<?php } ?>
											</li>
										<?php } ?>

										<?php /*if ($tax) { ?>
											<li class="price-box taxes">
												<?php echo $text_tax; ?>
												<span class="tax-price"><?php echo $tax; ?></span>
											</li>
										<?php }*/ ?>

										<?php if ($points) { ?>
											<li class="price-box points">
												<?php echo $text_points; ?>
												<span class="points-price"><?php echo $points; ?></span>
											</li>
										<?php } ?>
									</ul>
								<?php } ?>

								<div id="product">
									<?php if ($options) { ?>
										<div class="product-options">
											<h3><?php echo $text_option; ?></h3>
											<?php foreach ($options as $option) { ?>

												<?php

												$extra_class = '';

												if ($option['raw_info']['combination'] == '1') {
													$extra_class .= 'combination';
												}

												?>

												<?php if ($option['type'] == 'select') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<select name="option[<?php echo $option['product_option_id']; ?>]" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control">
														<option value=""><?php echo $text_select; ?></option>
														<?php foreach ($option['product_option_value'] as $option_value) { ?>
															<option value="<?php echo $option_value['product_option_value_id']; ?>"
																data-option-value-id="<?php echo $option_value['option_value_id']; ?>"
																data-option-price="<?php echo print_product_option_price($option_value['price_prefix'], $option_value['price']); ?>">
															<?php echo $option_value['name']; ?>
															<?php /*if ($option_value['price']) { ?>
																<span class="option-price">(<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)</span>
															<?php }*/ ?>
															</option>
														<?php } ?>
													</select>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'radio') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label"><?php echo $option['name']; ?></label>
													<div id="input-option<?php echo $option['product_option_id']; ?>">
														<?php foreach ($option['product_option_value'] as $option_value) { ?>
														<div class="radio">
															<label>
																<input type="radio" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option_value['product_option_value_id']; ?>"
																	data-option-value-id="<?php echo $option_value['option_value_id']; ?>"
																	data-option-price="<?php echo print_product_option_price($option_value['price_prefix'], $option_value['price']); ?>" />
																<?php echo $option_value['name']; ?>
																<?php /*if ($option_value['price']) { ?>
																	<span class="option-price">(<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)</span>
																<?php }*/ ?>
															</label>
														</div>
														<?php } ?>
													</div>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'checkbox') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label"><?php echo $option['name']; ?></label>
													<div id="input-option<?php echo $option['product_option_id']; ?>">
														<?php foreach ($option['product_option_value'] as $option_value) { ?>
														<div class="checkbox">
															<label>
																<input type="checkbox" name="option[<?php echo $option['product_option_id']; ?>][]" value="<?php echo $option_value['product_option_value_id']; ?>"
																	data-option-price="<?php echo print_product_option_price($option_value['price_prefix'], $option_value['price']); ?>" />
																<?php echo $option_value['name']; ?>
																<?php /*if ($option_value['price']) { ?>
																	<span class="option-price">(<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)</span>
																<?php }*/ ?>
															</label>
														</div>
														<?php } ?>
													</div>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'image') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?> option-image" data-type="<?php echo $option['type']; ?>">
													<label class="control-label"><?php echo $option['name']; ?></label>
													<div id="input-option<?php echo $option['product_option_id']; ?>" class="option-image-container">
														<?php foreach ($option['product_option_value'] as $option_value) { ?>
														<div class="radio option-image-item">
															<label>
																<input type="radio" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option_value['product_option_value_id']; ?>"
																	data-option-value-id="<?php echo $option_value['option_value_id']; ?>"
																	data-option-price="<?php echo print_product_option_price($option_value['price_prefix'], $option_value['price']); ?>" />
																<img src="<?php echo $option_value['image']; ?>" alt="<?php echo $option_value['name'] . ($option_value['price'] ? ' ' . $option_value['price_prefix'] . $option_value['price'] : ''); ?>" title="<?php echo $option_value['name'] . ($option_value['price'] ? ' ' . $option_value['price_prefix'] . $option_value['price'] : ''); ?>" class="img-thumbnail" data-toggle="tooltip" />
																<?php echo $option_value['name']; ?>
																<?php /*if ($option_value['price']) { ?>
																	<span class="option-price">(<?php echo $option_value['price_prefix']; ?><?php echo $option_value['price']; ?>)</span>
																<?php }*/ ?>
															</label>
														</div>
														<?php } ?>
													</div>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'text') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" placeholder="<?php echo $option['name']; ?>" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'textarea') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<textarea name="option[<?php echo $option['product_option_id']; ?>]" rows="5" placeholder="<?php echo $option['name']; ?>" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control"><?php echo $option['value']; ?></textarea>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'file') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label"><?php echo $option['name']; ?></label>
													<button type="button" id="button-upload<?php echo $option['product_option_id']; ?>" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-default btn-block"><i class="fa fa-upload"></i> <?php echo $button_upload; ?></button>
													<input type="hidden" name="option[<?php echo $option['product_option_id']; ?>]" value="" id="input-option<?php echo $option['product_option_id']; ?>" />
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'date') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<div class="input-group date">
														<input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="YYYY-MM-DD" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
														<span class="input-group-btn">
															<button class="btn btn-default" type="button"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'datetime') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<div class="input-group datetime">
														<input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
														<span class="input-group-btn">
															<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
												<?php } ?>

												<?php if ($option['type'] == 'time') { ?>
												<div class="form-group<?php echo ($option['required'] ? ' required' : ''); ?> <?php echo $extra_class; ?>" data-type="<?php echo $option['type']; ?>">
													<label class="control-label" for="input-option<?php echo $option['product_option_id']; ?>"><?php echo $option['name']; ?></label>
													<div class="input-group time">
														<input type="text" name="option[<?php echo $option['product_option_id']; ?>]" value="<?php echo $option['value']; ?>" data-date-format="HH:mm" id="input-option<?php echo $option['product_option_id']; ?>" class="form-control" />
														<span class="input-group-btn">
															<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
														</span>
													</div>
												</div>
												<?php } ?>

											<?php } ?>
										</div>
									<?php } // options ?>

									<?php if ($recurrings) { ?>
										<div class="product-recurring">
											<h3><?php echo $text_payment_recurring ?></h3>
											<div class="form-group required">
												<select name="recurring_id" class="form-control">
													<option value=""><?php echo $text_select; ?></option>
													<?php foreach ($recurrings as $recurring) { ?>
													<option value="<?php echo $recurring['recurring_id'] ?>"><?php echo $recurring['name'] ?></option>
													<?php } ?>
												</select>
												<div class="help-block" id="recurring-description"></div>
											</div>
										</div>
									<?php } ?>

									<div class="product-cart">
										<?php if ($minimum > 1) { ?>
											<div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo $text_minimum; ?></div>
										<?php } ?>

										<?php if (!$has_stock && $config_stock_text_out != '') { ?>
											<div class="out-of-stock"><?php echo $config_stock_text_out; ?></div>
										<?php } ?>

										<div class="form-group" <?php if (!$has_stock) { echo('style="display:none;"'); } ?>>
											<label class="control-label" for="input-quantity"><?php echo $entry_qty; ?></label>
											<input type="text" name="quantity" value="<?php echo $minimum; ?>" size="2" id="input-quantity" class="form-control" />
											<input type="hidden" name="product_id" value="<?php echo $product_id; ?>" />
										</div>

										<button type="button" id="button-cart" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-primary btn-lg btn-block <?php if (!$has_stock) { echo('disabled'); } ?>"><i class="fa fa-shopping-cart"></i> <span><?php echo $button_cart; ?></span></button>
									</div>

									<div class="product-extra">
										<div class="pull-left">
											<button type="button" data-toggle="tooltip" class="btn-wishlist btn btn-default" title="<?php echo $button_wishlist; ?>" onclick="wishlist.add('<?php echo $product_id; ?>');"><i class="fa fa-heart"></i></button>
											<button type="button" data-toggle="tooltip" class="btn-compare btn btn-default" title="<?php echo $button_compare; ?>" onclick="compare.add('<?php echo $product_id; ?>');"><i class="fa fa-exchange"></i></button>
										</div>

										<?php if ($review_status) { ?>
										<div class="product-rating pull-right text-right">
											<div class="rating">
												<?php for ($i = 1; $i <= 5; $i++) { ?>
													<?php if ($rating < $i) { ?>
														<span class="fa fa-stack"><i class="fa fa-star-o fa-stack-1x"></i></span>
													<?php } else { ?>
														<span class="fa fa-stack"><i class="fa fa-star fa-stack-1x"></i><i class="fa fa-star-o fa-stack-1x"></i></span>
													<?php } ?>
												<?php } ?>
											</div>
											<span class="review-link"><a href="#" onclick="$('a[href=\'#tab-review\']').trigger('click'); return false;"><?php echo $reviews; ?></a></span>
											<span class="review-link"><a href="#" onclick="$('a[href=\'#tab-review\']').trigger('click'); return false;"><?php echo $text_write; ?></a></span>
										</div>
										<?php } ?>

										<div class="clearfix"></div>
									</div>

									<?php if ($habilita_calculo_frete) { ?>
									<div id="product-shipping" class="product-frete form-register">
										<h4><i class="fa fa-truck"></i> <?php echo $text_shipping_rate; ?></h4>

										<div class="form-group required" <?php if ($config_campo_pais == '0') { echo('style="display:none"'); } ?>>
											<label class="control-label" for="input-country"><?php echo $entry_country; ?></label>
											<select name="country_id" id="input-country" class="form-control input-country">
											<option value=""><?php echo $text_select; ?></option>
											<?php foreach ($countries as $country) { ?>
												<option value="<?php echo $country['country_id']; ?>" <?php if ($country['country_id'] == $country_id) { echo('selected'); } ?> ><?php echo $country['name']; ?></option>
											<?php } ?>
											</select>
										</div>

										<div class="form-group">
											<label class="control-label" for="input-postcode" <?php if ($config_campo_pais == '0') { echo('style="display:none"'); } ?>><?php echo $entry_postcode; ?></label>
											<div class="input-group btn-block">
												<input type="tel" inputmode="numeric" name="postcode" id="input-postcode" class="form-control input-postcode mask-postcode" value="<?php echo $postcode; ?>" maxlength="10" placeholder="<?php echo $entry_postcode; ?>" />
												<span class="input-group-btn">
													<button type="button" id="button-shipping" data-loading-text="<?php echo $text_loading; ?>" class="button btn btn-primary"><?php /* ?><i class="fa fa-calculator"></i> <?php */ ?><?php echo $button_get_shipping; ?></button>
												</span>
											</div>
										</div>

										<div class="form-group required" style="display: none;">
											<label class="control-label" for="input-zone"><?php echo $entry_zone; ?></label>
											<select name="zone_id" id="input-zone" class="form-control input-zone"></select>
										</div>
									</div>
									<?php } ?>

								</div>


								<div class="product-social">
									<!-- AddThis Button BEGIN -->
									<?php /* ?><div class="addthis_toolbox addthis_default_style">
										<a class="addthis_button_facebook_like" fb:like:layout="button_count"></a>
										<a class="addthis_button_tweet"></a>
										<a class="addthis_button_pinterest_pinit"></a>
										<a class="addthis_button_google_plusone"></a>
										<a class="addthis_counter addthis_pill_style"></a>
									</div><?php */ ?>
									<?php /* ?><div class="addthis_toolbox addthis_default_style addthis_32x32_style">
										<a class="addthis_button_facebook"></a>
										<a class="addthis_button_twitter"></a>
										<a class="addthis_button_pinterest_share"></a>
										<a class="addthis_button_google_plusone_share"></a>
										<a class="addthis_button_compact"></a>
									</div><?php */ ?>
									<div class="addthis_toolbox">
										<div class="custom_images"><a
											class="addthis_button_facebook"><img src="<?php echo HTTP_SERVER; ?>/image/catalog/icones-sociais/facebook.png" border="0" data-toggle="tooltip" title="Compartilhar no Facebook"></a><a
											class="addthis_button_twitter"><img src="<?php echo HTTP_SERVER; ?>/image/catalog/icones-sociais/twitter.png" border="0" data-toggle="tooltip" title="Compartinlhar no Twitter"></a><a
											class="addthis_button_pinterest_share"><img src="<?php echo HTTP_SERVER; ?>/image/catalog/icones-sociais/pinterest.png" border="0" data-toggle="tooltip" title="Compartilhar no Pinterest"></a><a
											class="addthis_button_google_plusone_share"><img src="<?php echo HTTP_SERVER; ?>/image/catalog/icones-sociais/google-plus.png" border="0" data-toggle="tooltip" title="Compartilhar no Google+"></a><a
											class="addthis_button_more"><img src="<?php echo HTTP_SERVER; ?>/image/catalog/icones-sociais/plus.png" border="0" data-toggle="tooltip" title="Mais opções..."></a>
										</div>
									</div>
									<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js"></script>
									<!-- AddThis Button END -->
								</div>
							</div>

							<?php if ($column_left && $column_right) { ?>
							<?php $class = 'col-sm-6'; ?>
							<?php } elseif ($column_left || $column_right) { ?>
							<?php $class = 'col-sm-6'; ?>
							<?php } else { ?>
							<?php $class = 'col-sm-8'; ?>
							<?php } ?>
							<div class="product-details-2 col-xs-12 <?php echo $class; ?> pull-left">
								<?php if ($thumb || $images) { ?>
								<ul class="thumbnails">
									<?php if ($thumb) { ?>
										<li><a class="thumbnail" href="<?php echo $popup; ?>" title="<?php echo $heading_title; ?>"><img src="<?php echo $thumb; ?>" title="<?php echo $heading_title; ?>" alt="<?php echo $heading_title; ?>" /></a></li>
									<?php } ?>

									<?php if ($images) { ?>
										<?php foreach ($images as $image) { ?>
											<li class="image-additional"><a class="thumbnail" href="<?php echo $image['popup']; ?>" title="<?php echo $heading_title; ?>"> <img src="<?php echo $image['thumb']; ?>" title="<?php echo $heading_title; ?>" alt="<?php echo $heading_title; ?>" /></a></li>
										<?php } ?>
									<?php } ?>
								</ul>
								<?php } ?>

								<ul class="nav nav-tabs">
									<li class="active"><a href="#tab-description" data-toggle="tab"><?php echo $tab_description; ?></a></li>
									<?php if ($attribute_groups) { ?>
										<li><a href="#tab-specification" data-toggle="tab"><?php echo $tab_attribute; ?></a></li>
									<?php } ?>
									<?php if ($review_status) { ?>
										<li><a href="#tab-review" data-toggle="tab"><?php echo $tab_review; ?></a></li>
									<?php } ?>
								</ul>

								<div class="tab-content">
									<div class="tab-pane active" id="tab-description"><?php echo $description; ?></div>

									<?php if ($attribute_groups) { ?>
									<div class="tab-pane" id="tab-specification">
										<table class="table table-bordered">
											<?php foreach ($attribute_groups as $attribute_group) { ?>
											<thead>
												<tr>
													<td colspan="2"><strong><?php echo $attribute_group['name']; ?></strong></td>
												</tr>
											</thead>
											<tbody>
												<?php foreach ($attribute_group['attribute'] as $attribute) { ?>
												<tr>
													<td><?php echo $attribute['name']; ?></td>
													<td><?php echo $attribute['text']; ?></td>
												</tr>
												<?php } ?>
											</tbody>
											<?php } ?>
										</table>
									</div>
									<?php } ?>

									<?php if ($review_status) { ?>
									<div class="tab-pane" id="tab-review">
										<form class="form-horizontal" id="form-review">
											<div id="review"></div>
											<h2><?php echo $text_write; ?></h2>

											<?php if ($review_guest) { ?>
												<div class="form-group required">
													<div class="col-sm-12">
														<label class="control-label" for="input-name"><?php echo $entry_name; ?></label>
														<input type="text" name="name" value="" id="input-name" class="form-control" />
													</div>
												</div>
												<div class="form-group required">
													<div class="col-sm-12">
														<label class="control-label" for="input-review"><?php echo $entry_review; ?></label>
														<textarea name="text" rows="5" id="input-review" class="form-control"></textarea>
														<div class="help-block"><?php echo $text_note; ?></div>
													</div>
												</div>
												<div class="form-group required">
													<div class="col-sm-12">
														<label class="control-label"><?php echo $entry_rating; ?></label>
														&nbsp;&nbsp;&nbsp; <?php echo $entry_bad; ?>&nbsp;
														<input type="radio" name="rating" value="1" />
														&nbsp;
														<input type="radio" name="rating" value="2" />
														&nbsp;
														<input type="radio" name="rating" value="3" />
														&nbsp;
														<input type="radio" name="rating" value="4" />
														&nbsp;
														<input type="radio" name="rating" value="5" />
														&nbsp;<?php echo $entry_good; ?></div>
												</div>
												<?php if ($site_key) { ?>
													<div class="form-group">
														<div class="col-sm-12">
															<div class="g-recaptcha" data-sitekey="<?php echo $site_key; ?>"></div>
														</div>
													</div>
												<?php } ?>
												<div class="buttons clearfix">
													<div class="pull-right">
														<button type="button" id="button-review" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-primary"><?php echo $button_continue; ?></button>
													</div>
												</div>
											<?php } else { ?>
												<?php echo $text_login; ?>
											<?php } ?>
										</form>
									</div>
									<?php } ?>

								</div>

								<?php if ($tags) { ?>
									<?php
									$html_tags = array();
									for ($i = 0; $i < count($tags); $i++) {
										$html_tags[] = '<a href="' . $tags[$i]['href'] . '">' . $tags[$i]['tag'] . '</a>';
									}
									?>
									<div class="tags">
										<strong><?php echo $text_tags; ?></strong> <?php echo implode(', ', $html_tags); ?>
									</div>
								<?php } ?>
							</div>

						</div>
					</div>
				</div>

				<?php if ($products) { ?>
					<div class="oc-related col-xs-12">
						<h3><?php echo $text_related; ?></h3>
						<div class="row">

							<?php $class = 'product-grid col-xs-12'; ?>
							<?php include('catalog/view/theme/hdw1/template/product/_product_item_layout.tpl'); ?>

						</div>
					</div>
				<?php } ?>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>

</div>



<script type="text/javascript"><!--
if ($('select[name=\'recurring_id\']').length > 0) {
$('select[name=\'recurring_id\'], input[name="quantity"]').change(function(){
	$.ajax({
		url: 'index.php?route=product/product/getRecurringDescription',
		type: 'post',
		data: $('input[name=\'product_id\'], input[name=\'quantity\'], select[name=\'recurring_id\']'),
		dataType: 'json',
		beforeSend: function() {
			$('#recurring-description').html('');
		},
		success: function(json) {
			$('.alert, .text-danger').remove();

			if (json['success']) {
				$('#recurring-description').html(json['success']);
			}
		}
	});
});
}
//--></script>



<script type="text/javascript"><!--
$('#button-cart').on('click', function() {
	$.ajax({
		url: 'index.php?route=checkout/cart/add',
		type: 'post',
		data: $('#product input[type=\'text\'], #product input[type=\'hidden\'], #product input[type=\'radio\']:checked, #product input[type=\'checkbox\']:checked, #product select, #product textarea'),
		dataType: 'json',
		beforeSend: function() {
			$('#button-cart').button('loading');
		},
		complete: function() {
			$('#button-cart').button('reset');
		},
		success: function(json) {
			$('.alert, .text-danger').remove();
			$('.form-group').removeClass('has-error');

			if (json['error']) {
				if (json['error']['option']) {
					for (i in json['error']['option']) {
						var element = $('#input-option' + i.replace('_', '-'));

						if (element.parent().hasClass('input-group')) {
							element.parent().after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
						} else {
							element.after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
						}
					}
				}

				if (json['error']['recurring']) {
					$('select[name=\'recurring_id\']').after('<div class="text-danger">' + json['error']['recurring'] + '</div>');
				}

				// Highlight any found errors
				$('.text-danger').parent().addClass('has-error');
			}

			if (json['success']) {
				$('.breadcrumb').after('<div class="alert alert-success">' + json['success'] + '<button type="button" class="close" data-dismiss="alert">&times;</button></div>');

				$('#cart > button').html('<i class="fa fa-shopping-cart"></i> ' + json['total']);

				$('html, body').animate({ scrollTop: 0 }, 'slow');

				$('#cart > ul').load('index.php?route=common/cart/info ul li');

				setTimeout(function(){
					// location = 'index.php?route=checkout/cart';
					location = $('base').attr('href') + 'carrinho-de-compras';
				}, 1000);
			}
		}
	});
});
//--></script>



<script type="text/javascript"><!--
$('button[id^=\'button-upload\']').on('click', function() {
	var node = this;

	$('#form-upload').remove();

	$('body').prepend('<form enctype="multipart/form-data" id="form-upload" style="display: none;"><input type="file" name="file" /></form>');

	$('#form-upload input[name=\'file\']').trigger('click');

	if (typeof timer != 'undefined') {
			clearInterval(timer);
	}

	timer = setInterval(function() {
		if ($('#form-upload input[name=\'file\']').val() != '') {
			clearInterval(timer);

			$.ajax({
				url: 'index.php?route=tool/upload',
				type: 'post',
				dataType: 'json',
				data: new FormData($('#form-upload')[0]),
				cache: false,
				contentType: false,
				processData: false,
				beforeSend: function() {
					$(node).button('loading');
				},
				complete: function() {
					$(node).button('reset');
				},
				success: function(json) {
					$('.text-danger').remove();

					if (json['error']) {
						$(node).parent().find('input').after('<div class="text-danger">' + json['error'] + '</div>');
					}

					if (json['success']) {
						alert(json['success']);

						$(node).parent().find('input').attr('value', json['code']);
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				}
			});
		}
	}, 500);
});
//--></script>



<script type="text/javascript"><!--
$('#review').delegate('.pagination a', 'click', function(e) {
	e.preventDefault();

		$('#review').fadeOut('slow');

		$('#review').load(this.href);

		$('#review').fadeIn('slow');
});

$('#review').load('index.php?route=product/product/review&product_id=<?php echo $product_id; ?>');

$('#button-review').on('click', function() {
	$.ajax({
		url: 'index.php?route=product/product/write&product_id=<?php echo $product_id; ?>',
		type: 'post',
		dataType: 'json',
		data: $("#form-review").serialize(),
		beforeSend: function() {
			$('#button-review').button('loading');
		},
		complete: function() {
			$('#button-review').button('reset');
		},
		success: function(json) {
			$('.alert-success, .alert-danger').remove();

			if (json['error']) {
				$('#review').after('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['success']) {
				$('#review').after('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

				$('input[name=\'name\']').val('');
				$('textarea[name=\'text\']').val('');
				$('input[name=\'rating\']:checked').prop('checked', false);
			}
		}
	});
});
//--></script>



<script type="text/javascript"><!--
$(document).ready(function() {
	$('.thumbnails').magnificPopup({
		type:'image',
		delegate: 'a',
		gallery: {
			enabled:true
		}
	});
});
//--></script>



<script type="text/javascript"><!--
$(document).ready(function() {

	var $productCart = $('.product-cart');
	var $productOptions = $('.product-options');
	var $combinations = $productOptions.find('.combination');

	var $buttonCart = $('#button-cart');
	var $inputQuantity = $('#input-quantity');

	$combinations.on('change', 'input, select', function(){
		var values = [];

		$combinations.find('input:checked, option:selected').each(function(i){
			var value = parseInt(this.getAttribute('data-option-value-id'), 10);

			if (!isNaN(value) && value > 0) {
				values.push(value);
			}
		});

		$productCart.find('.combination-status').remove();

		if (values.length == $combinations.length) {
			$.ajax({
				url: 'index.php?route=product/product/productOptionStatus',
				type: 'post',
				data: {
					product_id: <?php echo $product_id; ?>,
					combination: values.sort(function(a, b){return a-b}).join('-')
				},
				dataType: 'json',
				beforeSend: function() {
					$productCart.find('.combination-status').remove();
					$productCart.prepend('<div class="alert alert-info combination-status"><i class="fa fa-refresh fa-spin fa-lg"></i> &nbsp; <?php echo $text_combination_loading; ?></div>');
				},
				success: function(json) {
					setTimeout(function(){
						$productCart.find('.combination-status').remove();
						$productCart.find('.out-of-stock').remove();

						if (json['error']) {
							$buttonCart.addClass('disabled');
							$inputQuantity.parent().hide();
							<?php if ($config_stock_text_out != '') { ?>
								$inputQuantity.parent().before('<div class="out-of-stock"><?php echo $config_stock_text_out; ?></div>');
							<?php } ?>
							$productCart.prepend('<div class="alert alert-danger combination-status"><i class="fa fa-exclamation-triangle"></i> ' + json['error'] + '</div>');
						}

						if (json['success']) {
							$buttonCart.removeClass('disabled');
							$inputQuantity.parent().show();
							$productCart.prepend('<div class="alert alert-success combination-status"><i class="fa fa-thumbs-up"></i> ' + json['success'] + '</div>');
						}
					}, 300);
				}
			});
		}
	});

});
//--></script>



<?php if ($price) { ?>
<script type="text/javascript"><!--
$(document).ready(function() {

	var $productPrices = $('.product-prices');
	var $priceBoxPreco = $productPrices.find('.price-box.preco');

	var $precoOld = $priceBoxPreco.find('.price-old');
	var $precoNew = $priceBoxPreco.find('.price-new');

	var areaTotal = 1;
	var precoOldOriginal = limpaPreco($precoOld.html());
	var precoNewOriginal = limpaPreco($precoNew.html());
	var precoOldInicial = precoOldOriginal;
	var precoNewInicial = precoNewOriginal;
	var precoOldFinal = precoOldOriginal;
	var precoNewFinal = precoNewOriginal;
	var lastPrecoOld = 0;
	var lastPrecoNew = 0;

	var $options = $('.product-options').find('input[type=radio], input[type=checkbox], select');
	$options.on('click change blur', atualizaPreco);

	function atualizaPreco(e) {
		var precoCombinacao = 0; // modifica preço do m2
		var precoAdicional = 0; // apenas adiciona preço fixo no final

		$options.each(function(){
			var tag = (this.nodeName + '').toLowerCase();
			var obj = null;
			var $pai = null;

			if (tag == 'input') {
				if (this.type == 'radio' || this.type == 'checkbox') {
					if (this.checked) {
						obj = this;
					}
				}
			}

			if (tag == 'select') {
				obj = this.options[this.selectedIndex];
			}

			if (obj && obj.getAttribute('data-option-price')) {
				var optionPrice = +obj.getAttribute('data-option-price');
				if (!isNaN(optionPrice)) {
					$pai = $(this).parents('#product .form-group');
					if ($pai.length && $pai.hasClass('combination')) {
						precoCombinacao += optionPrice;
					} else {
						precoAdicional += optionPrice;
					}
				}
			}
		});

		precoOldFinal = ((precoOldInicial + precoCombinacao) * areaTotal) + precoAdicional;
		precoNewFinal = ((precoNewInicial + precoCombinacao) * areaTotal) + precoAdicional;

		if (precoOldFinal == lastPrecoOld && precoNewFinal == lastPrecoNew) {
			return;
		}

		if (precoOldFinal < 0) { precoOldFinal = 0; }
		if (precoNewFinal < 0) { precoNewFinal = 0; }

		lastPrecoOld = precoOldFinal;
		lastPrecoNew = precoNewFinal;

		$precoOld.html(formataPreco(precoOldFinal));
		$precoNew.html(formataPreco(precoNewFinal));

		<?php if ($habilita_parcelamentos) { ?>
			atualizaParcelamentos();
		<?php } ?>

		<?php if ($habilita_descontos) { ?>
			atualizaDescontos();
		<?php } ?>
	}

	<?php if ($habilita_parcelamentos) { ?>
	var cfg_parcelamentos = <?php echo json_encode($parcelamentos_cfg); ?>;

	function atualizaParcelamentos() {
		$productPrices.find('.price-box.parcelamento').remove();

		var parcelamentos = calcularParcelamentos();

		for (var a = 0; a < parcelamentos.length; a++) {
			var parcelamento = parcelamentos[a];

			var html = '';
			html += '<li class="price-box parcelamento">';
			html += '	<span class="parcelas-resumo">' + parcelamento['descricao_titulo'] + '</span>';
			html += '	<span class="parcelas-ver">' + parcelamento['texto_link'] + '</span>';

			html += '	<div class="parcelas-wrapper">';
			html += '		<div class="parcelas-table">';
			html += '			<span class="parcelas-titulo">' + parcelamento['titulo_tabela'] + '</span>';

			html += '			<div class="parcelas-list">';
			html += '				<ul>';
			for (var p = 0; p < parcelamento['parcelas'].length; p++) {
				html += '<li>' + parcelamento['parcelas'][p] + '</li>';
			}
			html += '				</ul>';
			html += '			</div>';

			if (parcelamento['texto_juros'] != '' || parcelamento['texto_parcela_minima'] != '' || parcelamento['texto_observacoes'] != '') {
				html += '<small>';

				if (parcelamento['texto_juros'] != '') {
					html += ' <span class="parcelas-juros">' + parcelamento['texto_juros'] + '</span> ';
				}

				if (parcelamento['texto_parcela_minima'] != '') {
					html += ' <span class="parcelas-minima">' + parcelamento['texto_parcela_minima'] + '</span> ';
				}

				if (parcelamento['texto_observacoes'] != '') {
					html += ' <span class="parcelas-obs">' + parcelamento['texto_observacoes'] + '</span> ';
				}

				html += '</small>';
			}

			html += '		</div> <!-- .parcelas-table -->';
			html += '	</div> <!-- .parcelas-wrapper -->';
			html += '</li>';

			var $tmp = $productPrices.find('.price-box.parcelamento');
			$tmp = ($tmp.length > 0) ? $tmp.last() : $priceBoxPreco;
			$tmp.after(html);
		}
	}

	function calcularParcelamentos() {
		var retorno = [];

		if (!cfg_parcelamentos || cfg_parcelamentos.length == 0) {
			return retorno;
		}

		var parcelamentos = cfg_parcelamentos['parcelamentos'];

		if (!parcelamentos || parcelamentos.length == 0) {
			return retorno;
		}

		for (var n = 0; n < parcelamentos.length; n++) {
			var parcelamento = parcelamentos[n];

			var tipo_juros           = parseInt(parcelamento['tipo_juros'], 10);
			var juros                = parseFloat(parcelamento['juros']);
			var maximo_parcelas      = parseInt(parcelamento['maximo_parcelas'], 10);
			var minimo               = parseFloat(parcelamento['minimo']);
			var parcela_minima       = parseFloat(parcelamento['parcela_minima']);
			var parcelas_sem_juros   = parseInt(parcelamento['parcelas_sem_juros'], 10);
			var resumo_sem_juros     = parseInt(parcelamento['resumo_sem_juros'], 10);

			var descricao_tabela     = parcelamento['descricao_tabela'];
			var descricao_titulo     = parcelamento['descricao_titulo'];
			var texto_a_vista        = parcelamento['texto_a_vista'];
			var texto_com_juros      = parcelamento['texto_com_juros'];
			var texto_juros          = parcelamento['texto_juros'];
			var texto_link           = parcelamento['texto_link'];
			var texto_observacoes    = parcelamento['texto_observacoes'];
			var texto_parcela_minima = parcelamento['texto_parcela_minima'];
			var texto_sem_juros      = parcelamento['texto_sem_juros'];
			var titulo_tabela        = parcelamento['titulo_tabela'];

			if (descricao_tabela == '') { continue; }
			if (texto_link == '') { continue; }

			var preco_numero = precoNewFinal;

			var valor_minimo = minimo * current_currency_value;
			if (preco_numero < valor_minimo) { continue; }

			var parcela_minima = parcela_minima * current_currency_value;
			if (preco_numero < parcela_minima) { continue; }

			var parcelas = [];

			parcelas[1] = preco_numero;
			var resumo_parcela = 1;

			for (var p = 2; p <= maximo_parcelas; p++) {

				// se a parcela tiver juros
				if (p > parcelas_sem_juros) {
					var valor_parcela = 0;

					if (tipo_juros == 2) {
						valor_parcela = calcularJurosBacen(preco_numero, juros, p);
					} else if (tipo_juros == 1) {
						valor_parcela = calcularJurosComposto(preco_numero, juros, p);
					} else {
						valor_parcela = calcularJurosSimples(preco_numero, juros, p);
					}

					valor_parcela = valor_parcela / p;

				// Se a parcela nao tiver juros
				} else {
					valor_parcela = preco_numero / p;

				}

				// Verifica se é maior que a parcela minima
				if (valor_parcela < parcela_minima) {
					break;
				}

				if (resumo_sem_juros) {
					if (p <= parcelas_sem_juros) {
						resumo_parcela = p;
					}
				} else {
					resumo_parcela = p;
				}

				parcelas[p] = valor_parcela;
			}

			if (parcelas.length > 1) {

				var numero_de_vezes  = resumo_parcela;
				var valor_da_parcela = parcelas[resumo_parcela];
				var descricao_juros  = '';
				var valor_total      = valor_da_parcela * numero_de_vezes;

				if (resumo_parcela <= parcelas_sem_juros) {
					descricao_juros = texto_sem_juros;
				} else {
					descricao_juros = texto_com_juros;
				}

				numero_de_vezes  = '<span class="parcelamento-parcelas">'+ numero_de_vezes +'x</span>';
				valor_da_parcela = '<span class="parcelamento-valor">'+ formataPreco(valor_da_parcela) +'</span>';
				descricao_juros  = '<span class="parcelamento-juros">'+ descricao_juros +'</span>';
				valor_total      = '<span class="parcelamento-total">'+ formataPreco(valor_total) +'</span>';

				var _descricao_titulo = descricao_titulo;
				_descricao_titulo = _descricao_titulo.replace(/\{\{numero_de_vezes\}\}/g, numero_de_vezes);
				_descricao_titulo = _descricao_titulo.replace(/\{\{valor_da_parcela\}\}/g, valor_da_parcela);
				_descricao_titulo = _descricao_titulo.replace(/\{\{descricao_juros\}\}/g, descricao_juros);
				_descricao_titulo = _descricao_titulo.replace(/\{\{valor_total\}\}/g, valor_total);

				var descricao_parcelas = [];
				for (var p = 1; p < parcelas.length; p++) {
					numero_de_vezes = p;
					valor_da_parcela = parcelas[p];
					valor_total = valor_da_parcela * numero_de_vezes;

					if (p == 1) {
						descricao_juros = texto_a_vista;
					} else if (p <= parcelas_sem_juros) {
						descricao_juros = texto_sem_juros;
					} else {
						descricao_juros = texto_com_juros;
					}

					numero_de_vezes  = '<span class="parcelamento-parcelas">'+ numero_de_vezes +'x</span>';
					valor_da_parcela = '<span class="parcelamento-valor">'+ formataPreco(valor_da_parcela) +'</span>';
					descricao_juros  = '<span class="parcelamento-juros">'+ descricao_juros +'</span>';
					valor_total      = '<span class="parcelamento-total">'+ formataPreco(valor_total) +'</span>';

					var _descricao_tabela = descricao_tabela;
					_descricao_tabela = _descricao_tabela.replace(/\{\{numero_de_vezes\}\}/g, numero_de_vezes);
					_descricao_tabela = _descricao_tabela.replace(/\{\{valor_da_parcela\}\}/g, valor_da_parcela);
					_descricao_tabela = _descricao_tabela.replace(/\{\{descricao_juros\}\}/g, descricao_juros);
					_descricao_tabela = _descricao_tabela.replace(/\{\{valor_total\}\}/g, valor_total);

					descricao_parcelas.push(_descricao_tabela);
				}

				var _texto_juros = '';
				if (parcelas_sem_juros < maximo_parcelas) {
					var taxa_de_juros = formataNumero(juros, 2) + '%';

					_texto_juros = texto_juros;
					_texto_juros = _texto_juros.replace(/\{\{taxa_de_juros\}\}/g, taxa_de_juros);
				}

				var _texto_parcela_minima = '';
				if (parcela_minima > 0) {
					var parcela_minima2 = formataPreco(parcela_minima);

					_texto_parcela_minima = texto_parcela_minima;
					_texto_parcela_minima = _texto_parcela_minima.replace(/\{\{parcela_minima\}\}/g, parcela_minima2);
				}

				retorno.push({
					'descricao_titulo'     : _descricao_titulo,
					'texto_link'           : texto_link,
					'titulo_tabela'        : titulo_tabela,
					'parcelas'             : descricao_parcelas,
					'texto_juros'          : _texto_juros,
					'texto_parcela_minima' : _texto_parcela_minima,
					'texto_observacoes'    : texto_observacoes
				});
			}
		}

		return retorno;
	}

	function calcularJurosSimples(valor_a_parcelar, taxa_de_juros, numero_de_parcelas) {
		taxa_de_juros = taxa_de_juros / 100;
		return valor_a_parcelar * (1 + taxa_de_juros * numero_de_parcelas);
	}

	function calcularJurosComposto(valor_a_parcelar, taxa_de_juros, numero_de_parcelas) {
		taxa_de_juros = taxa_de_juros / 100;
		return valor_a_parcelar * Math.pow(1 + taxa_de_juros, numero_de_parcelas);
	}

	function calcularJurosBacen(valor_a_parcelar, taxa_de_juros, numero_de_parcelas) {
		// Utilizando a metodologia (formula) do Banco Central (tabela Price) disponivel em:
		// https://www3.bcb.gov.br/CALCIDADAO/publico/exibirMetodologiaFinanciamentoPrestacoesFixas.do?method=exibirMetodologiaFinanciamentoPrestacoesFixas
		// Desenvolvido por Eric Mariano Endo - Hotel da WEB
		taxa_de_juros = taxa_de_juros / 100;
		var valor_da_parcela = (valor_a_parcelar * taxa_de_juros) / (1 - Math.pow(1 + taxa_de_juros, -numero_de_parcelas));
		return valor_da_parcela * numero_de_parcelas;
	}
	<?php } ?>

	<?php if ($habilita_descontos) { ?>
	var cfg_descontos = <?php echo json_encode($descontos_cfg); ?>;

	function atualizaDescontos() {
		$productPrices.find('.price-box.descontos').remove();

		var descontos = calcularDescontos();

		for (var a = 0; a < descontos.length; a++) {
			var desconto = descontos[a];

			var html = '';
			html += '<li class="price-box descontos">';
			html += '	<span>' + desconto['descricao'] + '</span>';
			if (desconto['validade'] != '') {
				html += '<small class="desconto-obs">' + desconto['validade'] + '</small>';
			}
			html += '</li>';

			var $tmp = $productPrices.find('.price-box.descontos');
			$tmp = ($tmp.length > 0) ? $tmp.last() : $productPrices.find('.price-box.parcelamento');
			$tmp = ($tmp.length > 0) ? $tmp.last() : $priceBoxPreco;
			$tmp.after(html);
		}
	}

	function calcularDescontos() {
		var retorno = [];

		if (!cfg_descontos || cfg_descontos.length == 0) {
			return retorno;
		}

		var descontos = cfg_descontos['descontos'];

		if (!descontos || descontos.length == 0) {
			return retorno;
		}

		for (var n = 0; n < descontos.length; n++) {
			var desconto = descontos[n];

			if (desconto['descricao'] == '') { continue; }

			var preco_numero = precoNewFinal;

			var valor_minimo = parseFloat(desconto['minimo']) * current_currency_value;
			if (preco_numero < valor_minimo) { continue; }

			var preco_original          = preco_numero;
			var desconto_em_porcentagem = parseFloat(desconto['desconto']);
			var desconto_em_valor       = (preco_original <= 0) ? 0 : ((preco_original / 100) * desconto_em_porcentagem);
			var preco_com_desconto      = preco_original - desconto_em_valor;

			preco_original          = '<span class="preco_original">' + formataPreco(preco_original) + '</span>';
			desconto_em_porcentagem = '<span class="desconto_em_porcentagem">' + (desconto_em_porcentagem + '').replace('.', ',') + '%</span>';
			desconto_em_valor       = '<span class="desconto_em_valor">' + formataPreco(desconto_em_valor) + '</span>';
			preco_com_desconto      = '<span class="preco_com_desconto">' + formataPreco(preco_com_desconto) + '</span>';

			var descricao = desconto['descricao'];
			descricao = descricao.replace(/\{\{preco_original\}\}/g, preco_original);
			descricao = descricao.replace(/\{\{preco_com_desconto\}\}/g, preco_com_desconto);
			descricao = descricao.replace(/\{\{desconto_em_porcentagem\}\}/g, desconto_em_porcentagem);
			descricao = descricao.replace(/\{\{desconto_em_valor\}\}/g, desconto_em_valor);

			var validade = '';
			if (valor_minimo > 0) {
				validade = cfg_descontos['text_validade'].replace(/%s/, formataPreco(valor_minimo));
			}

			retorno.push({
				'descricao': descricao,
				'validade' : validade
			});
		}

		return retorno;
	}
	<?php } ?>

	// inicia automaticamente
	atualizaPreco();

	// helper functions
	function limpaPreco(preco) {
		var divisor = parseInt('1' + (new Array(current_currency_decimal_place + 1).join('0')), 10);
		return parseFloat((parseInt((preco + '').replace(/[^0-9]/gi, ''), 10) / divisor).toFixed(current_currency_decimal_place));
	}

	function formataNumero(numero, casas_decimais) {
		// return numero.toFixed(casas_decimais).replace('.', current_language_decimal_point).replace(/\B(?=(\d{3})+(?!\d))/g, current_language_thousand_point);
		var parts = numero.toFixed(casas_decimais).split('.');
		parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, current_language_thousand_point);
		return parts.join(current_language_decimal_point);
	}

	function formataPreco(preco) {
		preco = formataNumero(preco, current_currency_decimal_place);
		return current_currency_symbol_left + preco + current_currency_symbol_right;
	}





	// CALCULADOR DE ÁREA EM M2
	function initCalculoArea() {

		var $productOptions = $('#product .product-options');

		// obrigatório possuir no mínimo 2 opções do tipo "text"
		var $productOptionsText = $productOptions.find('.form-group[data-type="text"]');
		if ($productOptionsText.length < 2) { return false; }

		// obrigatório conter opções com os seguintes nomes (placeholders)
		var $inputLarguraAltura = $productOptionsText.find('[placeholder="Largura e Altura (cm)"]');
		var $inputAreaTotal = $productOptionsText.find('[placeholder="Área total (m²)"]');
		if ($inputLarguraAltura.length < 1 || $inputAreaTotal.length < 1) { return false; }

		var casasDecimaisArea = 4;

		// largura e altura mínimas permitidas
		var minLargura = 1;
		var maxLargura = 10000;
		var minAltura = 1;
		var maxAltura = 10000;

		// busca valor padrão da opção "Largura e Altura";
		// formato = quatro números inteiros separados por /, ex: 50/5000/50/10000
		var padraoLarguraAltura = $.trim($inputLarguraAltura.val());
		if (padraoLarguraAltura != '') {
			padraoLarguraAltura = padraoLarguraAltura.split('/');
			if (padraoLarguraAltura.length == 4) {
				minLargura = padraoLarguraAltura[0];
				maxLargura = padraoLarguraAltura[1];
				minAltura = padraoLarguraAltura[2];
				maxAltura = padraoLarguraAltura[3];
			}
		}

		// reseta valor padrão
		$inputLarguraAltura.val('');

		// insere novos campos "Largura" e "Altura" separados
		$inputLarguraAltura.after('<div class="input-group"><input type="number" class="form-control" id="opt-largura" min="'+minLargura+'" max="'+maxLargura+'" step="1" placeholder="Largura (cm)"><div class="input-group-addon">x</div><input type="number" class="form-control" id="opt-altura" min="'+minAltura+'" max="'+maxAltura+'" step="1" placeholder="Altura (cm)"></div>');

		// esconde o campo "Largura e Altura" original
		$inputLarguraAltura.hide();

		// busca novos campos
		var $inputLargura = $productOptionsText.find('#opt-largura');
		var $inputAltura = $productOptionsText.find('#opt-altura');

		// area total mínima permitida
		// busca valor padrão da opção "Área total";
		// formato = número float em formato americano, ex: 1.2
		var minArea = parseFloat($.trim($inputAreaTotal.val()));
		if (isNaN(minArea)) { minArea = 0.01; }
		minArea = minArea.toFixed(casasDecimaisArea);

		// reseta valor padrão
		$inputAreaTotal.val('');

		// remove acesso por "tab"
		$inputAreaTotal.attr('tabindex', '-1');

		// modifica placeholder do campo "Área total"
		$inputAreaTotal.attr('placeholder', 'Informe Largura e Altura acima');

		// exibe mensagem ao tentar preencher o campo "Área total"
		var timerInputAreaTotal;
		$inputAreaTotal.on('focus', function(){
			showErrorField($inputAreaTotal, 'O valor deste campo é calculado automaticamente conforme a Largura e Altura informados acima.');
			clearTimeout(timerInputAreaTotal);
			timerInputAreaTotal = setTimeout(function(){ clearErrorField($inputAreaTotal); }, 6000);

			// coloca o foco no campo "Largura" ou "Altura"
			if ($inputLargura.val() == '') { $inputLargura.focus(); return false; }
			if ($inputAltura.val() == '') { $inputAltura.focus(); return false; }
			$inputLargura.focus();
		});

		$inputLargura.on('keyup blur', inputSomenteNumeros);
		$inputAltura.on('keyup blur', inputSomenteNumeros);

		function inputSomenteNumeros(e) {
			this.value = somenteNumeros(this.value);
		}

		function somenteNumeros(val) {
			return (val + '').replace(/[^0-9]/gi, '');
		}

		$inputLargura.on('keyup blur click', startCalculoAreaTotal);
		$inputAltura.on('keyup blur click', startCalculoAreaTotal);

		var timerCalculoAreaTotal;
		function startCalculoAreaTotal(e) {
			clearTimeout(timerCalculoAreaTotal);
			timerCalculoAreaTotal = setTimeout(calculaAreaTotal, 200);
		}

		var lastLargura = false;
		var lastAltura = false;

		function calculaAreaTotal() {
			var largura = parseInt(somenteNumeros($inputLargura.val()), 10);
			var altura = parseInt(somenteNumeros($inputAltura.val()), 10);

			if (isNaN(largura) || isNaN(altura)) {
				$inputLarguraAltura.val('');
				return false;
			}

			if (largura == lastLargura && altura == lastAltura) { return false; }

			if (largura < minLargura || largura > maxLargura) {
				showErrorField($inputLarguraAltura, 'Largura mínima é '+minLargura+'cm e máxima é '+maxLargura+'cm.');
				lastLargura = 0;
				$inputLarguraAltura.val('');
				$inputLargura.focus();
				return false;
			}

			if (altura < minAltura || altura > maxAltura) {
				showErrorField($inputLarguraAltura, 'Altura mínima é '+minAltura+'cm e máxima é '+maxAltura+'cm.');
				lastAltura = 0;
				$inputLarguraAltura.val('');
				$inputAltura.focus();
				return false;
			}

			lastLargura = largura;
			lastAltura = altura;

			clearErrorField($inputLarguraAltura);
			clearErrorField($inputAreaTotal);

			// preenche campo original da opção
			$inputLarguraAltura.val(largura + 'cm x ' + altura + 'cm')

			var area = ((largura * altura) / 10000).toFixed(casasDecimaisArea);
			var valArea = '';

			$inputAreaTotal.parent().find('.text-min-area').remove();
			if (area < minArea) {
				$inputAreaTotal.after('<div class="text-min-area"><b>OBS: Para calcular o preço final do produto será considerada a área mínima de '+ formataArea(minArea) +'.</b> É possível comprar uma metragem menor, porém o preço mínimo será referente a área mínima de '+ formataArea(minArea) +'.</div>');
				valArea = formataArea(minArea) + ' (real ' + formataArea(area) + ')';
				area = minArea;
			} else {
				valArea = formataArea(area);
			}

			$inputAreaTotal.val(valArea);

			areaTotal = area;

			atualizaPreco();
		}

		function showErrorField($input, erro){
			$input.parent().addClass('has-error').find('.text-danger').remove();
			$input.after('<div class="text-danger">' + erro + '</div>');
		}

		function clearErrorField($input) {
			$input.parent().removeClass('has-error').find('.text-danger').remove();
		}

		function formataArea(area) {
			return (area + '').replace('.', ',').replace(/(,0+|0+)$/, '') + 'm²';
		}
	}

	initCalculoArea();

});
//--></script>
<?php } ?>



<?php if ($habilita_calculo_frete) { ?>
<script src="catalog/view/javascript/jquery.maskedinput.min.js" type="text/javascript"></script>

<script type="text/javascript"><!--
$(function(){
	var $productShipping = $('#product-shipping');
	var $buttonShipping  = $('#button-shipping');
	var $inputCountry    = $('#input-country');
	var $inputPostcode   = $('#input-postcode');
	var $inputZone       = $('#input-zone');

	var country = '';

	$inputCountry.on('change', function() {
		country = this.options[this.selectedIndex].text.toLowerCase();

		if (country == 'brazil' || country == 'brasil') {
			$inputPostcode.mask('99999-999');
			$inputZone.parent().hide();
		} else {
			$inputPostcode.unmask();
			$inputZone.parent().show();
		}

		$.ajax({
			url: 'index.php?route=checkout/shipping/country&country_id=' + this.value,
			dataType: 'json',
			beforeSend: function() {
				$('.fa-spin').remove();
				$productShipping.find('h4').append(' <i class="fa fa-circle-o-notch fa-spin"></i>');
			},
			complete: function() {
				setTimeout(function(){ $('.fa-spin').remove(); }, 500);
			},
			success: function(json) {
				if (json['postcode_required'] == '1') {
					$inputPostcode.parent().parent().addClass('required');
				} else {
					$inputPostcode.parent().parent().removeClass('required');
				}

				if (json['zone'] && json['zone'] != '') {
					html = '<option value=""><?php echo $text_select; ?></option>';
					for (i = 0; i < json['zone'].length; i++) {
						html += '<option value="' + json['zone'][i]['zone_id'] + '" data-code="' + json['zone'][i]['code'] + '"';

						if (json['zone'][i]['zone_id'] == '<?php echo $zone_id; ?>') {
							html += ' selected="selected"';
						}

						html += '>' + json['zone'][i]['name'] + '</option>';
					}
				} else {
					html = '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
					$inputZone.parent().hide();
				}

				$inputZone.html(html);
				$inputPostcode.trigger('keyup');
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
		});
	});

	var returnedCeps = {};

	$inputPostcode.on('keyup', function(e){
		if (country == 'brazil' || country == 'brasil') {
			var cep = this.value.replace(/[^0-9]/g, '');
			if (cep.length != 8) { return true; }

			var $this = $(this);

			$inputZone.find('option').prop('selected', false);
			$productShipping.find('.text-danger').remove();

			// verifica se esta no cache
			if (returnedCeps[cep] && returnedCeps[cep] != '') {
				afterChangePostcodeBrasil(returnedCeps[cep], $this);
				return true;
			}

			var lastCep = $this.data('last-cep');
			if (lastCep == cep) { return true; }
			$this.data('last-cep', cep);

			var xhrCep = $this.data('xhr-cep');

			if(xhrCep && xhrCep.readyState != 4){
				xhrCep.abort();
			}

			xhrCep = $.ajax({
				url: 'index.php?route=account/register/consulta_cep&c=' + cep,
				dataType: 'json',
				beforeSend: function() {
					$('.fa-spin').remove();
					$productShipping.find('h4').append(' <i class="fa fa-circle-o-notch fa-spin"></i>');
				},
				complete: function() {
					setTimeout(function(){ $('.fa-spin').remove(); }, 500);
				},
				success: function(json) {
					afterChangePostcodeBrasil(json, $this);
					returnedCeps[cep] = json;
				},
				error: function(xhr, ajaxOptions, thrownError) {
					if (thrownError != 'abort') {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
					}
				}
			});

			$this.data('xhr-cep', xhrCep);
		}
	});

	function afterChangePostcodeBrasil(json, $this) {
		$inputZone.find('option').prop('selected', false);
		$productShipping.find('.text-danger').remove();

		if (json['erro'] == '0') {
			$inputZone.parent().hide();
			$inputZone.find('option[data-code=' + unescape(json['uf']) + ']').prop('selected', true);
		} else {
			$inputZone.after('<div class="text-danger">Não foi possível encontrar o estado para o CEP informado! Por favor, confira se o CEP foi digitado corretamente ou então selecione manualmente seu estado.</div>');
			$inputZone.parent().show();
			$inputZone.focus();
		}
	}

	$buttonShipping.on('click', function() {
		if (country == 'brazil' || country == 'brasil') {
			var cep = ($inputPostcode.val()).replace(/[^0-9]/g, '');
			if (cep.length != 8) {
				alert('Por favor, informe corretamente o CEP com 8 dígitos.');
				return false;
			}
			var uf = $inputZone.val();
			if (uf == '' || uf == '0') {
				$inputPostcode.trigger('keyup');
				return false;
			}
		}

		$.ajax({
			url: 'index.php?route=product/product/quoteShipping',
			type: 'post',
			data: $('#product').find('input[type=\'text\'], input[type=\'tel\'], input[type=\'hidden\'], input[type=\'radio\']:checked, input[type=\'checkbox\']:checked, select, textarea'),
			dataType: 'json',
			beforeSend: function(){
				$('.fa-spin').remove();
				$productShipping.find('h4').append(' <i class="fa fa-circle-o-notch fa-spin"></i>');
				$buttonShipping.button('loading');
			},
			complete: function(){
				setTimeout(function(){ $('.fa-spin').remove(); }, 500);
				$buttonShipping.button('reset');
			},
			success: function(json){
				$('.alert, .text-danger').remove();
				$('.form-group').removeClass('has-error');

				if (json && json['error']) {
					if (json['error']['option']) {
						for (i in json['error']['option']) {
							var element = $('#input-option' + i.replace('_', '-'));

							if (element.parent().hasClass('input-group')) {
								element.parent().after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
							} else {
								element.after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
							}

							// Highlight any found errors
							$('.text-danger').parent().addClass('has-error');

							alert(json['error']['option'][i]);
						}
						return false;
					}

					if (json['error']['recurring']) {
						$('select[name=\'recurring_id\']').after('<div class="text-danger">' + json['error']['recurring'] + '</div>');

						// Highlight any found errors
						$('.text-danger').parent().addClass('has-error');

						alert(json['error']['recurring']);
						return false;
					}

					if (json['error']['warning']) {
						$('.breadcrumb').after('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> '+json['error']['warning']+'<button type="button" class="close" data-dismiss="alert">&times;</button></div>');
						$('html, body').animate({scrollTop:0},'slow');
						alert(json['error']['warning']);
						return false;
					}

					if (json['error']['postcode']) {
						alert(json['error']['postcode']);
						return false;
					}

					if (json['error']['country']) {
						alert(json['error']['country']);
						return false;
					}

					if (json['error']['zone']) {
						alert(json['error']['zone']);
						return false;
					}
				}

				if(json && json['shipping_method']){
					$('#modal-shipping').remove();

					html  = '<div id="modal-shipping" class="modal">';
					html += '  <div class="modal-dialog">';
					html += '    <div class="modal-content">';
					html += '      <div class="modal-header">';
					html += '        <h4 class="modal-title"><i class="fa fa-truck" style="faont-size:22px;"></i> <?php echo $text_shipping_methods; ?></h4>';
					html += '      </div>';
					html += '      <div class="modal-body">';
					html += '<table class="table table-striped table-hover" style="margin:0; border-bottom: 1px solid rgba(0, 0, 0, 0.05);">';
					html += '<tbody>';
					for (i in json['shipping_method']) {
						// html += '<p><strong>'+json['shipping_method'][i]['title']+'</strong></p>';
						if (!json['shipping_method'][i]['error']) {
							for (j in json['shipping_method'][i]['quote']) {
								html += '<tr>';
								html += '  <td align="right">'+json['shipping_method'][i]['quote'][j]['title']+'</td><td align="right"><strong>'+json['shipping_method'][i]['quote'][j]['text']+'</strong></td>';
								html += '</tr>';
							}
						} else {
							html += '<tr><td><div class="alert alert-danger">'+json['shipping_method'][i]['error']+'</div></tr></td>';
						}
					}
					html += '</tbody>';
					html += '</table>';
					html += '      </div>';
					html += '      <div class="modal-footer">';
					html += '        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo $button_close; ?> <i class="fa fa-close"></i></button>';
					html += '      </div>';
					html += '    </div>';
					html += '  </div>';
					html += '</div> ';

					$('body').append(html);
					$('#modal-shipping').modal('show');
				}
			},
			error: function(xhr,ajaxOptions,thrownError){
				alert(thrownError+"\r\n"+xhr.statusText+"\r\n"+xhr.responseText);
			}
		});
	});

	$inputCountry.trigger('change');
});
//--></script>
<?php } ?>



<?php echo $footer; ?>