<?php echo $header; ?>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<?php if ($products) { ?>
					<div class="oc-content col-xs-12">
						<div class="oc-content-inner">

							<h1><?php echo $heading_title; ?></h1>
							<p><a href="<?php echo $compare; ?>" id="compare-total"><?php echo $text_compare; ?></a></p>
							<div class="row">
								<div class="col-sm-3 col-md-4 hidden-xs">
									<div class="btn-group">
										<button type="button" id="list-view" class="btn btn-default" data-toggle="tooltip" title="<?php echo $button_list; ?>"><i class="fa fa-th-list"></i></button>
										<button type="button" id="grid-view" class="btn btn-default" data-toggle="tooltip" title="<?php echo $button_grid; ?>"><i class="fa fa-th"></i></button>
									</div>
								</div>
								<div class="col-xs-12 col-sm-2 col-md-3 text-right">
									<label class="control-label" for="input-sort"><?php echo $text_sort; ?></label>
								</div>
								<div class="col-xs-12 col-sm-3 col-md-2 text-right">
									<select id="input-sort" class="form-control" onchange="location = this.value;">
										<?php foreach ($sorts as $sorts) { ?>
										<?php if ($sorts['value'] == $sort . '-' . $order) { ?>
										<option value="<?php echo $sorts['href']; ?>" selected="selected"><?php echo $sorts['text']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $sorts['href']; ?>"><?php echo $sorts['text']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
								<div class="col-xs-12 col-sm-2 col-md-1 text-right">
									<label class="control-label" for="input-limit"><?php echo $text_limit; ?></label>
								</div>
								<div class="col-xs-12 col-sm-2 col-md-2 text-right">
									<select id="input-limit" class="form-control" onchange="location = this.value;">
										<?php foreach ($limits as $limits) { ?>
										<?php if ($limits['value'] == $limit) { ?>
										<option value="<?php echo $limits['href']; ?>" selected="selected"><?php echo $limits['text']; ?></option>
										<?php } else { ?>
										<option value="<?php echo $limits['href']; ?>"><?php echo $limits['text']; ?></option>
										<?php } ?>
										<?php } ?>
									</select>
								</div>
							</div>

						</div>
					</div>

					<?php $class = 'product-grid col-xs-12'; ?>
					<?php include('catalog/view/theme/hdw1/template/product/_product_item_layout.tpl'); ?>

					<div class="oc-content col-xs-12">
						<div class="oc-content-inner">

							<div class="row pagination-container">
								<div class="pagination-numbers col-xs-12 col-sm-6 text-left"><?php echo $pagination; ?></div>
								<div class="pagination-info col-xs-12 col-sm-6 text-right"><?php echo $results; ?></div>
							</div>

						</div>
					</div>

				<?php } else { ?>
					<div class="oc-content col-xs-12">
						<div class="oc-content-inner">

							<h1><?php echo $heading_title; ?></h1>
							<p><?php echo $text_empty; ?></p>
							<div class="buttons">
								<div class="pull-right"><a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a></div>
							</div>

						</div>
					</div>
				<?php } ?>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>

</div>
<?php echo $footer; ?>