
<?php foreach ($products as $product) { ?>

<?php

$raw_info = isset($product['raw_info']) ? $product['raw_info'] : array();

$produto_promocao = $product['special'] ? true : false;
$produto_esgotado = !$product['has_stock'];

$extra_class = '';

if ($produto_promocao) {
	$extra_class .= ' product-special';
}
if ($produto_esgotado) {
	$extra_class .= ' product-out-of-stock';
}
if (isset($raw_info['has_downloads']) && $raw_info['has_downloads'] > 0) {
	$extra_class .= ' product-has-download';
}
if (isset($raw_info['has_recurring']) && $raw_info['has_recurring'] > 0) {
	$extra_class .= ' product-has-recurring';
}
if (isset($raw_info['has_options']) && $raw_info['has_options'] > 0) {
	$extra_class .= ' product-has-options';
}
if (isset($raw_info['options_price_plus']) && $raw_info['options_price_plus'] > 0) {
	$extra_class .= ' product-options-price-plus';
}
if (isset($raw_info['options_price_minus']) && $raw_info['options_price_minus'] > 0) {
	$extra_class .= ' product-options-price-minus';
}

$extra_images = isset($product['extra_images']) ? $product['extra_images'] : array();
$extra_image = isset($extra_images[0]) ? $extra_images[0] : '';

?>

<div class="product-layout <?php echo $class; ?><?php echo $extra_class; ?>">
	<a class="product-thumb" href="<?php echo $product['href']; ?>">

		<div class="image <?php if ($extra_image != '') { echo('extra-image'); } ?>">
			<img src="<?php echo $product['thumb']; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive image1" />
			<?php if ($extra_image != '') { ?>
				<img src="<?php echo $extra_image; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive image2" />
			<?php } ?>
		</div>


		<div class="caption">
			<h4><?php echo $product['name']; ?></h4>

			<p class="description"><?php echo $product['description']; ?></p>

			<?php if ($product['rating']) { ?>
				<div class="rating">
					<?php for ($i = 1; $i <= 5; $i++) { ?>
						<?php if ($product['rating'] < $i) { ?>
							<span class="fa fa-stack"><i class="fa fa-star-o fa-stack-2x"></i></span>
						<?php } else { ?>
							<span class="fa fa-stack"><i class="fa fa-star fa-stack-2x"></i><i class="fa fa-star-o fa-stack-2x"></i></span>
						<?php } ?>
					<?php } ?>
				</div>
			<?php } ?>

			<?php if ($product['price']) { ?>
				<div class="price">
					<?php if (!$product['special']) { ?>
						<span class="price-new"><?php echo $product['price']; ?></span>
					<?php } else { ?>
						<span class="price-new"><?php echo $product['special']; ?></span>
						<span class="price-old"><?php echo $product['price']; ?></span>
					<?php } ?>

					<?php if ($product['tax']) { ?>
						<span class="price-tax"><?php echo $text_tax; ?> <?php echo $product['tax']; ?></span>
					<?php } ?>
				</div>

				<?php if ((isset($product['descontos']) && $product['descontos']) || (isset($product['parcelamentos']) && $product['parcelamentos'])) { ?>
					<div class="price-extra">
						<?php if (isset($product['parcelamentos']) && $product['parcelamentos']) { ?>
							<?php foreach ($product['parcelamentos'] as $parcelamento) { ?>
								<div class="parcelamento"><?php echo $parcelamento; ?></div>
							<?php } ?>
						<?php } ?>

						<?php if (isset($product['descontos']) && $product['descontos']) { ?>
							<?php foreach ($product['descontos'] as $desconto) { ?>
								<div class="descontos"><?php echo $desconto; ?></div>
							<?php } ?>
						<?php } ?>
					</div>
				<?php } ?>
			<?php } ?>

			<?php if ($produto_esgotado && $config_stock_text_out != '') { ?>
				<div class="out-of-stock"><?php echo $config_stock_text_out; ?></div>
			<?php } ?>
		</div>

		<div class="buttons">
			<?php if (!$produto_esgotado || $config_stock_text_out == '') { ?>
				<button type="button" class="btn-add-to-cart btn btn-primary" onclick="cart.add('<?php echo $product['product_id']; ?>', '<?php echo isset($product['minimum']) ? $product['minimum'] : 1; ?>'); return false;"><i class="fa fa-shopping-cart"></i> <span><?php echo $button_cart; ?></span></button>
			<?php } ?>

			<div class="buttons-extra">
				<button type="button" class="btn-wishlist btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $button_wishlist; ?>" onclick="wishlist.add('<?php echo $product['product_id']; ?>'); return false;"><i class="fa fa-heart"></i></button>
				<button type="button" class="btn-compare btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $button_compare; ?>" onclick="compare.add('<?php echo $product['product_id']; ?>'); return false;"><i class="fa fa-exchange"></i></button>
			</div>
		</div>

	</a>
</div>
<?php } ?>

<?php

// fillers
echo str_repeat('<div class="product-layout '.$class.'"></div>', 4);

?>
