<?php /* ?><link rel="stylesheet" href="<?php echo $stylesheet; ?>"><?php */ ?>

<div id="pagseguro-form">
	<div class="row">

		<div class="col-xs-12">
			<strong>Por favor, confirme ou preencha as informações abaixo para finalizar sua compra.</strong>
			<br>&nbsp;
		</div>

		<input type="hidden" name="senderHash" id="senderHash" value="">

		<div class="col-xs-12">
			<div class="row form-group">
				<div class="col-xs-12">
					<label class="radio-pessoa"><input type="radio" name="pessoa" class="tipo-pessoa" value="f" <?php if ($pessoa == 'f') { echo 'checked'; } ?>><span> Pessoa Física</span></label>
					&nbsp; &nbsp; &nbsp;
					<label class="radio-pessoa"><input type="radio" name="pessoa" class="tipo-pessoa" value="j" <?php if ($pessoa == 'j') { echo 'checked'; } ?>><span> Pessoa Jurídica</span></label>
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-3" style="display:none;">
			<div class="row form-group">
				<label class="col-xs-12" for="senderFirstName">Nome:</label>
				<div class="col-xs-12">
					<input type="text" name="senderFirstName" id="senderFirstName" size="20" maxlength="20" value="<?php echo $firstname; ?>" class="form-control">
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-3" style="display:none;">
			<div class="row form-group">
				<label class="col-xs-12" for="senderLastName">Sobrenome:</label>
				<div class="col-xs-12">
					<input type="text" name="senderLastName" id="senderLastName" size="20" maxlength="28" value="<?php echo $lastname; ?>" class="form-control">
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-3" style="display:none;">
			<div class="row form-group">
				<label class="col-xs-12" for="senderCPF">CPF: </label>
				<div class="col-xs-12">
					<input type="tel" name="senderCPF" id="senderCPF" value="<?php echo $cpf; ?>" class="form-control">
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-6" style="display:none;">
			<div class="row form-group">
				<label class="col-xs-12" for="senderName">Razão Social:</label>
				<div class="col-xs-12">
					<input type="text" name="senderName" id="senderName" size="20" maxlength="40" value="<?php echo $razao; ?>" class="form-control">
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-3" style="display:none;">
			<div class="row form-group">
				<label class="col-xs-12" for="senderCNPJ">CNPJ: </label>
				<div class="col-xs-12">
					<input type="tel" name="senderCNPJ" id="senderCNPJ" value="<?php echo $cnpj; ?>" class="form-control">
				</div>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-3">
			<div class="row form-group">
				<label class="col-xs-12" for="senderPhone">Telefone:</label>
				<div class="col-xs-12">
					<input type="tel" name="senderPhone" id="senderPhone" value="<?php echo $telefone; ?>" class="form-control">
				</div>
			</div>
		</div>

	</div>

	<strong>Selecione abaixo seu banco para transferência online.</strong><br>

	<div class="bancos">
		<br><br>
		Aguarde, carregando bancos...
		<br><br>
	</div>
</div>

<div class="buttons">
	<div class="pull-right">
		<input type="button" value="Confirmar compra" id="button-confirm" class="btn btn-primary" data-loading-text="Por favor aguarde...">
	</div>
</div>

<style>
.tipo-pessoa:checked + span { font-weight: bold; }
.radio-pessoa { cursor: pointer; }
</style>

<style>
.bancos{margin-bottom:20px; text-align:left;}
.bancos .banco{display:inline-block;}
.bancos .banco label{position:relative;	display:inline-block; min-width:130px; margin:10px 10px 0 0; padding: 10px; border:3px solid #eee; border-radius:5px; text-align:center; cursor:pointer;}
.bancos .banco.indisponivel{opacity:0.4;}
.bancos .banco.indisponivel label{border:3px dotted #bbb;}
.bancos .banco label span{display:block; margin:10px 0 0;}
.bancos .banco label i{display:none;}
.bancos .banco input{display:none;}
.bancos .banco input:checked+label{border:3px solid #555;}
.bancos .banco input:checked+label i{position:absolute; display:inline-block; right:-3px; top:-3px; padding:4px; background:#555; color:#fff; border-radius:5px; text-shadow:0 1px 0 #000;}
</style>

<script type="text/javascript" src="<?php echo $pagseguro_js; ?>"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery.maskedinput.min.js?v20180205"></script>
<script type="text/javascript"><!--
(function($){

	var initInterval = setInterval(function(){
		if (typeof PagSeguroDirectPayment !== 'undefined') {
			init();
		}
	}, 100);

	function init() {
		clearInterval(initInterval);

		PagSeguroDirectPayment.setSessionId('<?php echo $pagseguro_session; ?>');

		PagSeguroDirectPayment.getPaymentMethods({
			success: function (result) {
				// console.log('success');
				// console.log(result);
				var cards = result.paymentMethods.ONLINE_DEBIT.options;
				var html = '';

				$.map(cards, function (e) {
					if (e.status == 'AVAILABLE') {
						html += '<div class="banco">';
						html += '  <input type="radio" name="bankName" id="' + e.name + '" value="' + e.name + '">';
						html += '  <label for="' + e.name + '">';
						html += '    <img src="https://stc.pagseguro.uol.com.br' + e.images.MEDIUM.path + '">';
						html += '    <span>' + e.displayName + '</span>';
						html += '    <i class="fa fa-check"></i>';
						html += '  </label>';
						html += '</div>';
					} else {
						html += '<div class="banco indisponivel" data-toggle="tooltip" title="BANCO TEMPORARIAMENTE INDISPONÍVEL!">';
						html += '  <input type="radio" name="bankName" id="' + e.name + '" value="' + e.name + '" disabled>';
						html += '  <label for="' + e.name + '">';
						html += '    <img src="https://stc.pagseguro.uol.com.br' + e.images.MEDIUM.path + '">';
						html += '    <span>' + e.displayName + '</span>';
						html += '  </label>';
						html += '</div>';
					}
				});

				$('.bancos').html(html);
				$('[data-toggle=\'tooltip\']').tooltip({container: 'body'});
			},
			error: function (response) {
				// console.log('error');
				alert('Ops, não foi possível carregar os bancos conveniados. Por favor tente novamente. Caso este erro continue aparecendo entre em contato conosco.');
				location.reload(true);
			},
			complete: function (response) {
				// console.log('complete');
			}
		});
	}

	var $pagseguroForm = $('#pagseguro-form');
	var $buttonConfirm = $('#button-confirm');

	var $tipoPessoa      = $('.tipo-pessoa');
	var $senderHash      = $('#senderHash');
	var $senderFirstName = $('#senderFirstName');
	var $senderLastName  = $('#senderLastName');
	var $senderCPF       = $('#senderCPF');
	var $senderName      = $('#senderName');
	var $senderCNPJ      = $('#senderCNPJ');
	var $senderPhone     = $('#senderPhone');

	var $paiSenderName      = $senderName.parent().parent().parent();
	var $paiSenderFirstName = $senderFirstName.parent().parent().parent();
	var $paiSenderLastName  = $senderLastName.parent().parent().parent();
	var $paiSenderCPF       = $senderCPF.parent().parent().parent();
	var $paiSenderCNPJ      = $senderCNPJ.parent().parent().parent();

	$senderCPF.unmask().mask("999.999.999-99");
	$senderCNPJ.unmask().mask("99.999.999/9999-99");

	$senderPhone.unmask().mask("(99) 9999-9999?9").bind('keyup', function(e){
		if (e.type == 'keyup' && $.inArray(parseInt(e.which), [9, 16, 17, 18, 35, 36, 37, 38, 39, 40]) > -1){ return true; }
		var length = this.value.replace(/[^0-9]/g, '').length;
		if (e.type == 'keyup' && length < 10) { return true; }
		$(this).unmask().mask(length > 10 ? '(99) 99999-999?9' : '(99) 9999-9999?9');
	}).trigger('keyup');

	function changePessoa(){
		var tipoPessoa = $tipoPessoa.filter(':checked').val();

		if (tipoPessoa == 'f') {
			$paiSenderFirstName.show();
			$paiSenderLastName.show();
			$paiSenderCPF.show();
			$paiSenderName.hide();
			$paiSenderCNPJ.hide();
		} else {
			$paiSenderFirstName.hide();
			$paiSenderLastName.hide();
			$paiSenderCPF.hide();
			$paiSenderName.show();
			$paiSenderCNPJ.show();
		}
	}

	$tipoPessoa.on('click', changePessoa);
	changePessoa();

	function PagseguroValidate() {
		var tipoPessoa      = $tipoPessoa.filter(':checked').val();
		var senderFirstName = $senderFirstName.val();
		var senderLastName  = $senderLastName.val();
		var senderCPF       = $senderCPF.val();
		var senderName      = $senderName.val();
		var senderCNPJ      = $senderCNPJ.val();
		var senderPhone     = $senderPhone.val();
		var $bankName       = $('input[name=bankName]:checked');

		if (tipoPessoa == 'f') {

			senderFirstName = $.trim(senderFirstName);
			$senderFirstName.val(senderFirstName);
			if (senderFirstName.length < 2) {
				alert('Por favor informe corretamente seu nome. Mínimo 2 caracteres.');
				$senderFirstName.focus();
				return false;
			}

			senderLastName = $.trim(senderLastName);
			$senderLastName.val(senderLastName);
			if (senderLastName.length < 2) {
				alert('Por favor informe corretamente seu sobrenome. Mínimo 2 caracteres.');
				$senderLastName.focus();
				return false;
			}

			if (!(/^[0-9]{3}\.[0-9]{3}\.[0-9]{3}-[0-9]{2}$/).test(senderCPF)) {
				alert('Por favor informe corretamente seu CPF.');
				$senderCPF.focus();
				return false;
			}

		} else {

			senderName = $.trim(senderName);
			$senderName.val(senderName);
			if (senderName.length < 5 || senderName.indexOf(' ') == -1) {
				alert('Por favor informe corretamente a razão social. Deve conter pelo menos dois nomes separados por espaço. Mínimo 5 caracteres.');
				$senderName.focus();
				return false;
			}

			if (!(/^[0-9]{2}\.[0-9]{3}\.[0-9]{3}\/[0-9]{4}-[0-9]{2}$/).test(senderCNPJ)) {
				alert('Por favor informe corretamente o CNPJ da empresa.');
				$senderCNPJ.focus();
				return false;
			}

		}

		if (!(/^\([0-9]{2}\) [0-9]{4,5}-[0-9]{4}$/).test(senderPhone)) {
			alert('Por favor informe corretamente seu telefone.');
			$senderPhone.focus();
			return false;
		}

		if ($bankName.length < 1) {
			alert('Por favor selecione o banco em que possui conta para fazer a transferência online. Basta clicar sobre a logomarca do banco.');
			return false;
		}

		return true;
	}

	$buttonConfirm.bind('click', function (e) {
		e.preventDefault();

		if (PagseguroValidate()) {
			var w = window.open('', 'janelaEft', 'height=600,width=800,channelmode=0,dependent=0,directories=0,fullscreen=0,location=0,menubar=0,resizable=1,scrollbars=1,status=0,toolbar=0');
			w.document.body.innerHTML = "<h1>Por favor aguarde...</h1>";

			$buttonConfirm.button('loading');

			$senderHash.val(PagSeguroDirectPayment.getSenderHash());

			$.ajax({
				type: 'POST',
				url: 'index.php?route=payment/pagseguro_eft/payment',
				async: false,
				dataType: 'json',
				data: $pagseguroForm.find('input,textarea,select').serialize(),
				success: function (response) {
					// console.log('success');
					if (response['success']) {
						w.location.href = '<?php echo HTTP_SERVER; ?>index.php?route=payment/pagseguro_eft/open&order_id=' + response['order_id'];
						location.href = '<?php echo HTTP_SERVER; ?>index.php?route=payment/pagseguro_eft/confirm';
						return true;
					}

					w.close();
					alert('Ops, ocorreu um erro. Por favor atualize seu cadastro incluindo seu nome completo, CPF/CNPJ e telefone com DDD. Depois tente finalizar o pedido novamente.');
					location.href = '<?php echo HTTP_SERVER; ?>index.php?route=account/edit';
				},
				error: function (response) {
					// console.log('error');
					w.close();
					alert('Ops, ocorreu um erro. Por favor tente novamente. Caso este erro continue aparecendo entre em contato conosco.');
					location.reload(true);
				},
				complete: function (response) {
					// console.log('complete');
					$buttonConfirm.button('reset');
				}
			});
		}
	});

})(jQuery);
//--></script>