<?php

include_once('_functions.php');

$setting = isset($setting) ? $setting : array();

$timeout = isset($setting['timeout']) ? intval($setting['timeout']) : 4;
if ($timeout < 0) { $timeout = 0; }
if ($timeout > 60) { $timeout = 60; }
if (count($banners) == 1) { $timeout = 0; }
$timeout = ($timeout == 0) ? 'false' : $timeout * 1000;

$mclass = modules_moduleClass($setting) . modules_screenClass($setting) . modules_extraClass($setting);

?>
<?php if ($banners) { ?>
<div class="oc-slideshow <?php echo $mclass; ?>">

	<div id="slideshow<?php echo $module; ?>">
		<?php foreach ($banners as $banner) { ?>
			<?php

			extract($banner);

			$link = trim($link);
			$target = isset($target) ? $target : 'self';

			$popup_width = isset($popup_width) ? intval($popup_width) : 600;
			$popup_height = isset($popup_height) ? intval($popup_height) : 400;
			$popup_width = ($popup_width > 0) ? $popup_width : 600;
			$popup_height = ($popup_height > 0) ? $popup_height : 400;

			$link_open = '';
			$link_close = '';

			if ($link != '') {
				$link_open = '<a href="'. $link .'" ';

				if ($target == 'new') {
					$link_open .= 'target="_blank"';
				} elseif ($target == 'pop') {
					$link_open .= 'onclick="window.open(this.href, \'\', \'width='.$popup_width.',height='.$popup_height.',top=10,left=10,titlebar=no,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes\'); return false;"';
				}

				$link_open .= '>';
				$link_close = '</a>';
			}

			?>
			<div class="item">
				<?php echo($link_open); ?>
				<img data-src="<?php echo $image; ?>" alt="<?php echo $title; ?>" class="img-responsive lazyOwl" />
				<?php echo($link_close); ?>
			</div>
		<?php } ?>
	</div>

	<script type="text/javascript"><!--
	(function(){

		var module = {
			id: 'slideshow<?php echo $module; ?>',
			init: function() {
				this.el.owlCarousel({
					singleItem: true,
					autoPlay: <?php echo $timeout; ?>,
					stopOnHover: true,
					navigation: true,
					navigationText: ['<i class="fa fa-chevron-left fa-5x"></i>', '<i class="fa fa-chevron-right fa-5x"></i>'],
					pagination: true,
					paginationNumbers: false,
					lazyLoad: true,
					transitionStyle: false // false, fade, backSlide, goDown and scaleUp
				});
			}
		};

		initOwlInsideHiddenModules(module);

	})();
	--></script>

</div>
<?php } ?>