<?php

function modules_moduleClass($setting) {
	$columns = isset($setting['columns']) ? trim($setting['columns']) : '0';

	$class = '';

	if ($columns != '0') {
		if (is_numeric($columns) && $columns < 1) { $columns = 1; }
		if (is_numeric($columns) && $columns > 6) { $columns = 6; }

		if (is_numeric($columns)) {
			switch ($columns) {
			case 1: $columns = 'c2'; break;
			case 2: $columns = 'c4'; break;
			case 3: $columns = 'c6'; break;
			case 4: $columns = 'c8'; break;
			case 5: $columns = 'c10'; break;
			case 6: $columns = 'c12'; break;
			}
		}

		switch ($columns) {
		case 'c1'  : $columns = 'c1'; break;
		case 'c2'  : $columns = 'c2'; break;
		case 'c3'  : $columns = 'c3'; break;
		case 'c4'  : $columns = 'c4'; break;
		case 'c5'  : $columns = 'c5'; break;
		case 'c6'  : $columns = 'c6'; break;
		case 'c7'  : $columns = 'c7'; break;
		case 'c8'  : $columns = 'c8'; break;
		case 'c9'  : $columns = 'c9'; break;
		case 'c10' : $columns = 'c10'; break;
		case 'c11' : $columns = 'c11'; break;
		case 'c12' : $columns = 'c12'; break;
		default: $columns = '';
		}

		if ($columns != '') {
			$bs_columns = str_replace('c', '', $columns);
			$class = "col-xs-12 col-sm-{$bs_columns} ";
		}
	}

	return $class;
}

function modules_screenClass($setting) {
	$screen = isset($setting['screen']) ? $setting['screen'] : '';

	$class = '';

	switch ($screen) {
	case 'lg': $class .= ' hidden-xs hidden-sm '; break;
	case 'md': $class .= ' hidden-xs hidden-md hidden-lg '; break;
	case 'sm': $class .= ' hidden-sm hidden-md hidden-lg '; break;
	case 'n-lg': $class .= ' hidden-md hidden-lg '; break;
	case 'n-md': $class .= ' hidden-sm '; break;
	case 'n-sm': $class .= ' hidden-xs '; break;
	}

	return $class;
}

function modules_extraClass($setting) {
	$cssclass = isset($setting['cssclass']) ? trim($setting['cssclass']) : '';
	$cssclass = ($cssclass != '') ? " {$cssclass} " : '';

	return $cssclass;
}
