<?php echo $header; ?>
<style>
.contact-fax-title,
.contact-open-content + .contact-comment-title { margin-top: 20px; }
@media only screen and (max-width: 767px) {
	.contact-location-image + .contact-location-address,
	.contact-location-phones,
	.contact-location-comment { margin-top: 20px; padding-top: 20px; border-top: 1px dotted rgba(0,0,0,0.1); }
}
@media only screen and (min-width: 768px) {
	.contact-location-image + .contact-location-address,
	.contact-location-phones,
	.contact-location-comment { border-left: 1px dotted rgba(0,0,0,0.1); }
}
</style>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<div class="oc-content col-xs-12">
					<div class="oc-content-inner">
						<h1><?php echo $heading_title; ?></h1>

						<div id="contact-location">
							<h3><?php echo $text_location; ?></h3>
							<div class="panel-group">
								<div class="panel panel-default">
									<div class="panel-body">
										<div class="row">

											<?php
											$class1 = '';
											$class2 = 'col-sm-6';
											$class3 = 'col-sm-6';
											$class4 = '';
											if ($image && ($open || $comment)) {
												$class1 = 'col-sm-3';
												$class2 = 'col-sm-4';
												$class3 = 'col-sm-2';
												$class4 = 'col-sm-3';
											} elseif ($image) {
												$class1 = 'col-sm-3';
												$class2 = 'col-sm-6';
												$class3 = 'col-sm-3';
												$class4 = '';
											} elseif ($open || $comment) {
												$class1 = '';
												$class2 = 'col-sm-5';
												$class3 = 'col-sm-3';
												$class4 = 'col-sm-4';
											}
											?>

											<?php if ($image) { ?>
												<div class="contact-location-image <?php echo $class1; ?> col-xs-12">
													<img src="<?php echo $image; ?>" alt="<?php echo $store; ?>" title="<?php echo $store; ?>" class="img-responsive" />
												</div>
											<?php } ?>

											<div class="contact-location-address <?php echo $class2; ?> col-xs-12">
												<div class="contact-address-title"><strong><?php echo $store; ?></strong></div>
												<address class="contact-address-content"><?php echo $address; ?></address>
												<?php if ($geocode) { ?>
													<a href="https://maps.google.com/maps?q=<?php echo urlencode($geocode); ?>" target="_blank" class="btn btn-primary"><i class="fa fa-map-marker"></i> <?php echo $button_map; ?></a>
												<?php } ?>
											</div>

											<div class="contact-location-phones <?php echo $class3; ?> col-xs-12">
												<div class="contact-phone-title"><strong><?php echo $text_telephone; ?></strong></div>
												<div class="contact-phone-content"><?php echo $telephone; ?></div>
												<?php if ($fax) { ?>
													<div class="contact-fax-title"><strong><?php echo $text_fax; ?></strong></div>
													<div class="contact-fax-content"><?php echo $fax; ?></div>
												<?php } ?>
											</div>

											<?php if ($open || $comment) { ?>
												<div class="contact-location-comment <?php echo $class4; ?> col-xs-12">
													<?php if ($open) { ?>
														<div class="contact-open-title"><strong><?php echo $text_open; ?></strong></div>
														<div class="contact-open-content"><?php echo $open; ?></div>
													<?php } ?>
													<?php if ($comment) { ?>
														<div class="contact-comment-title"><strong><?php echo $text_comment; ?></strong></div>
														<div class="contact-comment-content"><?php echo $comment; ?></div>
													<?php } ?>
												</div>
											<?php } ?>

										</div>
									</div>
								</div>
							</div>
						</div>

						<?php if ($locations) { ?>
						<div id="contact-locations">
							<h3><?php echo $text_store; ?></h3>
							<div class="panel-group" id="accordion">
								<?php foreach ($locations as $location) { ?>
								<div class="panel panel-default">
									<div class="panel-heading">
										<h4 class="panel-title"><a href="#collapse-location<?php echo $location['location_id']; ?>" class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"><?php echo $location['name']; ?> <i class="fa fa-caret-down"></i></a></h4>
									</div>
									<div class="panel-collapse collapse" id="collapse-location<?php echo $location['location_id']; ?>">
										<div class="panel-body">
											<div class="row">

												<?php
												$class1 = '';
												$class2 = 'col-sm-6';
												$class3 = 'col-sm-6';
												$class4 = '';
												if ($image && ($open || $comment)) {
													$class1 = 'col-sm-3';
													$class2 = 'col-sm-4';
													$class3 = 'col-sm-2';
													$class4 = 'col-sm-3';
												} elseif ($image) {
													$class1 = 'col-sm-3';
													$class2 = 'col-sm-6';
													$class3 = 'col-sm-3';
													$class4 = '';
												} elseif ($open || $comment) {
													$class1 = '';
													$class2 = 'col-sm-5';
													$class3 = 'col-sm-3';
													$class4 = 'col-sm-4';
												}
												?>

												<?php if ($location['image']) { ?>
													<div class="contact-location-image <?php echo $class1; ?> col-xs-12">
														<img src="<?php echo $location['image']; ?>" alt="<?php echo $location['name']; ?>" title="<?php echo $location['name']; ?>" class="img-responsive" />
													</div>
												<?php } ?>

												<div class="contact-location-address <?php echo $class2; ?> col-xs-12">
													<div class="contact-address-title"><strong><?php echo $location['name']; ?></strong></div>
													<address class="contact-address-content"><?php echo $location['address']; ?></address>
													<?php if ($location['geocode']) { ?>
														<a href="https://maps.google.com/maps?q=<?php echo urlencode($location['geocode']); ?>" target="_blank" class="btn btn-primary"><i class="fa fa-map-marker"></i> <?php echo $button_map; ?></a>
													<?php } ?>
												</div>

												<div class="contact-location-phones <?php echo $class3; ?> col-xs-12">
													<div class="contact-phone-title"><strong><?php echo $text_telephone; ?></strong></div>
													<div class="contact-phone-content"><?php echo $location['telephone']; ?></div>
													<?php if ($location['fax']) { ?>
														<div class="contact-fax-title"><strong><?php echo $text_fax; ?></strong></div>
														<div class="contact-fax-content"><?php echo $location['fax']; ?></div>
													<?php } ?>
												</div>

												<?php if ($location['open'] || $location['comment']) { ?>
													<div class="contact-location-comment <?php echo $class4; ?> col-xs-12">
														<?php if ($location['open']) { ?>
															<div class="contact-open-title"><strong><?php echo $text_open; ?></strong></div>
															<div class="contact-open-content"><?php echo $location['open']; ?></div>
														<?php } ?>
														<?php if ($location['comment']) { ?>
															<div class="contact-comment-title"><strong><?php echo $text_comment; ?></strong></div>
															<div class="contact-comment-content"><?php echo $location['comment']; ?></div>
														<?php } ?>
													</div>
												<?php } ?>

											</div>
										</div>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>
						<?php } ?>

						<div id="contact-form">
							<h3><?php echo $text_contact; ?></h3>
							<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" class="form-horizontal">
								<fieldset>
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-name"><?php echo $entry_name; ?></label>
										<div class="col-sm-10">
											<input type="text" name="name" value="<?php echo $name; ?>" id="input-name" class="form-control" />
											<?php if ($error_name) { ?>
											<div class="text-danger"><?php echo $error_name; ?></div>
											<?php } ?>
										</div>
									</div>
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-email"><?php echo $entry_email; ?></label>
										<div class="col-sm-10">
											<input type="text" name="email" value="<?php echo $email; ?>" id="input-email" class="form-control" />
											<?php if ($error_email) { ?>
											<div class="text-danger"><?php echo $error_email; ?></div>
											<?php } ?>
										</div>
									</div>
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-enquiry"><?php echo $entry_enquiry; ?></label>
										<div class="col-sm-10">
											<textarea name="enquiry" rows="10" id="input-enquiry" class="form-control"><?php echo $enquiry; ?></textarea>
											<?php if ($error_enquiry) { ?>
											<div class="text-danger"><?php echo $error_enquiry; ?></div>
											<?php } ?>
										</div>
									</div>
									<?php if ($site_key) { ?>
										<div class="form-group">
											<div class="col-sm-offset-2 col-sm-10">
												<div class="g-recaptcha" data-sitekey="<?php echo $site_key; ?>"></div>
												<?php if ($error_captcha) { ?>
													<div class="text-danger"><?php echo $error_captcha; ?></div>
												<?php } ?>
											</div>
										</div>
									<?php } ?>
								</fieldset>
								<div class="buttons">
									<div class="pull-right">
										<input class="btn btn-primary" type="submit" value="<?php echo $button_submit; ?>" />
									</div>
								</div>
							</form>
						</div>

					</div>
				</div>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>
</div>
<?php echo $footer; ?>
