<?php

$payment_method = isset($_REQUEST['pm']) ? $_REQUEST['pm'] : '';

$payment_instructions = '';

if ($payment_method != '') {
	if ($payment_method == md5('bank_transfer_hdw')) {
		$instructions = $this->registry->get('config')->get('bank_transfer_hdw_post_instructions');
	}

	if ($payment_method == md5('combinar')) {
		$instructions = $this->registry->get('config')->get('combinar_post_instructions');
	}

	if ($payment_method == md5('boleto_manual')) {
		$instructions = $this->registry->get('config')->get('boleto_manual_post_instructions');
	}

	if ($payment_method == md5('bndes')) {
		$instructions = $this->registry->get('config')->get('bndes_post_instructions');
	}

	if ($payment_method == md5('cheque_hdw')) {
		$instructions = $this->registry->get('config')->get('cheque_hdw_post_instructions');
	}

	$language_id = $this->registry->get('config')->get('config_language_id');

	$payment_instructions = (isset($instructions[$language_id]) && $instructions[$language_id] != '') ? nl2br($instructions[$language_id]) : '';
}

?>
<?php echo $header; ?>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<div class="oc-content col-xs-12">
					<div class="oc-content-inner">

						<h1><?php echo $heading_title; ?></h1>

						<?php if ($payment_instructions != '') { ?>
							<div class="well well-sm text-autolink">
								<?php echo $payment_instructions; ?>
							</div>
						<?php } ?>

						<?php if (isset($order_data) && is_array($order_data) && defined('EBIT_ID')) { ?>
							<div style="text-align: center;">
								<param id="ebitParam" value="email=<?php echo $order_data['email'];
								?>&transactionId=<?php echo $order_data['order_id'];
								?>&deliveryTax=<?php echo 0;
								?>&totalSpent=<?php echo number_format($order_data['total'], 2, '.', '');

								?>&productName=PEDIDO<?php echo $order_data['order_id']; ?>&quantity=1&value=<?php echo number_format($order_data['total'], 2, '.', ''); ?>&sku=PEDIDO<?php echo $order_data['order_id'];

								?>&buscapeId=<?php echo EBIT_ID;
								?>&storeId=<?php echo EBIT_ID;

								?>" />
								<a id="bannerEbit"></a>
								<script type="text/javascript" id="getSelo" src="https://imgs.ebit.com.br/ebitBR/selo-ebit/js/getSelo.js?<?php echo EBIT_ID; ?>&lightbox=true"></script>
							</div>
						<?php } ?>

						<?php echo $text_message; ?>

						<div class="buttons">
							<div class="pull-right"><a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a></div>
						</div>

					</div>
				</div>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>

</div>



<script type="text/javascript" src="catalog/view/javascript/autolinker.min.js"></script>

<script>
$('.text-autolink').each(function(){
	var html = Autolinker.link($(this).html(), { newWindow: true });
	$(this).html(html).removeClass('text-autolink');
});
</script>



<?php if(isset($gaTracking) && $gaTracking != '') { ?>
<script>
ga('require', 'ecommerce');
<?php echo $gaTracking; ?>
ga('ecommerce:send');
</script>
<?php } ?>



<?php echo $footer; ?>