<?php

$hdw = new Hdw();

$taghead_top           = isset($taghead_top) ? $taghead_top : '';
$taghead_bottom        = isset($taghead_bottom) ? $taghead_bottom : '';
$tagbody_top           = isset($tagbody_top) ? $tagbody_top : '';
$header_top            = isset($header_top) ? $header_top : '';
$header_content_top    = isset($header_content_top) ? $header_content_top : '';
$header_content_bottom = isset($header_content_bottom) ? $header_content_bottom : '';
$header_bottom         = isset($header_bottom) ? $header_bottom : '';
$content_before        = isset($content_before) ? $content_before : '';


$metaog = isset($metaog) ? $metaog : '';
$metatw = isset($metatw) ? $metatw : '';


$language_code           = $this->registry->get('language')->get('code');
$language_decimal_point  = $this->registry->get('language')->get('decimal_point');
$language_thousand_point = $this->registry->get('language')->get('thousand_point');

$currency_code           = $this->registry->get('currency')->getCode();
$currency_value          = $this->registry->get('currency')->getValue();
$currency_symbol_left    = $this->registry->get('currency')->getSymbolLeft();
$currency_symbol_right   = $this->registry->get('currency')->getSymbolRight();
$currency_decimal_place  = $this->registry->get('currency')->getDecimalPlace();

$config_campo_idade = $this->registry->get('config')->has('config_campo_idade') ? $this->registry->get('config')->get('config_campo_idade') : 0;
$config_campo_idade = is_numeric($config_campo_idade) ? $config_campo_idade : 0;

$birth_max_date = date('Y-m-d', mktime(0, 0, 0, date('m'), date('d'), date('Y') - $config_campo_idade));


$pClasses = array(
	'product-category',
	'product-product',
	'product-manufacturer-info'
);

foreach ($pClasses as $c) {
	if (strpos($class, $c) !== false) {
		$class .= ' ' . $c;
	}
}

?><!DOCTYPE html>
<!--[if IE]><![endif]-->
<!--[if IE 8 ]><html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>" class="ie8"><![endif]-->
<!--[if IE 9 ]><html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>" class="ie9"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<!--<![endif]-->
<head>
<?php echo $taghead_top; ?>

<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo $title; ?></title>

<base href="<?php echo $base; ?>" />

<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>

<?php if ($keywords) { ?>
<meta name="keywords" content= "<?php echo $keywords; ?>" />
<?php } ?>

<meta http-equiv="X-UA-Compatible" content="IE=edge">

<?php if ($icon) { ?>
<link href="<?php echo $icon; ?>" rel="icon" />
<?php } ?>

<meta property="og:locale" content="pt_BR">
<meta property="og:url" content="<?php echo trim($base, '/') . $_SERVER['REQUEST_URI']; ?>">
<meta property="og:title" content="<?php echo $title; ?>" />
<meta property="og:site_name" content="<?php echo $name; ?>" />
<?php if (is_array($metaog)) { ?>
<?php foreach ($metaog as $og) { ?>
<meta property="<?php echo $og['meta'] ?>" content="<?php echo $og['content']; ?>" />
<?php } ?>
<?php } ?>

<meta name="twitter:title" content="<?php echo $title; ?>">
<?php if (is_array($metatw)) { ?>
<?php foreach ($metatw as $tw) { ?>
<meta name="<?php echo $tw['meta'] ?>" content="<?php echo $tw['content']; ?>" />
<?php } ?>
<?php } ?>

<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>

<script src="<?php echo $hdw->_file_last_modified('catalog/view/javascript/jquery/jquery-2.1.1.min.js'); ?>" type="text/javascript"></script>
<link href="<?php echo $hdw->_file_last_modified('catalog/view/javascript/bootstrap/css/bootstrap.min.css'); ?>" rel="stylesheet" media="screen" />
<script src="<?php echo $hdw->_file_last_modified('catalog/view/javascript/bootstrap/js/bootstrap.min.js'); ?>" type="text/javascript"></script>
<?php /* ?><link href="<?php echo $hdw->_file_last_modified('catalog/view/javascript/font-awesome/css/font-awesome.min.css'); ?>" rel="stylesheet" type="text/css" /><?php */ ?>
<?php /* ?><link href="//fonts.googleapis.com/css?family=Open+Sans:400,400i,300,700" rel="stylesheet" type="text/css" /><?php */ ?>
<link href="<?php echo $hdw->_file_last_modified('catalog/view/theme/hdw1/stylesheet/stylesheet.css'); ?>" rel="stylesheet">

<?php foreach ($styles as $style) { ?>
<link href="<?php echo $hdw->_file_last_modified($style['href']); ?>" type="text/css" rel="<?php echo $style['rel']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>

<script>
var current_language_code           = '<?php echo $language_code; ?>';
var current_language_decimal_point  = '<?php echo $language_decimal_point; ?>';
var current_language_thousand_point = '<?php echo $language_thousand_point; ?>';

var current_currency_code          = '<?php echo $currency_code; ?>';
var current_currency_value         = <?php echo $currency_value; ?>;
var current_currency_symbol_left   = '<?php echo $currency_symbol_left; ?>';
var current_currency_symbol_right  = '<?php echo $currency_symbol_right; ?>';
var current_currency_decimal_place = <?php echo $currency_decimal_place; ?>;

var birth_max_date = '<?php echo $birth_max_date; ?>';
</script>

<script src="<?php echo $hdw->_file_last_modified('catalog/view/javascript/common.js'); ?>" type="text/javascript"></script>

<?php foreach ($scripts as $script) { ?>
<script src="<?php echo $hdw->_file_last_modified($script); ?>" type="text/javascript"></script>
<?php } ?>

<script>
// inicia owlCarousel somente se o módulo estiver visível
function initOwlInsideHiddenModules(module) {
	module.el = $('#' + module.id);

	if (module.el.length == 0) {
		return;
	}

	module.parent = module.el.parent();
	module.initialized = false;
	module.timer;

	module.pre_init = function() {
		if (this.initialized || !this.parent.is(':visible')) {
			return;
		}

		this.initialized = true;
		this.init();
	};

	$(window).on('resize.init-' + module.id, function() {
		clearTimeout(module.timer);
		module.timer = setTimeout(function(){
			module.pre_init();
		}, 300);
	}).trigger('resize.init-' + module.id);
}
</script>

<?php /* ?><style>
body {
	background-image: url(image/catalog/background/background-pattern-<?php echo mt_rand(1, 29); ?>.png);
	background-attachment: fixed;
}
</style><?php */ ?>

<?php echo $google_analytics; ?>
<?php echo $taghead_bottom; ?>
</head>

<body class="<?php echo $class; ?>">
<?php echo $tagbody_top; ?>

<header>
	<?php if ($header_top != '') { ?>
		<div id="header-top">
			<?php echo $header_top; ?>
		</div>
	<?php } ?>

	<nav id="header-nav">
		<div class="container">

			<div id="header-nav-content" class="clearfix">
				<?php echo $currency; ?>
				<?php echo $language; ?>

				<div id="header-nav-links" class="nav pull-right">
					<ul class="list-inline">
						<li class="nav-link nav-link-contact"><a href="<?php echo $contact; ?>"><i class="fa fa-phone"></i> <span class="hidden-xs"><?php echo $telephone; ?></span></a></li>
						<li class="nav-link nav-link-account dropdown"><a href="<?php echo $account; ?>" title="<?php echo $text_account; ?>" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user"></i> <span class="hidden-xs hidden-sm hidden-md"><?php echo $text_account; ?></span> <span class="caret"></span></a>
							<ul class="dropdown-menu dropdown-menu-right">
								<?php if ($logged) { ?>
								<li class="nav-link-account2"><a class="btn btn-link btn-block" href="<?php echo $account; ?>"><?php echo $text_account; ?></a></li>
								<li class="nav-link-order"><a class="btn btn-link btn-block" href="<?php echo $order; ?>"><?php echo $text_order; ?></a></li>
								<li class="nav-link-transaction"><a class="btn btn-link btn-block" href="<?php echo $transaction; ?>"><?php echo $text_transaction; ?></a></li>
								<li class="nav-link-download"><a class="btn btn-link btn-block" href="<?php echo $download; ?>"><?php echo $text_download; ?></a></li>
								<li class="nav-link-logout"><a class="btn btn-link btn-block" href="<?php echo $logout; ?>"><?php echo $text_logout; ?></a></li>
								<?php } else { ?>
								<li class="nav-link-register"><a class="btn btn-link btn-block" href="<?php echo $register; ?>"><?php echo $text_register; ?></a></li>
								<li class="nav-link-login"><a class="btn btn-link btn-block" href="<?php echo $login; ?>"><?php echo $text_login; ?></a></li>
								<?php } ?>
							</ul>
						</li>
						<li class="nav-link nav-link-wishlist"><a href="<?php echo $wishlist; ?>" id="wishlist-total" title="<?php echo $text_wishlist; ?>"><i class="fa fa-heart"></i> <span class="hidden-xs hidden-sm hidden-md"><?php echo $text_wishlist; ?></span></a></li>
						<li class="nav-link nav-link-cart"><a href="<?php echo $shopping_cart; ?>" title="<?php echo $text_shopping_cart; ?>"><i class="fa fa-shopping-cart"></i> <span class="hidden-xs hidden-sm hidden-md"><?php echo $text_shopping_cart; ?></span></a></li>
						<li class="nav-link nav-link-checkout"><a href="<?php echo $checkout; ?>" title="<?php echo $text_checkout; ?>"><i class="fa fa-share"></i> <span class="hidden-xs hidden-sm hidden-md"><?php echo $text_checkout; ?></span></a></li>
					</ul>
				</div>
			</div>

		</div>
	</nav>

	<?php if ($header_content_top != '') { ?>
		<div id="header-content-top">
			<?php echo $header_content_top; ?>
		</div>
	<?php } ?>

	<div id="header-main">
		<div class="container">

			<div id="header-main-content">
				<div class="row vertical-align">
					<div id="header-main-logo" class="col-xs-12 col-sm-4">
						<div id="logo">
							<?php if ($logo) { ?>
							<a href="<?php echo $home; ?>"><img src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" class="img-responsive" /></a>
							<?php } else { ?>
							<h1><a href="<?php echo $home; ?>"><?php echo $name; ?></a></h1>
							<?php } ?>
						</div>
					</div>
					<div id="header-main-search" class="col-xs-12 col-sm-4"><?php echo $search; ?></div>
					<div id="header-main-cart" class="col-xs-12 col-sm-4 col-md-3 col-md-offset-1"><?php echo $cart; ?></div>
				</div>
			</div>

		</div>
	</div>

	<?php if ($header_content_bottom != '') { ?>
		<div id="header-content-bottom">
			<?php echo $header_content_bottom; ?>
		</div>
	<?php } ?>

	<?php if ($categories) { ?>
	<nav id="header-menu">
		<div class="container">

			<div id="header-menu-content" class="navbar">
				<div class="navbar-header"><span id="category" class="visible-xs"><?php echo $text_category; ?></span>
					<button type="button" class="btn btn-navbar navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse"><i class="fa fa-bars"></i></button>
				</div>
				<div class="collapse navbar-collapse navbar-ex1-collapse">
					<ul class="nav navbar-nav">
						<?php
						$children_group_by = 'column'; // column or category
						foreach ($categories as $category) {
							if (isset($category['children']) === true && empty($category['children']) === false) {
								?>
								<li class="dropdown lvl1 has-child">
									<a href="<?php echo $category['href']; ?>" class="dropdown-toggle" data-toggle="dropdown"><?php echo $category['name']; ?></a>
									<div class="dropdown-menu">
										<div class="dropdown-inner">
											<?php
											if ($children_group_by === 'column') {
												$category_children = array();

												foreach ($category['children'] as $child) {
													$category_children[] = $child;
													if (isset($child['children']) === true && empty($child['children']) === false){
														foreach ($child['children'] as $child2) {
															$category_children[] = $child2;
														}
													}
												}

												foreach (array_chunk($category_children, ceil(count($category_children) / $category['column']), true) as $children) {
													?>
													<ul class="list-unstyled">
														<?php
														foreach ($children as $c => $child) {
															$class = 'lvl' . (isset($child['level']) === true ? $child['level'] : '');

															if (isset($child['level']) === true && $child['level'] == 2) {
																if (isset($child['children']) === true && empty($child['children']) === false) {
																	$class .= ' has-child';
																} else {
																	$class .= ' no-child';
																}
															}

															$next_child = isset($category_children[$c + 1]) ? $category_children[$c + 1] : array();

															if (isset($child['level']) === true && $child['level'] == 3 && (empty($next_child) === true || isset($next_child['level']) === false || (isset($next_child['level']) === true && $next_child['level'] != 3))) {
																$class .= ' last-child';
															}
															?>
															<li class="<?php echo $class; ?>"><a href="<?php echo $child['href']; ?>"><?php echo $child['name']; ?></a></li>
															<?php
														}
														?>
													</ul>
													<?php
												}
											} else {
												?>
												<ul class="list-unstyled">
													<?php
													foreach ($category['children'] as $child) {
														if (isset($child['children']) === true && empty($child['children']) === false) {
															?>
															<li class="lvl2 has-child">
																<a href="<?php echo $child['href']; ?>"><?php echo $child['name']; ?></a>
																<ul class="list-unstyled">
																	<?php
																	foreach ($child['children'] as $child2) {
																		?>
																		<li class="lvl3"><a href="<?php echo $child2['href']; ?>"><?php echo $child2['name']; ?></a></li>
																		<?php
																	}
																	?>
																</ul>
															</li>
															<?php
														} else {
															?>
															<li class="lvl2 no-child"><a href="<?php echo $child['href']; ?>"><?php echo $child['name']; ?></a></li>
															<?php
														}
													}
													?>
												</ul>
												<?php
											}
											?>
										</div>
										<a href="<?php echo $category['href']; ?>" class="see-all"><?php echo $text_all; ?> <?php echo $category['name']; ?></a>
									</div>
								</li>
								<?php
							} else {
								?>
								<li class="lvl1 no-child"><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a></li>
								<?php
							}
						}
						?>
					</ul>
				</div>
			</div>

		</nav>
	</div>
	<?php } ?>

	<?php if ($header_bottom != '') { ?>
		<div id="header-bottom">
			<?php echo $header_bottom; ?>
		</div>
	<?php } ?>
</header>

<div id="main-content">

	<?php if ($content_before != '') { ?>
		<div id="content-before" class="container">
			<div class="row">
				<?php echo $content_before; ?>
			</div>
		</div>
	<?php } ?>
