<?php echo $header; ?>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<?php if ($error_warning) { ?>
	<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?></div>
	<?php } ?>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<div class="oc-content col-xs-12">
					<div class="oc-content-inner">
						<h1><?php echo $heading_title; ?></h1>
						<p><?php echo $text_account_already; ?></p>
						<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" class="form-horizontal form-register">



							<fieldset id="address">
								<legend><?php echo $text_your_address; ?></legend>
								<div class="form-group required" <?php if ($config_campo_pais == '0') { echo('style="display:none"'); } ?> >
									<label class="col-sm-2 control-label" for="input-country"><?php echo $entry_country; ?></label>
									<div class="col-sm-10">
										<select name="country_id" id="input-country" class="form-control input-country">
											<option value=""><?php echo $text_select; ?></option>
											<?php foreach ($countries as $country) { ?>
											<?php if ($country['country_id'] == $country_id) { ?>
											<option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
											<?php } else { ?>
											<option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
											<?php } ?>
											<?php } ?>
										</select>
										<?php if ($error_country) { ?>
										<div class="text-danger"><?php echo $error_country; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-postcode"><?php echo $entry_postcode; ?></label>
									<div class="col-sm-10">
										<input type="tel" inputmode="numeric" name="postcode" maxlength="10" value="<?php echo $postcode; ?>" placeholder="<?php echo $entry_postcode; ?>" id="input-postcode" class="form-control input-postcode mask-postcode" />
										<?php if ($error_postcode) { ?>
										<div class="text-danger"><?php echo $error_postcode; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-address-1"><?php echo $entry_address_1; ?></label>
									<div class="col-sm-10">
										<input type="text" name="address_1" maxlength="128" value="<?php echo $address_1; ?>" placeholder="<?php echo $entry_address_1; ?>" id="input-address-1" class="form-control input-address-1" />
										<?php if ($error_address_1) { ?>
										<div class="text-danger"><?php echo $error_address_1; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="fieldset-brasil">
									<div class="form-group required">
										<label class="col-sm-2 control-label" for="input-numero"><?php echo $entry_numero; ?></label>
										<div class="col-sm-10">
											<input type="text" inputmode="numeric" name="custom_field[address][numero]" maxlength="10" value="<?php echo isset($register_custom_field['numero']) ? $register_custom_field['numero'] : ''; ?>" placeholder="<?php echo $entry_numero; ?>" id="input-numero" class="form-control input-numero" />
											<?php if (isset($error_custom_field['numero'])) { ?>
											<div class="text-danger"><?php echo $error_custom_field['numero']; ?></div>
											<?php } ?>
										</div>
									</div>
									<div class="form-group">
										<label class="col-sm-2 control-label" for="input-complemento"><?php echo $entry_complemento; ?></label>
										<div class="col-sm-10">
											<input type="text" name="custom_field[address][complemento]" maxlength="14" value="<?php echo isset($register_custom_field['complemento']) ? $register_custom_field['complemento'] : ''; ?>" placeholder="<?php echo $entry_complemento; ?>" id="input-complemento" class="form-control input-complemento" />
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label" for="input-address-2"><?php echo $entry_address_2; ?></label>
									<div class="col-sm-10">
										<input type="text" name="address_2" maxlength="128" value="<?php echo $address_2; ?>" placeholder="<?php echo $entry_address_2; ?>" id="input-address-2" class="form-control input-address-2" />
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-city"><?php echo $entry_city; ?></label>
									<div class="col-sm-10">
										<input type="text" name="city" maxlength="128" value="<?php echo $city; ?>" placeholder="<?php echo $entry_city; ?>" id="input-city" class="form-control input-city" />
										<?php if ($error_city) { ?>
										<div class="text-danger"><?php echo $error_city; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-zone"><?php echo $entry_zone; ?></label>
									<div class="col-sm-10">
										<select name="zone_id" id="input-zone" class="form-control input-zone">
										</select>
										<?php if ($error_zone) { ?>
										<div class="text-danger"><?php echo $error_zone; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label" for="input-company"><?php echo $entry_company; ?></label>
									<div class="col-sm-10">
										<input type="text" name="company" maxlength="40" value="<?php echo $company; ?>" placeholder="<?php echo $entry_company; ?>" id="input-company" class="form-control input-company" />
									</div>
								</div>

								<?php foreach ($custom_fields as $custom_field) { ?>
								<?php if ($custom_field['location'] == 'address') { ?>
								<?php if ($custom_field['type'] == 'select') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<select name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control">
											<option value=""><?php echo $text_select; ?></option>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && $custom_field_value['custom_field_value_id'] == $register_custom_field[$custom_field['custom_field_id']]) { ?>
											<option value="<?php echo $custom_field_value['custom_field_value_id']; ?>" selected="selected"><?php echo $custom_field_value['name']; ?></option>
											<?php } else { ?>
											<option value="<?php echo $custom_field_value['custom_field_value_id']; ?>"><?php echo $custom_field_value['name']; ?></option>
											<?php } ?>
											<?php } ?>
										</select>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'radio') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<div class="radio">
												<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && $custom_field_value['custom_field_value_id'] == $register_custom_field[$custom_field['custom_field_id']]) { ?>
												<label>
													<input type="radio" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" checked="checked" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } else { ?>
												<label>
													<input type="radio" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } ?>
											</div>
											<?php } ?>
										</div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'checkbox') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<div class="checkbox">
												<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && in_array($custom_field_value['custom_field_value_id'], $register_custom_field[$custom_field['custom_field_id']])) { ?>
												<label>
													<input type="checkbox" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>][]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" checked="checked" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } else { ?>
												<label>
													<input type="checkbox" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>][]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } ?>
											</div>
											<?php } ?>
										</div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'text') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'textarea') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<textarea name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" rows="5" placeholder="<?php echo $custom_field['name']; ?>" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control"><?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?></textarea>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'file') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<button type="button" id="button-custom-field<?php echo $custom_field['custom_field_id']; ?>" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-default"><i class="fa fa-upload"></i> <?php echo $button_upload; ?></button>
										<input type="hidden" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : ''); ?>" />
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'date') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group date">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="YYYY-MM-DD" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'time') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group time">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="HH:mm" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'datetime') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group datetime">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php } ?>
								<?php } ?>
							</fieldset>



							<fieldset id="account">
								<legend><?php echo $text_your_details; ?></legend>

								<input type="hidden" name="custom_field[account][country_id]" class="hidden-country" value="<?php echo $country_id; ?>" />

								<div class="form-group required" style="display: <?php echo (count($customer_groups) > 1 ? 'block' : 'none'); ?>;">
									<label class="col-sm-2 control-label"><?php echo $entry_customer_group; ?></label>
									<div class="col-sm-10">
										<div id="input-customer-group">
											<?php foreach ($customer_groups as $customer_group) { ?>
											<?php if ($customer_group['customer_group_id'] == $customer_group_id || count($customer_groups) == 1) { ?>
												<label class="radio-inline">
													<input type="radio" name="customer_group_id" class="input-customer-group" value="<?php echo $customer_group['customer_group_id']; ?>" checked="checked" />
													<?php echo $customer_group['name']; ?></label>
											<?php } else { ?>
												<label class="radio-inline">
													<input type="radio" name="customer_group_id" class="input-customer-group" value="<?php echo $customer_group['customer_group_id']; ?>" />
													<?php echo $customer_group['name']; ?></label>
											<?php } ?>
											<?php } ?>
										</div>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-firstname"><?php echo $entry_firstname; ?></label>
									<div class="col-sm-10">
										<input type="text" name="firstname" maxlength="32" value="<?php echo $firstname; ?>" placeholder="<?php echo $entry_firstname; ?>" id="input-firstname" class="form-control input-firstname" />
										<?php if ($error_firstname) { ?>
										<div class="text-danger"><?php echo $error_firstname; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-lastname"><?php echo $entry_lastname; ?></label>
									<div class="col-sm-10">
										<input type="text" name="lastname" maxlength="32" value="<?php echo $lastname; ?>" placeholder="<?php echo $entry_lastname; ?>" id="input-lastname" class="form-control input-lastname" />
										<?php if ($error_lastname) { ?>
										<div class="text-danger"><?php echo $error_lastname; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-email"><?php echo $entry_email; ?></label>
									<div class="col-sm-10">
										<input type="email" name="email" value="<?php echo $email; ?>" placeholder="<?php echo $entry_email; ?>" id="input-email" class="form-control input-email" />
										<?php if ($error_email) { ?>
										<div class="text-danger"><?php echo $error_email; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-telephone"><?php echo $entry_telephone; ?></label>
									<div class="col-sm-10">
										<input type="tel" name="telephone" maxlength="32" value="<?php echo $telephone; ?>" placeholder="<?php echo $entry_telephone; ?>" id="input-telephone" class="form-control input-telephone mask-phone" />
										<?php if ($error_telephone) { ?>
										<div class="text-danger"><?php echo $error_telephone; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php if ($config_campo_celular > 0) { ?>
								<div class="form-group <?php if ($config_campo_celular == 1) { echo('required'); } ?>">
									<label class="col-sm-2 control-label" for="input-celular"><?php echo $entry_celular; ?></label>
									<div class="col-sm-10">
										<input type="tel" name="custom_field[account][celular]" maxlength="32" value="<?php echo isset($register_custom_field['celular']) ? $register_custom_field['celular'] : ''; ?>" placeholder="<?php echo $entry_celular; ?>" id="input-celular" class="form-control input-celular mask-phone" />
										<?php if (isset($error_custom_field['celular'])) { ?>
										<div class="text-danger"><?php echo $error_custom_field['celular']; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>

								<?php /* ?>
								<div class="form-group">
									<label class="col-sm-2 control-label" for="input-fax"><?php echo $entry_fax; ?></label>
									<div class="col-sm-10">
										<input type="tel" name="fax" maxlength="32" value="<?php echo $fax; ?>" placeholder="<?php echo $entry_fax; ?>" id="input-fax" class="form-control input-fax mask-phone" />
										<?php if ($error_fax) { ?>
										<div class="text-danger"><?php echo $error_fax; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php */ ?>
								<input type="hidden" name="fax" value="<?php echo $fax; ?>" />

								<?php if ($config_campo_sexo > 0) { ?>
								<div class="form-group <?php if ($config_campo_sexo == 1) { echo('required'); } ?>">
									<label class="col-sm-2 control-label"><?php echo $entry_sexo; ?></label>
									<div class="col-sm-10">
										<div id="input-sexo">
											<label class="radio-inline">
												<input type="radio" name="custom_field[account][sexo]" value="f" class="input-sexo" <?php if (isset($register_custom_field['sexo']) && $register_custom_field['sexo'] == 'f') { echo('checked'); } ?> />
												<?php echo $entry_sexo_f; ?></label>
											<label class="radio-inline">
												<input type="radio" name="custom_field[account][sexo]" value="m" class="input-sexo" <?php if (isset($register_custom_field['sexo']) && $register_custom_field['sexo'] == 'm') { echo('checked'); } ?> />
												<?php echo $entry_sexo_m; ?></label>
										</div>
										<?php if (isset($error_custom_field['sexo'])) { ?>
										<div class="text-danger"><?php echo $error_custom_field['sexo']; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($config_campo_nascimento > 0) { ?>
								<div class="form-group <?php if ($config_campo_nascimento == 1) { echo('required'); } ?>">
									<label class="col-sm-2 control-label" for="input-nascimento"><?php echo $entry_nascimento; ?></label>
									<div class="col-sm-10">
										<div class="input-group birth">
											<input type="text" inputmode="numeric" name="custom_field[account][nascimento]" value="<?php echo isset($register_custom_field['nascimento']) ? $register_custom_field['nascimento'] : ''; ?>" placeholder="<?php echo $entry_nascimento; ?>" data-date-format="YYYY-MM-DD" id="input-nascimento" class="form-control input-nascimento" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field['nascimento'])) { ?>
										<div class="text-danger"><?php echo $error_custom_field['nascimento']; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<div class="fieldset-brasil">
									<div class="form-group required" style="display: <?php echo ($config_campo_pessoa == 'fj' ? 'block' : 'none'); ?>;">
										<label class="col-sm-2 control-label"><?php echo $entry_tipo; ?></label>
										<div class="col-sm-10">
											<div id="input-tipo">
												<label class="radio-inline">
													<input type="radio" name="custom_field[account][tipo]" value="f" class="input-tipo" <?php if ($config_campo_pessoa == 'f' || (isset($register_custom_field['tipo']) && $register_custom_field['tipo'] == 'f')) { echo('checked'); } ?> />
													<?php echo $entry_tipo_fisica; ?></label>
												<label class="radio-inline">
													<input type="radio" name="custom_field[account][tipo]" value="j" class="input-tipo" <?php if ($config_campo_pessoa == 'j' || (isset($register_custom_field['tipo']) && $register_custom_field['tipo'] == 'j')) { echo('checked'); } ?> />
													<?php echo $entry_tipo_juridica; ?></label>
											</div>
											<?php if (isset($error_custom_field['tipo'])) { ?>
											<div class="text-danger"><?php echo $error_custom_field['tipo']; ?></div>
											<?php } ?>
										</div>
									</div>
									<?php if ($config_campo_pessoa == 'fj' || $config_campo_pessoa == 'f') { ?>
									<div class="fieldset-pessoa-fisica">
										<div class="form-group required">
											<label class="col-sm-2 control-label" for="input-cpf"><?php echo $entry_cpf; ?></label>
											<div class="col-sm-10">
												<input type="tel" inputmode="numeric" name="custom_field[account][cpf]" value="<?php echo isset($register_custom_field['cpf']) ? $register_custom_field['cpf'] : ''; ?>" placeholder="<?php echo $entry_cpf; ?>" id="input-cpf" class="form-control input-cpf mask-cpf" />
												<?php if (isset($error_custom_field['cpf'])) { ?>
												<div class="text-danger"><?php echo $error_custom_field['cpf']; ?></div>
												<?php } ?>
											</div>
										</div>
										<?php if ($config_campo_rg > 0) { ?>
										<div class="form-group <?php if ($config_campo_rg == 1) { echo('required'); } ?>">
											<label class="col-sm-2 control-label" for="input-rg"><?php echo $entry_rg; ?></label>
											<div class="col-sm-10">
												<input type="tel" inputmode="numeric" name="custom_field[account][rg]" maxlength="20" value="<?php echo isset($register_custom_field['rg']) ? $register_custom_field['rg'] : ''; ?>" placeholder="<?php echo $entry_rg; ?>" id="input-rg" class="form-control input-rg" />
											</div>
											<?php if (isset($error_custom_field['rg'])) { ?>
											<div class="text-danger"><?php echo $error_custom_field['rg']; ?></div>
											<?php } ?>
										</div>
										<?php } ?>
									</div>
									<?php } ?>
									<?php if ($config_campo_pessoa == 'fj' || $config_campo_pessoa == 'j') { ?>
									<div class="fieldset-pessoa-juridica">
										<div class="form-group required">
											<label class="col-sm-2 control-label" for="input-razao"><?php echo $entry_razao; ?></label>
											<div class="col-sm-10">
												<input type="text" name="custom_field[account][razao]" maxlength="64" value="<?php echo isset($register_custom_field['razao']) ? $register_custom_field['razao'] : ''; ?>" placeholder="<?php echo $entry_razao; ?>" id="input-razao" class="form-control input-razao" />
												<?php if (isset($error_custom_field['razao'])) { ?>
												<div class="text-danger"><?php echo $error_custom_field['razao']; ?></div>
												<?php } ?>
											</div>
										</div>
										<div class="form-group required">
											<label class="col-sm-2 control-label" for="input-cnpj"><?php echo $entry_cnpj; ?></label>
											<div class="col-sm-10">
												<input type="tel" inputmode="numeric" name="custom_field[account][cnpj]" value="<?php echo isset($register_custom_field['cnpj']) ? $register_custom_field['cnpj'] : ''; ?>" placeholder="<?php echo $entry_cnpj; ?>" id="input-cnpj" class="form-control input-cnpj mask-cnpj" />
												<?php if (isset($error_custom_field['cnpj'])) { ?>
												<div class="text-danger"><?php echo $error_custom_field['cnpj']; ?></div>
												<?php } ?>
											</div>
										</div>
										<?php if ($config_campo_ie > 0) { ?>
										<div class="form-group <?php if ($config_campo_ie == 1) { echo('required'); } ?>">
											<label class="col-sm-2 control-label" for="input-ie"><?php echo $entry_ie; ?></label>
											<div class="col-sm-10">
												<input type="tel" inputmode="numeric" name="custom_field[account][ie]" maxlength="20" value="<?php echo isset($register_custom_field['ie']) ? $register_custom_field['ie'] : ''; ?>" placeholder="<?php echo $entry_ie; ?>" id="input-ie" class="form-control input-ie" />
												<?php if (isset($error_custom_field['ie'])) { ?>
												<div class="text-danger"><?php echo $error_custom_field['ie']; ?></div>
												<?php } ?>
											</div>
										</div>
										<?php } ?>
										<?php if ($config_campo_im > 0) { ?>
										<div class="form-group <?php if ($config_campo_im == 1) { echo('required'); } ?>">
											<label class="col-sm-2 control-label" for="input-im"><?php echo $entry_im; ?></label>
											<div class="col-sm-10">
												<input type="tel" inputmode="numeric" name="custom_field[account][im]" maxlength="20" value="<?php echo isset($register_custom_field['im']) ? $register_custom_field['im'] : ''; ?>" placeholder="<?php echo $entry_im; ?>" id="input-im" class="form-control input-im" />
												<?php if (isset($error_custom_field['im'])) { ?>
												<div class="text-danger"><?php echo $error_custom_field['im']; ?></div>
												<?php } ?>
											</div>
										</div>
										<?php } ?>
									</div>
									<?php } ?>
								</div>

								<?php foreach ($custom_fields as $custom_field) { ?>
								<?php if ($custom_field['location'] == 'account') { ?>
								<?php if ($custom_field['type'] == 'select') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<select name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control">
											<option value=""><?php echo $text_select; ?></option>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && $custom_field_value['custom_field_value_id'] == $register_custom_field[$custom_field['custom_field_id']]) { ?>
											<option value="<?php echo $custom_field_value['custom_field_value_id']; ?>" selected="selected"><?php echo $custom_field_value['name']; ?></option>
											<?php } else { ?>
											<option value="<?php echo $custom_field_value['custom_field_value_id']; ?>"><?php echo $custom_field_value['name']; ?></option>
											<?php } ?>
											<?php } ?>
										</select>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'radio') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<div class="radio">
												<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && $custom_field_value['custom_field_value_id'] == $register_custom_field[$custom_field['custom_field_id']]) { ?>
												<label>
													<input type="radio" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" checked="checked" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } else { ?>
												<label>
													<input type="radio" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } ?>
											</div>
											<?php } ?>
										</div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'checkbox') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div>
											<?php foreach ($custom_field['custom_field_value'] as $custom_field_value) { ?>
											<div class="checkbox">
												<?php if (isset($register_custom_field[$custom_field['custom_field_id']]) && in_array($custom_field_value['custom_field_value_id'], $register_custom_field[$custom_field['custom_field_id']])) { ?>
												<label>
													<input type="checkbox" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>][]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" checked="checked" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } else { ?>
												<label>
													<input type="checkbox" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>][]" value="<?php echo $custom_field_value['custom_field_value_id']; ?>" />
													<?php echo $custom_field_value['name']; ?></label>
												<?php } ?>
											</div>
											<?php } ?>
										</div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'text') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'textarea') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<textarea name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" rows="5" placeholder="<?php echo $custom_field['name']; ?>" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control"><?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?></textarea>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'file') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<button type="button" id="button-custom-field<?php echo $custom_field['custom_field_id']; ?>" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-default"><i class="fa fa-upload"></i> <?php echo $button_upload; ?></button>
										<input type="hidden" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : ''); ?>" />
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'date') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group date">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="YYYY-MM-DD" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'time') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group time">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="HH:mm" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php if ($custom_field['type'] == 'datetime') { ?>
								<div id="custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-group custom-field" data-sort="<?php echo $custom_field['sort_order']; ?>">
									<label class="col-sm-2 control-label" for="input-custom-field<?php echo $custom_field['custom_field_id']; ?>"><?php echo $custom_field['name']; ?></label>
									<div class="col-sm-10">
										<div class="input-group datetime">
											<input type="text" name="custom_field[<?php echo $custom_field['location']; ?>][<?php echo $custom_field['custom_field_id']; ?>]" value="<?php echo (isset($register_custom_field[$custom_field['custom_field_id']]) ? $register_custom_field[$custom_field['custom_field_id']] : $custom_field['value']); ?>" placeholder="<?php echo $custom_field['name']; ?>" data-date-format="YYYY-MM-DD HH:mm" id="input-custom-field<?php echo $custom_field['custom_field_id']; ?>" class="form-control" />
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span></div>
										<?php if (isset($error_custom_field[$custom_field['custom_field_id']])) { ?>
										<div class="text-danger"><?php echo $error_custom_field[$custom_field['custom_field_id']]; ?></div>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
								<?php } ?>
								<?php } ?>
							</fieldset>



							<fieldset>
								<legend><?php echo $text_your_password; ?></legend>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-password"><?php echo $entry_password; ?></label>
									<div class="col-sm-10">
										<input type="password" name="password" value="<?php echo $password; ?>" placeholder="<?php echo $entry_password; ?>" id="input-password" class="form-control" />
										<?php if ($error_password) { ?>
										<div class="text-danger"><?php echo $error_password; ?></div>
										<?php } ?>
									</div>
								</div>
								<div class="form-group required">
									<label class="col-sm-2 control-label" for="input-confirm"><?php echo $entry_confirm; ?></label>
									<div class="col-sm-10">
										<input type="password" name="confirm" value="<?php echo $confirm; ?>" placeholder="<?php echo $entry_confirm; ?>" id="input-confirm" class="form-control" />
										<?php if ($error_confirm) { ?>
										<div class="text-danger"><?php echo $error_confirm; ?></div>
										<?php } ?>
									</div>
								</div>
							</fieldset>



							<fieldset>
								<legend><?php echo $text_newsletter; ?></legend>
								<div class="form-group">
									<label class="col-sm-2 control-label"><?php echo $entry_newsletter; ?></label>
									<div class="col-sm-10">
										<?php if ($newsletter) { ?>
										<label class="radio-inline">
											<input type="radio" name="newsletter" value="1" checked="checked" />
											<?php echo $text_yes; ?></label>
										<label class="radio-inline">
											<input type="radio" name="newsletter" value="0" />
											<?php echo $text_no; ?></label>
										<?php } else { ?>
										<label class="radio-inline">
											<input type="radio" name="newsletter" value="1" />
											<?php echo $text_yes; ?></label>
										<label class="radio-inline">
											<input type="radio" name="newsletter" value="0" checked="checked" />
											<?php echo $text_no; ?></label>
										<?php } ?>
									</div>
								</div>
							</fieldset>



							<?php if ($text_agree) { ?>
							<div class="buttons">
								<div class="pull-right"><?php echo $text_agree; ?>
									<?php if ($agree) { ?>
									<input type="checkbox" name="agree" value="1" checked="checked" />
									<?php } else { ?>
									<input type="checkbox" name="agree" value="1" />
									<?php } ?>
									&nbsp;
									<input type="submit" value="<?php echo $button_continue; ?>" class="btn btn-primary" />
								</div>
							</div>
							<?php } else { ?>
							<div class="buttons">
								<div class="pull-right">
									<input type="submit" value="<?php echo $button_continue; ?>" class="btn btn-primary" />
								</div>
							</div>
							<?php } ?>



						</form>
					</div>
				</div>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>

</div>
<script type="text/javascript"><!--
// Sort the custom fields
sortCustomFields( $('#account') );
sortCustomFields( $('#address') );

$('input[name=\'customer_group_id\']').on('change', function() {
	$.ajax({
		url: 'index.php?route=account/register/customfield&customer_group_id=' + this.value,
		dataType: 'json',
		success: function(json) {
			$('.custom-field').hide();
			$('.custom-field').removeClass('required');

			for (i = 0; i < json.length; i++) {
				custom_field = json[i];

				$('#custom-field' + custom_field['custom_field_id']).show();

				if (custom_field['required']) {
					$('#custom-field' + custom_field['custom_field_id']).addClass('required');
				}
			}


		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('input[name=\'customer_group_id\']:checked').trigger('change');
//--></script>
<script type="text/javascript"><!--
$('button[id^=\'button-custom-field\']').on('click', function() {
	var node = this;

	$('#form-upload').remove();

	$('body').prepend('<form enctype="multipart/form-data" id="form-upload" style="display: none;"><input type="file" name="file" /></form>');

	$('#form-upload input[name=\'file\']').trigger('click');

	if (typeof timer != 'undefined') {
			clearInterval(timer);
	}

	timer = setInterval(function() {
		if ($('#form-upload input[name=\'file\']').val() != '') {
			clearInterval(timer);

			$.ajax({
				url: 'index.php?route=tool/upload',
				type: 'post',
				dataType: 'json',
				data: new FormData($('#form-upload')[0]),
				cache: false,
				contentType: false,
				processData: false,
				beforeSend: function() {
					$(node).button('loading');
				},
				complete: function() {
					$(node).button('reset');
				},
				success: function(json) {
					$(node).parent().find('.text-danger').remove();

					if (json['error']) {
						$(node).parent().find('input').after('<div class="text-danger">' + json['error'] + '</div>');
					}

					if (json['success']) {
						alert(json['success']);

						$(node).parent().find('input').attr('value', json['code']);
					}
				},
				error: function(xhr, ajaxOptions, thrownError) {
					alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
				}
			});
		}
	}, 500);
});
//--></script>
<script type="text/javascript"><!--
$('select[name=\'country_id\']').on('change', function() {
	$.ajax({
		url: 'index.php?route=account/account/country&country_id=' + this.value,
		dataType: 'json',
		beforeSend: function() {
			$('select[name=\'country_id\']').after(' <i class="fa fa-circle-o-notch fa-spin"></i>');
		},
		complete: function() {
			$('.fa-spin').remove();
		},
		success: function(json) {
			if (json['postcode_required'] == '1') {
				$('input[name=\'postcode\']').parent().parent().addClass('required');
			} else {
				$('input[name=\'postcode\']').parent().parent().removeClass('required');
			}

			html = '<option value=""><?php echo $text_select; ?></option>';

			if (json['zone'] && json['zone'] != '') {
				for (i = 0; i < json['zone'].length; i++) {
					html += '<option value="' + json['zone'][i]['zone_id'] + '" data-code="' + json['zone'][i]['code'] + '"';

					if (json['zone'][i]['zone_id'] == '<?php echo $zone_id; ?>') {
						html += ' selected="selected"';
					}

					html += '>' + json['zone'][i]['name'] + '</option>';
				}
			} else {
				html += '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
			}

			$('select[name=\'zone_id\']').html(html);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('select[name=\'country_id\']').trigger('change');
//--></script>

<script src="catalog/view/javascript/jquery.maskedinput.min.js" type="text/javascript"></script>

<script type="text/javascript"><!--
initFormRegister();
//--></script>
<?php if ($postcode != '' && !isset($_REQUEST['postcode'])) { ?>
<script type="text/javascript"><!--
$('#address .input-postcode').trigger('keyup');
//--></script>
<?php } ?>
<?php echo $footer; ?>