<?php echo $header; ?>
<div class="container">

	<ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	</ul>

	<div class="row">
		<?php echo $column_left; ?>

		<?php if ($column_left && $column_right) { ?>
			<?php $class = 'col-sm-6'; ?>
		<?php } elseif ($column_left || $column_right) { ?>
			<?php $class = 'col-sm-9'; ?>
		<?php } else { ?>
			<?php $class = 'col-sm-12'; ?>
		<?php } ?>

		<div id="content" class="col-xs-12 <?php echo $class; ?>">
			<div class="row">
				<?php echo $content_top; ?>

				<div class="oc-content col-xs-12">
					<div class="oc-content-inner">

						<h1><?php echo $heading_title; ?></h1>
						<?php if ($downloads) { ?>
						<table class="table table-bordered table-hover">
							<thead>
								<tr>
									<td class="text-left"><?php echo $column_order_id; ?></td>
									<td class="text-left"><?php echo $column_date_added; ?></td>
									<td class="text-left"><?php echo $column_name; ?></td>
									<td class="text-left">Downloads</td>
									<td></td>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($downloads as $download) { extract($download); ?>
								<tr>
									<td class="text-left"><?php echo $order_id; ?></td>
									<td class="text-left"><?php echo $date_added; ?></td>
									<td class="text-left"><?php echo $name; ?><br>[<?php echo $size; ?>]</td>
									<td class="text-left">
										<?php if ($total == 0) { ?>
											<strong>NOVO!</strong> Download ainda não realizado!<br>
											Clique no botão ao lado para fazer o download.
										<?php } else { ?>
											<?php if ($max_limit > 0 && $total >= $max_limit) { ?>
												Download indisponível!<br>
												Você já alcançou o limite máximo de <?php echo ($max_limit == 1) ? '1 download' : "{$max_limit} downloads"; ?>.
											<?php } else { ?>
												Download realizado <?php echo ($total == 1) ? '1 vez' : "{$total} vezes"; ?>.<br>
												<?php echo ($max_limit == 0) ? 'Sem limite de downloads.' : "Limite de {$max_limit} downloads."; ?>
											<?php } ?>
										<?php } ?>
									</td>
									<td>
										<?php if ($max_limit > 0 && $total >= $max_limit) { ?>
											<a href="#" data-toggle="tooltip" title="Download indisponível" class="btn btn-danger btn-no-download"><i class="fa fa-cloud-download"></i></a>
										<?php } else { ?>
											<a href="<?php echo $href; ?>" data-toggle="tooltip" title="<?php echo $button_download; ?>" class="btn btn-primary btn-download"><i class="fa fa-cloud-download"></i></a>
										<?php } ?>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
						<div class="row">
							<div class="col-sm-6 text-left"><?php echo $pagination; ?></div>
							<div class="col-sm-6 text-right"><?php echo $results; ?></div>
						</div>
						<?php } else { ?>
						<p><?php echo $text_empty; ?></p>
						<?php } ?>
						<div class="buttons clearfix">
							<div class="pull-right"><a href="<?php echo $continue; ?>" class="btn btn-primary"><?php echo $button_continue; ?></a></div>
						</div>

					</div>
				</div>

				<?php echo $content_bottom; ?>
			</div>
		</div>

		<?php echo $column_right; ?>
	</div>

</div>

<script>
$(document).ready(function(){
	$('.btn-download').on('click', function(e){
		$(this).attr('desabled', 'disabled');

		setTimeout(function(){
			document.location.reload();
		}, 1000);
	});
	$('.btn-no-download').on('click', function(e){
		e.preventDefault();
		alert('Download indisponível! Você já alcançou o limite de downloads para este arquivo.');
		return false;
	});
});
</script>

<?php echo $footer; ?>