<?php
class ModelShippingPickupHdw extends Model {
	function getQuote($address) {
		$this->load->language('shipping/pickup_hdw');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('pickup_hdw_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if (!$this->config->get('pickup_hdw_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {
			$quote_data = array();

			$titulo = trim($this->config->get('pickup_hdw_title'));
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_description');

			$quote_data['pickup_hdw'] = array(
				'code'         => 'pickup_hdw.pickup_hdw',
				'title'        => $titulo,
				'cost'         => 0.00,
				'tax_class_id' => 0,
				'text'         => $this->currency->format(0.00)
			);

			$method_data = array(
				'code'       => 'pickup_hdw',
				'title'      => $this->language->get('text_title'),
				'quote'      => $quote_data,
				'sort_order' => $this->config->get('pickup_hdw_sort_order'),
				'error'      => false
			);
		}

		return $method_data;
	}
}