<?php
class ModelShippingJadlog extends Model {

	private $vCubagem = array(
		'0'  =>'6000',
		'3'  =>'3333',
		'4'  =>'3333',
		'5'  =>'3333',
		'6'  =>'3333',
		'7'  =>'6000',
		'9'  =>'6000',
		'10' =>'6000',
		'12' =>'6000',
		'14' =>'3333'
	);

	public function getQuote($address) {
		$this->load->language('shipping/free');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('jadlog_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if (!$this->config->get('jadlog_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();
		$quote_data = array();

		if ($status) {
			$cost = 0;

			//dados do carrinho e calcula as medidas
			$pais = $address['iso_code_2'];

			$titulo = $this->config->get('jadlog_nome');
			$tipos = $this->config->get('jadlog_tipos');

			$tiposFrete = array(
				'Expresso'   => 0,
				'Package'    => 3,
				'Rodoviario' => 4,
				'Economico'  => 5,
				'DOC'        => 6,
				'Corporate'  => 7,
				'.COM'       => 9,
				'Cargo'      => 12
			);

			$soapClient = new SoapClient("https://jadlog.com.br/JadlogEdiWs/services/ValorFreteBean?wsdl");

			$default = array(
				'cep_origem'  => preg_replace('/\D/', '', $this->config->get('jadlog_cep')),
				'cep_destino' => preg_replace('/\D/', '', $address['postcode']),
				'peso'        => '',
				'valor'       => number_format($this->cart->getSubTotal(), 2, ',', ''),
				'modalidade'  => '',
				'cnpj'        => trim($this->config->get('jadlog_user')),
				'password'    => trim($this->config->get('jadlog_senha')),
				'seguro'      => 'N',
				'coleta'      => number_format($this->config->get('jadlog_coleta'), 2, ',', ''),
				'acobrar'     => ($this->config->get('jadlog_frete') == 0 ? 'N' : 'S'),
				'entrega'     => ($this->config->get('jadlog_entrega') == 0 ? 'D' : 'R')
			);

			foreach ($tiposFrete as $k => $v) {
				if (!empty($tipos) && in_array($v,$tipos)) {

					$peso_cubado = $this->pesoCubado($v);
					$fator_cubagem = $this->vCubagem[$v];
					if ($fator_cubagem == '6000') {
						$prazo = $this->config->get('jadlog_prazoa');
					} else {
						$prazo = $this->config->get('jadlog_prazo');
					}

					//regra do maior peso
					$weight = $this->cart->getWeight();
					if ($weight > $peso_cubado) {
						$peso_cubado = $weight;
					}

					$default['peso'] = number_format($peso_cubado, 2, ',', '');
					$default['modalidade'] = $v;

					$consulta['vModalidade'] = $default['modalidade'];
					$consulta['Password']    = $default['password'];
					$consulta['vSeguro']     = $default['seguro'];
					$consulta['vVlDec']      = $default['valor'];
					$consulta['vVlColeta']   = $default['coleta'];
					$consulta['vCepOrig']    = $default['cep_origem'];
					$consulta['vCepDest']    = $default['cep_destino'];
					$consulta['vPeso']       = $default['peso'];
					$consulta['vFrap']       = $default['acobrar'];
					$consulta['vEntrega']    = $default['entrega'];
					$consulta['vCnpj']       = $default['cnpj'];

					try {
						$info = $soapClient->__call("valorar", array($consulta));
						$calculo = json_decode(json_encode(@simplexml_load_string($info->valorarReturn)),true);
						if (isset($calculo['Jadlog_Valor_Frete']['Retorno'])) {
							if ($calculo['Jadlog_Valor_Frete']['Retorno'] <= 0) {
								$this->log->write("Erro Jadlog {$k}: " . $calculo['Jadlog_Valor_Frete']['Mensagem']);
							} else {
								$cost = str_replace('.', '', $calculo['Jadlog_Valor_Frete']['Retorno']);
								$cost = str_replace(',', '.', $cost);
								$cost = ($cost + $this->config->get('jadlog_taxa'));

								$code = $v;
								$quote_data[$code] = array(
									'code'         => 'jadlog.' . $code,
									'title'        => "{$titulo} {$k} {$prazo}",
									'cost'         => $this->tax->calculate($cost, $this->config->get('jadlog_tax_class_id'), $this->config->get('config_tax')),
									'tax_class_id' => $this->config->get('jadlog_tax_class_id'),
									'text'         => $this->formatar($this->tax->calculate($cost, $this->config->get('jadlog_tax_class_id'), $this->config->get('config_tax')))
								);
							}
						}
					} catch (SoapFault $fault) {
						//print_r($fault->faultstring);
						$this->log->write("Erro de acesso a api jadlog, verificar se o mesmo esta online e o firewall esta com a porta 8080 liberada!");
					}
				}
			}

			//se retornou contas
			if (count($quote_data) > 0) {
				$method_data = array(
					'code'       => 'jadlog',
					'title'      => $this->config->get('jadlog_nome'),
					'quote'      => $quote_data,
					'sort_order' => $this->config->get('jadlog_sort_order'),
					'error'      => false
				);
			}
		}

		return $method_data;
	}

	public function formatar($valor){
		if (version_compare(VERSION, '2.2.0.0', '>=')) {
			return $this->currency->format($valor,$this->session->data['currency']);
		} else {
			return $this->currency->format($valor);
		}
	}

	public function pesoCubado($meio){
		$produtos = $this->cart->getProducts();
		$peso_cubico = 0;
		//faz a cubagem dos produtos
		$fator_cubagem = $this->vCubagem[$meio];
		foreach ($produtos as $prod) {
			$lar = $this->qualMedidaProduto($prod['length_class_id'], $prod['length']);
			$alt = $this->qualMedidaProduto($prod['length_class_id'], $prod['height']);
			$com = $this->qualMedidaProduto($prod['length_class_id'], $prod['width']);
			$peso_cubico += (($lar * $com * $alt) / $fator_cubagem) * $prod['quantity'];
		}
		return number_format($peso_cubico, 2, '.', '');
	}

	public function qualMedidaProduto($un,$med){
		$result = $this->db->query("SELECT * FROM " . DB_PREFIX . "length_class_description WHERE length_class_id = '" . (int)$un . "' AND language_id = '" . $this->config->get('config_language_id') . "'");
		if ($result->row['unit'] == 'mm') {
			return ($med / 10);
		} elseif ($result->row['unit'] == 'm') {
			return ($med * 100);
		} else {
			return $med;
		}
	}
}
