<?php
class ModelShippingFreteCombinar extends Model {
	function getQuote($address) {
		$this->load->language('shipping/frete_combinar');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('frete_combinar_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if (!$this->config->get('frete_combinar_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {
			$quote_data = array();

			$titulo = trim($this->config->get('frete_combinar_title'));
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_description');

			$quote_data['frete_combinar'] = array(
				'code'         => 'frete_combinar.frete_combinar',
				'title'        => $titulo,
				'cost'         => 0.00,
				'tax_class_id' => 0,
				'text'         => 'A combinar'
			);

			$method_data = array(
				'code'       => 'frete_combinar',
				'title'      => $this->language->get('text_title'),
				'quote'      => $quote_data,
				'sort_order' => $this->config->get('frete_combinar_sort_order'),
				'error'      => false
			);
		}

		return $method_data;
	}
}