<?php
class ModelShippingFreeHdw extends Model {
	function getQuote($address) {
		$status = TRUE;

		// requer idioma portugues
		$query = $this->db->query("SELECT language_id FROM " . DB_PREFIX . "language WHERE directory = 'portuguese-br'");
		if ($query->num_rows) {
			$id_idioma_portugues = $query->row['language_id'];
		} else {
			$status = FALSE;
		}

		// requer unidade de peso kg
		$query = $this->db->query("SELECT weight_class_id FROM " . DB_PREFIX . "weight_class_description WHERE unit = 'kg' AND language_id = '" . (int)$id_idioma_portugues . "'");
		if ($query->num_rows) {
			$id_peso_kilogramas = $query->row['weight_class_id'];
		} else {
			$status = FALSE;
		}

		$quote_data = array();

		if ($status) {
			$this->load->language('shipping/free_hdw');

			$free_hdw_zones = $this->config->get('free_hdw_zone');
			$free_hdw_zones = is_array($free_hdw_zones) ? $free_hdw_zones : array();

			$cart_subtotal = floatval($this->cart->getSubTotal());

			$cart_weight = floatval($this->cart->getWeight());
			$cart_weight = $this->weight->convert($cart_weight, $this->config->get('config_weight_class_id'), $id_peso_kilogramas);

			$language_id = $this->config->get('config_language_id');

			foreach ($free_hdw_zones as $key => $zone) {
				if ($zone['status'] == 0) {
					continue;
				}

				$total = floatval($zone['total']);

				if ($cart_subtotal < $total) {
					continue;
				}

				$weight = isset($zone['weight']) ? floatval($zone['weight']) : 0;

				if ($weight > 0 && $cart_weight > $weight) {
					continue;
				}

				$cep_inicial = intval( preg_replace('/[^0-9]/i', '', $zone['cep_inicial']) );
				$cep_final = intval( preg_replace('/[^0-9]/i', '', $zone['cep_final']) );
				$postcode = intval( preg_replace('/[^0-9]/i', '', $address['postcode']) );

				if ($cep_inicial != '' && $postcode < $cep_inicial) {
					continue;
				}

				if ($cep_final != '' && $postcode > $cep_final) {
					continue;
				}

				if ($zone['geo_zone_id'] > 0) {
					$query = $this->db->query("SELECT *
						FROM
							" . DB_PREFIX . "zone_to_geo_zone
						WHERE
							geo_zone_id = '" . (int)$zone['geo_zone_id'] . "' AND
							country_id = '" . (int)$address['country_id'] . "' AND
							(zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')
					");

					if (!$query->num_rows) {
						continue;
					}
				}

				if (isset($zone['customer_group_id']) && $zone['customer_group_id'] > 0) {
					if ($zone['customer_group_id'] != $this->config->get('config_customer_group_id')) {
						continue;
					}

					$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$zone['customer_group_id'] . "'");

					if (!$query->num_rows) {
						continue;
					}
				}

				$titulo = isset($zone['titulo'][$language_id]) ? trim($zone['titulo'][$language_id]) : '';
				$titulo = ($titulo != '') ? $titulo : $this->language->get('text_description');

				$quote_data['free_hdw_' . $key] = array(
					'code'         => 'free_hdw.free_hdw_' . $key,
					'title'        => $titulo,
					'cost'         => 0.00,
					'tax_class_id' => 0,
					'text'         => $this->currency->format(0.00)
				);

				break;

			} // foreach
		}

		$method_data = array();

		if ($quote_data) {
			$method_data = array(
				'code'       => 'free_hdw',
				'title'      => $this->language->get('text_title'),
				'quote'      => $quote_data,
				'sort_order' => $this->config->get('free_hdw_sort_order'),
				'error'      => false
			);
		}

		return $method_data;
	}
}