<?php

class ModelPaymentPagseguroEft extends Model {

	public function getMethod($address, $total) {
		$this->load->language('payment/pagseguro_eft');

		$pagseguro_minimo = floatval($this->config->get('pagseguro_eft_minimo'));
		$pagseguro_maximo = floatval($this->config->get('pagseguro_eft_maximo'));
		$round_total = round($total,2);

		if ($pagseguro_minimo > 0 && $round_total < $pagseguro_minimo) {
			$status = false;
		} elseif ($pagseguro_maximo > 0 && $round_total > $pagseguro_maximo) {
			$status = false;
		} elseif (!$this->config->get('pagseguro_eft_geo_zone_id')) {
			$status = true;
		} else {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int) $this->config->get('pagseguro_eft_geo_zone_id') . "' AND country_id = '" . (int) $address['country_id'] . "' AND (zone_id = '" . (int) $address['zone_id'] . "' OR zone_id = '0')");
			if ($query->num_rows) {
				$status = true;
			} else {
				$status = false;
			}
		}

		$method_data = array();

		if ($status) {
			$language_id = $this->config->get('config_language_id');

			$titulo = $this->config->has('pagseguro_eft_title') ? $this->config->get('pagseguro_eft_title') : array();
			$titulo = isset($titulo[$language_id]) ? trim($titulo[$language_id]) : '';
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_title');

			$method_data = array(
				'code'       => 'pagseguro_eft',
				'title'      => html_entity_decode($titulo, ENT_NOQUOTES, 'utf-8'),
				'terms'      => '',
				'sort_order' => $this->config->get('pagseguro_eft_sort_order')
			);
		}

		return $method_data;
	}

	public function addPaymentLink($order_id, $payment_link){
		$this->db->query("INSERT INTO " . DB_PREFIX . "order_pagseguro SET paymentLink = '" . $payment_link . "' , order_id = '" . (int)$order_id . "'");
	}

	public function getPaymentLink($order_id){
		$order = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_pagseguro WHERE order_id = '" . (int)$order_id . "'");

		if ($order->num_rows) {
			return $order->row['paymentLink'];
		} else {
			return '';
		}
	}

}
