<?php

class ModelPaymentPagseguro extends Model {

	public function getMethod($address, $total) {
		$this->load->language('payment/pagseguro');

		$pagseguro_minimo = floatval($this->config->get('pagseguro_minimo'));
		$pagseguro_maximo = floatval($this->config->get('pagseguro_maximo'));
		$round_total = round($total,2);

		if ($pagseguro_minimo > 0 && $round_total < $pagseguro_minimo) {
			$status = false;
		} elseif ($pagseguro_maximo > 0 && $round_total > $pagseguro_maximo) {
			$status = false;
		} elseif (!$this->config->get('pagseguro_geo_zone_id')) {
			$status = true;
		} else {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('pagseguro_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
			if ($query->num_rows) {
				$status = true;
			} else {
				$status = false;
			}
		}

		$method_data = array();

		if ($status) {
			$language_id = $this->config->get('config_language_id');

			$titulo = $this->config->has('pagseguro_title') ? $this->config->get('pagseguro_title') : array();
			$titulo = isset($titulo[$language_id]) ? trim($titulo[$language_id]) : '';
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_title');

			$method_data = array(
				'code'       => 'pagseguro',
				'title'      => html_entity_decode($titulo, ENT_NOQUOTES, 'utf-8'),
				'terms'      => '',
				'sort_order' => $this->config->get('pagseguro_sort_order')
			);
		}

		return $method_data;
	}

}
