<?php
class ModelPaymentMoip extends Model {
	public function getMethod($address, $total) {
		return array();
	}

	public function captureToken($data) {
		//Verifica se está em modo de teste
		if (!$this->config->get('moip_modo_teste')) {
			$action = 'https://www.moip.com.br/ws/alpha/EnviarInstrucao/Unica';
		} else {
			$action = 'https://desenvolvedor.moip.com.br/sandbox/ws/alpha/EnviarInstrucao/Unica';
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		$logo = $server . 'image/' . $this->config->get('config_logo');

		// Inicia cURL
		$ch = curl_init();

		$header[] = "Authorization: Basic " . base64_encode($this->config->get('moip_token').':'.$this->config->get('moip_key'));

		$razao_pagamento = $this->mySubstr('Pedido nº '. $data['order_id'] .' - '. $this->config->get('config_name'), 0, 250);

		$customer_name = trim(trim($data['firstname']) .' '. trim($data['lastname']));
		$customer_name = preg_replace('/\s+/', ' ', $customer_name);
		$customer_name = $this->mySubstr($customer_name, 0, 65);

		$customer_email = $this->mySubstr(trim($data['email']), 0, 64);

		$customer_telephone = $this->mySubstr(preg_replace('/[^0-9]/', '', $data['telephone']), 0, 13);

		$pessoa = isset($data['custom_field']['tipo'])  ? $data['custom_field']['tipo']  : 'f';
		$razao  = isset($data['custom_field']['razao']) ? $data['custom_field']['razao'] : '';
		$cpf    = isset($data['custom_field']['cpf'])   ? $data['custom_field']['cpf']   : '';
		$cnpj   = isset($data['custom_field']['cnpj'])  ? $data['custom_field']['cnpj']  : '';

		$documento = $this->mySubstr(($pessoa == 'f' ? $cpf : $cnpj), 0, 18);

		$payment_numero      = isset($data['payment_custom_field']['numero'])      ? $data['payment_custom_field']['numero']      : '';
		$payment_complemento = isset($data['payment_custom_field']['complemento']) ? $data['payment_custom_field']['complemento'] : '';

		$payment_address_1   = $this->mySubstr($data['payment_address_1'], 0, 65);
		$payment_numero      = $this->mySubstr($payment_numero, 0, 12);
		$payment_complemento = $this->mySubstr($payment_complemento, 0, 65);
		$payment_address_2   = $this->mySubstr($data['payment_address_2'], 0, 65); // bairro
		$payment_city        = $this->mySubstr($data['payment_city'], 0, 32);
		$payment_zone        = $data['payment_zone_code'];
		$payment_postcode    = preg_replace('/[^0-9]/', '', $data['payment_postcode']);

		$moip_boleto_instrucao_1 = $this->mySubstr($this->config->get('moip_boleto_instrucao_1'), 0, 63);
		$moip_boleto_instrucao_2 = $this->mySubstr($this->config->get('moip_boleto_instrucao_2'), 0, 63);
		$moip_boleto_instrucao_3 = $this->mySubstr($this->config->get('moip_boleto_instrucao_3'), 0, 63);

		$postfields = '
<EnviarInstrucao>
	<InstrucaoUnica TipoValidacao="Transparente">
		<Razao>' . $razao_pagamento . '</Razao>
		<Valores>
			<Valor moeda="BRL">' . $data['amount'] . '</Valor>
		</Valores>
		<IdProprio>' . $data['order_id'] . '</IdProprio>
		<Pagador>
			<Nome>' . $customer_name . '</Nome>
			<Identidade>' . $documento . '</Identidade>
			<Email>' . $customer_email . '</Email>
			<IdPagador>' . $data['customer_id'] . '</IdPagador>
			<EnderecoCobranca>
				<Logradouro>' . $payment_address_1 . '</Logradouro>
				<Numero>' . $payment_numero . '</Numero>
				<Complemento>' . $payment_complemento . '</Complemento>
				<Bairro>' . $payment_address_2 . '</Bairro>
				<Cidade>' . $payment_city . '</Cidade>
				<Estado>' . $payment_zone . '</Estado>
				<CEP>' . $payment_postcode . '</CEP>
				<Pais>BRA</Pais>
				<TelefoneFixo>' . $customer_telephone . '</TelefoneFixo>
			</EnderecoCobranca>
		</Pagador>
		<Boleto>
			<DiasExpiracao Tipo="Corridos">' . $this->config->get('moip_boleto_vencimento') . '</DiasExpiracao>
			<Instrucao1>' . $moip_boleto_instrucao_1 . '</Instrucao1>
			<Instrucao2>' . $moip_boleto_instrucao_2 . '</Instrucao2>
			<Instrucao3>' . $moip_boleto_instrucao_3 . '</Instrucao3>
			<URLLogo>' . $logo . '</URLLogo>
		</Boleto>
		'. $this->mensagens($data) .'
		'. $this->parcelas() .'
	</InstrucaoUnica>
</EnviarInstrucao>
';

		// Seta opçoes e parâmetro
		$options = array(
			CURLOPT_URL            => $action,
			CURLOPT_HTTPHEADER     => $header,
			CURLOPT_POST           => true,
			CURLOPT_POSTFIELDS     => $postfields,
			CURLOPT_RETURNTRANSFER => true,
			// CURLOPT_SSL_VERIFYPEER => false,
			// CURLOPT_SSLVERSION     => 1
			CURLOPT_SSLVERSION     => CURL_SSLVERSION_TLSv1_2
		);
		curl_setopt_array($ch, $options);

		// Executa cURL
		$response = curl_exec($ch);
		$curl_info = curl_getinfo($ch);
		$curl_error = curl_error($ch);

		// Fecha coneçao cURL
		curl_close($ch);

		// Transforma string em elemento XML
		$xml = simplexml_load_string($response);

		if ($this->config->get('moip_debug')) {
			if (file_exists(DIR_LOGS . 'moip.log')) {
				unlink(DIR_LOGS . 'moip.log');
			}

			$response = $response === false ? 'false' : $response;

			$logs = new Log('moip.log');
			$logs->write('POST: '.html_entity_decode($postfields));
			$logs->write('RESPOSTA: '.html_entity_decode($response));

			if (is_array($curl_info)) {
				$logs->write("CURL_INFO:\n".html_entity_decode(print_r($curl_info, true)));
			} else {
				$logs->write(html_entity_decode($curl_info));
			}

			$logs->write(html_entity_decode($curl_error));
		}

		if ($xml === false) {
			return $curl_error;
		}

		// Acessa XML e pega "Token de Pagamento"
		if (isset($xml->Resposta->Erro)) {
			return $xml->Resposta->Erro;
		} else {
			return $xml->Resposta->Token;
		}
	}

	public function mensagens($data) {
		$msgs = array();
		$msgs[] = 'Ref. pedido nº '. $data['order_id'] .' efetuado em '. date('d/m/Y \à\s H:i', strtotime($data['date_added'])) .'.';

		/* Produtos */
		foreach ($this->cart->getProducts() as $product) {
			$options_names = array();
			foreach ($product['option'] as $option) {
				if (in_array($option['type'], array('select','radio','checkbox','image'))) {
					$options_names[] = $option['value'];
				}
			}
			$options_names = implode('/', $options_names);
			if ($options_names) { $options_names = " ({$options_names})"; }

			$msgs[] = $product['quantity'] .'x ' . $product['name'] . $options_names;
		}

		$mensagens = '<Mensagens>'."\n";
		foreach ($msgs as $msg) {
			$mensagens .= '			<Mensagem>'. $this->mySubstr($msg, 0, 256) .'</Mensagem>'."\n";
		}
		$mensagens .= '		';
		$mensagens .= '</Mensagens>';

		return $mensagens;
	}

	public function parcelas() {
		$parcelas = $this->config->get('moip_parcela');

		$parcelamento  = '';

		if (!empty($parcelas) && is_array($parcelas)) {
			$parcelamento .= '<Parcelamentos>'."\n";

			foreach ($parcelas as $parcela) {
				$parcelamento .= '			<Parcelamento>'."\n";
				$parcelamento .= '				<MinimoParcelas>' . $parcela['de'] . '</MinimoParcelas>'."\n";
				$parcelamento .= '				<MaximoParcelas>' . $parcela['para'] . '</MaximoParcelas>'."\n";
				$parcelamento .= '				<Juros>' . $parcela['juros'] . '</Juros>'."\n";
				// $parcelamento .= '				<Recebimento>AVista</Recebimento>'."\n"; // AVista ou Parcelado
				// $parcelamento .= '				<Repassar>true</Repassar>'."\n"; // true ou false
				$parcelamento .= '			</Parcelamento>'."\n";
			}

			$parcelamento .= '		';
			$parcelamento .= '</Parcelamentos>';
		}

		return $parcelamento;
	}

	public function nasp($order_id, $order_status_id, $comment = '', $notify = false) {
		$this->load->model('checkout/order');
		$this->model_checkout_order->addOrderHistory($order_id, $order_status_id, $comment, $notify);
	}

	// private function removeAcentos($text) {
	// 	$acentos = array('Á','À','Â','Ã','É','Ê','Í','Ó','Ô','Õ','Ú','Ç','á','à','â','ã','é','ê','í','ó','ô','õ','ú','ç','æ');
	// 	$sAcentos = array('A','A','A','A','E','E','I','O','O','O','U','C','a','a','a','a','e','e','i','o','o','o','u','c','AE');

	// 	return str_replace($acentos, $sAcentos, $text);
	// }

	private function mySubstr($string, $start = 0, $limit = 10) {
		if (function_exists("mb_substr")) {
			$string = mb_substr($string, $start, $limit, 'UTF-8');
		} else {
			$string = utf8_encode(substr(utf8_decode($string), $start, $limit));
		}

		return $string;
	}

}