<?php
class ModelPaymentCombinar4 extends Model {
	public function getMethod($address, $total) {
		$this->load->language('payment/combinar4');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('combinar4_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if ($this->config->get('combinar4_total') > 0 && $this->config->get('combinar4_total') > round($total,2)) {
			$status = false;
		} elseif (!$this->config->get('combinar4_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {
			$language_id = $this->config->get('config_language_id');

			$titulo = $this->config->has('combinar4_title') ? $this->config->get('combinar4_title') : array();
			$titulo = isset($titulo[$language_id]) ? trim($titulo[$language_id]) : '';
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_title');

			$method_data = array(
				'code'       => 'combinar4',
				'title'      => $titulo,
				'terms'      => '',
				'sort_order' => $this->config->get('combinar4_sort_order')
			);
		}

		return $method_data;
	}
}