<?php
class ModelPaymentCieloSi extends Model {
  	public function getMethod($address, $total) {
		$this->load->language('payment/cielo_si');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('cielo_si_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if ($this->config->get('cielo_si_total') > round($total,2)) {
			$status = false;
		} elseif (!$this->config->get('cielo_si_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {
			$language_id = $this->config->get('config_language_id');

			$titulo = $this->config->has('cielo_si_title') ? $this->config->get('cielo_si_title') : array();
			$titulo = isset($titulo[$language_id]) ? trim($titulo[$language_id]) : '';
			$titulo = ($titulo != '') ? $titulo : $this->language->get('text_title');

      		$method_data = array(
				'code'       => 'cielo_si',
				'title'      => $titulo,
				'terms'      => '',
				'sort_order' => $this->config->get('cielo_si_sort_order')
      		);
    	}

    	return $method_data;
  	}
}