<?php
class ModelModuleExibirParcelamento extends Model {
	// public function exibirParcelamentoProduto($config, $preco) {
	// 	$retorno = array();

	// 	if (!is_array($config) || count($config) == 0) {
	// 		return $retorno;
	// 	}

	// 	extract($config);

	// 	if (!isset($parcelamentos) || !is_array($parcelamentos) || count($parcelamentos) == 0) {
	// 		return $retorno;
	// 	}

	// 	foreach($parcelamentos as $parcelamento){
	// 		extract($parcelamento);

	// 		if ($descricao_tabela == '') { continue; }
	// 		if ($texto_link == '') { continue; }

	// 		$preco_numero = intval( preg_replace('/[^0-9]/', '', $preco) ) / $currency_divisor;

	// 		$valor_minimo = $this->currency->convert($minimo, $currency_code_default, $currency_code_user);
	// 		if ($preco_numero < $valor_minimo) { continue; }

	// 		$parcela_minima = $this->currency->convert($parcela_minima, $currency_code_default, $currency_code_user);
	// 		if ($preco_numero < $parcela_minima) { continue; }

	// 		$parcelas = array();

	// 		$parcelas[1] = $preco_numero;
	// 		$resumo_parcela = 1;

	// 		for ($p = 2; $p <= $maximo_parcelas; $p++) {

	// 			// Se a parcela tiver juros
	// 			if ($p > $parcelas_sem_juros) {
	// 				$num_p = $p - $parcelas_sem_juros;

	// 				if ($tipo_juros == 2) {
	// 					$valor_parcela = $this->calcularJurosBacen($preco_numero, $juros, $p);
	// 				} elseif ($tipo_juros == 1) {
	// 					$valor_parcela = $this->calcularJurosComposto($preco_numero, $juros, $p);
	// 				} else {
	// 					$valor_parcela = $this->calcularJurosSimples($preco_numero, $juros, $p);
	// 				}

	// 				$valor_parcela = $valor_parcela / $p;

	// 			// Se a parcela nao tiver juros
	// 			} else {
	// 				$valor_parcela = $preco_numero / $p;

	// 			}

	// 			// Verifica se é maior que a parcela minima
	// 			if ($valor_parcela < $parcela_minima) {
	// 				break;
	// 			}

	// 			if ($resumo_sem_juros) {
	// 				if ($p <= $parcelas_sem_juros) {
	// 					$resumo_parcela = $p;
	// 				}
	// 			} else {
	// 				$resumo_parcela = $p;
	// 			}

	// 			$parcelas[$p] = $valor_parcela;
	// 		}

	// 		$total_parcelas = count($parcelas);

	// 		if ($total_parcelas > 1) {

	// 			$numero_de_vezes = $resumo_parcela;
	// 			$valor_da_parcela = $parcelas[$resumo_parcela];
	// 			$valor_total = $valor_da_parcela * $numero_de_vezes;

	// 			if ($resumo_parcela <= $parcelas_sem_juros) {
	// 				$descricao_juros = $texto_sem_juros;
	// 			} else {
	// 				$descricao_juros = $texto_com_juros;
	// 			}

	// 			$numero_de_vezes  = '<span class="parcelamento-parcelas">'. $numero_de_vezes .'x</span>';
	// 			$valor_da_parcela = '<span class="parcelamento-valor">'. $this->currency->format($valor_da_parcela) .'</span>';
	// 			$descricao_juros  = '<span class="parcelamento-juros">'. $descricao_juros .'</span>';
	// 			$valor_total      = '<span class="parcelamento-total">'. $this->currency->format($valor_total) .'</span>';

	// 			$_descricao_titulo = $descricao_titulo;
	// 			$_descricao_titulo = str_replace('{{numero_de_vezes}}', $numero_de_vezes, $_descricao_titulo);
	// 			$_descricao_titulo = str_replace('{{valor_da_parcela}}', $valor_da_parcela, $_descricao_titulo);
	// 			$_descricao_titulo = str_replace('{{descricao_juros}}', $descricao_juros, $_descricao_titulo);
	// 			$_descricao_titulo = str_replace('{{valor_total}}', $valor_total, $_descricao_titulo);

	// 			$parcelamento = array();
	// 			foreach ($parcelas as $parcela => $valor) {
	// 				$numero_de_vezes = $parcela;
	// 				$valor_da_parcela = $valor;
	// 				$valor_total = $valor_da_parcela * $numero_de_vezes;

	// 				if ($parcela == 1) {
	// 					$descricao_juros = $texto_a_vista;
	// 				} elseif($parcela <= $parcelas_sem_juros) {
	// 					$descricao_juros = $texto_sem_juros;
	// 				} else {
	// 					$descricao_juros = $texto_com_juros;
	// 				}

	// 				$numero_de_vezes  = '<span class="parcelamento-parcelas">'. $numero_de_vezes .'x</span>';
	// 				$valor_da_parcela = '<span class="parcelamento-valor">'. $this->currency->format($valor_da_parcela) .'</span>';
	// 				$descricao_juros  = '<span class="parcelamento-juros">'. $descricao_juros .'</span>';
	// 				$valor_total      = '<span class="parcelamento-total">'. $this->currency->format($valor_total) .'</span>';

	// 				$_descricao_tabela = $descricao_tabela;
	// 				$_descricao_tabela = str_replace('{{numero_de_vezes}}', $numero_de_vezes, $_descricao_tabela);
	// 				$_descricao_tabela = str_replace('{{valor_da_parcela}}', $valor_da_parcela, $_descricao_tabela);
	// 				$_descricao_tabela = str_replace('{{descricao_juros}}', $descricao_juros, $_descricao_tabela);
	// 				$_descricao_tabela = str_replace('{{valor_total}}', $valor_total, $_descricao_tabela);

	// 				$parcelamento[] = $_descricao_tabela;
	// 			}

	// 			$_texto_juros = '';
	// 			if ($parcelas_sem_juros < $maximo_parcelas) {
	// 				$taxa_de_juros = number_format($juros, 2, ',', '.') . '%';

	// 				$_texto_juros = $texto_juros;
	// 				$_texto_juros = str_replace('{{taxa_de_juros}}', $taxa_de_juros, $_texto_juros);
	// 			}

	// 			$_texto_parcela_minima = '';
	// 			if ($parcela_minima > 0) {
	// 				$parcela_minima2 = $this->currency->format($parcela_minima);

	// 				$_texto_parcela_minima = $texto_parcela_minima;
	// 				$_texto_parcela_minima = str_replace('{{parcela_minima}}', $parcela_minima2, $_texto_parcela_minima);
	// 			}

	// 			$retorno[] = array(
	// 				'descricao_titulo'     => $_descricao_titulo,
	// 				'texto_link'           => $texto_link,
	// 				'titulo_tabela'        => $titulo_tabela,
	// 				'parcelas'             => $parcelamento,
	// 				'texto_juros'          => $_texto_juros,
	// 				'texto_parcela_minima' => $_texto_parcela_minima,
	// 				'texto_observacoes'    => $texto_observacoes
	// 			);
	// 		}
	// 	}

	// 	return $retorno;
	// }

	public function exibirParcelamentoListagem($config, $preco) {
		$retorno = array();

		if (!is_array($config) || count($config) == 0) {
			return $retorno;
		}

		extract($config);

		if (!isset($parcelamentos) || !is_array($parcelamentos) || count($parcelamentos) == 0) {
			return $retorno;
		}

		foreach($parcelamentos as $parcelamento){
			extract($parcelamento);

			if ($listagem != '1') { continue; }
			if ($descricao_lista == ''){ continue; }

			$preco_numero = intval( preg_replace('/[^0-9]/', '', $preco) ) / $currency_divisor;

			$valor_minimo = $this->currency->convert($minimo, $currency_code_default, $currency_code_user);
			if ($preco_numero < $valor_minimo) { continue; }

			$parcela_minima = $this->currency->convert($parcela_minima, $currency_code_default, $currency_code_user);
			if ($preco_numero < $parcela_minima) { continue; }

			$valor_parcela = 0;
			$total_parcelas = 0;

			if ($resumo_sem_juros) {
				$maximo_parcelas = $parcelas_sem_juros;
			}

			for ($p = $maximo_parcelas; $p >= 2; $p--) {

				// Se a parcela tiver juros
				if ($p > $parcelas_sem_juros) {
					$num_p = $p - $parcelas_sem_juros;

					if ($tipo_juros == 2) {
						$valor_parcela = $this->calcularJurosBacen($preco_numero, $juros, $p);
					} elseif ($tipo_juros == 1) {
						$valor_parcela = $this->calcularJurosComposto($preco_numero, $juros, $p);
					} else {
						$valor_parcela = $this->calcularJurosSimples($preco_numero, $juros, $p);
					}

					$valor_parcela = $valor_parcela / $p;

				// Se a parcela nao tiver juros
				} else {
					$valor_parcela = $preco_numero / $p;

				}

				// Verifica se é maior que a parcela minima
				if ($valor_parcela >= $parcela_minima) {
					$total_parcelas = $p;
					break;
				}
			}

			if ($total_parcelas > 1) {
				$numero_de_vezes = $total_parcelas;
				$valor_da_parcela = $this->currency->format($valor_parcela);
				$valor_total = $this->currency->format($valor_parcela * $numero_de_vezes);

				if ($total_parcelas <= $parcelas_sem_juros) {
					$descricao_juros = $texto_sem_juros;
				} else {
					$descricao_juros = $texto_com_juros;
				}

				$numero_de_vezes  = '<span class="parcelamento-parcelas">'. $numero_de_vezes .'x</span>';
				$valor_da_parcela = '<span class="parcelamento-valor">'. $valor_da_parcela .'</span>';
				$descricao_juros  = '<span class="parcelamento-juros">'. $descricao_juros .'</span>';
				$valor_total      = '<span class="parcelamento-total">'. $valor_total .'</span>';

				$_descricao_lista = $descricao_lista;
				$_descricao_lista = str_replace('{{numero_de_vezes}}', $numero_de_vezes, $_descricao_lista);
				$_descricao_lista = str_replace('{{valor_da_parcela}}', $valor_da_parcela, $_descricao_lista);
				$_descricao_lista = str_replace('{{descricao_juros}}', $descricao_juros, $_descricao_lista);
				$_descricao_lista = str_replace('{{valor_total}}', $valor_total, $_descricao_lista);

				$retorno[] = $_descricao_lista;
			}
		}

		return $retorno;
	}

	public function getParcelamentoConfig() {
		$parcelamentos = $this->config->get('exibir_parcelamento_config');

		if(!is_array($parcelamentos)){
			return array();
		}

		$config_language_id = $this->config->get('config_language_id');

		$tmp = array();
		$sort_order = array();

		foreach($parcelamentos as $parcelamento){
			if(!isset($parcelamento['status']) || $parcelamento['status'] == '0'){ continue; }
			if(!isset($parcelamento['minimo']) || !is_numeric($parcelamento['minimo'])){ continue; }
			if(!isset($parcelamento['maximo_parcelas']) || !is_numeric($parcelamento['maximo_parcelas']) || $parcelamento['maximo_parcelas'] <= 1){ continue; }
			if(!isset($parcelamento['parcelas_sem_juros']) || !is_numeric($parcelamento['parcelas_sem_juros']) || $parcelamento['parcelas_sem_juros'] <= 0){ continue; }
			if(!isset($parcelamento['juros']) || !is_numeric($parcelamento['juros']) || $parcelamento['juros'] < 0){ continue; }
			if(!isset($parcelamento['tipo_juros']) || !in_array($parcelamento['tipo_juros'], array(0,1,2)) ){ continue; }
			if(!isset($parcelamento['parcela_minima']) || !is_numeric($parcelamento['parcela_minima'])){ continue; }

			$parcelamento['texto_a_vista']   = isset($parcelamento['texto_a_vista'][$config_language_id]) ? trim($parcelamento['texto_a_vista'][$config_language_id]) : '';
			$parcelamento['texto_sem_juros'] = isset($parcelamento['texto_sem_juros'][$config_language_id]) ? trim($parcelamento['texto_sem_juros'][$config_language_id]) : '';
			$parcelamento['texto_com_juros'] = isset($parcelamento['texto_com_juros'][$config_language_id]) ? trim($parcelamento['texto_com_juros'][$config_language_id]) : '';

			if($parcelamento['texto_a_vista'] == ''){ continue; }
			if($parcelamento['texto_sem_juros'] == ''){ continue; }
			if($parcelamento['texto_com_juros'] == ''){ continue; }

			if ($parcelamento['juros'] <= 0) {
				$parcelamento['parcelas_sem_juros'] = $parcelamento['maximo_parcelas'];
			}

			if(!isset($parcelamento['sort_order']) || !is_numeric($parcelamento['sort_order'])){ $parcelamento['sort_order'] = 0; }

			$parcelamento['descricao_lista']      = isset($parcelamento['descricao_lista'][$config_language_id]) ? trim($parcelamento['descricao_lista'][$config_language_id]) : '';
			$parcelamento['descricao_titulo']     = isset($parcelamento['descricao_titulo'][$config_language_id]) ? trim($parcelamento['descricao_titulo'][$config_language_id]) : '';
			$parcelamento['texto_link']           = isset($parcelamento['texto_link'][$config_language_id]) ? trim($parcelamento['texto_link'][$config_language_id]) : '';
			$parcelamento['titulo_tabela']        = isset($parcelamento['titulo_tabela'][$config_language_id]) ? trim($parcelamento['titulo_tabela'][$config_language_id]) : '';
			$parcelamento['descricao_tabela']     = isset($parcelamento['descricao_tabela'][$config_language_id]) ? trim($parcelamento['descricao_tabela'][$config_language_id]) : '';
			$parcelamento['texto_juros']          = isset($parcelamento['texto_juros'][$config_language_id]) ? trim($parcelamento['texto_juros'][$config_language_id]) : '';
			$parcelamento['texto_parcela_minima'] = isset($parcelamento['texto_parcela_minima'][$config_language_id]) ? trim($parcelamento['texto_parcela_minima'][$config_language_id]) : '';
			$parcelamento['texto_observacoes']    = isset($parcelamento['texto_observacoes'][$config_language_id]) ? trim($parcelamento['texto_observacoes'][$config_language_id]) : '';

			$tmp[] = $parcelamento;
			$sort_order[] = $parcelamento['sort_order'];
		}

		$parcelamentos = $tmp;

		if (count($parcelamentos) > 1) {
			array_multisort($sort_order, SORT_ASC, $parcelamentos);
		}

		if ($parcelamentos) {
			$tmp = array();
			$tmp['parcelamentos'] = $parcelamentos;
			$tmp['currency_code_default'] = $this->config->get('config_currency');
			$tmp['currency_code_user'] = $this->currency->getCode();
			$tmp['currency_divisor'] = '1' . str_repeat('0', $this->currency->getDecimalPlace());
			$parcelamentos = $tmp;
		}

		// print_r($parcelamentos);exit;
		return $parcelamentos;
	}

	public function calcularJurosSimples($valor_a_parcelar, $taxa_de_juros, $numero_de_parcelas) {
		$taxa_de_juros = $taxa_de_juros / 100;
		return $valor_a_parcelar * (1 + $taxa_de_juros * $numero_de_parcelas);
	}

	public function calcularJurosComposto($valor_a_parcelar, $taxa_de_juros, $numero_de_parcelas) {
		$taxa_de_juros = $taxa_de_juros / 100;
		return $valor_a_parcelar * pow((1 + $taxa_de_juros), $numero_de_parcelas);
	}

	public function calcularJurosBacen($valor_a_parcelar, $taxa_de_juros, $numero_de_parcelas) {
		// Utilizando a metodologia (formula) do Banco Central (tabela Price) disponivel em:
		// https://www3.bcb.gov.br/CALCIDADAO/publico/exibirMetodologiaFinanciamentoPrestacoesFixas.do?method=exibirMetodologiaFinanciamentoPrestacoesFixas
		// Desenvolvido por Eric Mariano Endo - Hotel da WEB
		$taxa_de_juros = $taxa_de_juros / 100;
		$valor_da_parcela = ($valor_a_parcelar * $taxa_de_juros) / (1 - pow((1 + $taxa_de_juros), -$numero_de_parcelas));
		return $valor_da_parcela * $numero_de_parcelas;
	}
}