<?php
class ModelModuleExibirDescontos extends Model {
	// public function exibirDescontosProduto($config, $preco) {
	// 	$retorno = array();

	// 	if (!is_array($config) || count($config) == 0) {
	// 		return $retorno;
	// 	}

	// 	extract($config);

	// 	if (!isset($descontos) || !is_array($descontos) || count($descontos) == 0) {
	// 		return $retorno;
	// 	}

	// 	$this->load->language('module/exibir_descontos');

	// 	foreach($descontos as $desconto){
	// 		if ($desconto['descricao'] == '') { continue; }

	// 		$preco_numero = intval( preg_replace('/[^0-9]/', '', $preco) ) / $currency_divisor;

	// 		$valor_minimo = $this->currency->convert($desconto['minimo'], $currency_code_default, $currency_code_user);
	// 		if ($preco_numero < $valor_minimo) { continue; }

	// 		$preco_original          = $preco_numero;
	// 		$desconto_em_porcentagem = $desconto['desconto'];
	// 		$desconto_em_valor       = ($preco_original <= 0) ? 0 : (($preco_original / 100) * $desconto_em_porcentagem);
	// 		$preco_com_desconto      = $preco_original - $desconto_em_valor;

	// 		$preco_original          = '<span class="preco_original">'.$this->currency->format($preco_original).'</span>';
	// 		$desconto_em_porcentagem = '<span class="desconto_em_porcentagem">'.str_replace('.', ',', $desconto_em_porcentagem).'%</span>';
	// 		$desconto_em_valor       = '<span class="desconto_em_valor">'.$this->currency->format($desconto_em_valor).'</span>';
	// 		$preco_com_desconto      = '<span class="preco_com_desconto">'.$this->currency->format($preco_com_desconto).'</span>';

	// 		$descricao = $desconto['descricao'];
	// 		$descricao = str_replace('{{preco_original}}', $preco_original, $descricao);
	// 		$descricao = str_replace('{{preco_com_desconto}}', $preco_com_desconto, $descricao);
	// 		$descricao = str_replace('{{desconto_em_porcentagem}}', $desconto_em_porcentagem, $descricao);
	// 		$descricao = str_replace('{{desconto_em_valor}}', $desconto_em_valor, $descricao);

	// 		$validade = '';

	// 		$valor_minimo = $desconto['minimo'];
	// 		if ($valor_minimo > 0) {
	// 			$validade = sprintf($this->language->get('text_validade'), $this->currency->format($valor_minimo));
	// 		}

	// 		$retorno[] = array(
	// 			'descricao' => $descricao,
	// 			'validade'  => $validade
	// 		);
	// 	}

	// 	return $retorno;
	// }

	public function exibirDescontosListagem($config, $preco) {
		$retorno = array();

		if (!is_array($config) || count($config) == 0) {
			return $retorno;
		}

		extract($config);

		if (!isset($descontos) || !is_array($descontos) || count($descontos) == 0) {
			return $retorno;
		}

		foreach($descontos as $desconto){
			if (!isset($desconto['listagem']) || $desconto['listagem'] != '1') { continue; }
			if ($desconto['descricao_lista'] == '') { continue; }

			$preco_numero = intval( preg_replace('/[^0-9]/', '', $preco) ) / $currency_divisor;

			$valor_minimo = $this->currency->convert($desconto['minimo'], $currency_code_default, $currency_code_user);
			if($preco_numero < $valor_minimo){ continue; }

			$preco_original          = $preco_numero;
			$desconto_em_porcentagem = $desconto['desconto'];
			$desconto_em_valor       = ($preco_original <= 0) ? 0 : (($preco_original / 100) * $desconto_em_porcentagem);
			$preco_com_desconto      = $preco_original - $desconto_em_valor;

			$preco_original          = '<span class="preco_original">'.$this->currency->format($preco_original).'</span>';
			$desconto_em_porcentagem = '<span class="desconto_em_porcentagem">'.$desconto_em_porcentagem.'%</span>';
			$desconto_em_valor       = '<span class="desconto_em_valor">'.$this->currency->format($desconto_em_valor).'</span>';
			$preco_com_desconto      = '<span class="preco_com_desconto">'.$this->currency->format($preco_com_desconto).'</span>';

			$descricao = $desconto['descricao_lista'];
			$descricao = str_replace('{{preco_original}}', $preco_original, $descricao);
			$descricao = str_replace('{{preco_com_desconto}}', $preco_com_desconto, $descricao);
			$descricao = str_replace('{{desconto_em_porcentagem}}', $desconto_em_porcentagem, $descricao);
			$descricao = str_replace('{{desconto_em_valor}}', $desconto_em_valor, $descricao);

			$retorno[] = $descricao;
		}

		return $retorno;
	}

	public function getDescontosConfig() {
		$descontos = $this->config->get('exibir_descontos_config');

		if(!is_array($descontos)){
			return array();
		}

		$config_language_id = $this->config->get('config_language_id');

		$tmp = array();
		$sort_order = array();

		foreach($descontos as $desconto){
			if(!isset($desconto['status']) || $desconto['status'] == '0'){ continue; }
			if(!isset($desconto['desconto']) || !is_numeric($desconto['desconto']) || $desconto['desconto'] <= 0){ continue; }
			if(!isset($desconto['minimo']) || !is_numeric($desconto['minimo'])){ continue; }
			if(!isset($desconto['sort_order']) || !is_numeric($desconto['sort_order'])){ $desconto['sort_order'] = 0; }

			if($desconto['desconto'] > 100){ $desconto['desconto'] = 100; }

			$desconto['descricao'] = isset($desconto['descricao'][$config_language_id]) ? trim($desconto['descricao'][$config_language_id]) : '';
			$desconto['descricao_lista'] = isset($desconto['descricao_lista'][$config_language_id]) ? trim($desconto['descricao_lista'][$config_language_id]) : '';

			$tmp[] = $desconto;
			$sort_order[] = $desconto['sort_order'];
		}

		$descontos = $tmp;

		if (count($descontos) > 1) {
			array_multisort($sort_order, SORT_ASC, $descontos);
		}

		if ($descontos) {
			$this->load->language('module/exibir_descontos');

			$tmp = array();
			$tmp['descontos'] = $descontos;
			$tmp['currency_code_default'] = $this->config->get('config_currency');
			$tmp['currency_code_user'] = $this->currency->getCode();
			$tmp['currency_divisor'] = '1' . str_repeat('0', $this->currency->getDecimalPlace());
			$tmp['text_validade'] = $this->language->get('text_validade');
			$descontos = $tmp;
		}

		// print_r($descontos);exit;
		return $descontos;
	}
}