<?php
class ControllerPaymentMoipBoleto extends Controller {

	public function index() {

		//Captura o ID do Pedido
		$order_id = $this->session->data['order_id'];

		$data = array();

		//Carrega models
		$this->load->model('checkout/order');
		$this->load->model('payment/moip');

		//Adiciona os dados da compra no array order_info
		$order_info = $this->model_checkout_order->getOrder($order_id);

		$data = $order_info;

		//Captura o id da compra
		$data['order_id'] = $order_id;

		//Captura o valor total
		$data['amount'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);

		//Captura o código do MoIP
		$data['code'] = $this->model_payment_moip->captureToken($data);

		//Links
		$data['continue'] = $this->url->link('checkout/success', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/moip_boleto.tpl')) {
			return $this->load->view($this->config->get('config_template') . '/template/payment/moip_boleto.tpl', $data);
		} else {
			return $this->load->view('default/template/payment/moip_boleto.tpl', $data);
		}
	}

	public function confirm() {
		$this->load->model('checkout/order');

		$this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $this->config->get('config_order_status_id'));

		if (isset($this->session->data['order_id'])) {
			$this->cart->clear();
			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['comment']);
			unset($this->session->data['coupon']);
		}
	}
}