<?php
class ControllerPaymentCombinar extends Controller {
	public function index() {
		$data['text_loading'] = $this->language->get('text_loading');
		$data['button_confirm'] = $this->language->get('button_confirm');

		$language_id = $this->config->get('config_language_id');
		$instructions = $this->config->get('combinar_pre_instructions');
		$instructions = isset($instructions[$language_id]) ? trim($instructions[$language_id]) : '';
		$instructions = ($instructions != '') ? nl2br($instructions) : '';

		$data['text_instruction'] = $instructions;

		$data['continue'] = $this->url->link('checkout/success', 'pm=' . md5('combinar'));

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/combinar.tpl')) {
			return $this->load->view($this->config->get('config_template') . '/template/payment/combinar.tpl', $data);
		} else {
			return $this->load->view('default/template/payment/combinar.tpl', $data);
		}
	}

	public function confirm() {
		if ($this->session->data['payment_method']['code'] == 'combinar') {
			$this->load->model('checkout/order');

			$language_id = $this->config->get('config_language_id');
			$instructions = $this->config->get('combinar_post_instructions');
			$instructions = isset($instructions[$language_id]) ? trim($instructions[$language_id]) : '';

			$comment = $instructions;

			$this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $this->config->get('combinar_order_status_id'), $comment, true);
		}
	}
}