<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-desconto" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-desconto" class="form-horizontal">

					<div class="form-group">
						<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
						<div class="col-sm-10">
							<select name="desconto_status" id="input-status" class="form-control">
								<?php if ($desconto_status) { ?>
								<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
								<option value="0"><?php echo $text_disabled; ?></option>
								<?php } else { ?>
								<option value="1"><?php echo $text_enabled; ?></option>
								<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
						<div class="col-sm-10">
							<input type="text" name="desconto_sort_order" value="<?php echo $desconto_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
						</div>
					</div>

					<table id="module" class="table table-striped table-bordered table-hover">
						<thead>
							<tr>
								<td class="text-left required"><?php echo $entry_payment_method; ?></td>
								<td class="text-left required"><?php echo $entry_discount; ?></td>
								<td class="text-left required"><?php echo $entry_total; ?></td>
								<td></td>
							</tr>
						</thead>
						<tbody>
							<?php $module_row = 0; ?>
							<?php foreach ($modules as $desconto_module) { ?>
							<tr id="module-row<?php echo $module_row; ?>">
								<td class="text-left">
									<select name="desconto_module[<?php echo $module_row; ?>][forma_pgto]" class="form-control">
										<?php foreach ($payment_methods as $payment_method) { ?>
											<?php if (isset($desconto_module['forma_pgto']) && $payment_method['code'] == $desconto_module['forma_pgto']) { ?>
												<option value="<?php echo $payment_method['code']; ?>" selected="selected"><?php echo $payment_method['name']; ?></option>
											<?php } else { ?>
												<option value="<?php echo $payment_method['code']; ?>"><?php echo $payment_method['name']; ?></option>
											<?php } ?>
										<?php } ?>
									</select>
								</td>
								<td class="text-left">
									<input type="text" name="desconto_module[<?php echo $module_row; ?>][desconto]" value="<?php echo isset($desconto_module['desconto']) ? $desconto_module['desconto'] : ''; ?>" placeholder="<?php echo $entry_discount; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<input type="text" name="desconto_module[<?php echo $module_row; ?>][minimo]" value="<?php echo isset($desconto_module['minimo']) ? $desconto_module['minimo'] : ''; ?>" placeholder="<?php echo $entry_total; ?>" class="form-control" />
								</td>
								<td class="text-left"><button type="button" onclick="$('#module-row<?php echo $module_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
							</tr>
							<?php $module_row++; ?>
							<?php } ?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="3"></td>
								<td class="text-left"><button type="button" onclick="addModule();" data-toggle="tooltip" title="<?php echo $button_module_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
							</tr>
						</tfoot>
					</table>

				</form>

			</div>
		</div>

	</div>

</div>



<script type="text/javascript"><!--
var module_row = <?php echo $module_row; ?>;

function addModule() {
	html  = '<tr id="module-row' + module_row + '">';
	html += '	<td class="text-left">';
	html += '		<select name="desconto_module[' + module_row + '][forma_pgto]" class="form-control">';
	html += '			<option value=""></option>';
	<?php foreach ($payment_methods as $payment_method) { ?>
	html += '			<option value="<?php echo $payment_method['code']; ?>"><?php echo $payment_method['name']; ?></option>';
	<?php } ?>
	html += '		</select>';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="desconto_module[' + module_row + '][desconto]" value="0" placeholder="<?php echo $entry_discount; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="desconto_module[' + module_row + '][minimo]" value="0.00" placeholder="<?php echo $entry_total; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left"><button type="button" onclick="$(\'#module-row' + module_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#module tbody').append(html);
	// $('[data-toggle=\'tooltip\']').tooltip({container: 'body', html: true});

	module_row++;
}
//--></script>



<?php echo $footer; ?>