<?php

$admin_username = $this->registry->get('user')->getUserName();

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-totalexpress" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> Configurações do módulo Transportadora Total Express</h3>
			</div>
			<div class="panel-body">
				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-totalexpress" class="form-horizontal">

				<table class="table table-striped">
				<tr>
					<td width="130">Nome de Exibição</td>
					<td><input type="text" name="totalexpress_nome" value="<?php echo $totalexpress_nome; ?>" size="40"></td>
				</tr>
				<tr>
					<td>Login</td>
					<td><input type="text" name="totalexpress_login" value="<?php echo $totalexpress_login; ?>" size="40"></td>
				</tr>
				<tr>
					<td>Senha</td>
					<td><input type="text" name="totalexpress_senha" value="<?php echo $totalexpress_senha; ?>" size="40"></td>
				</tr>
				<?php
				foreach ($servicos_total as $key => $valor) {
					$status  = isset($totalexpress_servicos[$key]['status'])  ? $totalexpress_servicos[$key]['status']  : '0';
					$cubagem = isset($totalexpress_servicos[$key]['cubagem']) ? $totalexpress_servicos[$key]['cubagem'] : '300';
					$nome    = isset($totalexpress_servicos[$key]['nome'])    ? $totalexpress_servicos[$key]['nome']    : $valor;
					?>
					<tr>
						<td>Ativar (<?php echo $key; ?>)</td>
						<td>
							<input type="checkbox" name="totalexpress_servicos[<?php echo $key; ?>][status]" value="1" <?php echo $status ? 'checked' : ''; ?>>
							<input type="text" name="totalexpress_servicos[<?php echo $key; ?>][nome]" value="<?php echo $nome; ?>">
							com fator de cubagem
							<input type="text" name="totalexpress_servicos[<?php echo $key; ?>][cubagem]" size="5" value="<?php echo $cubagem; ?>">
							(consultar transportadora)
						</td>
					</tr>
					<?php
				}
				?>
				<tr>
					<td>Prazo Extra</td>
					<td><input type="number" name="totalexpress_prazo_extra" value="<?php echo $totalexpress_prazo_extra; ?>"> (dias)</td>
				</tr>
				<tr>
					<td>Taxa Extra</td>
					<td><input type="text" class="dinheiro" name="totalexpress_taxa_extra" value="<?php echo $totalexpress_taxa_extra; ?>"> (R$)</td>
				</tr>
				<tr>
					<td>Peso Mínimo</td>
					<td><input type="text" class="dinheiro" name="totalexpress_minimo" value="<?php echo $totalexpress_minimo; ?>"> (KG)</td>
				</tr>
				<tr <?php if ($admin_username != 'devhdw') { echo('style="display:none;"'); } ?>>
					<td>Grupo de Impostos</td>
					<td>
						<select name="totalexpress_tax_class_id">
						<option value="0"><?php echo $text_none; ?></option>
						<?php foreach ($tax_classes as $tax_class) { ?>
							<?php if ($tax_class['tax_class_id'] == $totalexpress_tax_class_id) { ?>
								<option value="<?php echo $tax_class['tax_class_id']; ?>" selected><?php echo $tax_class['title']; ?></option>
							<?php } else { ?>
								<option value="<?php echo $tax_class['tax_class_id']; ?>"><?php echo $tax_class['title']; ?></option>
							<?php } ?>
						<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Região Geográfica</td>
					<td>
						<select name="totalexpress_geo_zone_id">
						<option value="0">Todas as regiões</option>
						<?php foreach ($geo_zones as $geo_zone) { ?>
							<?php if ($geo_zone['geo_zone_id'] == $totalexpress_geo_zone_id) { ?>
								<option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected><?php echo $geo_zone['name']; ?></option>
							<?php } else { ?>
								<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
							<?php } ?>
						<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Situação</td>
					<td>
						<select name="totalexpress_status">
						<?php if ($totalexpress_status) { ?>
							<option value="1" selected><?php echo $text_enabled; ?></option>
							<option value="0"><?php echo $text_disabled; ?></option>
						<?php } else { ?>
							<option value="1"><?php echo $text_enabled; ?></option>
							<option value="0" selected><?php echo $text_disabled; ?></option>
						<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Posição</td>
					<td><input type="text" name="totalexpress_sort_order" value="<?php echo $totalexpress_sort_order; ?>" size="3"></td>
				</tr>
				</table>
				</form>
			</div>
		</div>

	</div>
</div>

<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.maskmoney/3.0.2/jquery.maskMoney.min.js"></script>
<script>
$(function(){
	$(".dinheiro").maskMoney({thousands:'', decimal:'.', allowZero:true, suffix: ''});
});
</script>

<?php echo $footer; ?>