<?php

$admin_username = $this->registry->get('user')->getUserName();

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-jadlog" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $heading_title; ?></h3>
			</div>
			<div class="panel-body">
				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-jadlog" class="form-control-ex">

				<table class="table table-striped form">
				<tr>
					<td width="130">Nome de Exibição</td>
					<td><input type="text" name="jadlog_nome" value="<?php echo $jadlog_nome; ?>" size="40"></td>
				</tr>
				<tr>
					<td>Usuário/CNPJ</td>
					<td><input type="text" name="jadlog_user" value="<?php echo $jadlog_user; ?>" size="40"></td>
				</tr>
				<tr>
					<td>Senha</td>
					<td><input type="text" name="jadlog_senha" value="<?php echo $jadlog_senha; ?>" size="40"></td>
				</tr>
				<tr>
					<td>CEP Origem</td>
					<td><input type="text" name="jadlog_cep" value="<?php echo $jadlog_cep; ?>" size="40"></td>
				</tr>
				<tr>
					<td>Taxa Coleta</td>
					<td><input type="text" class="dinheiro" name="jadlog_coleta" value="<?php echo $jadlog_coleta; ?>"> (R$)</td>
				</tr>
				<tr>
					<td>Frete</td>
					<td>
						<select name="jadlog_frete">
							<?php if ($jadlog_frete) { ?>
								<option value="1" selected>Pago pelo cliente</option>
								<option value="0">Pago pela loja</option>
							<?php } else { ?>
								<option value="1">Pago pelo cliente</option>
								<option value="0" selected>Pago pela loja</option>
							<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Entrega</td>
					<td>
						<select name="jadlog_entrega">
							<?php if ($jadlog_entrega) { ?>
								<option value="1" selected>Retirar unidade Jadlog</option>
								<option value="0">A domicílio</option>
							<?php } else { ?>
								<option value="1">Retirar unidade Jadlog</option>
								<option value="0" selected>A domicílio</option>
							<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Tipos de Entrega</td>
					<td>
						<?php foreach ($tiposFrete as $k => $v) { ?>
							<label><input type="checkbox" name="jadlog_tipos[]" value="<?php echo $v; ?>" <?php echo (!empty($jadlog_tipos) && in_array($v, $jadlog_tipos)) ? 'checked' : ''; ?>> <?php echo $k; ?></label><br>
						<?php } ?>
					</td>
				</tr>
				<tr>
					<td>Prazo aprox. Rodoviário</td>
					<td><input type="text" name="jadlog_prazo" value="<?php echo $jadlog_prazo; ?>"></td>
				</tr>
				<tr>
					<td>Prazo aprox. Aéreo</td>
					<td><input type="text" name="jadlog_prazoa" value="<?php echo $jadlog_prazoa; ?>"></td>
				</tr>
				<tr>
					<td>Taxa Extra</td>
					<td><input type="text" class="dinheiro" name="jadlog_taxa" value="<?php echo $jadlog_taxa; ?>"> (R$)</td>
				</tr>
				<tr>
					<td>Total Mínimo</td>
					<td><input type="text" class="dinheiro" name="jadlog_total_minimo" value="<?php echo $jadlog_total_minimo; ?>"> (R$)</td>
				</tr>
				<tr>
					<td>Peso Mínimo</td>
					<td><input type="text" class="dinheiro" name="jadlog_peso_minimo" value="<?php echo $jadlog_peso_minimo; ?>"> (KG)</td>
				</tr>
				<tr <?php if ($admin_username != 'devhdw') { echo('style="display:none;"'); } ?>>
					<td>Grupo de Impostos</td>
					<td>
						<select name="jadlog_tax_class_id">
							<option value="0"><?php echo $text_none; ?></option>
							<?php foreach ($tax_classes as $tax_class) { ?>
								<?php if ($tax_class['tax_class_id'] == $jadlog_tax_class_id) { ?>
									<option value="<?php echo $tax_class['tax_class_id']; ?>" selected><?php echo $tax_class['title']; ?></option>
								<?php } else { ?>
									<option value="<?php echo $tax_class['tax_class_id']; ?>"><?php echo $tax_class['title']; ?></option>
								<?php } ?>
							<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td>Região Geográfica</td>
					<td>
						<select name="jadlog_geo_zone_id">
							<option value="0">Todas as regiões</option>
							<?php foreach ($geo_zones as $geo_zone) { ?>
								<?php if ($geo_zone['geo_zone_id'] == $jadlog_geo_zone_id) { ?>
									<option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected><?php echo $geo_zone['name']; ?></option>
								<?php } else { ?>
									<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
								<?php } ?>
							<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td><?php echo $entry_status; ?></td>
					<td>
						<select name="jadlog_status">
							<?php if ($jadlog_status) { ?>
								<option value="1" selected><?php echo $text_enabled; ?></option>
								<option value="0"><?php echo $text_disabled; ?></option>
							<?php } else { ?>
								<option value="1"><?php echo $text_enabled; ?></option>
								<option value="0" selected><?php echo $text_disabled; ?></option>
							<?php } ?>
						</select>
					</td>
				</tr>
				<tr>
					<td><?php echo $entry_sort_order; ?></td>
					<td><input type="text" name="jadlog_sort_order" value="<?php echo $jadlog_sort_order; ?>" size="3"></td>
				</tr>
				</table>
				</form>
			</div>
		</div>

	</div>
</div>

<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.maskmoney/3.0.2/jquery.maskMoney.min.js"></script>
<script>
$(function(){
	$(".dinheiro").maskMoney({thousands:'', decimal:'.', allowZero:true, suffix: ''});
});
</script>

<?php echo $footer; ?>