<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-item-hdw" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-item-hdw" class="form-horizontal">

					<div class="form-group">
						<label class="col-sm-2 control-label" for="input-tax-class"><?php echo $entry_tax_class; ?></label>
						<div class="col-sm-10">
							<select name="item_hdw_tax_class_id" id="input-tax-class" class="form-control">
								<option value="0"><?php echo $text_none; ?></option>
								<?php foreach ($tax_classes as $tax_class) { ?>
								<?php if ($tax_class['tax_class_id'] == $item_hdw_tax_class_id) { ?>
								<option value="<?php echo $tax_class['tax_class_id']; ?>" selected="selected"><?php echo $tax_class['title']; ?></option>
								<?php } else { ?>
								<option value="<?php echo $tax_class['tax_class_id']; ?>"><?php echo $tax_class['title']; ?></option>
								<?php } ?>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
						<div class="col-sm-10">
							<select name="item_hdw_status" id="input-status" class="form-control">
								<?php if ($item_hdw_status) { ?>
								<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
								<option value="0"><?php echo $text_disabled; ?></option>
								<?php } else { ?>
								<option value="1"><?php echo $text_enabled; ?></option>
								<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
						<div class="col-sm-10">
							<input type="text" name="item_hdw_sort_order" value="<?php echo $item_hdw_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
						</div>
					</div>

					<table id="zone" class="table table-striped table-bordered table-hover">
						<thead>
							<tr>
								<td class="text-left" style="width:23%; min-width:150px;"><span data-toggle="tooltip" title="<?php echo $help_titulo; ?>"><?php echo $entry_titulo; ?></span></td>
								<td class="text-left required" style="width:8%; min-width:80px;"><span data-toggle="tooltip" title="<?php echo $help_cost; ?>"><?php echo $entry_cost; ?></span></td>
								<td class="text-left required" style="width:8%; min-width:80px;"><span data-toggle="tooltip" title="<?php echo $help_cost_extra; ?>"><?php echo $entry_cost_extra; ?></span></td>
								<td class="text-left required" style="width:8%; min-width:80px;"><span data-toggle="tooltip" title="<?php echo $help_total_min; ?>"><?php echo $entry_total_min; ?></span></td>
								<td class="text-left" style="width:8%; min-width:80px;"><span data-toggle="tooltip" title="<?php echo $help_total_max; ?>"><?php echo $entry_total_max; ?></span></td>
								<td class="text-left" style="width:15%; min-width:105px;"><?php echo $entry_geo_zone; ?></td>
								<td class="text-left" style="width:15%; min-width:105px;">
									<span data-toggle="tooltip" title="<?php echo $help_cep; ?>"><?php echo $entry_cep; ?></span>
									<a href="http://www.buscacep.correios.com.br/sistemas/buscacep/buscaFaixaCep.cfm" target="_blank" data-toggle="tooltip" title="Clique aqui para consultar as faixas de CEP no site dos Correios."><span class="fa fa-external-link"></span></a>
								</td>
								<td class="text-left" style="width:15%; min-width:90px;"><?php echo $entry_status; ?></td>
								<td></td>
							</tr>
						</thead>
						<tbody>
							<?php $zone_row = 0; ?>
							<?php foreach ($item_hdw_zones as $item_hdw_zone) { ?>
							<tr id="zone-row<?php echo $zone_row; ?>">
								<td class="text-left">
									<?php foreach ($languages as $language) { ?>
									<div class="input-group">
										<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
										<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][titulo][<?php echo $language['language_id']; ?>]" value="<?php echo isset($item_hdw_zone['titulo'][$language['language_id']]) ? $item_hdw_zone['titulo'][$language['language_id']] : ''; ?>" placeholder="<?php echo $placeholder_titulo; ?>" class="form-control" />
									</div>
									<?php } ?>
								</td>
								<td class="text-left">
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][cost]" value="<?php echo isset($item_hdw_zone['cost']) ? $item_hdw_zone['cost'] : ''; ?>" placeholder="<?php echo $entry_cost; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][cost_extra]" value="<?php echo isset($item_hdw_zone['cost_extra']) ? $item_hdw_zone['cost_extra'] : ''; ?>" placeholder="<?php echo $entry_cost_extra; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][total_min]" value="<?php echo isset($item_hdw_zone['total_min']) ? $item_hdw_zone['total_min'] : ''; ?>" placeholder="<?php echo $entry_total_min; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][total_max]" value="<?php echo isset($item_hdw_zone['total_max']) ? $item_hdw_zone['total_max'] : ''; ?>" placeholder="<?php echo $entry_total_max; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<select name="item_hdw_zone[<?php echo $zone_row; ?>][geo_zone_id]" class="form-control">
										<option value="0"><?php echo $text_all_zones; ?></option>
										<?php foreach ($geo_zones as $geo_zone) { ?>
											<?php if (isset($item_hdw_zone['geo_zone_id']) && $geo_zone['geo_zone_id'] == $item_hdw_zone['geo_zone_id']) { ?>
												<option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected="selected"><?php echo $geo_zone['name']; ?></option>
											<?php } else { ?>
												<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
											<?php } ?>
										<?php } ?>
									</select>
								</td>
								<td class="text-left">
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][cep_inicial]" value="<?php echo isset($item_hdw_zone['cep_inicial']) ? $item_hdw_zone['cep_inicial'] : ''; ?>" placeholder="<?php echo $placeholder_cep_inicial; ?>" class="form-control" />
									<input type="text" name="item_hdw_zone[<?php echo $zone_row; ?>][cep_final]" value="<?php echo isset($item_hdw_zone['cep_final']) ? $item_hdw_zone['cep_final'] : ''; ?>" placeholder="<?php echo $placeholder_cep_final; ?>" class="form-control" />
								</td>
								<td class="text-left">
									<select name="item_hdw_zone[<?php echo $zone_row; ?>][status]" class="form-control">
										<option value="1" <?php if (isset($item_hdw_zone['status']) && $item_hdw_zone['status'] == '1') { echo('selected'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (isset($item_hdw_zone['status']) && $item_hdw_zone['status'] == '0') { echo('selected'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</td>
								<td class="text-left"><button type="button" onclick="$('#zone-row<?php echo $zone_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
							</tr>
							<?php $zone_row++; ?>
							<?php } ?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="8"></td>
								<td class="text-left"><button type="button" onclick="addZone();" data-toggle="tooltip" title="<?php echo $button_zone_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
							</tr>
						</tfoot>
					</table>

				</form>

			</div>
		</div>

	</div>

</div>



<script type="text/javascript"><!--
var zone_row = <?php echo $zone_row; ?>;

function addZone() {
	html  = '<tr id="zone-row' + zone_row + '">';
	html += '	<td class="text-left">';
	<?php foreach ($languages as $language) { ?>
	html += '		<div class="input-group">';
	html += '			<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>';
	html += '			<input type="text" name="item_hdw_zone[' + zone_row + '][titulo][<?php echo $language['language_id']; ?>]" value="" placeholder="<?php echo $placeholder_titulo; ?>" class="form-control" />';
	html += '		</div>';
	<?php } ?>
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][cost]" value="10.00" placeholder="<?php echo $entry_cost; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][cost_extra]" value="5.00" placeholder="<?php echo $entry_cost_extra; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][total_min]" value="0.01" placeholder="<?php echo $entry_total_min; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][total_max]" value="" placeholder="<?php echo $entry_total_max; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<select name="item_hdw_zone[' + zone_row + '][geo_zone_id]" class="form-control">';
	html += '			<option value="0"><?php echo $text_all_zones; ?></option>';
	html += '			<?php foreach ($geo_zones as $geo_zone) { ?>';
	html += '				<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>';
	html += '			<?php } ?>';
	html += '		</select>';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][cep_inicial]" value="" placeholder="<?php echo $placeholder_cep_inicial; ?>" class="form-control" />';
	html += '		<input type="text" name="item_hdw_zone[' + zone_row + '][cep_final]" value="" placeholder="<?php echo $placeholder_cep_final; ?>" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<select name="item_hdw_zone[' + zone_row + '][status]" class="form-control">';
	html += '			<option value="1"><?php echo $text_enabled; ?></option>';
	html += '			<option value="0"><?php echo $text_disabled; ?></option>';
	html += '		</select>';
	html += '	</td>';
	html += '	<td class="text-left"><button type="button" onclick="$(\'#zone-row' + zone_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#zone tbody').append(html);

	zone_row++;
}
//--></script>



<?php echo $footer; ?>