<?php

$admin_username = $this->registry->get('user')->getUserName();

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-correios" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-correios" class="form-horizontal">

					<ul class="nav nav-tabs">
						<li class="active"><a href="#tab-general" data-toggle="tab"><?php echo $tab_general; ?></a></li>
						<?php /* ?><li><a href="#tab-descontos" data-toggle="tab"><?php echo $tab_descontos; ?></a></li><?php */ ?>
					</ul>

					<div class="tab-content">
						<div class="tab-pane active" id="tab-general">

							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-postcode"><?php echo $entry_postcode; ?></label>
								<div class="col-sm-10">
									<input type="text" name="correios_postcode" value="<?php echo $correios_postcode; ?>" placeholder="<?php echo $entry_postcode; ?>" id="input-postcode" class="form-control" />
									<?php if ($error_postcode) { ?>
									<div class="text-danger"><?php echo $error_postcode; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $help_servicos; ?>"><?php echo $entry_servicos; ?></span></label>
								<div class="col-sm-10">

									<div id="service" class="well well-sm" style="height: auto; overflow: auto; margin: 0;">
										<div id="Correios">
											<?php foreach ($servicos as $s => $serv) { ?>
											<?php if ($s == '04510') { echo('Sem contrato:'); } ?>
											<?php if ($s == '04669') { echo('<br>Com contrato:'); } ?>
											<div class="form-inline">
												<div class="form-group form-group-sm">
													<div class="col-sm-12">
														<div class="checkbox-inline">
															<?php $campo1 = "correios_{$s}"; ?>
															<?php $campo2 = "correios_total_{$s}"; ?>
															<label><input type="checkbox" name="<?php echo $campo1; ?>" value="1" <?php if ($$campo1) { echo('checked'); } ?> /></label>
														</div>
														<input type="text" name="<?php echo $campo2; ?>" class="form-control" value="<?php echo $$campo2; ?>" title="<?php echo $text_total; ?>" placeholder="<?php echo $text_total; ?>" />
														<p class="form-control-static"><?php echo $serv; ?></p>
													</div>
												</div>
											</div>
											<?php } ?>
										</div>
									</div>

								</div>
							</div>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-contrato-codigo"><span data-toggle="tooltip" title="<?php echo $help_contrato; ?>"><?php echo $entry_contrato; ?></span></label>
								<div class="col-sm-10">
									<div class="row">
										<div class="col-sm-4">
											<input type="text" name="correios_contrato_codigo" value="<?php echo $correios_contrato_codigo; ?>" placeholder="<?php echo $entry_contrato_codigo; ?>" id="input-contrato-codigo" class="form-control" />
										</div>
										<div class="col-sm-4">
											<input type="text" name="correios_contrato_senha" value="<?php echo $correios_contrato_senha; ?>" placeholder="<?php echo $entry_contrato_senha; ?>" id="input-contrato-senha" class="form-control" />
										</div>
										<div class="col-sm-4"></div>
									</div>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $help_mao_propria; ?>"><?php echo $entry_mao_propria; ?></span></label>
								<div class="col-sm-10">
									<label class="radio-inline">
										<input type="radio" name="correios_mao_propria" value="s" <?php if ($correios_mao_propria == 's') { echo('checked="checked"'); } ?> />
										<?php echo $text_yes; ?>
									</label>
									<label class="radio-inline">
										<input type="radio" name="correios_mao_propria" value="n" <?php if ($correios_mao_propria == 'n') { echo('checked="checked"'); } ?> />
										<?php echo $text_no; ?>
									</label>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $help_aviso_recebimento; ?>"><?php echo $entry_aviso_recebimento; ?></span></label>
								<div class="col-sm-10">
									<label class="radio-inline">
										<input type="radio" name="correios_aviso_recebimento" value="s" <?php if ($correios_aviso_recebimento == 's') { echo('checked="checked"'); } ?> />
										<?php echo $text_yes; ?>
									</label>
									<label class="radio-inline">
										<input type="radio" name="correios_aviso_recebimento" value="n" <?php if ($correios_aviso_recebimento == 'n') { echo('checked="checked"'); } ?> />
										<?php echo $text_no; ?>
									</label>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label"><span data-toggle="tooltip" title="<?php echo $help_declarar_valor; ?>"><?php echo $entry_declarar_valor; ?></span></label>
								<div class="col-sm-10">
									<label class="radio-inline">
										<input type="radio" name="correios_declarar_valor" value="s" <?php if ($correios_declarar_valor == 's') { echo('checked="checked"'); } ?> />
										<?php echo $text_yes; ?>
									</label>
									<label class="radio-inline">
										<input type="radio" name="correios_declarar_valor" value="n" <?php if ($correios_declarar_valor == 'n') { echo('checked="checked"'); } ?> />
										<?php echo $text_no; ?>
									</label>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-correios-adicional"><span data-toggle="tooltip" title="<?php echo $help_adicional; ?>"><?php echo $entry_adicional; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="correios_adicional" value="<?php echo $correios_adicional; ?>" placeholder="<?php echo $entry_adicional; ?>" id="input-correios-adicional" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-correios-prazo-adicional"><span data-toggle="tooltip" title="<?php echo $help_prazo_adicional; ?>"><?php echo $entry_prazo_adicional; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="correios_prazo_adicional" value="<?php echo $correios_prazo_adicional; ?>" placeholder="<?php echo $entry_prazo_adicional; ?>" id="input-correios-prazo-adicional" class="form-control" />
								</div>
							</div>

							<br>

							<div class="form-group" <?php if ($admin_username != 'devhdw') { echo('style="display:none;"'); } ?>>
								<label class="col-sm-2 control-label" for="input-tax-class"><?php echo $entry_tax_class; ?></label>
								<div class="col-sm-10">
									<select name="correios_tax_class_id" id="input-tax-class" class="form-control">
										<option value="0"><?php echo $text_none; ?></option>
										<?php foreach ($tax_classes as $tax_class) { ?>
										<option value="<?php echo $tax_class['tax_class_id']; ?>" <?php if ($tax_class['tax_class_id'] == $correios_tax_class_id) { echo('selected="selected"'); } ?>><?php echo $tax_class['title']; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-geo-zone"><?php echo $entry_geo_zone; ?></label>
								<div class="col-sm-10">
									<select name="correios_geo_zone_id" id="input-geo-zone" class="form-control">
										<option value="0"><?php echo $text_all_zones; ?></option>
										<?php foreach ($geo_zones as $geo_zone) { ?>
										<option value="<?php echo $geo_zone['geo_zone_id']; ?>" <?php if ($geo_zone['geo_zone_id'] == $correios_geo_zone_id) { echo('selected="selected"'); } ?>><?php echo $geo_zone['name']; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="correios_status" id="input-status" class="form-control">
										<option value="1" <?php if ($correios_status == '1') { echo('selected="selected"'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if ($correios_status == '0') { echo('selected="selected"'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
								<div class="col-sm-10">
									<input type="text" name="correios_sort_order" value="<?php echo $correios_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
								</div>
							</div>

						</div>

						<?php /* ?><div class="tab-pane" id="tab-descontos">
													asdasdasd
												</div><?php */ ?>
					</div>

				</form>

			</div>
		</div>

	</div>

</div>
<?php echo $footer; ?>