<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<link href="view/javascript/bootstrap/css/bootstrap.css" rel="stylesheet" media="all" />
<script type="text/javascript" src="view/javascript/jquery/jquery-2.1.1.min.js"></script>
<script type="text/javascript" src="view/javascript/bootstrap/js/bootstrap.min.js"></script>
<link href="view/javascript/font-awesome/css/font-awesome.min.css" type="text/css" rel="stylesheet" />
<link type="text/css" href="view/stylesheet/stylesheet.css" rel="stylesheet" media="all" />
<style>
	body { font-size: 14px; }
</style>
</head>
<body>
<div class="container">

	<?php foreach ($orders as $order) { ?>
	<div style="page-break-after: always;">
		<h1><?php echo $text_picklist; ?> #<?php echo $order['order_id']; ?></h1>

		<table class="table table-bordered">
			<thead>
				<tr>
					<td style="width: 50%;"><?php echo $text_from; ?></td>
					<td style="width: 50%;"><?php echo $text_order_detail; ?></td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<address>
							<strong><?php echo $order['store_name']; ?></strong><br />
							<?php echo $order['store_address']; ?>
						</address>
						<b><?php echo $text_telephone; ?></b> <?php echo $order['store_telephone']; ?><br />
						<?php if ($order['store_fax']) { ?>
							<b><?php echo $text_fax; ?></b> <?php echo $order['store_fax']; ?><br />
						<?php } ?>
						<b><?php echo $text_email; ?></b> <?php echo $order['store_email']; ?><br />
						<b><?php echo $text_website; ?></b> <a href="<?php echo $order['store_url']; ?>"><?php echo $order['store_url']; ?></a>
					</td>
					<td style="width: 50%;">
						<b><?php echo $text_order_id; ?></b> <?php echo $order['order_id']; ?><br />
						<b><?php echo $text_date_added; ?></b> <?php echo $order['date_added']; ?><br />
						<?php if ($order['invoice_no']) { ?>
							<b><?php echo $text_invoice_no; ?></b> <?php echo $order['invoice_no']; ?><br />
						<?php } ?>
						<?php if ($order['shipping_method']) { ?>
							<b><?php echo $text_shipping_method; ?></b> <?php echo $order['shipping_method']; ?><br />
						<?php } ?>
					</td>
				</tr>
			</tbody>
		</table>

		<table class="table table-bordered">
			<thead>
				<tr>
					<td style="width: 50%;"><b><?php echo $text_ship_to; ?></b></td>
					<td style="width: 50%;"><b><?php echo $text_to; ?></b></td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php echo $order['shipping_address']; ?></td>
					<td>
						<?php
						$order_info = isset($order['order_info']) ? $order['order_info'] : array();
						$custom_field = isset($order_info['custom_field']) ? $order_info['custom_field'] : array();
						?>
						<div><strong><?php echo trim($order_info['firstname'] .' '. $order_info['lastname']); ?></strong></div>
						<?php /*if (isset($custom_field['cpf']) && $custom_field['cpf'] != ''){ ?>
							<div>CPF <?php echo $custom_field['cpf']; ?></div>
						<?php } ?>
						<?php if (isset($custom_field['rg']) && $custom_field['rg'] != ''){ ?>
							<div>RG <?php echo $custom_field['rg']; ?></div>
						<?php }*/ ?>
						<?php if (isset($custom_field['razao']) && $custom_field['razao'] != ''){ ?>
							<div><?php echo $custom_field['razao']; ?></div>
						<?php } ?>
						<?php /*if (isset($custom_field['cnpj']) && $custom_field['cnpj'] != ''){ ?>
							<div>CNPJ <?php echo $custom_field['cnpj']; ?></div>
						<?php }*/ ?>
						<div><?php echo $order['email']; ?></div>
						<div><?php echo $order['telephone']; ?></div>
						<?php if (isset($custom_field['celular']) && $custom_field['celular'] != ''){ ?>
							<div><?php echo $custom_field['celular']; ?></div>
						<?php } ?>
					</td>
				</tr>
			</tbody>
		</table>

		<table class="table table-bordered">
			<thead>
				<tr>
					<td><b><?php echo $column_location; ?></b></td>
					<td><b><?php echo $column_reference; ?></b></td>
					<td><b><?php echo $column_product; ?></b></td>
					<td><b><?php echo $column_weight; ?></b></td>
					<td><b><?php echo $column_model; ?></b></td>
					<td class="text-right"><b><?php echo $column_quantity; ?></b></td>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($order['product'] as $product) { ?>
				<tr>
					<td><?php echo $product['location']; ?></td>
					<td>
						<?php if ($product['sku']) { ?>
							<?php echo $text_sku; ?> <?php echo $product['sku']; ?><br />
						<?php } ?>
						<?php if ($product['upc']) { ?>
							<?php echo $text_upc; ?> <?php echo $product['upc']; ?><br />
						<?php } ?>
						<?php if ($product['ean']) { ?>
							<?php echo $text_ean; ?> <?php echo $product['ean']; ?><br />
						<?php } ?>
						<?php if ($product['jan']) { ?>
							<?php echo $text_jan; ?> <?php echo $product['jan']; ?><br />
						<?php } ?>
						<?php if ($product['isbn']) { ?>
							<?php echo $text_isbn; ?> <?php echo $product['isbn']; ?><br />
						<?php } ?>
						<?php if ($product['mpn']) { ?>
							<?php echo $text_mpn; ?><?php echo $product['mpn']; ?><br />
						<?php } ?>
					</td>
					<td>
						<?php echo $product['name']; ?>
						<?php foreach ($product['option'] as $option) { ?>
							<br />
							&nbsp;<small> - <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
						<?php } ?>
					</td>
					<td><?php echo $product['weight']; ?></td>
					<td><?php echo $product['model']; ?></td>
					<td class="text-right"><?php echo $product['quantity']; ?></td>
				</tr>
				<?php } ?>
			</tbody>
		</table>

		<?php if ($order['comment']) { ?>
		<table class="table table-bordered">
			<thead>
				<tr>
					<td><b><?php echo $column_comment; ?></b></td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php echo $order['comment']; ?></td>
				</tr>
			</tbody>
		</table>
		<?php } ?>

	</div>
	<?php } ?>

</div>
</body>
</html>