<?php

$logo = $this->registry->get('config')->get('config_logo');
$owner = $this->registry->get('config')->get('config_owner');

?><!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<link href="view/javascript/bootstrap/css/bootstrap.css" rel="stylesheet" media="all" />
<script type="text/javascript" src="view/javascript/jquery/jquery-2.1.1.min.js"></script>
<script type="text/javascript" src="view/javascript/bootstrap/js/bootstrap.min.js"></script>
<link href="view/javascript/font-awesome/css/font-awesome.min.css" type="text/css" rel="stylesheet" />
<link type="text/css" href="view/stylesheet/stylesheet.css" rel="stylesheet" media="all" />
<style>
	body { font-size: 11px; }

	.table { width: 100%; }

	.table.no-border,
	.table.no-border tr,
	.table.no-border tr td { border: none !important; }

	.table.table-small { margin: 0; }
	.table.table-small tr td { padding: 3px; }
	.table.table-small tr td.td-label { font-size: 9px; }

	.font-small { font-size: 9px; }
</style>
</head>
<body>
<div class="container" style="width: auto; padding: 0; margin: 0 auto;">

	<?php foreach ($orders as $order) { ?>
	<?php
	$order_info = isset($order['order_info']) ? $order['order_info'] : array();
	$custom_field = isset($order_info['custom_field']) ? $order_info['custom_field'] : array();
	$shipping_custom_field = isset($order_info['shipping_custom_field']) ? $order_info['shipping_custom_field'] : array();
	$total = $order['total'][count($order['total'])-1]['text'];
	?>
	<div style="page-break-after: always;">

		<table class="table table-bordered">
			<tr>
				<td align="left"><img src="<?php echo HTTP_CATALOG.'image/'.$logo ?>" alt="<?php echo strtoupper($owner); ?>" style="display: block; width: 150px;"></td>
				<td align="left">
					<?php echo strtoupper($owner); ?><br>
					<strong><?php echo $order['store_telephone']; ?> | <?php echo $order['store_fax']; ?></strong><br>
					<?php echo $order['store_url']; ?> | <?php echo $order['store_email']; ?>
				</td>
				<td align="right">
					<div class="font-small">DATA DO PEDIDO: <?php echo $order['date_added']; ?></div>
					<div style="font-size: 16px;"><strong>PEDIDO: <?php echo str_pad($order['order_id'], 6, '0', STR_PAD_LEFT); ?></strong></div>
				</td>
			</tr>
		</table>

		<table class="table table-bordered">
			<thead>
				<tr>
					<td class="font-small text-center" style="width: 35%;"><b>INFORMAÇÕES DO COMPRADOR</b></td>
					<td class="font-small text-center" style="width: 40%;"><b>DADOS DA ENTREGA</b></td>
					<td class="font-small text-center" style="width: 25%;"><b>RESUMO DO PEDIDO</b></td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<table class="table no-border table-small">
						<tr>
							<td align="right" class="td-label">NOME:</td>
							<td><?php echo trim($order_info['firstname'] .' '. $order_info['lastname']); ?></td>
						</tr>
						<?php if (isset($custom_field['cpf']) && $custom_field['cpf'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">CPF:</td>
							<td><?php echo $custom_field['cpf']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($custom_field['rg']) && $custom_field['rg'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">RG:</td>
							<td><?php echo $custom_field['rg']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($custom_field['razao']) && $custom_field['razao'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">RAZÃO SOCIAL:</td>
							<td><?php echo $custom_field['razao']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($custom_field['cnpj']) && $custom_field['cnpj'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">CNPJ:</td>
							<td><?php echo $custom_field['cnpj']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($order_info['email']) && $order_info['email'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">EMAIL:</td>
							<td><?php echo $order_info['email']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($order_info['telephone']) && $order_info['telephone'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">TELEFONE:</td>
							<td><?php echo $order_info['telephone']; ?></td>
						</tr>
						<?php } ?>
						<?php if (isset($custom_field['celular']) && $custom_field['celular'] != ''){ ?>
						<tr>
							<td align="right" class="td-label">CELULAR:</td>
							<td><?php echo $custom_field['celular']; ?></td>
						</tr>
						<?php } ?>
						</table>
					</td>
					<td>
						<table class="table no-border table-small">
						<tr>
							<td align="right" class="td-label">NOME:</td>
							<td><?php echo trim($order_info['shipping_firstname'] .' '. $order_info['shipping_lastname']); ?></td>
						</tr>
						<tr>
							<td align="right" class="td-label">ENDEREÇO:</td>
							<td><?php echo trim($order_info['shipping_address_1'] .' '. $shipping_custom_field['numero'] .' '. $shipping_custom_field['complemento']); ?></td>
						</tr>
						<tr>
							<td align="right" class="td-label">BAIRRO:</td>
							<td><?php echo trim($order_info['shipping_address_2']); ?></td>
						</tr>
						<tr>
							<td align="right" class="td-label">CIDADE:</td>
							<td><?php echo trim($order_info['shipping_city'] .' / '. $order_info['shipping_zone_code']); ?></td>
						</tr>
						<tr>
							<td align="right" class="td-label">CEP:</td>
							<td><?php echo trim($order_info['shipping_postcode']); ?></td>
						</tr>
						</table>
					</td>
					<td>
						<table class="table no-border table-small">
							<?php if ($order['shipping_method']) { ?>
							<tr>
								<td align="right" class="td-label"><div class="font-small">FRETE ESCOLHIDO:</div></td>
								<td align="center"><div style=""><?php echo $order['shipping_method']; ?></div></td>
							</tr>
							<?php } ?>
							<?php if ($order['payment_method']) { ?>
							<tr>
								<td align="right" class="td-label"><div class="font-small">FORMA PAGAMENTO:</div></td>
								<td align="center"><div style=""><?php echo $order['payment_method']; ?></div></td>
							</tr>
							<?php } ?>
							<tr>
								<td align="right" class="td-label"><div class="font-small">TOTAL DO PEDIDO:</div></td>
								<td align="center"><div style="font-size: 12px; color: #ff0000;"><strong><?php echo $total; ?></strong></div></td>
							</tr>
						</table>
					</td>
				</tr>
			</tbody>
		</table>

		<table class="table table-bordered">
			<thead>
				<tr>
					<td class="font-small text-center"><b>QTD</b></td>
					<td class="font-small text-center"><b>PRODUTO</b></td>
					<td class="font-small text-center"><b>MODELO</b></td>
					<td class="font-small text-center"><b>VALOR</b></td>
					<td class="font-small text-center"><b>TOTAL</b></td>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($order['product'] as $product) { ?>
				<tr>
					<td class="text-right"><?php echo $product['quantity']; ?></td>
					<td>
						<strong><?php echo $product['name']; ?></strong>
						<?php foreach ($product['option'] as $option) { ?>
							<br />
							&nbsp;<small> - <strong><?php echo $option['name']; ?>:</strong> <?php echo $option['value']; ?></small>
						<?php } ?>
					</td>
					<td class="text-center"><?php echo $product['model']; ?></td>
					<td class="text-right"><?php echo $product['price']; ?></td>
					<td class="text-right"><?php echo $product['total']; ?></td>
				</tr>
				<?php } ?>
				<?php foreach ($order['voucher'] as $voucher) { ?>
				<tr>
					<td class="text-right">1</td>
					<td><?php echo $voucher['description']; ?></td>
					<td></td>
					<td class="text-right"><?php echo $voucher['amount']; ?></td>
					<td class="text-right"><?php echo $voucher['amount']; ?></td>
				</tr>
				<?php } ?>
				<?php foreach ($order['total'] as $total) { ?>
				<tr>
					<td class="text-right" colspan="4"><b><?php echo $total['title']; ?></b></td>
					<td class="text-right"><?php echo $total['text']; ?></td>
				</tr>
				<?php } ?>
			</tbody>
		</table>

		<?php if ($order['comment']) { ?>
		<table class="table table-bordered">
			<thead>
				<tr>
					<td class="font-small text-center"><b>OBSERVAÇÕES DO PEDIDO</b></td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php echo $order['comment']; ?></td>
				</tr>
			</tbody>
		</table>
		<?php } ?>

	</div>
	<?php } ?>

</div>
</body>
</html>