<?php

$payment_custom_field = isset($order_info['payment_custom_field']) ? $order_info['payment_custom_field'] : array();
$shipping_custom_field = isset($order_info['shipping_custom_field']) ? $order_info['shipping_custom_field'] : array();

$has_downloads = false;
foreach ($products as $product) {
	if (isset($product['downloads']) && count($product['downloads']) > 0) {
		$has_downloads = true;
		break;
	}
}

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<a href="<?php echo $etiqueta_correios; ?>" target="_blank" data-toggle="tooltip" title="<?php echo $button_etiqueta_correios; ?>" class="btn btn-success"><i class="fa fa-file-text"></i></a>
				<a href="<?php echo $invoice; ?>" target="_blank" data-toggle="tooltip" title="<?php echo $button_invoice_print; ?>" class="btn btn-info"><i class="fa fa-print"></i></a>
				<a href="<?php echo $shipping; ?>" target="_blank" data-toggle="tooltip" title="<?php echo $button_shipping_print; ?>" class="btn btn-info"><i class="fa fa-truck"></i></a>
				<a href="<?php echo $edit; ?>" data-toggle="tooltip" title="<?php echo $button_edit; ?>" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
			</div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $heading_title; ?></h3>
			</div>
			<div class="panel-body">



				<ul class="nav nav-tabs">
					<li class="active"><a href="#tab-order" data-toggle="tab"><?php echo $tab_order; ?></a></li>
					<li><a href="#tab-payment" data-toggle="tab"><?php echo $tab_payment; ?></a></li>
					<?php if ($shipping_method) { ?>
					<li><a href="#tab-shipping" data-toggle="tab"><?php echo $tab_shipping; ?></a></li>
					<?php } ?>
					<li><a href="#tab-product" data-toggle="tab"><?php echo $tab_product; ?></a></li>
					<?php if ($has_downloads) { ?>
					<li><a href="#tab-downloads" data-toggle="tab">Downloads</a></li>
					<?php } ?>
					<li><a href="#tab-history" data-toggle="tab"><?php echo $tab_history; ?></a></li>
					<?php if ($payment_action) { ?>
					<li><a href="#tab-action" data-toggle="tab"><?php echo $tab_action; ?></a></li>
					<?php } ?>
					<?php if ($frauds) { ?>
					<?php foreach ($frauds as $fraud) { ?>
					<li><a href="#tab-<?php echo $fraud['code']; ?>" data-toggle="tab"><?php echo $fraud['title']; ?></a></li>
					<?php } ?>
					<?php } ?>
				</ul>



				<div class="tab-content">



					<div class="tab-pane active" id="tab-order">
						<table class="table table-bordered">
							<tr>
								<td><?php echo $text_order_id; ?></td>
								<td>#<?php echo $order_id; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_invoice_no; ?></td>
								<td><?php if ($invoice_no) { ?>
									<?php echo $invoice_no; ?>
									<?php } else { ?>
									<button id="button-invoice" class="btn btn-success btn-xs"><i class="fa fa-cog"></i> <?php echo $button_generate; ?></button>
									<?php } ?></td>
							</tr>
							<tr>
								<td><?php echo $text_store_name; ?></td>
								<td><?php echo $store_name; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_store_url; ?></td>
								<td><a href="<?php echo $store_url; ?>" target="_blank"><?php echo $store_url; ?></a></td>
							</tr>
							<?php if ($customer) { ?>
							<tr>
								<td><?php echo $text_customer; ?></td>
								<td><a href="<?php echo $customer; ?>" target="_blank"><?php echo $firstname; ?> <?php echo $lastname; ?></a></td>
							</tr>
							<?php } else { ?>
							<tr>
								<td><?php echo $text_customer; ?></td>
								<td><?php echo $firstname; ?> <?php echo $lastname; ?></td>
							</tr>
							<?php } ?>
							<?php if ($customer_group) { ?>
							<tr>
								<td><?php echo $text_customer_group; ?></td>
								<td><?php echo $customer_group; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['cpf']) && $account_custom_field['cpf'] != '') { ?>
							<tr>
								<td><?php echo $text_cpf; ?></td>
								<td><?php echo $account_custom_field['cpf']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['rg']) && $account_custom_field['rg'] != '') { ?>
							<tr>
								<td><?php echo $text_rg; ?></td>
								<td><?php echo $account_custom_field['rg']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['cnpj']) && $account_custom_field['cnpj'] != '') { ?>
							<tr>
								<td><?php echo $text_cnpj; ?></td>
								<td><?php echo $account_custom_field['cnpj']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['razao']) && $account_custom_field['razao'] != '') { ?>
							<tr>
								<td><?php echo $text_razao; ?></td>
								<td><?php echo $account_custom_field['razao']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['ie']) && $account_custom_field['ie'] != '') { ?>
							<tr>
								<td><?php echo $text_ie; ?></td>
								<td><?php echo $account_custom_field['ie']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['im']) && $account_custom_field['im'] != '') { ?>
							<tr>
								<td><?php echo $text_im; ?></td>
								<td><?php echo $account_custom_field['im']; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_email; ?></td>
								<td><a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></td>
							</tr>
							<tr>
								<td><?php echo $text_telephone; ?></td>
								<td><?php echo $telephone; ?></td>
							</tr>
							<?php if (isset($account_custom_field['celular']) && $account_custom_field['celular'] != '') { ?>
							<tr>
								<td><?php echo $text_celular; ?></td>
								<td><?php echo $account_custom_field['celular']; ?></td>
							</tr>
							<?php } ?>
							<?php if ($fax) { ?>
							<tr>
								<td><?php echo $text_fax; ?></td>
								<td><?php echo $fax; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['sexo']) && $account_custom_field['sexo'] != '') { ?>
							<tr>
								<td><?php echo $text_sexo; ?></td>
								<td><?php echo $account_custom_field['sexo'] == 'm' ? $text_sexo_m : $text_sexo_f; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($account_custom_field['nascimento']) && $account_custom_field['nascimento'] != '') { ?>
							<tr>
								<td><?php echo $text_nascimento; ?></td>
								<td><?php echo $account_custom_field['nascimento']; ?></td>
							</tr>
							<?php } ?>
							<?php foreach ($account_custom_fields as $custom_field) { ?>
							<tr>
								<td><?php echo $custom_field['name']; ?>:</td>
								<td><?php echo $custom_field['value']; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_total; ?></td>
								<td><?php echo $total; ?></td>
							</tr>
							<?php if ($customer && $reward) { ?>
							<tr>
								<td><?php echo $text_reward; ?></td>
								<td><?php echo $reward; ?>
									<?php if (!$reward_total) { ?>
									<button id="button-reward-add" class="btn btn-success btn-xs"><i class="fa fa-plus-circle"></i> <?php echo $button_reward_add; ?></button>
									<?php } else { ?>
									<button id="button-reward-remove" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-danger btn-xs"><i class="fa fa-minus-circle"></i> <?php echo $button_reward_remove; ?></button>
									<?php } ?></td>
							</tr>
							<?php } ?>
							<?php if ($order_status) { ?>
							<tr>
								<td><?php echo $text_order_status; ?></td>
								<td id="order-status"><?php echo $order_status; ?></td>
							</tr>
							<?php } ?>
							<?php if ($comment) { ?>
							<tr>
								<td><?php echo $text_comment; ?></td>
								<td><?php echo $comment; ?></td>
							</tr>
							<?php } ?>
							<?php if ($affiliate) { ?>
							<tr>
								<td><?php echo $text_affiliate; ?></td>
								<td><a href="<?php echo $affiliate; ?>"><?php echo $affiliate_firstname; ?> <?php echo $affiliate_lastname; ?></a></td>
							</tr>
							<tr>
								<td><?php echo $text_commission; ?></td>
								<td><?php echo $commission; ?>
									<?php if (!$commission_total) { ?>
									<button id="button-commission-add" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-success btn-xs"><i class="fa fa-plus-circle"></i> <?php echo $button_commission_add; ?></button>
									<?php } else { ?>
									<button id="button-commission-remove" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-danger btn-xs"><i class="fa fa-minus-circle"></i> <?php echo $button_commission_remove; ?></button>
									<?php } ?></td>
							</tr>
							<?php } ?>
							<?php if ($ip) { ?>
							<tr>
								<td><?php echo $text_ip; ?></td>
								<td><?php echo $ip; ?></td>
							</tr>
							<?php } ?>
							<?php if ($forwarded_ip) { ?>
							<tr>
								<td><?php echo $text_forwarded_ip; ?></td>
								<td><?php echo $forwarded_ip; ?></td>
							</tr>
							<?php } ?>
							<?php if ($user_agent) { ?>
							<tr>
								<td><?php echo $text_user_agent; ?></td>
								<td><?php echo $user_agent; ?></td>
							</tr>
							<?php } ?>
							<?php if ($accept_language) { ?>
							<tr>
								<td><?php echo $text_accept_language; ?></td>
								<td><?php echo $accept_language; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_date_added; ?></td>
								<td><?php echo $date_added; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_date_modified; ?></td>
								<td><?php echo $date_modified; ?></td>
							</tr>
						</table>
					</div>



					<div class="tab-pane" id="tab-payment">
						<table class="table table-bordered">
							<tr>
								<td><?php echo $text_firstname; ?></td>
								<td><?php echo $payment_firstname; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_lastname; ?></td>
								<td><?php echo $payment_lastname; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_country; ?></td>
								<td><?php echo $payment_country; ?></td>
							</tr>
							<?php if ($payment_postcode) { ?>
							<tr>
								<td><?php echo $text_postcode; ?></td>
								<td><?php echo $payment_postcode; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_address_1; ?></td>
								<td><?php echo $payment_address_1; ?></td>
							</tr>
							<?php if (isset($payment_custom_field['numero']) && $payment_custom_field['numero'] != '') { ?>
							<tr>
								<td><?php echo $text_numero; ?></td>
								<td><?php echo $payment_custom_field['numero']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($payment_custom_field['complemento']) && $payment_custom_field['complemento'] != '') { ?>
							<tr>
								<td><?php echo $text_complemento; ?></td>
								<td><?php echo $payment_custom_field['complemento']; ?></td>
							</tr>
							<?php } ?>
							<?php if ($payment_address_2) { ?>
							<tr>
								<td><?php echo $text_address_2; ?></td>
								<td><?php echo $payment_address_2; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_city; ?></td>
								<td><?php echo $payment_city; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_zone; ?></td>
								<td><?php echo $payment_zone; ?></td>
							</tr>
							<?php if ($payment_zone_code) { ?>
							<tr>
								<td><?php echo $text_zone_code; ?></td>
								<td><?php echo $payment_zone_code; ?></td>
							</tr>
							<?php } ?>
							<?php if ($payment_company) { ?>
							<tr>
								<td><?php echo $text_company; ?></td>
								<td><?php echo $payment_company; ?></td>
							</tr>
							<?php } ?>
							<?php foreach ($payment_custom_fields as $custom_field) { ?>
							<tr data-sort="<?php echo $custom_field['sort_order'] + 2; ?>">
								<td><?php echo $custom_field['name']; ?>:</td>
								<td><?php echo $custom_field['value']; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_payment_method; ?></td>
								<td><?php echo $payment_method; ?></td>
							</tr>
						</table>
					</div>



					<?php if ($shipping_method) { ?>
					<div class="tab-pane" id="tab-shipping">
						<table class="table table-bordered">
							<tr>
								<td><?php echo $text_firstname; ?></td>
								<td><?php echo $shipping_firstname; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_lastname; ?></td>
								<td><?php echo $shipping_lastname; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_country; ?></td>
								<td><?php echo $shipping_country; ?></td>
							</tr>
							<?php if ($shipping_postcode) { ?>
							<tr>
								<td><?php echo $text_postcode; ?></td>
								<td><?php echo $shipping_postcode; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_address_1; ?></td>
								<td><?php echo $shipping_address_1; ?></td>
							</tr>
							<?php if (isset($shipping_custom_field['numero']) && $shipping_custom_field['numero'] != '') { ?>
							<tr>
								<td><?php echo $text_numero; ?></td>
								<td><?php echo $shipping_custom_field['numero']; ?></td>
							</tr>
							<?php } ?>
							<?php if (isset($shipping_custom_field['complemento']) && $shipping_custom_field['complemento'] != '') { ?>
							<tr>
								<td><?php echo $text_complemento; ?></td>
								<td><?php echo $shipping_custom_field['complemento']; ?></td>
							</tr>
							<?php } ?>
							<?php if ($shipping_address_2) { ?>
							<tr>
								<td><?php echo $text_address_2; ?></td>
								<td><?php echo $shipping_address_2; ?></td>
							</tr>
							<?php } ?>
							<tr>
								<td><?php echo $text_city; ?></td>
								<td><?php echo $shipping_city; ?></td>
							</tr>
							<tr>
								<td><?php echo $text_zone; ?></td>
								<td><?php echo $shipping_zone; ?></td>
							</tr>
							<?php if ($shipping_zone_code) { ?>
							<tr>
								<td><?php echo $text_zone_code; ?></td>
								<td><?php echo $shipping_zone_code; ?></td>
							</tr>
							<?php } ?>
							<?php if ($shipping_company) { ?>
							<tr>
								<td><?php echo $text_company; ?></td>
								<td><?php echo $shipping_company; ?></td>
							</tr>
							<?php } ?>
							<?php foreach ($shipping_custom_fields as $custom_field) { ?>
							<tr data-sort="<?php echo $custom_field['sort_order'] + 2; ?>">
								<td><?php echo $custom_field['name']; ?>:</td>
								<td><?php echo $custom_field['value']; ?></td>
							</tr>
							<?php } ?>
							<?php if ($shipping_method) { ?>
							<tr>
								<td><?php echo $text_shipping_method; ?></td>
								<td><?php echo $shipping_method; ?></td>
							</tr>
							<?php } ?>
						</table>
					</div>
					<?php } ?>



					<div class="tab-pane" id="tab-product">
						<table class="table table-bordered">
							<thead>
								<tr>
									<td class="text-left"><?php echo $column_product; ?></td>
									<td class="text-left"><?php echo $column_model; ?></td>
									<td class="text-right"><?php echo $column_quantity; ?></td>
									<td class="text-right"><?php echo $column_price; ?></td>
									<td class="text-right"><?php echo $column_total; ?></td>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($products as $product) { ?>
								<tr>
									<td class="text-left"><a href="<?php echo $product['href']; ?>" target="_blank"><?php echo $product['name']; ?></a>
										<?php foreach ($product['option'] as $option) { ?>
											<br>
											<?php if ($option['type'] != 'file') { ?>
												&nbsp;<small> - <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
											<?php } else { ?>
												&nbsp;<small> - <?php echo $option['name']; ?>: <a href="<?php echo $option['href']; ?>" target="_blank"><?php echo $option['value']; ?></a></small>
											<?php } ?>
										<?php } ?>
									</td>
									<td class="text-left"><?php echo $product['model']; ?></td>
									<td class="text-right"><?php echo $product['quantity']; ?></td>
									<td class="text-right"><?php echo $product['price']; ?></td>
									<td class="text-right"><?php echo $product['total']; ?></td>
								</tr>
								<?php } ?>
								<?php foreach ($vouchers as $voucher) { ?>
								<tr>
									<td class="text-left"><a href="<?php echo $voucher['href']; ?>"><?php echo $voucher['description']; ?></a></td>
									<td class="text-left"></td>
									<td class="text-right">1</td>
									<td class="text-right"><?php echo $voucher['amount']; ?></td>
									<td class="text-right"><?php echo $voucher['amount']; ?></td>
								</tr>
								<?php } ?>
								<?php foreach ($totals as $total) { ?>
								<tr>
									<td colspan="4" class="text-right"><?php echo $total['title']; ?>:</td>
									<td class="text-right"><?php echo $total['text']; ?></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>



					<?php if ($has_downloads) { ?>
					<div class="tab-pane" id="tab-downloads">
						<table class="table table-bordered">
							<thead>
								<tr>
									<td class="text-left"><?php echo $column_product; ?></td>
									<td class="text-left">Arquivo</td>
									<td class="text-left">Num. Downloads</td>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($products as $product) { ?>
								<?php if (isset($product['downloads']) && count($product['downloads']) > 0) { ?>
								<?php foreach ($product['downloads'] as $download) { ?>
								<tr>
									<td class="text-left"><a href="<?php echo $product['href']; ?>" target="_blank"><?php echo $product['name']; ?></a></td>
									<td class="text-left"><a href="<?php echo $download['href']; ?>" target="_blank"><?php echo $download['mask']; ?></a></td>
									<td class="text-left">
										<?php if ($download['total'] == 0) { ?>
											Download ainda não realizado!
										<?php } else {?>
											Download realizado <?php echo ($download['total'] == 1) ? '1 vez' : $download['total'].' vezes'; ?>
										<?php }?>
										/
										<?php if ($download['max_limit'] == 0) { ?>
											Sem limite de downloads!
										<?php } else { ?>
											Limite de <?php echo ($download['max_limit'] == 1) ? '1 download' : $download['max_limit'].' downloads'; ?> /
											<?php $restam = $download['max_limit'] - $download['total']; ?>
											<?php if ($restam == 0) { ?>
												Nenhum download restante!
											<?php } else {?>
												<?php echo ($restam == 1) ? 'Resta 1 download' : "Restam {$restam} downloads"; ?>
											<?php }?>
										<?php }?>
									</td>
								</tr>
								<?php } ?>
								<?php } ?>
								<?php } ?>
							</tbody>
						</table>
					</div>
					<?php } ?>



					<div class="tab-pane" id="tab-history">
						<div id="history"></div>
						<br />
						<fieldset>
							<legend><?php echo $text_history; ?></legend>
							<form id="form-history" class="form-horizontal">
								<div class="form-group">
									<label class="col-sm-2 control-label" for="input-order-status"><?php echo $entry_order_status; ?></label>
									<div class="col-sm-10">
										<select name="order_status_id" id="input-order-status" class="form-control">
											<?php foreach ($order_statuses as $order_statuses) { ?>
											<?php if ($order_statuses['order_status_id'] == $order_status_id) { ?>
											<option value="<?php echo $order_statuses['order_status_id']; ?>" selected="selected"><?php echo $order_statuses['name']; ?></option>
											<?php } else { ?>
											<option value="<?php echo $order_statuses['order_status_id']; ?>"><?php echo $order_statuses['name']; ?></option>
											<?php } ?>
											<?php } ?>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label"></label>
									<div class="col-sm-10">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="notify" id="input-notify" value="1" />
												<strong><?php echo $entry_notify; ?></strong>
											</label>
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label"></label>
									<div class="col-sm-10">
										<div class="checkbox form-inline">
											<label>
												<input type="checkbox" name="correios" id="input-correios" value="1" />
												<strong>Incluir código de rastreamento dos Correios</strong>
											</label>
											<input type="text" name="codigo-correios" id="input-codigo-correios" class="form-control" placeholder="código de rastreamento">
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-sm-2 control-label" for="input-comment"><?php echo $entry_comment; ?></label>
									<div class="col-sm-10">
										<textarea name="comment" rows="8" id="input-comment" class="form-control"></textarea>
									</div>
								</div>
							</form>
							<div class="text-right">
								<button id="button-history" data-loading-text="<?php echo $text_loading; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i> <?php echo $button_history_add; ?></button>
							</div>
						</fieldset>
					</div>



					<?php if ($payment_action) { ?>
					<div class="tab-pane" id="tab-action"><?php echo $payment_action; ?></div>
					<?php } ?>



					<?php if ($frauds) { ?>
					<?php foreach ($frauds as $fraud) { ?>
					<div class="tab-pane" id="tab-<?php echo $fraud['code']; ?>">
					<?php echo $fraud['content']; ?>
					</div>
					<?php } ?>
					<?php } ?>



				</div>



			</div>
		</div>
	</div>

</div>



<script type="text/javascript"><!--
$(document).delegate('#button-invoice', 'click', function() {
	$.ajax({
		url: 'index.php?route=sale/order/createinvoiceno&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>',
		dataType: 'json',
		beforeSend: function() {
			$('#button-invoice').button('loading');
		},
		complete: function() {
			$('#button-invoice').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#tab-order').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['invoice_no']) {
				$('#button-invoice').replaceWith(json['invoice_no']);
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$(document).delegate('#button-reward-add', 'click', function() {
	$.ajax({
		url: 'index.php?route=sale/order/addreward&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>',
		type: 'post',
		dataType: 'json',
		beforeSend: function() {
			$('#button-reward-add').button('loading');
		},
		complete: function() {
			$('#button-reward-add').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#content > .container-fluid').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['success']) {
								$('#content > .container-fluid').prepend('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

				$('#button-reward-add').replaceWith('<button id="button-reward-remove" class="btn btn-danger btn-xs"><i class="fa fa-minus-circle"></i> <?php echo $button_reward_remove; ?></button>');
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$(document).delegate('#button-reward-remove', 'click', function() {
	$.ajax({
		url: 'index.php?route=sale/order/removereward&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>',
		type: 'post',
		dataType: 'json',
		beforeSend: function() {
			$('#button-reward-remove').button('loading');
		},
		complete: function() {
			$('#button-reward-remove').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#content > .container-fluid').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['success']) {
								$('#content > .container-fluid').prepend('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

				$('#button-reward-remove').replaceWith('<button id="button-reward-add" class="btn btn-success btn-xs"><i class="fa fa-plus-circle"></i> <?php echo $button_reward_add; ?></button>');
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$(document).delegate('#button-commission-add', 'click', function() {
	$.ajax({
		url: 'index.php?route=sale/order/addcommission&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>',
		type: 'post',
		dataType: 'json',
		beforeSend: function() {
			$('#button-commission-add').button('loading');
		},
		complete: function() {
			$('#button-commission-add').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#content > .container-fluid').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['success']) {
								$('#content > .container-fluid').prepend('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

				$('#button-commission-add').replaceWith('<button id="button-commission-remove" class="btn btn-danger btn-xs"><i class="fa fa-minus-circle"></i> <?php echo $button_commission_remove; ?></button>');
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$(document).delegate('#button-commission-remove', 'click', function() {
	$.ajax({
		url: 'index.php?route=sale/order/removecommission&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>',
		type: 'post',
		dataType: 'json',
		beforeSend: function() {
			$('#button-commission-remove').button('loading');

		},
		complete: function() {
			$('#button-commission-remove').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#content > .container-fluid').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
			}

			if (json['success']) {
								$('#content > .container-fluid').prepend('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');

				$('#button-commission-remove').replaceWith('<button id="button-commission-add" class="btn btn-success btn-xs"><i class="fa fa-minus-circle"></i> <?php echo $button_commission_add; ?></button>');
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('#history').delegate('.pagination a', 'click', function(e) {
	e.preventDefault();

	$('#history').load(this.href);
});

$('#history').load('index.php?route=sale/order/history&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>');

$('#button-history').on('click', function() {
	// if(typeof verifyStatusChange == 'function'){
	// 	if(verifyStatusChange() == false){
	// 		return false;
	// 	}else{
	// 		addOrderInfo();
	// 	}
	// }else{
	// 	addOrderInfo();
	// }

	var order_status_id = $('select[name=\'order_status_id\']').val();
	var notify          = $('input[name=\'notify\']').prop('checked') ? 1 : 0;
	var append          = $('input[name=\'append\']').prop('checked') ? 1 : 0;
	var comment         = $('textarea[name=\'comment\']').val();

	comment = inserirCodigoCorreios(comment);

	var post_data = '';
	post_data += 'order_status_id=' + encodeURIComponent(order_status_id);
	post_data += '&notify=' + notify;
	post_data += '&append=' + append;
	post_data += '&comment=' + encodeURIComponent(comment);

	$.ajax({
		url: 'index.php?route=sale/order/api&token=<?php echo $token; ?>&api=api/order/history&order_id=<?php echo $order_id; ?>',
		type: 'post',
		dataType: 'json',
		// data: 'order_status_id=' + encodeURIComponent($('select[name=\'order_status_id\']').val()) + '&notify=' + ($('input[name=\'notify\']').prop('checked') ? 1 : 0) + '&append=' + ($('input[name=\'append\']').prop('checked') ? 1 : 0) + '&comment=' + encodeURIComponent($('textarea[name=\'comment\']').val()),
		data: post_data,
		beforeSend: function() {
			$('#button-history').button('loading');
		},
		complete: function() {
			$('#button-history').button('reset');
		},
		success: function(json) {
			$('.alert').remove();

			if (json['error']) {
				$('#history').before('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + ' <button type="button" class="close" data-dismiss="alert">&times;</button></div>');
			}

			if (json['success']) {
				$('#history').load('index.php?route=sale/order/history&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>');

				$('#history').before('<div class="alert alert-success"><i class="fa fa-check-circle"></i> ' + json['success'] + ' <button type="button" class="close" data-dismiss="alert">&times;</button></div>');

				$('textarea[name=\'comment\']').val('');

				$('#order-status').html($('select[name=\'order_status_id\'] option:selected').text());

				resetCodigoCorreios();
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

// function changeStatus(){
// 	var status_id = $('select[name="order_status_id"]').val();

// 	$('#openbay-info').remove();

// 	$.ajax({
// 		url: 'index.php?route=extension/openbay/getorderinfo&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>&status_id='+status_id,
// 		dataType: 'html',
// 		success: function(html) {
// 			$('#history').after(html);
// 		}
// 	});
// }

// function addOrderInfo(){
// 	var status_id = $('select[name="order_status_id"]').val();

// 	$.ajax({
// 	  url: 'index.php?route=extension/openbay/addorderinfo&token=<?php echo $token; ?>&order_id=<?php echo $order_id; ?>&status_id='+status_id,
// 	  type: 'post',
// 	  dataType: 'html',
// 	  data: $(".openbay-data").serialize()
// 	});
// }

// $(document).ready(function() {
//   changeStatus();
// });

// $('select[name="order_status_id"]').change(function(){ changeStatus(); });
//--></script>

<script type="text/javascript"><!--
// Sort the custom fields
$('#tab-payment tr[data-sort]').detach().each(function() {
	if ($(this).attr('data-sort') >= 0 && $(this).attr('data-sort') <= $('#tab-payment tr').length) {
		$('#tab-payment tr').eq($(this).attr('data-sort')).before(this);
	}

	if ($(this).attr('data-sort') > $('#tab-payment tr').length) {
		$('#tab-payment tr:last').after(this);
	}

	if ($(this).attr('data-sort') < -$('#tab-payment tr').length) {
		$('#tab-payment tr:first').before(this);
	}
});

$('#tab-shipping tr[data-sort]').detach().each(function() {
	if ($(this).attr('data-sort') >= 0 && $(this).attr('data-sort') <= $('#tab-shipping tr').length) {
		$('#tab-shipping tr').eq($(this).attr('data-sort')).before(this);
	}

	if ($(this).attr('data-sort') > $('#tab-shipping tr').length) {
		$('#tab-shipping tr:last').after(this);
	}

	if ($(this).attr('data-sort') < -$('#tab-shipping tr').length) {
		$('#tab-shipping tr:first').before(this);
	}
});
//--></script>



<script type="text/javascript" src="view/javascript/autolinker.min.js"></script>

<script>
$(document).ajaxStop(function() {
	$('.text-autolink').each(function(){
		var html = Autolinker.link($(this).html(), { newWindow: true });
		$(this).html(html).removeClass('text-autolink');
	});
});
</script>



<script type="text/javascript"><!--
var $inputNotify = $('#input-notify');
var $inputCorreios = $('#input-correios');
var $inputCodigoCorreios = $('#input-codigo-correios');

$inputNotify.on('click', function(){
	if (!this.checked) {
		$inputCorreios[0].checked = false;
		$inputCorreios.trigger('change');
	}
});

$inputCorreios.on('click change', function(){
	if (this.checked) {
		$inputCodigoCorreios[0].disabled = false;
		$inputCodigoCorreios.focus();
		$inputNotify[0].checked = true;
	} else {
		$inputCodigoCorreios[0].disabled = true;
	}
});

$inputCodigoCorreios.on('keyup', function(e){
	var allowedKeys = [
		8,   // backspace
		9,   // tab
		13,  // enter
		16,  // shift
		17,  // ctrl
		18,  // alt
		19,  // pause
		20,  // caps lock
		27,  // esc
		33,  // pg up
		34,  // pg down
		35,  // end
		36,  // home
		37,  // left
		38,  // up
		39,  // right
		40,  // down
		45,  // insert
		46,  // delete
		91,  // win (left)
		92,  // win (right)
		93,  // context
		112, // f1
		113, // f2
		114, // f3
		115, // f4
		116, // f5
		117, // f6
		118, // f7
		119, // f8
		120, // f9
		121, // f10
		122, // f11
		123, // f12
		144, // num lock
		145 // scroll lock
	];

	var code = e.keyCode ? e.keyCode : e.which;

	if (allowedKeys.indexOf(code) > -1) {
		return true;
	}

	var val = this.value.replace(/[^0-9a-z]/gi, '');
	this.value = val;
});

$inputCorreios.trigger('change');

function inserirCodigoCorreios(comment) {
	var notify = $inputNotify[0].checked;
	var correios = $inputCorreios[0].checked;
	var codigo_correios = $inputCodigoCorreios.val();

	if (notify && correios && codigo_correios != '') {
		comment = $.trim(comment);
		comment += '\n\n';
		comment += 'Segue o link para rastreamento da encomenda no site dos Correios:\n';
		comment += '<?php echo HTTP_CATALOG.'index.php?route=shipping/correios/rastreamento/'; ?>';
		comment += codigo_correios;
		comment += '\n\n';
		comment += 'Caso não consiga acompanhar pelo link acima, poderá consultar diretamente no site http://correios.com.br utilizando o seguinte código de rastreamento:\n';
		comment += codigo_correios;
		comment = $.trim(comment);
	}

	return comment;
}

function resetCodigoCorreios() {
	$inputCodigoCorreios.val('');
	$inputCorreios[0].checked = false;
	$inputCorreios.trigger('change');
}
//--></script>



<?php echo $footer; ?>
