<?php
$tab_parcelas = false;
if (!$error_token && !$error_key && $error_parcelas) { $tab_parcelas = true; }
?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<!-- Page Header -->
	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-moip" data-toggle="tooltip" title="Save" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="Cancel" class="btn btn-default"><i class="fa fa-reply"></i></a>
			</div>

			<h1><?php echo $heading_title; ?></h1>

			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<!-- Container -->
	<div class="container-fluid">

		<!-- Error -->
		<?php if ($error_warning) { ?>
		<div class="alert alert-danger">
			<i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<!-- Panel -->
		<div class="panel panel-default">

			<!-- Title -->
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>

			<!-- Body -->
			<div class="panel-body">

				<!-- Nav -->
				<ul class="nav nav-tabs">
					<li <?php if (!$tab_parcelas) { echo('class="active"'); } ?>><a data-toggle="tab" href="#config">Config</a></li>
					<li><a data-toggle="tab" href="#boleto">Boleto</a></li>
					<li <?php if ($tab_parcelas) { echo('class="active"'); } ?>><a data-toggle="tab" href="#cartao">Cartão</a></li>
					<li><a data-toggle="tab" href="#debito">Débito</a></li>
					<li><a data-toggle="tab" href="#payment-status"><?php echo $tab_status_payment; ?></a></li>
					<li><a data-toggle="tab" href="#debug">Debug</a></li>
				</ul>

				<!-- Form -->
				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-moip" class="form-horizontal">
					<div class="tab-content">

						<!-- Tab Config -->
						<div id="config" class="tab-pane <?php if (!$tab_parcelas) { echo('active'); } ?>">
							<!-- Token -->
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="moip_token"><?php echo $entry_token; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_token" id="moip_token" class="form-control" value="<?php echo $moip_token; ?>" />
									<?php if ($error_token) { ?>
										<div class="text-danger"><?php echo $error_token; ?></div>
									<?php } ?>
								</div>
							</div>

							<!-- Key -->
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="moip_key"><?php echo $entry_key; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_key" id="moip_key" class="form-control" value="<?php echo $moip_key; ?>" />
									<?php if ($error_key) { ?>
										<div class="text-danger"><?php echo $error_key; ?></div>
									<?php } ?>
								</div>
							</div>

							<!-- Modo de Teste -->
							<div class="form-group required">
								<label class="col-sm-2 control-label" for=""><?php echo $entry_modo_teste; ?></label>
								<div class="col-sm-10">
									<label class="radio-inline"><input type="radio" name="moip_modo_teste" value="1" <?php if ($moip_modo_teste) { echo('checked'); } ?> /> <?php echo $text_yes; ?></label>
									<label class="radio-inline"><input type="radio" name="moip_modo_teste" value="0" <?php if (!$moip_modo_teste) { echo('checked'); } ?> /> <?php echo $text_no; ?></label>
								</div>
							</div>

							<!-- Debug -->
							<div class="form-group required">
								<label class="col-sm-2 control-label" for=""><?php echo $entry_debug; ?></label>
								<div class="col-sm-10">
									<label class="radio-inline"><input type="radio" name="moip_debug" value="1" <?php if ($moip_debug) { echo('checked'); } ?> /> <?php echo $text_yes; ?></label>
									<label class="radio-inline"><input type="radio" name="moip_debug" value="0" <?php if (!$moip_debug) { echo('checked'); } ?> /> <?php echo $text_no; ?></label>
								</div>
							</div>

							<br>

							<!-- Área/Zona Geográfica -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_geo_zone; ?></label>
								<div class="col-sm-10">
									<select name="moip_geo_zone_id" class="form-control">
									<option value="0" <?php if ($moip_geo_zone_id == 0) { echo('selected'); } ?>><?php echo $text_all_zones; ?></option>
									<?php foreach ($zones as $zone) { ?>
										<option value="<?php echo $zone['geo_zone_id']; ?>" <?php if ($moip_geo_zone_id == $zone['geo_zone_id']) { echo('selected'); } ?>><?php echo $zone['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status -->
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="moip_status"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="moip_status" id="moip_status" class="form-control">
										<option value="1" <?php if ($moip_status) { echo('selected'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (!$moip_status) { echo('selected'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>

							<!-- Ordem -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_sort_order; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_sort_order" class="form-control" value="<?php echo $moip_sort_order; ?>" />
								</div>
							</div>
						</div>

						<!-- Tab Boleto -->
						<div id="boleto" class="tab-pane">
							<!-- Boleto -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="moip_boleto" class="form-control">
										<option value="1" <?php if ($moip_boleto) { echo('selected'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (!$moip_boleto) { echo('selected'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>

							<!-- Título -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_titulo; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_boleto_titulo" class="form-control" value="<?php echo $moip_boleto_titulo; ?>" />
								</div>
							</div>

							<!-- Desconto -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_desconto; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_desconto_boleto" class="form-control" value="<?php echo $moip_desconto_boleto; ?>" placeholder="Em porcentagem %" />
								</div>
							</div>

							<!-- Vencimento -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_boleto_vencimento; ?></label>
								<div class="col-sm-10">
									<input type="number" name="moip_boleto_vencimento" class="form-control" maxlength="2" step="1" min="1" max="99" value="<?php echo $moip_boleto_vencimento; ?>" />
								</div>
							</div>

							<!-- Instrução 1 -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_boleto_instrucao_1; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_boleto_instrucao_1" class="form-control" maxlength="60" value="<?php echo $moip_boleto_instrucao_1; ?>" />
								</div>
							</div>

							<!-- Instrução 2 -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_boleto_instrucao_2; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_boleto_instrucao_2" class="form-control" maxlength="60" value="<?php echo $moip_boleto_instrucao_2; ?>" />
								</div>
							</div>

							<!-- Instrução 3 -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_boleto_instrucao_3; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_boleto_instrucao_3" class="form-control" maxlength="60" value="<?php echo $moip_boleto_instrucao_3; ?>" />
								</div>
							</div>
						</div>

						<!-- Tab Cartão -->
						<div id="cartao" class="tab-pane <?php if ($tab_parcelas) { echo('active'); } ?>">
							<!-- Parcelas -->
							<?php if ($error_parcelas) { ?>
							<div class="alert alert-danger"><?php echo $error_parcelas; ?></div>
							<?php } ?>

							<!-- Cartão de Crédito -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="moip_cartao" class="form-control">
										<option value="1" <?php if ($moip_cartao_credito) { echo('selected'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (!$moip_cartao_credito) { echo('selected'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>

							<!-- Título -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_titulo; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_cartao_titulo" class="form-control" value="<?php echo $moip_cartao_titulo; ?>" />
								</div>
							</div>

							<!-- Desconto -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_desconto; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_desconto_cartao" class="form-control" value="<?php echo $moip_desconto_cartao; ?>" placeholder="Em porcentagem %" />
								</div>
							</div>

							<table class="table table-bordered table-hover table-striped" id="table-plot">
							<thead>
								<tr>
									<th><?php echo $entry_parcela_de; ?></th>
									<th><?php echo $entry_parcela_para; ?></th>
									<th><?php echo $entry_parcela_juros; ?></th>
									<th></th>
								</tr>
							</thead>
							<tbody>
								<?php $count_plot = 0; ?>
								<?php foreach ($moip_parcela as $parcela) { ?>
								<tr id="plot<?php echo $count_plot; ?>">
									<td>
										<select name="moip_parcela[<?php echo $count_plot; ?>][de]" class="number-plots form-control">
										<?php for ($i=2; $i<=12; $i++) { ?>
											<option value="<?php echo $i; ?>" <?php if ($parcela['de'] == $i) { echo('selected'); } ?>><?php echo $i; ?>x</option>
										<?php } ?>
										</select>
									</td>
									<td>
										<select name="moip_parcela[<?php echo $count_plot; ?>][para]" class="number-plots form-control">
										<?php for ($i=2; $i<=12; $i++) { ?>
											<option value="<?php echo $i; ?>" <?php if ($parcela['para'] == $i) { echo('selected'); } ?>><?php echo $i; ?>x</option>
										<?php } ?>
										</select>
									</td>
									<td><input type="text" name="moip_parcela[<?php echo $count_plot; ?>][juros]" class="form-control" value="<?php echo $parcela['juros']; ?>" placeholder="Em porcentagem %" /></td>
									<td class="text-right"><button type="button" class="btn btn-danger" onClick="$('#plot<?php echo $count_plot; ?>').remove();"><i class="fa fa-remove"></i></button></td>
								</tr>
								<?php $count_plot++; ?>
								<?php } ?>
							</tbody>
							<tfoot>
								<tr>
									<td colspan="4" class="text-right"><button type="button" id="add-plot" class="btn btn-primary"><i class="fa fa-plus"></i></button></td>
								</tr>
							</tfoot>
							</table>
						</div>

						<!-- Tab Débito -->
						<div id="debito" class="tab-pane">
							<!-- Débito Online -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="moip_debito" class="form-control">
										<option value="1" <?php if ($moip_debito) { echo('selected'); } ?>><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (!$moip_debito) { echo('selected'); } ?>><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>

							<!-- Título -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_titulo; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_debito_titulo" class="form-control" value="<?php echo $moip_debito_titulo; ?>" />
								</div>
							</div>

							<!-- Desconto -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_desconto; ?></label>
								<div class="col-sm-10">
									<input type="text" name="moip_desconto_debito" class="form-control" value="<?php echo $moip_desconto_debito; ?>" placeholder="Em porcentagem %" />
								</div>
							</div>
						</div>

						<!-- Tab Status de Pagamento -->
						<div id="payment-status" class="tab-pane">
							<!-- Notificar Cliente -->
							<div class="form-group required">
								<label class="col-sm-2 control-label"><?php echo $entry_notificar_cliente; ?></label>
								<div class="col-sm-10">
									<label class="radio-inline"><input type="radio" name="moip_notificar_cliente" value="1" <?php if ($moip_notificar_cliente) { echo('checked'); } ?> /> <?php echo $text_yes; ?></label>
									<label class="radio-inline"><input type="radio" name="moip_notificar_cliente" value="0" <?php if (!$moip_notificar_cliente) { echo('checked'); } ?> /> <?php echo $text_no; ?></label>
								</div>
							</div>

							<br>

							<!-- Status Iniciado -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_iniciado; ?></label>
								<div class="col-sm-10">
									<select name="moip_iniciado" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_iniciado == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Boleto Impresso -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_boleto_impresso; ?></label>
								<div class="col-sm-10">
									<select name="moip_boleto_impresso" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_boleto_impresso == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Em Análise -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_em_analise; ?></label>
								<div class="col-sm-10">
									<select name="moip_em_analise" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_em_analise == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Autorizado -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_autorizado; ?></label>
								<div class="col-sm-10">
									<select name="moip_autorizado" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_autorizado == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Completo -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_completo; ?></label>
								<div class="col-sm-10">
									<select name="moip_completo" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_completo == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Cancelado -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_cancelado; ?></label>
								<div class="col-sm-10">
									<select name="moip_cancelado" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_cancelado == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Revertido -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_revertido; ?></label>
								<div class="col-sm-10">
									<select name="moip_revertido" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_revertido == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Em Revisão -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_em_revisao; ?></label>
								<div class="col-sm-10">
									<select name="moip_em_revisao" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_em_revisao == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>

							<!-- Status Reembolsado -->
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_reembolsado; ?></label>
								<div class="col-sm-10">
									<select name="moip_reembolsado" class="form-control">
									<?php foreach ($statuses as $status) { ?>
										<option value="<?php echo $status['order_status_id']; ?>" <?php if ($moip_reembolsado == $status['order_status_id']) { echo('selected'); } ?>><?php echo $status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
						</div>

						<!-- Tab Debug -->
						<div id="debug" class="tab-pane">
							<?php /* ?><div class="alert alert-info">
								https://labs.moip.com.br/playground/
								<button class="close" data-dismiss="alert" type="button">&times;</button>
							</div><?php */ ?>
							<pre class="well" style="min-height:150px"><?php foreach ($debug as $value) { echo htmlspecialchars($value); } ?></pre>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript"><!--
$(function(){
	// $('.nav-tabs li:first').addClass('active');
	// $('.tab-content div:first').addClass('active');

	$('#add-plot').click(function(){
		var html = '';
		var count_plot = <?php echo (int)$count_plot; ?>;

		html += '<tr id="plot' + count_plot + '">';
		html += ' <td>';
		html += '   <select name="moip_parcela[' + count_plot + '][de]" class="number-plots form-control">';
		for (i=2; i<=12; i++) {
		html += '     <option value="' + i + '">' + i + 'x</option>';
		}
		html += '   </select>';
		html += ' </td>';
		html += ' <td>';
		html += '   <select name="moip_parcela[' + count_plot + '][para]" class="number-plots form-control">';
		for (i=2; i<=12; i++) {
		html += '     <option value="' + i + '">' + i + 'x</option>';
		}
		html += '   </select>';
		html += ' </td>';
		html += ' <td><input type="text" name="moip_parcela[' + count_plot + '][juros]" class="form-control" value="" placeholder="Em porcentagem %" /></td>';
		html += ' <td class="text-right"><button type="button" class="btn btn-danger" onClick="$(\'#plot' + count_plot + '\').remove();"><i class="fa fa-remove"></i></button></td>';
		html += '</tr>';

		$('#table-plot tbody').append(html);
	});
});
//-->
</script>

<?php echo $footer ?>