<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-cielo-cc" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-cielo-cc" class="form-horizontal">

					<ul class="nav nav-tabs">
						<li class="active"><a href="#tab-general" data-toggle="tab"><?php echo $tab_general; ?></a></li>
						<li><a href="#tab-status" data-toggle="tab"><?php echo $tab_order_status; ?></a></li>
					</ul>

					<div class="tab-content">
						<div class="tab-pane active" id="tab-general">
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_title; ?></label>
								<div class="col-sm-10">
									<?php foreach ($languages as $language) { ?>
									<div class="input-group">
										<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
										<input type="text" name="cielo_cc_title[<?php echo $language['language_id']; ?>]" placeholder="<?php echo $heading_title; ?>" class="form-control" value="<?php echo isset($cielo_cc_title[$language['language_id']]) ? $cielo_cc_title[$language['language_id']] : 'Cielo (Cartão de Crédito/Débito ou Boleto)'; ?>">
									</div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-total"><span data-toggle="tooltip" title="<?php echo $help_total; ?>"><?php echo $entry_total; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_cc_total" value="<?php echo $cielo_cc_total; ?>" placeholder="<?php echo $entry_total; ?>" id="input-total" class="form-control" />
								</div>
							</div>
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-merchant-id"><span data-toggle="tooltip" title="<?php echo $help_merchant_id; ?>"><?php echo $entry_merchant_id; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_cc_merchant_id" value="<?php echo $cielo_cc_merchant_id; ?>" placeholder="<?php echo $entry_merchant_id; ?>" id="input-merchant-id" class="form-control" />
									<?php if ($error_merchant_id) { ?>
									<div class="text-danger"><?php echo $error_merchant_id; ?></div>
									<?php } ?>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-geo-zone"><?php echo $entry_geo_zone; ?></label>
								<div class="col-sm-10">
									<select name="cielo_cc_geo_zone_id" id="input-geo-zone" class="form-control">
									<option value="0"><?php echo $text_all_zones; ?></option>
									<?php foreach ($geo_zones as $geo_zone) { ?>
										<option value="<?php echo $geo_zone['geo_zone_id']; ?>" <?php if ($geo_zone['geo_zone_id'] == $cielo_cc_geo_zone_id) { echo('selected'); } ?>><?php echo $geo_zone['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="cielo_cc_status" id="input-status" class="form-control">
									<option value="1" <?php if ($cielo_cc_status == '1') { echo('selected'); } ?> ><?php echo $text_enabled; ?></option>
									<option value="0" <?php if ($cielo_cc_status == '0') { echo('selected'); } ?> ><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_cc_sort_order" value="<?php echo $cielo_cc_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
								</div>
							</div>

							<div style="margin: 30px 0; padding:10px; background:#d00; color:#fff;">
								<strong style="color:#ff0;">IMPORTANTE!</strong> Para o correto funcionamento deste módulo é necessário configurar também o
								<a href="https://cieloecommerce.cielo.com.br/Backoffice" target="_blank" style="color:#fff; text-decoration:underline;">Backoffice da Cielo</a>
								de acordo com os campos abaixo.
							</div>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-url-retorno"><span data-toggle="tooltip" title="<?php echo $help_url_retorno; ?>"><?php echo $entry_url_retorno; ?></span></label>
								<div class="col-sm-10">
									<input type="text" readonly="readonly" value="<?php echo HTTP_CATALOG . 'index.php?route=payment/cielo_cc/retorno'; ?>" id="input-url-retorno" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-url-notificacao"><span data-toggle="tooltip" title="<?php echo $help_url_notificacao; ?>"><?php echo $entry_url_notificacao; ?></span></label>
								<div class="col-sm-10">
									<input type="text" readonly="readonly" value="<?php echo HTTP_CATALOG . 'index.php?route=payment/cielo_cc/notificacao'; ?>" id="input-url-notificacao" class="form-control" />
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-url-status"><span data-toggle="tooltip" title="<?php echo $help_url_status; ?>"><?php echo $entry_url_status; ?></span></label>
								<div class="col-sm-10">
									<input type="text" readonly="readonly" value="<?php echo HTTP_CATALOG . 'index.php?route=payment/cielo_cc/status'; ?>" id="input-url-status" class="form-control" />
								</div>
							</div>
						</div>

						<div class="tab-pane" id="tab-status">
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-update-status"><span data-toggle="tooltip" title="<?php echo $help_update_status_alert; ?>"><?php echo $entry_update_status_alert; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_update_status_alert" id="input-update-status" class="form-control">
									<option value="1" <?php if ($cielo_cc_update_status_alert == '1') { echo('selected'); } ?> ><?php echo $text_yes; ?></option>
									<option value="0" <?php if ($cielo_cc_update_status_alert == '0') { echo('selected'); } ?> ><?php echo $text_no; ?></option>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-order-aguardando"><span data-toggle="tooltip" title="<?php echo $help_order_aguardando; ?>"><?php echo $entry_order_aguardando; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_aguardando" id="input-order-aguardando" class="form-control">
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_aguardando) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-pendente"><span data-toggle="tooltip" title="<?php echo $help_order_pendente; ?>"><?php echo $entry_order_pendente; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_pendente" id="input-order-pendente" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_pendente) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-autorizado"><span data-toggle="tooltip" title="<?php echo $help_order_autorizado; ?>"><?php echo $entry_order_autorizado; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_autorizado" id="input-order-autorizado" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_autorizado) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-pago"><span data-toggle="tooltip" title="<?php echo $help_order_pago; ?>"><?php echo $entry_order_pago; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_pago" id="input-order-pago" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_pago) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-negado"><span data-toggle="tooltip" title="<?php echo $help_order_negado; ?>"><?php echo $entry_order_negado; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_negado" id="input-order-negado" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_negado) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-cancelado"><span data-toggle="tooltip" title="<?php echo $help_order_cancelado; ?>"><?php echo $entry_order_cancelado; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_cancelado" id="input-order-cancelado" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_cancelado) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-order-nao-finalizado"><span data-toggle="tooltip" title="<?php echo $help_order_nao_finalizado; ?>"><?php echo $entry_order_nao_finalizado; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_cc_order_nao_finalizado" id="input-order-nao-finalizado" class="form-control">
									<option value=""><?php echo $text_nao_mudar_status; ?></option>
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_cc_order_nao_finalizado) { echo('selected'); } ?> ><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
						</div>
					</div>

				</form>

			</div>
		</div>

	</div>
</div>

<script>
$(document).ready(function() {
	$("input[type=text][readonly]")
	.focus(function () { $(this).select(); })
	.mouseup(function (e) { e.preventDefault(); });
});
</script>

<?php echo $footer; ?>