<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-cielo" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-cielo" class="form-horizontal">

					<?php if ($error_cartoes) { ?>
						<div style="margin:0 0 20px 0;"><span class="error"><strong><?php echo $error_cartoes; ?></strong></span></div>
					<?php } ?>

					<ul class="nav nav-tabs">
						<li class="active"><a href="#tab-general" data-toggle="tab"><?php echo $tab_general; ?></a></li>
						<li><a href="#tab-cards" data-toggle="tab"><?php echo $tab_cards; ?></a></li>
						<li><a href="#tab-status" data-toggle="tab"><?php echo $tab_status; ?></a></li>
					</ul>

					<div class="tab-content">

						<div class="tab-pane active" id="tab-general">
							<div class="form-group">
								<label class="col-sm-2 control-label"><?php echo $entry_title; ?></label>
								<div class="col-sm-10">
									<?php foreach ($languages as $language) { ?>
									<div class="input-group">
										<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
										<input type="text" name="cielo_title[<?php echo $language['language_id']; ?>]" placeholder="<?php echo $heading_title; ?>" class="form-control" value="<?php echo isset($cielo_title[$language['language_id']]) ? $cielo_title[$language['language_id']] : ''; ?>">
									</div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-total"><span data-toggle="tooltip" title="<?php echo $help_total; ?>"><?php echo $entry_total; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_total" value="<?php echo $cielo_total; ?>" placeholder="<?php echo $entry_total; ?>" id="input-total" class="form-control" />
									<?php if ($error_total) { ?>
									<div class="text-danger"><?php echo $error_total; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-afiliacao"><span data-toggle="tooltip" title="<?php echo $help_afiliacao; ?>"><?php echo $entry_afiliacao; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_afiliacao" value="<?php echo $cielo_afiliacao; ?>" placeholder="<?php echo $entry_afiliacao; ?>" id="input-afiliacao" class="form-control" />
									<?php if ($error_afiliacao) { ?>
									<div class="text-danger"><?php echo $error_afiliacao; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group required">
								<label class="col-sm-2 control-label" for="input-chave"><span data-toggle="tooltip" title="<?php echo $help_chave; ?>"><?php echo $entry_chave; ?></span></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_chave" value="<?php echo $cielo_chave; ?>" placeholder="<?php echo $entry_chave; ?>" id="input-chave" class="form-control" />
									<?php if ($error_chave) { ?>
									<div class="text-danger"><?php echo $error_chave; ?></div>
									<?php } ?>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-ambiente"><span data-toggle="tooltip" title="<?php echo $help_ambiente; ?>"><?php echo $entry_ambiente; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_ambiente" id="input-status" class="form-control">
									<option value="0" <?php if ($cielo_ambiente == '0') { echo('selected'); } ?> ><?php echo $text_ambiente_testes; ?></option>
									<option value="1" <?php if ($cielo_ambiente == '1') { echo('selected'); } ?> ><?php echo $text_ambiente_venda; ?></option>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-geo-zone"><?php echo $entry_geo_zone; ?></label>
								<div class="col-sm-10">
									<select name="cielo_geo_zone_id" id="input-geo-zone" class="form-control">
									<option value="0"><?php echo $text_all_zones; ?></option>
									<?php foreach ($geo_zones as $geo_zone) { ?>
										<option value="<?php echo $geo_zone['geo_zone_id']; ?>" <?php if ($geo_zone['geo_zone_id'] == $cielo_geo_zone_id) { echo('selected'); } ?>><?php echo $geo_zone['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
								<div class="col-sm-10">
									<select name="cielo_status" id="input-status" class="form-control">
									<option value="1" <?php if ($cielo_status == '1') { echo('selected'); } ?> ><?php echo $text_enabled; ?></option>
									<option value="0" <?php if ($cielo_status == '0') { echo('selected'); } ?> ><?php echo $text_disabled; ?></option>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
								<div class="col-sm-10">
									<input type="text" name="cielo_sort_order" value="<?php echo $cielo_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
								</div>
							</div>
						</div>

						<div class="tab-pane" id="tab-cards">
							<div class="col-sm-2">
								<ul class="nav nav-pills nav-stacked">
									<?php $count_tabs = 0; ?>
									<?php foreach($cartoes as $cartao){ ?>
										<li <?php if ($count_tabs == 0) { echo('class="active"'); } ?>>
											<a href="#tab-<?php echo $cartao; ?>" data-toggle="tab" <?php if (${"error_{$cartao}"} === TRUE) { echo('style="color:#f00;"'); } ?>>
												<?php if (${"error_{$cartao}"} === TRUE) { echo('** '); } ?>
												<?php echo $tab_names[$cartao]; ?>
											</a>
										</li>
										<?php $count_tabs++; ?>
									<?php } ?>
								</ul>
							</div>

							<div class="col-sm-10">
								<div class="tab-content">
									<?php $count_tabs = 0; ?>
									<?php foreach($cartoes as $cartao){ ?>
									<div class="tab-pane <?php if ($count_tabs == 0) { echo('active'); } ?>" id="tab-<?php echo $cartao; ?>">
										<div>
											<img src="../image/cielo/logo-<?php echo $cartao; ?>-mini.png" hspace="0" vspace="0" border="0" style="margin:0 8px 0 0; vertical-align:middle;">
											<strong><?php echo $title_names[$cartao]; ?></strong>
										</div>

										<br>

										<div class="form-group">
											<label class="col-sm-2 control-label" for="input-ativar-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo ${"help_ativar_{$cartao}"}; ?>"><?php echo ${"entry_ativar_{$cartao}"}; ?></span></label>
											<div class="col-sm-10">
												<select name="<?php echo "cielo_{$cartao}_ativar"; ?>" id="input-ativar-<?php echo $cartao; ?>" class="form-control">
												<option value="0" <?php if (${"cielo_{$cartao}_ativar"} == '0') { echo('selected'); } ?>><?php echo $text_no; ?></option>
												<option value="1" <?php if (${"cielo_{$cartao}_ativar"} == '1') { echo('selected'); } ?>><?php echo $text_yes; ?></option>
												</select>
											</div>
										</div>

										<div class="ativado">
											<br>

											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-captura-automatica-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_captura_automatica; ?>"><?php echo $entry_captura_automatica; ?></span></label>
												<div class="col-sm-10">
													<select name="<?php echo "cielo_{$cartao}_captura_automatica"; ?>" id="input-captura-automatica-<?php echo $cartao; ?>" class="form-control">
													<option value="1" <?php if (${"cielo_{$cartao}_captura_automatica"} == '1') { echo('selected'); } ?>><?php echo $text_yes; ?></option>
													<option value="0" <?php if (${"cielo_{$cartao}_captura_automatica"} == '0') { echo('selected'); } ?>><?php echo $text_no; ?></option>
													</select>
												</div>
											</div>
											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-tipo-autorizacao-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_tipo_autorizacao; ?>"><?php echo $entry_tipo_autorizacao; ?></span></label>
												<div class="col-sm-10">
													<select name="<?php echo "cielo_{$cartao}_tipo_autorizacao"; ?>" id="input-tipo-autorizacao-<?php echo $cartao; ?>" class="form-control">
													<?php foreach ($GLOBALS['CIELO_TIPOS_AUTORIZACAO'] as $tipo_autorizacao) { ?>
													<option value="<?php echo $tipo_autorizacao; ?>" <?php if (${"cielo_{$cartao}_tipo_autorizacao"} == $tipo_autorizacao) { echo('selected'); } ?>><?php echo ${"text_tipo_autorizacao_{$tipo_autorizacao}"}; ?></option>
													<?php } ?>
													</select>
												</div>
											</div>

											<br>

											<div class="form-group required">
												<label class="col-sm-2 control-label" for="input-valor-minimo-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_valor_minimo; ?>"><?php echo $entry_valor_minimo; ?></span></label>
												<div class="col-sm-10">
													<input type="text" name="<?php echo "cielo_{$cartao}_valor_minimo"; ?>" value="<?php echo ${"cielo_{$cartao}_valor_minimo"}; ?>" placeholder="<?php echo $entry_valor_minimo; ?>" id="input-valor-minimo-<?php echo $cartao; ?>" class="form-control" />
													<?php if (${"error_{$cartao}_valor_minimo"}) { ?>
													<span class="text-danger"><?php echo ${"error_{$cartao}_valor_minimo"}; ?></span>
													<?php } ?>
												</div>
											</div>
											<div class="form-group required">
												<label class="col-sm-2 control-label" for="input-desconto-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_desconto; ?>"><?php echo $entry_desconto; ?></span></label>
												<div class="col-sm-10">
													<div class="input-group">
      													<div class="input-group-addon">%</div>
														<input type="text" name="<?php echo "cielo_{$cartao}_desconto"; ?>" value="<?php echo ${"cielo_{$cartao}_desconto"}; ?>" placeholder="<?php echo $entry_desconto; ?>" id="input-desconto-<?php echo $cartao; ?>" maxlength="5" class="form-control" />
      												</div>
													<?php if (${"error_{$cartao}_desconto"}) { ?>
													<span class="text-danger"><?php echo ${"error_{$cartao}_desconto"}; ?></span>
													<?php } ?>
												</div>
											</div>

											<br>

											<div class="form-group">
												<label class="col-sm-2 control-label" for="input-parcelamento-<?php echo $cartao; ?>"><?php echo $entry_parcelamento; ?></label>
												<div class="col-sm-10">
													<select name="<?php echo "cielo_{$cartao}_parcelamento"; ?>" id="input-parcelamento-<?php echo $cartao; ?>" class="form-control">
													<option value="0" <?php if (${"cielo_{$cartao}_parcelamento"} == '0') { echo('selected'); } ?>><?php echo $text_no; ?></option>
													<option value="1" <?php if (${"cielo_{$cartao}_parcelamento"} == '1') { echo('selected'); } ?>><?php echo $text_yes; ?></option>
													</select>
												</div>
											</div>

											<div class="parcelamento-opcoes">
												<div class="form-group required">
													<label class="col-sm-2 control-label" for="input-parcela-minima-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_parcela_minima; ?>"><?php echo $entry_parcela_minima; ?></span></label>
													<div class="col-sm-10">
														<input type="text" name="<?php echo "cielo_{$cartao}_parcela_minima"; ?>" value="<?php echo ${"cielo_{$cartao}_parcela_minima"}; ?>" placeholder="<?php echo $entry_parcela_minima; ?>" id="input-parcela-minima-<?php echo $cartao; ?>" class="form-control" />
	      												<?php if (${"error_{$cartao}_parcela_minima"}) { ?>
														<span class="error"><?php echo ${"error_{$cartao}_parcela_minima"}; ?></span>
														<?php } ?>
													</div>
												</div>
												<div class="form-group required">
													<label class="col-sm-2 control-label" for="input-max-parcelas-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_max_parcelas; ?>"><?php echo $entry_max_parcelas; ?></span></label>
													<div class="col-sm-10">
														<input type="text" name="<?php echo "cielo_{$cartao}_max_parcelas"; ?>" value="<?php echo ${"cielo_{$cartao}_max_parcelas"}; ?>" placeholder="<?php echo $entry_max_parcelas; ?>" id="input-max-parcelas-<?php echo $cartao; ?>" maxlength="2" class="form-control" />
	      												<?php if (${"error_{$cartao}_max_parcelas"}) { ?>
														<span class="error"><?php echo ${"error_{$cartao}_max_parcelas"}; ?></span>
														<?php } ?>
													</div>
												</div>
												<div class="form-group required">
													<label class="col-sm-2 control-label" for="input-parcelas-sem-juros-<?php echo $cartao; ?>"><?php echo $entry_parcelas_sem_juros; ?></label>
													<div class="col-sm-10">
														<input type="text" name="<?php echo "cielo_{$cartao}_parcelas_sem_juros"; ?>" value="<?php echo ${"cielo_{$cartao}_parcelas_sem_juros"}; ?>" placeholder="<?php echo $entry_parcelas_sem_juros; ?>" id="input-parcelas-sem-juros-<?php echo $cartao; ?>" maxlength="2" class="form-control" />
	      												<?php if (${"error_{$cartao}_parcelas_sem_juros"}) { ?>
														<span class="error"><?php echo ${"error_{$cartao}_parcelas_sem_juros"}; ?></span>
														<?php } ?>
													</div>
												</div>
												<div class="form-group required">
													<label class="col-sm-2 control-label" for="input-parcelas-juros-loja-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_parcelas_juros_loja; ?>"><?php echo $entry_parcelas_juros_loja; ?></span></label>
													<div class="col-sm-10">
														<input type="text" name="<?php echo "cielo_{$cartao}_parcelas_juros_loja"; ?>" value="<?php echo ${"cielo_{$cartao}_parcelas_juros_loja"}; ?>" placeholder="<?php echo $entry_parcelas_juros_loja; ?>" id="input-parcelas-juros-loja-<?php echo $cartao; ?>" maxlength="2" class="form-control" />
	      												<?php if (${"error_{$cartao}_parcelas_juros_loja"}) { ?>
														<span class="error"><?php echo ${"error_{$cartao}_parcelas_juros_loja"}; ?></span>
														<?php } ?>
													</div>
												</div>
												<div class="form-group required">
													<label class="col-sm-2 control-label" for="input-juros-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_juros; ?>"><?php echo $entry_juros; ?></span></label>
													<div class="col-sm-10">
														<div class="input-group">
	      													<div class="input-group-addon">%</div>
															<input type="text" name="<?php echo "cielo_{$cartao}_juros"; ?>" value="<?php echo ${"cielo_{$cartao}_juros"}; ?>" placeholder="<?php echo $entry_juros; ?>" id="input-juros-<?php echo $cartao; ?>" maxlength="5" class="form-control" />
	      												</div>
	      												<?php if (${"error_{$cartao}_juros"}) { ?>
														<span class="error"><?php echo ${"error_{$cartao}_juros"}; ?></span>
														<?php } ?>
													</div>
												</div>
												<div class="form-group">
													<label class="col-sm-2 control-label" for="input-calculo-juros-<?php echo $cartao; ?>"><span data-toggle="tooltip" title="<?php echo $help_calculo_juros; ?>"><?php echo $entry_calculo_juros; ?></span></label>
													<div class="col-sm-10">
														<select name="<?php echo "cielo_{$cartao}_calculo_juros"; ?>" id="input-calculo-juros-<?php echo $cartao; ?>" class="form-control">
														<option value="1" <?php if(${"cielo_{$cartao}_calculo_juros"} == '1'){ echo('selected'); } ?> ><?php echo $text_calculo_juros_1; ?></option>
														<option value="2" <?php if(${"cielo_{$cartao}_calculo_juros"} == '2'){ echo('selected'); } ?> ><?php echo $text_calculo_juros_2; ?></option>
														<option value="3" <?php if(${"cielo_{$cartao}_calculo_juros"} == '3'){ echo('selected'); } ?> ><?php echo $text_calculo_juros_3; ?></option>
														</select>
													</div>
												</div>
											</div>
										</div>
									</div>
									<?php $count_tabs++; ?>
									<?php } ?>
								</div>
							</div>
						</div>

						<div class="tab-pane" id="tab-status">
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-update-status"><span data-toggle="tooltip" title="<?php echo $help_update_status_alert; ?>"><?php echo $entry_update_status_alert; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_update_status_alert" id="input-update-status" class="form-control">
									<option value="1" <?php if ($cielo_update_status_alert == '1') { echo('selected'); } ?> ><?php echo $text_yes; ?></option>
									<option value="0" <?php if ($cielo_update_status_alert == '0') { echo('selected'); } ?> ><?php echo $text_no; ?></option>
									</select>
								</div>
							</div>

							<br>

							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status-pendente"><span data-toggle="tooltip" title="<?php echo $help_status_pendente; ?>"><?php echo $entry_status_pendente; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_status_pendente" id="input-status-pendente" class="form-control">
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_status_pendente) { echo('selected'); } ?>><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status-aprovada"><span data-toggle="tooltip" title="<?php echo $help_status_aprovada; ?>"><?php echo $entry_status_aprovada; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_status_aprovada" id="input-status-aprovada" class="form-control">
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_status_aprovada) { echo('selected'); } ?>><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
							<div class="form-group">
								<label class="col-sm-2 control-label" for="input-status-nao-aprovada"><span data-toggle="tooltip" title="<?php echo $help_status_nao_aprovada; ?>"><?php echo $entry_status_nao_aprovada; ?></span></label>
								<div class="col-sm-10">
									<select name="cielo_status_nao_aprovada" id="input-status-nao-aprovada" class="form-control">
									<?php foreach ($order_statuses as $order_status) { ?>
										<option value="<?php echo $order_status['order_status_id']; ?>" <?php if ($order_status['order_status_id'] == $cielo_status_nao_aprovada) { echo('selected'); } ?>><?php echo $order_status['name']; ?></option>
									<?php } ?>
									</select>
								</div>
							</div>
						</div>

					</div>

				</form>

			</div>
		</div>

	</div>
</div>

<script type="text/javascript"><!--
$('#tab-cards .tab-pane').each(function(){
	var $this = $(this);
	var $ativar = $this.find('select[name$=ativar]');
	var $parcelamento = $this.find('select[name$=parcelamento]');
	var $divAtivado = $this.find('.ativado').hide();
	var $divParcelamentoOpcoes = $this.find('.parcelamento-opcoes').hide();

	$ativar.change(function(){
		var ativar = $(this).val();
		if(ativar == '1'){
			$divAtivado.stop(true,true).slideDown();
		}else{
			$divAtivado.stop(true,true).slideUp();
		}
		$parcelamento.trigger('change');
	});

	$parcelamento.change(function(){
		var ativar = $ativar.val();
		var parcelamento = $(this).val();
		if(parcelamento == '1'){
			$divParcelamentoOpcoes.stop(true,true).slideDown();
		}else{
			$divParcelamentoOpcoes.stop(true,true).slideUp();
		}
	});

	$ativar.change();
});
//--></script>

<?php echo $footer; ?>