<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
	<div class="page-header">
		<div class="container-fluid">
			<div class="pull-right">
				<button type="submit" form="form-iconsocial" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
				<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>
	<div class="container-fluid">
		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>
		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
			</div>
			<div class="panel-body">

				<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-iconsocial" class="form-horizontal">

					<div class="form-group required">
						<label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
						<div class="col-sm-10">
							<select name="iconsocial_config[status]" id="input-status" class="form-control">
								<option value="0" <?php if (isset($iconsocial_config['status']) && $iconsocial_config['status'] == '0') { echo('selected'); } ?> ><?php echo $text_disabled; ?></option>
								<option value="1" <?php if (isset($iconsocial_config['status']) && $iconsocial_config['status'] == '1') { echo('selected'); } ?> ><?php echo $text_enabled; ?></option>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label"><?php echo $entry_title; ?></label>
						<div class="col-sm-10">
							<?php foreach ($languages as $language) { ?>
								<div class="input-group">
									<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
									<input type="text" name="iconsocial_config[title][<?php echo $language['language_id']; ?>]" value="<?php echo isset($iconsocial_config['title'][$language['language_id']]) ? $iconsocial_config['title'][$language['language_id']] : ''; ?>" placeholder="<?php echo $entry_title; ?>" class="form-control" />
								</div>
							<?php } ?>
						</div>
					</div>
					<div class="form-group required">
						<label class="col-sm-2 control-label" for="input-style"><?php echo $entry_style; ?></label>
						<div class="col-sm-10">
							<select name="iconsocial_config[style]" id="input-style" class="form-control">
								<option value="1" <?php if (isset($iconsocial_config['style']) && $iconsocial_config['style'] == '1') { echo('selected'); } ?> ><?php echo $entry_style_opt1; ?></option>
								<option value="2" <?php if (isset($iconsocial_config['style']) && $iconsocial_config['style'] == '2') { echo('selected'); } ?> ><?php echo $entry_style_opt2; ?></option>
							</select>
						</div>
					</div>

					<table id="module" class="table table-striped table-bordered table-hover">
						<thead>
							<tr>
								<td class="text-left" style="width: 25%;"><?php echo $column_title; ?></td>
								<td class="text-left" style="width: 25%;"><?php echo $column_url; ?></td>
								<td class="text-left" style="width: 10%;"><?php echo $column_icon; ?></td>
								<td class="text-left" style="width: 20%;"><?php echo $column_size; ?></td>
								<td class="text-left" style="width: 15%;"><?php echo $column_status; ?></td>
								<td class="text-right" style="width: 5%;"><?php echo $column_sort_order; ?></td>
								<td></td>
							</tr>
						</thead>
						<tbody>
							<?php $module_row = 0; ?>
							<?php foreach ($iconsocial_modules as $module) { ?>
							<tr id="module-row<?php echo $module_row; ?>">
								<td class="text-left">
									<?php foreach ($languages as $language) { ?>
										<div class="input-group">
											<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>
											<input type="text" name="iconsocial_config[modules][<?php echo $module_row; ?>][title][<?php echo $language['language_id']; ?>]" value="<?php echo isset($module['title'][$language['language_id']]) ? $module['title'][$language['language_id']] : ''; ?>" placeholder="<?php echo $entry_title; ?>" class="form-control" />
										</div>
									<?php } ?>
								</td>
								<td class="text-left">
									<input type="text" name="iconsocial_config[modules][<?php echo $module_row; ?>][link]" value="<?php echo isset($module['link']) ? $module['link'] : ''; ?>" placeholder="http://" class="form-control" />
								</td>
								<td class="text-left">
									<a href="" id="thumb-image<?php echo $module_row; ?>" data-toggle="image" class="img-thumbnail"><img src="<?php echo $module['thumb']; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /></a>
									<input type="hidden" name="iconsocial_config[modules][<?php echo $module_row; ?>][icon]" value="<?php echo $module['icon']; ?>" id="input-image<?php echo $module_row; ?>" />
								</td>
								<td class="text-left form-inline">
									<?php echo $entry_width; ?> x <?php echo $entry_height; ?><br>
									<input type="text" name="iconsocial_config[modules][<?php echo $module_row; ?>][width]" size="4" value="<?php echo isset($module['width']) ? $module['width'] : ''; ?>" placeholder="<?php echo $entry_width; ?>" class="form-control" /> x
									<input type="text" name="iconsocial_config[modules][<?php echo $module_row; ?>][height]" size="4" value="<?php echo isset($module['height']) ? $module['height'] : ''; ?>" placeholder="<?php echo $entry_height; ?>" class="form-control" /> px
								</td>
								<td class="text-left">
									<select name="iconsocial_config[modules][<?php echo $module_row; ?>][status]" class="form-control">
										<option value="1" <?php if (isset($module['status']) && $module['status'] == '1') { echo('selected'); } ?> ><?php echo $text_enabled; ?></option>
										<option value="0" <?php if (isset($module['status']) && $module['status'] == '0') { echo('selected'); } ?> ><?php echo $text_disabled; ?></option>
									</select>
								</td>
								<td class="text-left">
									<input type="text" name="iconsocial_config[modules][<?php echo $module_row; ?>][sort_order]" value="<?php echo isset($module['sort_order']) ? $module['sort_order'] : ''; ?>" class="form-control" />
								</td>
								<td class="text-left"><button type="button" onclick="$('#module-row<?php echo $module_row; ?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
							</tr>
							<?php $module_row++; ?>
							<?php } ?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="6"></td>
								<td class="text-left"><button type="button" onclick="addModule();" data-toggle="tooltip" title="<?php echo $button_module_add; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
							</tr>
						</tfoot>
					</table>

				</form>

			</div>
		</div>
	</div>
</div>

<script type="text/javascript"><!--
var module_row = <?php echo $module_row; ?>;

function addModule() {
	html  = '<tr id="module-row' + module_row + '">';
	html += '	<td class="text-left">';
	<?php foreach ($languages as $language) { ?>
	html += '			<div class="input-group">';
	html += '				<span class="input-group-addon"><img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" /></span>';
	html += '				<input type="text" name="iconsocial_config[modules][' + module_row + '][title][<?php echo $language['language_id']; ?>]" value="" placeholder="<?php echo $entry_title; ?>" class="form-control" />';
	html += '			</div>';
	<?php } ?>
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="iconsocial_config[modules][' + module_row + '][link]" value="" placeholder="http://" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<a href="" id="thumb-image' + module_row + '" data-toggle="image" class="img-thumbnail"><img src="<?php echo $placeholder; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /></a>';
	html += '		<input type="hidden" name="iconsocial_config[modules][' + module_row + '][icon]" value="" id="input-image' + module_row + '" />';
	html += '	</td>';
	html += '	<td class="text-left form-inline">';
	html += '		<?php echo $entry_width; ?> x <?php echo $entry_height; ?><br>';
	html += '		<input type="text" name="iconsocial_config[modules][' + module_row + '][width]" size="4" value="24" placeholder="<?php echo $entry_width; ?>" class="form-control" /> x';
	html += '		<input type="text" name="iconsocial_config[modules][' + module_row + '][height]" size="4" value="24" placeholder="<?php echo $entry_height; ?>" class="form-control" /> px';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<select name="iconsocial_config[modules][' + module_row + '][status]" class="form-control">';
	html += '			<option value="1"><?php echo $text_enabled; ?></option>';
	html += '			<option value="0"><?php echo $text_disabled; ?></option>';
	html += '		</select>';
	html += '	</td>';
	html += '	<td class="text-left">';
	html += '		<input type="text" name="iconsocial_config[modules][' + module_row + '][sort_order]" value="" class="form-control" />';
	html += '	</td>';
	html += '	<td class="text-left"><button type="button" onclick="$(\'#module-row' + module_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
	html += '</tr>';

	$('#module tbody').append(html);

	module_row++;
}

<?php if ($module_row == 0) { ?>
	addModule();
<?php } ?>
//--></script>

<?php echo $footer; ?>