<?php

$admin_username = $this->registry->get('user')->getUserName();

function is_locked($edit_url) {
	if (substr(HTTP_SERVER, 0, 5) == 'https') {
		return false;
	}

	$is_locked = false;
	if (strpos($edit_url, 'cielo') !== false) { $is_locked = true; }
	if (strpos($edit_url, 'moip') !== false) { $is_locked = true; }
	if (strpos($edit_url, 'mp_transparente') !== false) { $is_locked = true; }
	if (strpos($edit_url, 'pagar_me') !== false) { $is_locked = true; }
	if (strpos($edit_url, 'pagseguro_credit_card') !== false) { $is_locked = true; }
	if (strpos($edit_url, 'redepay') !== false) { $is_locked = true; }

	return $is_locked;
}

?>
<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">

	<div class="page-header">
		<div class="container-fluid">
			<h1><?php echo $heading_title; ?></h1>
			<ul class="breadcrumb">
				<?php foreach ($breadcrumbs as $breadcrumb) { ?>
				<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="container-fluid">

		<?php if ($error_warning) { ?>
		<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<?php if ($success) { ?>
		<div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
			<button type="button" class="close" data-dismiss="alert">&times;</button>
		</div>
		<?php } ?>

		<div class="panel panel-default">

			<div class="panel-heading">
				<h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $text_list; ?></h3>
			</div>

			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover">
					<thead>
						<tr>
							<td class="text-left"><?php echo $column_name; ?></td>
							<td></td>
							<td class="text-left"><?php echo $column_status; ?></td>
							<td class="text-right"><?php echo $column_sort_order; ?></td>
							<td class="text-right"><?php echo $column_action; ?></td>
						</tr>
					</thead>
					<tbody>
						<?php if ($extensions) { ?>
						<?php foreach ($extensions as $extension) { ?>
						<tr>
							<td class="text-left"><?php echo $extension['name']; ?></td>
							<td class="text-center"><?php echo $extension['link'] ?></td>
							<td class="text-left"><?php echo $extension['status'] ?></td>
							<td class="text-right"><?php echo $extension['sort_order']; ?></td>
							<td class="text-right">
								<?php

								$is_locked = is_locked($extension['edit']);

								if ($is_locked) {
									$class = ($admin_username == 'devhdw') ? 'btn-sm' : '';
									if ($admin_username == 'devhdw') { echo('('); }
									?>
									<a href="http://www.hoteldaweb.com.br/ssl-conexao-segura" target="_blank" data-toggle="tooltip" title="<?php echo $button_install; ?>" onclick="return showModalSSL(event, '<?php echo $extension['name']; ?>');" class="btn <?php echo $class; ?> btn-success"><i class="fa fa-plus-circle"></i></a>
									<button type="button" class="btn <?php echo $class; ?> btn-primary" disabled="disabled"><i class="fa fa-pencil"></i></button>
									<?php
									if ($admin_username == 'devhdw') { echo(') &nbsp; '); }
								}

								if (!$is_locked || $admin_username == 'devhdw') {
									if (!$extension['installed']) {
										?><a href="<?php echo $extension['install']; ?>" data-toggle="tooltip" title="<?php echo $button_install; ?>" class="btn btn-success"><i class="fa fa-plus-circle"></i></a> <?php
									} else {
										?><a onclick="confirm('<?php echo $text_confirm; ?>') ? location.href='<?php echo $extension['uninstall']; ?>' : false;" data-toggle="tooltip" title="<?php echo $button_uninstall; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></a> <?php
									}

									if ($extension['installed']) {
										?><a href="<?php echo $extension['edit']; ?>" data-toggle="tooltip" title="<?php echo $button_edit; ?>" class="btn btn-primary"><i class="fa fa-pencil"></i></a><?php
									} else {
										?><button type="button" class="btn btn-primary" disabled="disabled"><i class="fa fa-pencil"></i></button><?php
									}
								}

								?>
							</td>
						</tr>
						<?php } ?>
						<?php } else { ?>
						<tr>
							<td class="text-center" colspan="6"><?php echo $text_no_results; ?></td>
						</tr>
						<?php } ?>
					</tbody>
					</table>
				</div>
			</div>

		</div>
	</div>

</div>

<script>
function showModalSSL(e, modulo){
	e.preventDefault();

	var html = '';
	html += '<div class="modal-dialog modal-filemanager">';
	html += '	<div class="modal-content">';
	html += '		<div class="modal-header">';
	html += '			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>';
	html += '			<h4 class="modal-title"><i class="fa fa-exclamation-triangle" style="color:red;"></i>&nbsp; Alerta de Segurança</h4>';
	html += '		</div>';
	html += '		<div class="modal-body">';
	html += '			<div style="padding:20px; text-align:center;">';
	html += '				<div style="font-size:20px; line-height:1.5;">Antes de ativar este módulo de pagamento é preciso <strong>melhorar a segurança</strong> da sua loja com um <strong>certificado de segurança SSL</strong>.</div><br>';
	html += '				<div style="font-size:14px; line-height:1.5;">O módulo <strong>' + modulo + '</strong> solicita informações sigilosas do seu cliente para concluir o pagamento. Por este motivo é obrigatória a utilização do protocolo HTTP<strong>S</strong> para criptografar estas informações, proporcionando segurança a você lojista e seu cliente.</div>';
	html += '				<br><br><a href="http://www.hoteldaweb.com.br/ssl-conexao-segura" target="_blank" class="btn btn-lg btn-success" style="font-size:18px;font-weight:300;"><i class="fa fa-shield" style="font-size:18px;color:steelblue;"></i>&nbsp; Contrate já um Certificado SSL</a>';
	html += '			</div>';
	html += '		</div>';
	html += '	</div>';
	html += '</div>';

	$('body').append('<div id="modal-ssl" class="modal">' + html + '</div>');
	$('#modal-ssl').modal('show');

	return false;
}
</script>



<?php echo $footer; ?>