<?php

$language_code = $this->registry->get('language')->get('code');

$config_campo_idade = $this->registry->get('config')->has('config_campo_idade') ? $this->registry->get('config')->get('config_campo_idade') : 0;
$config_campo_idade = is_numeric($config_campo_idade) ? $config_campo_idade : 0;

$birth_max_date = date('Y-m-d', mktime(0, 0, 0, date('m'), date('d'), date('Y') - $config_campo_idade));

$token = isset($this->registry->get('session')->data['token']) ? $this->registry->get('session')->data['token'] : '';

?><!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />

<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($keywords) { ?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<?php } ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

<script type="text/javascript" src="view/javascript/jquery/jquery-2.1.1.min.js"></script>
<script type="text/javascript" src="view/javascript/bootstrap/js/bootstrap.min.js"></script>
<link href="view/javascript/bootstrap/opencart/opencart.css" type="text/css" rel="stylesheet" />
<!-- <link href="view/javascript/font-awesome/css/font-awesome.min.css" type="text/css" rel="stylesheet" /> -->



<!-- include codemirror (codemirror.css, codemirror.js, xml.js, formatting.js) -->
<link rel="stylesheet" type="text/css" href="view/javascript/codemirror/5.6.0/codemirror.min.css" />
<link rel="stylesheet" type="text/css" href="view/javascript/codemirror/5.6.0/addon/hint/show-hint.min.css" />
<link rel="stylesheet" type="text/css" href="view/javascript/codemirror/5.6.0/theme/monokai.min.css" />

<script type="text/javascript" src="view/javascript/codemirror/5.6.0/codemirror.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/keymap/sublime.min.js"></script>

<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/hint/show-hint.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/hint/xml-hint.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/hint/html-hint.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/hint/css-hint.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/hint/javascript-hint.min.js"></script>

<script type="text/javascript" src="view/javascript/codemirror/5.6.0/mode/xml/xml.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/mode/javascript/javascript.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/mode/css/css.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/mode/htmlmixed/htmlmixed.min.js"></script>

<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/fold/xml-fold.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/search/searchcursor.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/search/search.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/edit/closebrackets.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/edit/closetag.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/edit/matchbrackets.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/edit/matchtags.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/edit/trailingspace.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/search/match-highlighter.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/selection/active-line.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/comment/comment.min.js"></script>
<script type="text/javascript" src="view/javascript/codemirror/5.6.0/addon/comment/continuecomment.min.js"></script>

<link href="view/javascript/summernote/summernote.css" rel="stylesheet" />
<script type="text/javascript" src="view/javascript/summernote/summernote.js"></script>

<?php if ($language_code == 'pt-br') { ?>
<script type="text/javascript" src="view/javascript/summernote/summernote-pt-BR.js"></script>
<script>
(function ($) {
	$.summernote.options.lang = 'pt-BR';
})(jQuery);
</script>
<?php } ?>

<script type="text/javascript" src="view/javascript/summernote/plugin/summernote-ext-video.js"></script>
<script type="text/javascript" src="view/javascript/summernote/plugin/summernote-ext-specialchar.js"></script>
<script>
(function ($) {
	$.summernote.options.toolbar = [
		['view', ['codeview', 'fullscreen']],
		['insert', ['link', 'picture', 'video']],
		['font', ['paragraph', 'bold', 'italic', 'underline', 'clear']],
		['para', ['ul', 'ol']],
		['fontstyle', ['strikethrough', 'superscript', 'subscript']],
		['insert2', ['specialChar', 'hr']],
		['table', ['table']],
		['style', ['style']],
		['fontname', ['fontname']],
		['fontsize', ['fontsize']],
		['height', ['height']],
		['color', ['color']],
		['help', ['help']]
	];

	$.summernote.options.codemirror = {
		mode: 'text/html',
		htmlMode: true,
		lineNumbers: true,
		autoCloseTags: true,
		autoCloseBrackets: true,
		showTrailingSpace: true,
		styleActiveLine: true,
		continueComments: true,
		matchBrackets: true,
		matchTags: {
			bothTags: true
		},
		highlightSelectionMatches: {
			minChars: 2
		},
		extraKeys: {
			'Ctrl-J': 'toMatchingTag',
			'Ctrl-Space': 'autocomplete'
		},
		indentWithTabs: true,
		tabSize: 4,
		indentUnit: 4,
		keyMap: 'sublime',
		theme: 'monokai'
	};
})(jQuery);
</script>



<script src="view/javascript/jquery/datetimepicker/moment.js" type="text/javascript"></script>
<script src="view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<link href="view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css" type="text/css" rel="stylesheet" media="screen" />

<link type="text/css" href="view/stylesheet/stylesheet.css?v20160728" rel="stylesheet" media="screen" />

<?php foreach ($styles as $style) { ?>
<link type="text/css" href="<?php echo $style['href']; ?>" rel="<?php echo $style['rel']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>

<script>
var current_language_code = '<?php echo $language_code; ?>';
var birth_max_date = '<?php echo $birth_max_date; ?>';
var oc_session_token = '<?php echo $token; ?>';
</script>

<script src="view/javascript/common.js?v20160728" type="text/javascript"></script>

<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>



<script>
var WebFontConfig = {
	// carrega arquivos locais em caso de falha dos CDNs
	fontinactive: function(familyName, fvd) {
		if (familyName == 'FontAwesome') {
			WebFont.load({
				custom: {
					families: [ 'FontAwesome' ],
					urls: ['view/javascript/font-awesome/css/font-awesome.min.css'],
					testStrings: { 'FontAwesome': '\uf19d' }
				}
			});
		}
		if (familyName == 'Open Sans') {
			WebFont.load({
				custom: {
					families: [ 'Open+Sans:300,400,600,700,800,300i,400i,600i,700i,800i' ],
					urls: ['view/stylesheet/fonts.css']
				}
			});
		}
	},

	classes: false,
	events: true,
	timeout: 2000,

	// tenta carregar os arquivos dos CDNs
	custom: {
		families: [ 'FontAwesome' ],
		urls: ['https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css'],
		testStrings: { 'FontAwesome': '\uf19d' }
	},
	google: {
		families: [ 'Open+Sans:300,400,600,700,800,300i,400i,600i,700i,800i' ]
	}
};

(function(){
	var wf = document.createElement("script");
	wf.src = 'view/javascript/webfont.js';
	wf.async = 'true';
	document.head.appendChild(wf);
})();
</script>



</head>
<body>
<div id="container">

<header id="header" class="navbar navbar-static-top">

	<div class="navbar-header">
		<?php if ($logged) { ?>
		<a type="button" id="button-menu" class="pull-left"><i class="fa fa-indent fa-lg"></i></a>
		<?php } ?>
		<a href="<?php echo $home; ?>" class="navbar-brand"><img src="view/image/logo.png" alt="<?php echo $heading_title; ?>" title="<?php echo $heading_title; ?>" /></a>
	</div>

	<?php if ($logged) { ?>
		<ul class="nav pull-right">
			<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown"><span class="label label-danger pull-left"><?php echo $alerts; ?></span> <i class="fa fa-bell fa-lg"></i></a>
				<ul class="dropdown-menu dropdown-menu-right alerts-dropdown">
					<li class="dropdown-header"><?php echo $text_order; ?></li>
					<li><a href="<?php echo $order_status; ?>" style="display: block; overflow: auto;"><span class="label label-warning pull-right"><?php echo $order_status_total; ?></span><?php echo $text_order_status; ?></a></li>
					<li><a href="<?php echo $complete_status; ?>"><span class="label label-success pull-right"><?php echo $complete_status_total; ?></span><?php echo $text_complete_status; ?></a></li>
					<li><a href="<?php echo $return; ?>"><span class="label label-danger pull-right"><?php echo $return_total; ?></span><?php echo $text_return; ?></a></li>
					<li class="divider"></li>
					<li class="dropdown-header"><?php echo $text_customer; ?></li>
					<li><a href="<?php echo $online; ?>"><span class="label label-success pull-right"><?php echo $online_total; ?></span><?php echo $text_online; ?></a></li>
					<li><a href="<?php echo $customer_approval; ?>"><span class="label label-danger pull-right"><?php echo $customer_total; ?></span><?php echo $text_approval; ?></a></li>
					<li class="divider"></li>
					<li class="dropdown-header"><?php echo $text_product; ?></li>
					<li><a href="<?php echo $product; ?>"><span class="label label-danger pull-right"><?php echo $product_total; ?></span><?php echo $text_stock; ?></a></li>
					<li><a href="<?php echo $review; ?>"><span class="label label-danger pull-right"><?php echo $review_total; ?></span><?php echo $text_review; ?></a></li>
					<li class="divider"></li>
					<li class="dropdown-header"><?php echo $text_affiliate; ?></li>
					<li><a href="<?php echo $affiliate_approval; ?>"><span class="label label-danger pull-right"><?php echo $affiliate_total; ?></span><?php echo $text_approval; ?></a></li>
				</ul>
			</li>
			<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-life-ring fa-lg"></i></a>
				<ul class="dropdown-menu dropdown-menu-right">
					<li class="dropdown-header"><?php echo $text_store; ?> <i class="fa fa-shopping-cart"></i></li>
					<?php foreach ($stores as $store) { ?>
					<li><a href="<?php echo $store['href']; ?>" target="_blank"><?php echo $store['name']; ?></a></li>
					<?php } ?>
					<li class="divider"></li>
					<li class="dropdown-header"><?php echo $text_help; ?> <i class="fa fa-life-ring"></i></li>
					<li><a href="http://www.opencart.com" target="_blank"><?php echo $text_homepage; ?></a></li>
					<li><a href="http://docs.opencart.com" target="_blank"><?php echo $text_documentation; ?></a></li>
					<li><a href="http://forum.opencart.com" target="_blank"><?php echo $text_support; ?></a></li>
				</ul>
			</li>
			<li><a href="<?php echo $logout; ?>"><span class="hidden-xs hidden-sm hidden-md"><?php echo $text_logout; ?></span> <i class="fa fa-sign-out fa-lg"></i></a></li>
		</ul>
	<?php } ?>

</header>
